# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""

# Module PySide6.QtHelp
import PySide6
try:
    import typing
except ImportError:
    from PySide6.support.signature import typing
from PySide6.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken6 as Shiboken
Shiboken.Object = Object

import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp


class QCompressedHelpInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtHelp.QCompressedHelpInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def component(self) -> str: ...
    @staticmethod
    def fromCompressedHelpFile(documentationFileName:str) -> PySide6.QtHelp.QCompressedHelpInfo: ...
    def isNull(self) -> bool: ...
    def namespaceName(self) -> str: ...
    def swap(self, other:PySide6.QtHelp.QCompressedHelpInfo) -> None: ...
    def version(self) -> PySide6.QtCore.QVersionNumber: ...


class QHelpContentItem(Shiboken.Object):
    @staticmethod
    def __copy__() -> None: ...
    def child(self, row:int) -> PySide6.QtHelp.QHelpContentItem: ...
    def childCount(self) -> int: ...
    def childPosition(self, child:PySide6.QtHelp.QHelpContentItem) -> int: ...
    def parent(self) -> PySide6.QtHelp.QHelpContentItem: ...
    def row(self) -> int: ...
    def title(self) -> str: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QHelpContentModel(PySide6.QtCore.QAbstractItemModel):
    def columnCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...
    def contentItemAt(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtHelp.QHelpContentItem: ...
    def createContents(self, customFilterName:str) -> None: ...
    def data(self, index:PySide6.QtCore.QModelIndex, role:int) -> typing.Any: ...
    def index(self, row:int, column:int, parent:PySide6.QtCore.QModelIndex=...) -> PySide6.QtCore.QModelIndex: ...
    def isCreatingContents(self) -> bool: ...
    @typing.overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, index:PySide6.QtCore.QModelIndex) -> PySide6.QtCore.QModelIndex: ...
    def rowCount(self, parent:PySide6.QtCore.QModelIndex=...) -> int: ...


class QHelpContentWidget(PySide6.QtWidgets.QTreeView):
    def indexOf(self, link:PySide6.QtCore.QUrl) -> PySide6.QtCore.QModelIndex: ...


class QHelpEngine(PySide6.QtHelp.QHelpEngineCore):

    def __init__(self, collectionFile:str, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def contentModel(self) -> PySide6.QtHelp.QHelpContentModel: ...
    def contentWidget(self) -> PySide6.QtHelp.QHelpContentWidget: ...
    def indexModel(self) -> PySide6.QtHelp.QHelpIndexModel: ...
    def indexWidget(self) -> PySide6.QtHelp.QHelpIndexWidget: ...
    def searchEngine(self) -> PySide6.QtHelp.QHelpSearchEngine: ...


class QHelpEngineCore(PySide6.QtCore.QObject):

    def __init__(self, collectionFile:str, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def addCustomFilter(self, filterName:str, attributes:typing.Sequence) -> bool: ...
    def autoSaveFilter(self) -> bool: ...
    def collectionFile(self) -> str: ...
    def copyCollectionFile(self, fileName:str) -> bool: ...
    def currentFilter(self) -> str: ...
    def customFilters(self) -> typing.List: ...
    def customValue(self, key:str, defaultValue:typing.Any=...) -> typing.Any: ...
    def documentationFileName(self, namespaceName:str) -> str: ...
    @typing.overload
    def documentsForIdentifier(self, id:str) -> typing.List: ...
    @typing.overload
    def documentsForIdentifier(self, id:str, filterName:str) -> typing.List: ...
    @typing.overload
    def documentsForKeyword(self, keyword:str) -> typing.List: ...
    @typing.overload
    def documentsForKeyword(self, keyword:str, filterName:str) -> typing.List: ...
    def error(self) -> str: ...
    def fileData(self, url:PySide6.QtCore.QUrl) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def files(self, namespaceName:str, filterAttributes:typing.Sequence, extensionFilter:str=...) -> typing.List: ...
    @typing.overload
    def files(self, namespaceName:str, filterName:str, extensionFilter:str=...) -> typing.List: ...
    def filterAttributeSets(self, namespaceName:str) -> typing.List: ...
    @typing.overload
    def filterAttributes(self) -> typing.List: ...
    @typing.overload
    def filterAttributes(self, filterName:str) -> typing.List: ...
    def filterEngine(self) -> PySide6.QtHelp.QHelpFilterEngine: ...
    def findFile(self, url:PySide6.QtCore.QUrl) -> PySide6.QtCore.QUrl: ...
    def isReadOnly(self) -> bool: ...
    @staticmethod
    def metaData(documentationFileName:str, name:str) -> typing.Any: ...
    @staticmethod
    def namespaceName(documentationFileName:str) -> str: ...
    def registerDocumentation(self, documentationFileName:str) -> bool: ...
    def registeredDocumentations(self) -> typing.List: ...
    def removeCustomFilter(self, filterName:str) -> bool: ...
    def removeCustomValue(self, key:str) -> bool: ...
    def setAutoSaveFilter(self, save:bool) -> None: ...
    def setCollectionFile(self, fileName:str) -> None: ...
    def setCurrentFilter(self, filterName:str) -> None: ...
    def setCustomValue(self, key:str, value:typing.Any) -> bool: ...
    def setReadOnly(self, enable:bool) -> None: ...
    def setUsesFilterEngine(self, uses:bool) -> None: ...
    def setupData(self) -> bool: ...
    def unregisterDocumentation(self, namespaceName:str) -> bool: ...
    def usesFilterEngine(self) -> bool: ...


class QHelpFilterData(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtHelp.QHelpFilterData) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def components(self) -> typing.List: ...
    def setComponents(self, components:typing.Sequence) -> None: ...
    def setVersions(self, versions:typing.Sequence) -> None: ...
    def swap(self, other:PySide6.QtHelp.QHelpFilterData) -> None: ...
    def versions(self) -> typing.List: ...


class QHelpFilterEngine(PySide6.QtCore.QObject):

    def __init__(self, helpEngine:PySide6.QtHelp.QHelpEngineCore) -> None: ...

    def activeFilter(self) -> str: ...
    def availableComponents(self) -> typing.List: ...
    def availableVersions(self) -> typing.List: ...
    def filterData(self, filterName:str) -> PySide6.QtHelp.QHelpFilterData: ...
    def filters(self) -> typing.List: ...
    @typing.overload
    def indices(self) -> typing.List: ...
    @typing.overload
    def indices(self, filterName:str) -> typing.List: ...
    def namespaceToComponent(self) -> typing.Dict: ...
    def namespaceToVersion(self) -> typing.Dict: ...
    def namespacesForFilter(self, filterName:str) -> typing.List: ...
    def removeFilter(self, filterName:str) -> bool: ...
    def setActiveFilter(self, filterName:str) -> bool: ...
    def setFilterData(self, filterName:str, filterData:PySide6.QtHelp.QHelpFilterData) -> bool: ...


class QHelpFilterSettingsWidget(PySide6.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide6.QtWidgets.QWidget]=...) -> None: ...

    def applySettings(self, filterEngine:PySide6.QtHelp.QHelpFilterEngine) -> bool: ...
    def readSettings(self, filterEngine:PySide6.QtHelp.QHelpFilterEngine) -> None: ...
    def setAvailableComponents(self, components:typing.Sequence) -> None: ...
    def setAvailableVersions(self, versions:typing.Sequence) -> None: ...


class QHelpIndexModel(PySide6.QtCore.QStringListModel):
    @typing.overload
    def createIndex(self, customFilterName:str) -> None: ...
    @typing.overload
    def createIndex(self, row:int, column:int, id:int=...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, row:int, column:int, ptr:object) -> PySide6.QtCore.QModelIndex: ...
    def filter(self, filter:str, wildcard:str=...) -> PySide6.QtCore.QModelIndex: ...
    def helpEngine(self) -> PySide6.QtHelp.QHelpEngineCore: ...
    def isCreatingIndex(self) -> bool: ...


class QHelpIndexWidget(PySide6.QtWidgets.QListView):
    def activateCurrentItem(self) -> None: ...
    def filterIndices(self, filter:str, wildcard:str=...) -> None: ...


class QHelpLink(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QHelpLink:PySide6.QtHelp.QHelpLink) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QHelpSearchEngine(PySide6.QtCore.QObject):

    def __init__(self, helpEngine:PySide6.QtHelp.QHelpEngineCore, parent:typing.Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def cancelIndexing(self) -> None: ...
    def cancelSearching(self) -> None: ...
    def hitCount(self) -> int: ...
    def hits(self, start:int, end:int) -> typing.List: ...
    def hitsCount(self) -> int: ...
    def query(self) -> typing.List: ...
    def queryWidget(self) -> PySide6.QtHelp.QHelpSearchQueryWidget: ...
    def reindexDocumentation(self) -> None: ...
    def resultWidget(self) -> PySide6.QtHelp.QHelpSearchResultWidget: ...
    def scheduleIndexDocumentation(self) -> None: ...
    @typing.overload
    def search(self, queryList:typing.Sequence) -> None: ...
    @typing.overload
    def search(self, searchInput:str) -> None: ...
    def searchInput(self) -> str: ...
    def searchResultCount(self) -> int: ...
    def searchResults(self, start:int, end:int) -> typing.List: ...


class QHelpSearchQuery(Shiboken.Object):
    DEFAULT                  : QHelpSearchQuery.FieldName = ... # 0x0
    FUZZY                    : QHelpSearchQuery.FieldName = ... # 0x1
    WITHOUT                  : QHelpSearchQuery.FieldName = ... # 0x2
    PHRASE                   : QHelpSearchQuery.FieldName = ... # 0x3
    ALL                      : QHelpSearchQuery.FieldName = ... # 0x4
    ATLEAST                  : QHelpSearchQuery.FieldName = ... # 0x5

    class FieldName(Shiboken.Enum):
        DEFAULT                  : QHelpSearchQuery.FieldName = ... # 0x0
        FUZZY                    : QHelpSearchQuery.FieldName = ... # 0x1
        WITHOUT                  : QHelpSearchQuery.FieldName = ... # 0x2
        PHRASE                   : QHelpSearchQuery.FieldName = ... # 0x3
        ALL                      : QHelpSearchQuery.FieldName = ... # 0x4
        ATLEAST                  : QHelpSearchQuery.FieldName = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QHelpSearchQuery:PySide6.QtHelp.QHelpSearchQuery) -> None: ...
    @typing.overload
    def __init__(self, field:PySide6.QtHelp.QHelpSearchQuery.FieldName, wordList_:typing.Sequence) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QHelpSearchQueryWidget(PySide6.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide6.QtWidgets.QWidget]=...) -> None: ...

    def changeEvent(self, event:PySide6.QtCore.QEvent) -> None: ...
    def collapseExtendedSearch(self) -> None: ...
    def expandExtendedSearch(self) -> None: ...
    def focusInEvent(self, focusEvent:PySide6.QtGui.QFocusEvent) -> None: ...
    def isCompactMode(self) -> bool: ...
    def query(self) -> typing.List: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on:bool) -> None: ...
    def setQuery(self, queryList:typing.Sequence) -> None: ...
    def setSearchInput(self, searchInput:str) -> None: ...


class QHelpSearchResult(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide6.QtHelp.QHelpSearchResult) -> None: ...
    @typing.overload
    def __init__(self, url:PySide6.QtCore.QUrl, title:str, snippet:str) -> None: ...

    def snippet(self) -> str: ...
    def title(self) -> str: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QHelpSearchResultWidget(PySide6.QtWidgets.QWidget):
    def changeEvent(self, event:PySide6.QtCore.QEvent) -> None: ...
    def linkAt(self, point:PySide6.QtCore.QPoint) -> PySide6.QtCore.QUrl: ...

# eof
