"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ecs-deployment-provider/is-complete.lambda.ts
var is_complete_lambda_exports = {};
__export(is_complete_lambda_exports, {
  DeploymentStatus: () => DeploymentStatus,
  handler: () => handler
});
module.exports = __toCommonJS(is_complete_lambda_exports);
var AWS = __toESM(require("aws-sdk"));

// src/ecs-deployment-provider/logger.ts
var Logger = class {
  constructor() {
    this.persistentAttributes = {};
  }
  info(message, ...attributes) {
    process.stdout.write(this.formatMessage(message, { level: "INFO" }, ...attributes) + "\n");
  }
  warn(message, ...attributes) {
    process.stdout.write(this.formatMessage(message, { level: "WARN" }, ...attributes) + "\n");
  }
  error(message, ...attributes) {
    process.stdout.write(this.formatMessage(message, { level: "ERROR" }, ...attributes) + "\n");
  }
  appendKeys(attributes) {
    this.persistentAttributes = { ...this.persistentAttributes, ...attributes };
  }
  formatMessage(message, ...attributes) {
    const formattedMessage = [this.persistentAttributes, ...attributes].reduce((combined, current) => {
      return { ...combined, ...current };
    }, { message });
    return JSON.stringify(formattedMessage);
  }
};

// src/ecs-deployment-provider/is-complete.lambda.ts
var DeploymentStatus = /* @__PURE__ */ ((DeploymentStatus2) => {
  DeploymentStatus2["CREATED"] = "Created";
  DeploymentStatus2["QUEUED"] = "Queued";
  DeploymentStatus2["IN_PROGRESS"] = "InProgress";
  DeploymentStatus2["BAKING"] = "Baking";
  DeploymentStatus2["SUCCEEDED"] = "Succeeded";
  DeploymentStatus2["FAILED"] = "Failed";
  DeploymentStatus2["STOPPED"] = "Stopped";
  DeploymentStatus2["READY"] = "Ready";
  return DeploymentStatus2;
})(DeploymentStatus || {});
async function handler(event) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p;
  const logger = new Logger();
  const codedeployClient = new AWS.CodeDeploy();
  try {
    const resp = await codedeployClient.getDeployment({ deploymentId: event.PhysicalResourceId }).promise();
    let rollbackResp = {};
    if ((_b = (_a = resp.deploymentInfo) == null ? void 0 : _a.rollbackInfo) == null ? void 0 : _b.rollbackDeploymentId) {
      rollbackResp = await codedeployClient.getDeployment({ deploymentId: (_d = (_c = resp.deploymentInfo) == null ? void 0 : _c.rollbackInfo) == null ? void 0 : _d.rollbackDeploymentId }).promise();
    }
    logger.appendKeys({
      stackEvent: event.RequestType,
      deploymentId: event.PhysicalResourceId,
      deploymentStatus: (_e = resp.deploymentInfo) == null ? void 0 : _e.status,
      rollbackStatus: (_f = rollbackResp == null ? void 0 : rollbackResp.deploymentInfo) == null ? void 0 : _f.status
    });
    logger.info("Checking deployment");
    switch (event.RequestType) {
      case "Create":
      case "Update":
        switch ((_g = resp.deploymentInfo) == null ? void 0 : _g.status) {
          case "Succeeded" /* SUCCEEDED */:
            logger.info("Deployment finished successfully", { complete: true });
            return { IsComplete: true };
          case "Failed" /* FAILED */:
          case "Stopped" /* STOPPED */:
            if ((_h = rollbackResp.deploymentInfo) == null ? void 0 : _h.status) {
              if (((_i = rollbackResp.deploymentInfo) == null ? void 0 : _i.status) == "Succeeded" /* SUCCEEDED */ || ((_j = rollbackResp.deploymentInfo) == null ? void 0 : _j.status) == "Failed" /* FAILED */ || ((_k = rollbackResp.deploymentInfo) == null ? void 0 : _k.status) == "Stopped" /* STOPPED */) {
                const errInfo = resp.deploymentInfo.errorInformation;
                const error = new Error(`Deployment ${resp.deploymentInfo.status}: [${errInfo == null ? void 0 : errInfo.code}] ${errInfo == null ? void 0 : errInfo.message}`);
                logger.error("Deployment failed", { complete: true, error });
                throw error;
              }
              logger.info("Waiting for final status from a rollback", { complete: false });
              return { IsComplete: false };
            } else {
              const errInfo = resp.deploymentInfo.errorInformation;
              const error = new Error(`Deployment ${resp.deploymentInfo.status}: [${errInfo == null ? void 0 : errInfo.code}] ${errInfo == null ? void 0 : errInfo.message}`);
              logger.error("No rollback to wait for", { complete: true, error });
              throw error;
            }
          default:
            logger.info("Waiting for final status from deployment", { complete: false });
            return { IsComplete: false };
        }
      case "Delete":
        switch ((_l = resp.deploymentInfo) == null ? void 0 : _l.status) {
          case "Succeeded" /* SUCCEEDED */:
            logger.info("Deployment finished successfully - nothing to delete", { complete: true });
            return { IsComplete: true };
          case "Failed" /* FAILED */:
          case "Stopped" /* STOPPED */:
            if ((_m = rollbackResp.deploymentInfo) == null ? void 0 : _m.status) {
              if (((_n = rollbackResp.deploymentInfo) == null ? void 0 : _n.status) == "Succeeded" /* SUCCEEDED */ || ((_o = rollbackResp.deploymentInfo) == null ? void 0 : _o.status) == "Failed" /* FAILED */ || ((_p = rollbackResp.deploymentInfo) == null ? void 0 : _p.status) == "Stopped" /* STOPPED */) {
                logger.info("Rollback in final status", { complete: true });
                return { IsComplete: true };
              }
              logger.info("Waiting for final status from a rollback", { complete: false });
              return { IsComplete: false };
            }
            logger.info("No rollback to wait for", { complete: true });
            return { IsComplete: true };
          default:
            logger.info("Waiting for final status from deployment", { complete: false });
            return { IsComplete: false };
        }
      default:
        logger.error("Unknown request type");
        throw new Error(`Unknown request type: ${event.RequestType}`);
    }
  } catch (e) {
    logger.error("Unable to determine deployment status", { error: e });
    if (event.RequestType === "Delete") {
      logger.warn("Ignoring error - nothing to do", { complete: true });
      return { IsComplete: true };
    }
    throw e;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DeploymentStatus,
  handler
});
