"""Add category

Revision ID: 89920abb7ff8
Revises: 16ff997426d3
Create Date: 2025-06-13 15:06:08.092501

"""

from typing import Sequence, Union

import sqlalchemy
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "89920abb7ff8"
down_revision: Union[str, None] = "16ff997426d3"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "category",
        sa.Column(
            "id",
            sa.Uuid(),
            server_default=sqlalchemy.func.gen_random_uuid(),
            nullable=False,
        ),
        sa.Column("title", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        schema="corpus_related",
    )
    op.add_column(
        "corpus",
        sa.Column("category_id", sa.Uuid()),
        schema="corpus_related",
    )
    op.create_foreign_key(
        None,
        "corpus",
        "category",
        ["category_id"],
        ["id"],
        source_schema="corpus_related",
        referent_schema="corpus_related",
    )


def downgrade() -> None:
    op.drop_column("corpus", "category_id", schema="corpus_related")
    op.drop_table("category", schema="corpus_related")
