#   This Python module is part of the PyRate software package.
#
#   Copyright 2020 Geoscience Australia
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
"""
This Python module contains a collection of constants used in
various components of the PyRate software
"""

# lookup keys for the metadata fields in PyRate GeoTIFF files
PYRATE_NCOLS = 'NCOLS'
PYRATE_NROWS = 'NROWS'
PYRATE_X_STEP = 'X_STEP'
PYRATE_Y_STEP = 'Y_STEP'
PYRATE_LAT = 'LAT'
PYRATE_LONG = 'LONG'
FIRST_DATE = 'FIRST_DATE'
FIRST_TIME = 'FIRST_TIME'
SECOND_DATE = 'SECOND_DATE'
SECOND_TIME = 'SECOND_TIME'
EPOCH_DATE = 'EPOCH_DATE'
PYRATE_DATUM = 'DATUM'
PYRATE_TIME_SPAN = 'TIME_SPAN_YEAR'
PYRATE_WAVELENGTH_METRES = 'WAVELENGTH_METRES'
PYRATE_INCIDENCE_DEGREES = 'INCIDENCE_DEGREES'
PYRATE_INSAR_PROCESSOR = 'INSAR_PROCESSOR'
PYRATE_WEATHER_ERROR = 'WEATHER_ERROR'
PYRATE_APS_ERROR = 'APS_ERROR'
PYRATE_MAXVAR = 'CVD_MAXVAR'
PYRATE_ALPHA = 'CVD_ALPHA'
COHERENCE = 'COHERENCE_MASKED_MULTILOOKED_IFG'
MULTILOOKED = 'MULTILOOKED_IFG'
MULTILOOKED_COH = 'MULTILOOKED_COH'
ORIG = 'ORIGINAL_IFG'
COH = 'ORIGINAL_COH'
DEM = 'ORIGINAL_DEM'
MLOOKED_DEM = 'MULTILOOKED_DEM'
INCIDENCE = 'INCIDENCE_ANGLE_MAP'
MLOOKED_INC = 'MULTILOOKED_INCIDENCE_ANGLE_MAP'
INCR = 'INCREMENTAL_TIME_SLICE'
CUML = 'CUMULATIVE_TIME_SLICE'
STACKRATE = 'STACKED_RATE_MAP'
STACKERROR = 'STACKED_RATE_ERROR'
STACKSAMP = 'STACKED_RATE_SAMPLES'
PYRATE_ORBITAL_ERROR = 'ORBITAL_ERROR'
ORB_REMOVED = 'REMOVED'
APS_REMOVED = 'REMOVED'
PYRATE_REF_PHASE = 'REFERENCE_PHASE'
REF_PHASE_REMOVED = 'REMOVED'
NAN_STATUS = 'NAN_STATUS'
NAN_CONVERTED = 'CONVERTED'
DATA_TYPE = 'DATA_TYPE'
DATA_UNITS = 'DATA_UNITS'
INPUT_TYPE = 'INPUT_TYPE'

PYRATE_REFPIX_X = 'REF_PIX_X'
PYRATE_REFPIX_Y = 'REF_PIX_Y'
PYRATE_REFPIX_LAT = 'REF_PIX_LAT'
PYRATE_REFPIX_LON = 'REF_PIX_LON'
PYRATE_MEAN_REF_AREA = 'REF_AREA_MEAN'
PYRATE_STDDEV_REF_AREA = 'REF_AREA_STDDEV'
SEQUENCE_POSITION = 'SEQUENCE_POSITION'

DAYS_PER_YEAR = 365.25  # span of year, not a calendar year
YEARS_PER_DAY = 1 / DAYS_PER_YEAR
SPEED_OF_LIGHT_METRES_PER_SECOND = 3e8
MM_PER_METRE = 1000
