# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.Qt3DAnimation, except for defaults which are replaced by "...".
"""

# Module PySide6.Qt3DAnimation
import PySide6
try:
    import typing
except ImportError:
    from PySide6.support.signature import typing
from PySide6.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken6 as Shiboken
Shiboken.Object = Object

import PySide6.Qt3DAnimation


class Qt3DAnimation(Shiboken.Object):

    class QAbstractAnimation(PySide6.QtCore.QObject):
        KeyframeAnimation        : Qt3DAnimation.QAbstractAnimation.AnimationType = ... # 0x1
        MorphingAnimation        : Qt3DAnimation.QAbstractAnimation.AnimationType = ... # 0x2
        VertexBlendAnimation     : Qt3DAnimation.QAbstractAnimation.AnimationType = ... # 0x3

        class AnimationType(object):
            KeyframeAnimation        : Qt3DAnimation.QAbstractAnimation.AnimationType = ... # 0x1
            MorphingAnimation        : Qt3DAnimation.QAbstractAnimation.AnimationType = ... # 0x2
            VertexBlendAnimation     : Qt3DAnimation.QAbstractAnimation.AnimationType = ... # 0x3
        def animationName(self) -> str: ...
        def animationType(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation.AnimationType: ...
        def duration(self) -> float: ...
        def position(self) -> float: ...
        def setAnimationName(self, name: str) -> None: ...
        def setDuration(self, duration: float) -> None: ...
        def setPosition(self, position: float) -> None: ...

    class QAbstractAnimationClip(PySide6.Qt3DCore.QNode):
        def duration(self) -> float: ...

    class QAbstractChannelMapping(PySide6.Qt3DCore.QNode): ...

    class QAbstractClipAnimator(PySide6.Qt3DCore.QComponent):
        Infinite                 : Qt3DAnimation.QAbstractClipAnimator.Loops = ... # -0x1

        class Loops(object):
            Infinite                 : Qt3DAnimation.QAbstractClipAnimator.Loops = ... # -0x1

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def clock(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QClock: ...
        def isRunning(self) -> bool: ...
        def loopCount(self) -> int: ...
        def normalizedTime(self) -> float: ...
        def setClock(self, clock: PySide6.Qt3DAnimation.Qt3DAnimation.QClock) -> None: ...
        def setLoopCount(self, loops: int) -> None: ...
        def setNormalizedTime(self, timeFraction: float) -> None: ...
        def setRunning(self, running: bool) -> None: ...
        def start(self) -> None: ...
        def stop(self) -> None: ...

    class QAbstractClipBlendNode(PySide6.Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...


    class QAdditiveClipBlend(PySide6.Qt3DAnimation.QAbstractClipBlendNode):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def additiveClip(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def additiveFactor(self) -> float: ...
        def baseClip(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def setAdditiveClip(self, additiveClip: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode) -> None: ...
        def setAdditiveFactor(self, additiveFactor: float) -> None: ...
        def setBaseClip(self, baseClip: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode) -> None: ...

    class QAnimationAspect(PySide6.Qt3DCore.QAbstractAspect):

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...


    class QAnimationCallback(Shiboken.Object):
        OnOwningThread           : Qt3DAnimation.QAnimationCallback.Flag = ... # 0x0
        OnThreadPool             : Qt3DAnimation.QAnimationCallback.Flag = ... # 0x1

        class Flag(object):
            OnOwningThread           : Qt3DAnimation.QAnimationCallback.Flag = ... # 0x0
            OnThreadPool             : Qt3DAnimation.QAnimationCallback.Flag = ... # 0x1

        def __init__(self) -> None: ...

        def valueChanged(self, value: typing.Any) -> None: ...

    class QAnimationClip(PySide6.Qt3DAnimation.QAbstractAnimationClip):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...


    class QAnimationClipLoader(PySide6.Qt3DAnimation.QAbstractAnimationClip):
        NotReady                 : Qt3DAnimation.QAnimationClipLoader.Status = ... # 0x0
        Ready                    : Qt3DAnimation.QAnimationClipLoader.Status = ... # 0x1
        Error                    : Qt3DAnimation.QAnimationClipLoader.Status = ... # 0x2

        class Status(object):
            NotReady                 : Qt3DAnimation.QAnimationClipLoader.Status = ... # 0x0
            Ready                    : Qt3DAnimation.QAnimationClipLoader.Status = ... # 0x1
            Error                    : Qt3DAnimation.QAnimationClipLoader.Status = ... # 0x2

        @typing.overload
        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...
        @typing.overload
        def __init__(self, source: PySide6.QtCore.QUrl, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def setSource(self, source: PySide6.QtCore.QUrl) -> None: ...
        def source(self) -> PySide6.QtCore.QUrl: ...
        def status(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.Status: ...

    class QAnimationController(PySide6.QtCore.QObject):

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...

        def activeAnimationGroup(self) -> int: ...
        def addAnimationGroup(self, animationGroups: PySide6.Qt3DAnimation.Qt3DAnimation.QAnimationGroup) -> None: ...
        def animationGroupList(self) -> typing.List[PySide6.Qt3DAnimation.Qt3DAnimation.QAnimationGroup]: ...
        def entity(self) -> PySide6.Qt3DCore.Qt3DCore.QEntity: ...
        def getAnimationIndex(self, name: str) -> int: ...
        def getGroup(self, index: int) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAnimationGroup: ...
        def position(self) -> float: ...
        def positionOffset(self) -> float: ...
        def positionScale(self) -> float: ...
        def recursive(self) -> bool: ...
        def removeAnimationGroup(self, animationGroups: PySide6.Qt3DAnimation.Qt3DAnimation.QAnimationGroup) -> None: ...
        def setActiveAnimationGroup(self, index: int) -> None: ...
        def setAnimationGroups(self, animationGroups: typing.Sequence[PySide6.Qt3DAnimation.Qt3DAnimation.QAnimationGroup]) -> None: ...
        def setEntity(self, entity: PySide6.Qt3DCore.Qt3DCore.QEntity) -> None: ...
        def setPosition(self, position: float) -> None: ...
        def setPositionOffset(self, offset: float) -> None: ...
        def setPositionScale(self, scale: float) -> None: ...
        def setRecursive(self, recursive: bool) -> None: ...

    class QAnimationGroup(PySide6.QtCore.QObject):

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...

        def addAnimation(self, animation: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation) -> None: ...
        def animationList(self) -> typing.List[PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation]: ...
        def duration(self) -> float: ...
        def name(self) -> str: ...
        def position(self) -> float: ...
        def removeAnimation(self, animation: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation) -> None: ...
        def setAnimations(self, animations: typing.Sequence[PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation]) -> None: ...
        def setName(self, name: str) -> None: ...
        def setPosition(self, position: float) -> None: ...

    class QBlendedClipAnimator(PySide6.Qt3DAnimation.QAbstractClipAnimator):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def blendTree(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def setBlendTree(self, blendTree: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode) -> None: ...

    class QClipAnimator(PySide6.Qt3DAnimation.QAbstractClipAnimator):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def clip(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimationClip: ...
        def setClip(self, clip: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractAnimationClip) -> None: ...

    class QClock(PySide6.Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def playbackRate(self) -> float: ...
        def setPlaybackRate(self, playbackRate: float) -> None: ...

    class QKeyFrame(Shiboken.Object):
        ConstantInterpolation    : Qt3DAnimation.QKeyFrame.InterpolationType = ... # 0x0
        LinearInterpolation      : Qt3DAnimation.QKeyFrame.InterpolationType = ... # 0x1
        BezierInterpolation      : Qt3DAnimation.QKeyFrame.InterpolationType = ... # 0x2

        class InterpolationType(object):
            ConstantInterpolation    : Qt3DAnimation.QKeyFrame.InterpolationType = ... # 0x0
            LinearInterpolation      : Qt3DAnimation.QKeyFrame.InterpolationType = ... # 0x1
            BezierInterpolation      : Qt3DAnimation.QKeyFrame.InterpolationType = ... # 0x2

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, coords: PySide6.QtGui.QVector2D) -> None: ...
        @typing.overload
        def __init__(self, coords: PySide6.QtGui.QVector2D, lh: PySide6.QtGui.QVector2D, rh: PySide6.QtGui.QVector2D) -> None: ...

        def coordinates(self) -> PySide6.QtGui.QVector2D: ...
        def interpolationType(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QKeyFrame.InterpolationType: ...
        def leftControlPoint(self) -> PySide6.QtGui.QVector2D: ...
        def rightControlPoint(self) -> PySide6.QtGui.QVector2D: ...
        def setCoordinates(self, coords: PySide6.QtGui.QVector2D) -> None: ...
        def setInterpolationType(self, interp: PySide6.Qt3DAnimation.Qt3DAnimation.QKeyFrame.InterpolationType) -> None: ...
        def setLeftControlPoint(self, lh: PySide6.QtGui.QVector2D) -> None: ...
        def setRightControlPoint(self, rh: PySide6.QtGui.QVector2D) -> None: ...

    class QKeyframeAnimation(PySide6.Qt3DAnimation.QAbstractAnimation):
        None_                    : Qt3DAnimation.QKeyframeAnimation.RepeatMode = ... # 0x0
        Constant                 : Qt3DAnimation.QKeyframeAnimation.RepeatMode = ... # 0x1
        Repeat                   : Qt3DAnimation.QKeyframeAnimation.RepeatMode = ... # 0x2

        class RepeatMode(object):
            None_                    : Qt3DAnimation.QKeyframeAnimation.RepeatMode = ... # 0x0
            Constant                 : Qt3DAnimation.QKeyframeAnimation.RepeatMode = ... # 0x1
            Repeat                   : Qt3DAnimation.QKeyframeAnimation.RepeatMode = ... # 0x2

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...

        def addKeyframe(self, keyframe: PySide6.Qt3DCore.Qt3DCore.QTransform) -> None: ...
        def easing(self) -> PySide6.QtCore.QEasingCurve: ...
        def endMode(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        def framePositions(self) -> typing.List[float]: ...
        def keyframeList(self) -> typing.List[PySide6.Qt3DCore.Qt3DCore.QTransform]: ...
        def removeKeyframe(self, keyframe: PySide6.Qt3DCore.Qt3DCore.QTransform) -> None: ...
        def setEasing(self, easing: PySide6.QtCore.QEasingCurve) -> None: ...
        def setEndMode(self, mode: PySide6.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode) -> None: ...
        def setFramePositions(self, positions: typing.Sequence[float]) -> None: ...
        def setKeyframes(self, keyframes: typing.Sequence[PySide6.Qt3DCore.Qt3DCore.QTransform]) -> None: ...
        def setStartMode(self, mode: PySide6.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode) -> None: ...
        def setTarget(self, target: PySide6.Qt3DCore.Qt3DCore.QTransform) -> None: ...
        def setTargetName(self, name: str) -> None: ...
        def startMode(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        def target(self) -> PySide6.Qt3DCore.Qt3DCore.QTransform: ...
        def targetName(self) -> str: ...

    class QLerpClipBlend(PySide6.Qt3DAnimation.QAbstractClipBlendNode):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def blendFactor(self) -> float: ...
        def endClip(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def setBlendFactor(self, blendFactor: float) -> None: ...
        def setEndClip(self, endClip: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode) -> None: ...
        def setStartClip(self, startClip: PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode) -> None: ...
        def startClip(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...

    class QMorphTarget(PySide6.QtCore.QObject):

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...

        def addAttribute(self, attribute: PySide6.Qt3DCore.Qt3DCore.QAttribute) -> None: ...
        def attributeList(self) -> typing.List[PySide6.Qt3DCore.Qt3DCore.QAttribute]: ...
        def attributeNames(self) -> typing.List[str]: ...
        @staticmethod
        def fromGeometry(geometry: PySide6.Qt3DCore.Qt3DCore.QGeometry, attributes: typing.Sequence[str]) -> PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget: ...
        def removeAttribute(self, attribute: PySide6.Qt3DCore.Qt3DCore.QAttribute) -> None: ...
        def setAttributes(self, attributes: typing.Sequence[PySide6.Qt3DCore.Qt3DCore.QAttribute]) -> None: ...

    class QMorphingAnimation(PySide6.Qt3DAnimation.QAbstractAnimation):
        Normalized               : Qt3DAnimation.QMorphingAnimation.Method = ... # 0x0
        Relative                 : Qt3DAnimation.QMorphingAnimation.Method = ... # 0x1

        class Method(object):
            Normalized               : Qt3DAnimation.QMorphingAnimation.Method = ... # 0x0
            Relative                 : Qt3DAnimation.QMorphingAnimation.Method = ... # 0x1

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...

        def addMorphTarget(self, target: PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget) -> None: ...
        def easing(self) -> PySide6.QtCore.QEasingCurve: ...
        def getWeights(self, positionIndex: int) -> typing.List[float]: ...
        def interpolator(self) -> float: ...
        def method(self) -> PySide6.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method: ...
        def morphTargetList(self) -> typing.List[PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget]: ...
        def removeMorphTarget(self, target: PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget) -> None: ...
        def setEasing(self, easing: PySide6.QtCore.QEasingCurve) -> None: ...
        def setMethod(self, method: PySide6.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method) -> None: ...
        def setMorphTargets(self, targets: typing.Sequence[PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget]) -> None: ...
        def setTarget(self, target: PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer) -> None: ...
        def setTargetName(self, name: str) -> None: ...
        def setTargetPositions(self, targetPositions: typing.Sequence[float]) -> None: ...
        def setWeights(self, positionIndex: int, weights: typing.Sequence[float]) -> None: ...
        def target(self) -> PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer: ...
        def targetName(self) -> str: ...
        def targetPositions(self) -> typing.List[float]: ...

    class QSkeletonMapping(PySide6.Qt3DAnimation.QAbstractChannelMapping):

        def __init__(self, parent: typing.Optional[PySide6.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...

        def setSkeleton(self, skeleton: PySide6.Qt3DCore.Qt3DCore.QAbstractSkeleton) -> None: ...
        def skeleton(self) -> PySide6.Qt3DCore.Qt3DCore.QAbstractSkeleton: ...

    class QVertexBlendAnimation(PySide6.Qt3DAnimation.QAbstractAnimation):

        def __init__(self, parent: typing.Optional[PySide6.QtCore.QObject] = ...) -> None: ...

        def addMorphTarget(self, target: PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget) -> None: ...
        def interpolator(self) -> float: ...
        def morphTargetList(self) -> typing.List[PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget]: ...
        def removeMorphTarget(self, target: PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget) -> None: ...
        def setMorphTargets(self, targets: typing.Sequence[PySide6.Qt3DAnimation.Qt3DAnimation.QMorphTarget]) -> None: ...
        def setTarget(self, target: PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer) -> None: ...
        def setTargetName(self, name: str) -> None: ...
        def setTargetPositions(self, targetPositions: typing.Sequence[float]) -> None: ...
        def target(self) -> PySide6.Qt3DRender.Qt3DRender.QGeometryRenderer: ...
        def targetName(self) -> str: ...
        def targetPositions(self) -> typing.List[float]: ...

# eof
