# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGLFunctions, except for defaults which are replaced by "...".
"""

# Module PySide6.QtOpenGLFunctions
import PySide6
try:
    import typing
except ImportError:
    from PySide6.support.signature import typing
from PySide6.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken6 as Shiboken
Shiboken.Object = Object

import PySide6.QtOpenGLFunctions


class QOpenGLFunctions_1_0(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_1(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_2(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_3(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_4(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_5(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_2_0(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_2_1(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_0(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_1(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_2_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_2_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_3_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_3_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_0_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_0_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_1_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_1_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_2_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_2_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_3_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_3_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_4_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_4_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_5_Compatibility(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearAccum(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glClearIndex(self, c: float) -> None: ...
    def glColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4d(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4dv(self, v: typing.Sequence[float]) -> None: ...
    def glColor4f(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glColor4fv(self, v: typing.Sequence[float]) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u: float) -> None: ...
    def glEvalCoord1dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord1f(self, u: float) -> None: ...
    def glEvalCoord1fv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2d(self, u: float, v: float) -> None: ...
    def glEvalCoord2dv(self, u: typing.Sequence[float]) -> None: ...
    def glEvalCoord2f(self, u: float, v: float) -> None: ...
    def glEvalCoord2fv(self, u: typing.Sequence[float]) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordd(self, coord: float) -> None: ...
    def glFogCoorddv(self, coord: typing.Sequence[float]) -> None: ...
    def glFogCoordf(self, coord: float) -> None: ...
    def glFogCoordfv(self, coord: typing.Sequence[float]) -> None: ...
    def glFrustum(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glIndexd(self, c: float) -> None: ...
    def glIndexdv(self, c: typing.Sequence[float]) -> None: ...
    def glIndexf(self, c: float) -> None: ...
    def glIndexfv(self, c: typing.Sequence[float]) -> None: ...
    def glInitNames(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glLoadTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glMultMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixd(self, m: typing.Sequence[float]) -> None: ...
    def glMultTransposeMatrixf(self, m: typing.Sequence[float]) -> None: ...
    def glNormal3d(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3dv(self, v: typing.Sequence[float]) -> None: ...
    def glNormal3f(self, nx: float, ny: float, nz: float) -> None: ...
    def glNormal3fv(self, v: typing.Sequence[float]) -> None: ...
    def glOrtho(self, left: float, right: float, bottom: float, top: float, zNear: float, zFar: float) -> None: ...
    def glPassThrough(self, token: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelZoom(self, xfactor: float, yfactor: float) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glRasterPos2d(self, x: float, y: float) -> None: ...
    def glRasterPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos2f(self, x: float, y: float) -> None: ...
    def glRasterPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3d(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos3f(self, x: float, y: float, z: float) -> None: ...
    def glRasterPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4dv(self, v: typing.Sequence[float]) -> None: ...
    def glRasterPos4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glRasterPos4fv(self, v: typing.Sequence[float]) -> None: ...
    def glRectd(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectdv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glRectf(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def glRectfv(self, v1: typing.Sequence[float], v2: typing.Sequence[float]) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glRotatef(self, angle: float, x: float, y: float, z: float) -> None: ...
    def glScaled(self, x: float, y: float, z: float) -> None: ...
    def glScalef(self, x: float, y: float, z: float) -> None: ...
    def glSecondaryColor3d(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3dv(self, v: typing.Sequence[float]) -> None: ...
    def glSecondaryColor3f(self, red: float, green: float, blue: float) -> None: ...
    def glSecondaryColor3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1d(self, s: float) -> None: ...
    def glTexCoord1dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord1f(self, s: float) -> None: ...
    def glTexCoord1fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2d(self, s: float, t: float) -> None: ...
    def glTexCoord2dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord2f(self, s: float, t: float) -> None: ...
    def glTexCoord2fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3d(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord3f(self, s: float, t: float, r: float) -> None: ...
    def glTexCoord3fv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4d(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4dv(self, v: typing.Sequence[float]) -> None: ...
    def glTexCoord4f(self, s: float, t: float, r: float, q: float) -> None: ...
    def glTexCoord4fv(self, v: typing.Sequence[float]) -> None: ...
    def glTextureBarrier(self) -> None: ...
    def glTranslated(self, x: float, y: float, z: float) -> None: ...
    def glTranslatef(self, x: float, y: float, z: float) -> None: ...
    def glVertex2d(self, x: float, y: float) -> None: ...
    def glVertex2dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex2f(self, x: float, y: float) -> None: ...
    def glVertex2fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3d(self, x: float, y: float, z: float) -> None: ...
    def glVertex3dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex3f(self, x: float, y: float, z: float) -> None: ...
    def glVertex3fv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4d(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4dv(self, v: typing.Sequence[float]) -> None: ...
    def glVertex4f(self, x: float, y: float, z: float, w: float) -> None: ...
    def glVertex4fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2d(self, x: float, y: float) -> None: ...
    def glWindowPos2dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos2f(self, x: float, y: float) -> None: ...
    def glWindowPos2fv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3d(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3dv(self, v: typing.Sequence[float]) -> None: ...
    def glWindowPos3f(self, x: float, y: float, z: float) -> None: ...
    def glWindowPos3fv(self, v: typing.Sequence[float]) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_5_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClearDepth(self, depth: float) -> None: ...
    def glClearDepthf(self, dd: float) -> None: ...
    def glDepthRange(self, nearVal: float, farVal: float) -> None: ...
    def glDepthRangef(self, n: float, f: float) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glMinSampleShading(self, value: float) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPointSize(self, size: float) -> None: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glTextureBarrier(self) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...

# eof
