import * as cdk from '@aws-cdk/core';
import { PolicyStatement } from './policy-statement';
/**
 * Properties for a new PolicyDocument.
 *
 * @stability stable
 */
export interface PolicyDocumentProps {
    /**
     * Automatically assign Statement Ids to all statements.
     *
     * @default false
     * @stability stable
     */
    readonly assignSids?: boolean;
    /**
     * Initial statements to add to the policy document.
     *
     * @default - No statements
     * @stability stable
     */
    readonly statements?: PolicyStatement[];
}
/**
 * A PolicyDocument is a collection of statements.
 *
 * @stability stable
 */
export declare class PolicyDocument implements cdk.IResolvable {
    /**
     * Creates a new PolicyDocument based on the object provided.
     *
     * This will accept an object created from the `.toJSON()` call
     *
     * @param obj the PolicyDocument in object form.
     * @stability stable
     */
    static fromJson(obj: any): PolicyDocument;
    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     *
     * @stability stable
     */
    readonly creationStack: string[];
    private readonly statements;
    private readonly autoAssignSids;
    /**
     * @stability stable
     */
    constructor(props?: PolicyDocumentProps);
    /**
     * Produce the Token's value at resolution time.
     *
     * @stability stable
     */
    resolve(context: cdk.IResolveContext): any;
    /**
     * Whether the policy document contains any statements.
     *
     * @stability stable
     */
    get isEmpty(): boolean;
    /**
     * The number of statements already added to this policy.
     *
     * Can be used, for example, to generate unique "sid"s within the policy.
     *
     * @stability stable
     */
    get statementCount(): number;
    /**
     * Adds a statement to the policy document.
     *
     * @param statement the statement to add.
     * @stability stable
     */
    addStatements(...statement: PolicyStatement[]): void;
    /**
     * Encode the policy document as a string.
     *
     * @stability stable
     */
    toString(): string;
    /**
     * JSON-ify the document.
     *
     * Used when JSON.stringify() is called
     *
     * @stability stable
     */
    toJSON(): any;
    /**
     * Validate that all policy statements in the policy document satisfies the requirements for any policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     * @stability stable
     */
    validateForAnyPolicy(): string[];
    /**
     * Validate that all policy statements in the policy document satisfies the requirements for a resource-based policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     * @stability stable
     */
    validateForResourcePolicy(): string[];
    /**
     * Validate that all policy statements in the policy document satisfies the requirements for an identity-based policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     * @stability stable
     */
    validateForIdentityPolicy(): string[];
    private render;
}
