"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetInvoiceRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class GetInvoiceRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class GetInvoiceInvoicesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetInvoiceInvoicesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetInvoiceInvoicesLinksTypedDict(TypedDict):
    documentation: NotRequired[GetInvoiceInvoicesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetInvoiceInvoicesLinks(BaseModel):
    documentation: Optional[GetInvoiceInvoicesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetInvoiceInvoicesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetInvoiceInvoicesLinks], pydantic.Field(alias="_links")
    ] = None


class GetInvoiceInvoicesResponseBody(Exception):
    r"""An error response object."""

    data: GetInvoiceInvoicesResponseBodyData

    def __init__(self, data: GetInvoiceInvoicesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetInvoiceInvoicesResponseBodyData)


class NetAmountTypedDict(TypedDict):
    r"""Total amount of the invoice, excluding VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class NetAmount(BaseModel):
    r"""Total amount of the invoice, excluding VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetInvoiceVatAmountTypedDict(TypedDict):
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside the EU, no VAT will be charged."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetInvoiceVatAmount(BaseModel):
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside the EU, no VAT will be charged."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GrossAmountTypedDict(TypedDict):
    r"""Total amount of the invoice, including VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GrossAmount(BaseModel):
    r"""Total amount of the invoice, including VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetInvoiceAmountTypedDict(TypedDict):
    r"""Line item amount excluding VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetInvoiceAmount(BaseModel):
    r"""Line item amount excluding VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetInvoiceLinesTypedDict(TypedDict):
    period: NotRequired[str]
    r"""The administrative period in `YYYY-MM` on which the line should be booked."""
    description: NotRequired[str]
    r"""Description of the product."""
    count: NotRequired[int]
    r"""Number of products invoiced. For example, the number of payments."""
    vat_percentage: NotRequired[int]
    r"""VAT percentage rate that applies to this product."""
    amount: NotRequired[GetInvoiceAmountTypedDict]
    r"""Line item amount excluding VAT."""


class GetInvoiceLines(BaseModel):
    period: Optional[str] = None
    r"""The administrative period in `YYYY-MM` on which the line should be booked."""

    description: Optional[str] = None
    r"""Description of the product."""

    count: Optional[int] = None
    r"""Number of products invoiced. For example, the number of payments."""

    vat_percentage: Annotated[Optional[int], pydantic.Field(alias="vatPercentage")] = (
        None
    )
    r"""VAT percentage rate that applies to this product."""

    amount: Optional[GetInvoiceAmount] = None
    r"""Line item amount excluding VAT."""


class GetInvoiceSelfTypedDict(TypedDict):
    r"""URL to the current invoice resource."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetInvoiceSelf(BaseModel):
    r"""URL to the current invoice resource."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PdfTypedDict(TypedDict):
    r"""URL to a downloadable PDF of the invoice."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class Pdf(BaseModel):
    r"""URL to a downloadable PDF of the invoice."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetInvoiceDocumentationTypedDict(TypedDict):
    r"""URL to the API documentation."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetInvoiceDocumentation(BaseModel):
    r"""URL to the API documentation."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetInvoiceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetInvoiceSelfTypedDict]
    r"""URL to the current invoice resource."""
    pdf: NotRequired[PdfTypedDict]
    r"""URL to a downloadable PDF of the invoice."""
    documentation: NotRequired[GetInvoiceDocumentationTypedDict]
    r"""URL to the API documentation."""


class GetInvoiceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetInvoiceSelf], pydantic.Field(alias="self")] = None
    r"""URL to the current invoice resource."""

    pdf: Optional[Pdf] = None
    r"""URL to a downloadable PDF of the invoice."""

    documentation: Optional[GetInvoiceDocumentation] = None
    r"""URL to the API documentation."""


class GetInvoiceResponseBodyTypedDict(TypedDict):
    r"""The invoice object."""

    resource: NotRequired[str]
    r"""Indicates that the response contains an invoice object. Will always contain the string `invoice` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this invoice. Example: `inv_FrvewDA3Pr`."""
    reference: NotRequired[str]
    r"""The reference number of the invoice. An example value would be: `2024.10000`."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number to which the invoice was issued to, if applicable."""
    status: NotRequired[str]
    r"""Status of the invoice.

    * `open` — The invoice is not paid yet.
    * `paid` — The invoice is paid.
    * `overdue` — Payment of the invoice is overdue.

    Possible values: `open` `paid` `overdue`
    """
    net_amount: NotRequired[NetAmountTypedDict]
    r"""Total amount of the invoice, excluding VAT."""
    vat_amount: NotRequired[GetInvoiceVatAmountTypedDict]
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside the EU, no VAT will be charged."""
    gross_amount: NotRequired[GrossAmountTypedDict]
    r"""Total amount of the invoice, including VAT."""
    lines: NotRequired[List[GetInvoiceLinesTypedDict]]
    r"""The collection of products which make up the invoice."""
    issued_at: NotRequired[str]
    r"""The invoice date in `YYYY-MM-DD` format."""
    paid_at: NotRequired[Nullable[str]]
    r"""The date on which the invoice was paid, if applicable, in `YYYY-MM-DD` format."""
    due_at: NotRequired[Nullable[str]]
    r"""The date on which the invoice is due, if applicable, in `YYYY-MM-DD` format."""
    links: NotRequired[GetInvoiceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetInvoiceResponseBody(BaseModel):
    r"""The invoice object."""

    resource: Optional[str] = "invoice"
    r"""Indicates that the response contains an invoice object. Will always contain the string `invoice` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this invoice. Example: `inv_FrvewDA3Pr`."""

    reference: Optional[str] = None
    r"""The reference number of the invoice. An example value would be: `2024.10000`."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number to which the invoice was issued to, if applicable."""

    status: Optional[str] = None
    r"""Status of the invoice.

    * `open` — The invoice is not paid yet.
    * `paid` — The invoice is paid.
    * `overdue` — Payment of the invoice is overdue.

    Possible values: `open` `paid` `overdue`
    """

    net_amount: Annotated[Optional[NetAmount], pydantic.Field(alias="netAmount")] = None
    r"""Total amount of the invoice, excluding VAT."""

    vat_amount: Annotated[
        Optional[GetInvoiceVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""VAT amount of the invoice. Only applicable to merchants registered in the Netherlands. For EU merchants, VAT will be shifted to the recipient (as per article 44 and 196 in the EU VAT Directive 2006/112). For merchants outside the EU, no VAT will be charged."""

    gross_amount: Annotated[
        Optional[GrossAmount], pydantic.Field(alias="grossAmount")
    ] = None
    r"""Total amount of the invoice, including VAT."""

    lines: Optional[List[GetInvoiceLines]] = None
    r"""The collection of products which make up the invoice."""

    issued_at: Annotated[Optional[str], pydantic.Field(alias="issuedAt")] = None
    r"""The invoice date in `YYYY-MM-DD` format."""

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date on which the invoice was paid, if applicable, in `YYYY-MM-DD` format."""

    due_at: Annotated[OptionalNullable[str], pydantic.Field(alias="dueAt")] = UNSET
    r"""The date on which the invoice is due, if applicable, in `YYYY-MM-DD` format."""

    links: Annotated[Optional[GetInvoiceLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "reference",
            "vatNumber",
            "status",
            "netAmount",
            "vatAmount",
            "grossAmount",
            "lines",
            "issuedAt",
            "paidAt",
            "dueAt",
            "_links",
        ]
        nullable_fields = ["vatNumber", "paidAt", "dueAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
