"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AddressTypedDict(TypedDict):
    r"""The address of the organization."""

    street_and_number: NotRequired[str]
    r"""A street and street number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    city: NotRequired[str]
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class Address(BaseModel):
    r"""The address of the organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    city: Optional[str] = None

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class OrganizationTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the organization."""
    address: NotRequired[AddressTypedDict]
    r"""The address of the organization."""
    registration_number: NotRequired[str]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field can be omitted for merchants residing in other countries.
    """
    vat_regulation: NotRequired[Nullable[str]]
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field can be omitted for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """


class Organization(BaseModel):
    name: Optional[str] = None
    r"""The name of the organization."""

    address: Optional[Address] = None
    r"""The address of the organization."""

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field can be omitted for merchants residing in other countries.
    """

    vat_regulation: Annotated[
        OptionalNullable[str], pydantic.Field(alias="vatRegulation")
    ] = UNSET
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field can be omitted for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "address",
            "registrationNumber",
            "vatNumber",
            "vatRegulation",
        ]
        nullable_fields = ["vatNumber", "vatRegulation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ProfileTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""
    website: NotRequired[str]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""
    email: NotRequired[str]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[str]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types) for all possible options."""


class Profile(BaseModel):
    name: Optional[str] = None
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""

    website: Optional[str] = None
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""

    email: Optional[str] = None
    r"""The email address associated with the profile's trade name or brand."""

    phone: Optional[str] = None
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types) for all possible options."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "businessCategory",
        ]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SubmitOnboardingDataRequestBodyTypedDict(TypedDict):
    organization: NotRequired[OrganizationTypedDict]
    profile: NotRequired[ProfileTypedDict]


class SubmitOnboardingDataRequestBody(BaseModel):
    organization: Optional[Organization] = None

    profile: Optional[Profile] = None
