"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_ssm_1 = require("@aws-sdk/client-ssm");
const region = process.env.AWS_REGION;
const ssmClient = new client_ssm_1.SSMClient({ region: region });
const ssmParameterName = process.env.SSM_PATH || '';
const handler = async (event, context) => {
    console.info('Printing event:', event);
    console.info('Printing context:', context);
    await processSnsEvent(event);
    return;
};
exports.handler = handler;
async function processSnsEvent(event) {
    for (const record of event.Records) {
        const eventMessage = record.Sns.Message;
        // convert the event message to json
        const messageJson = JSON.parse(eventMessage);
        // obtain the image state
        const imageState = messageJson.state.status;
        // update the SSM parameter if the image state is available
        if (imageState === 'AVAILABLE') {
            console.info('Image is available');
            const recipeName = messageJson.name;
            for (const ami of messageJson.outputResources.amis) {
                // obtain ami id
                console.info('AMI ID:', ami.image);
                // update SSM parameter
                const putParameterCommand = new client_ssm_1.PutParameterCommand({
                    Name: ssmParameterName,
                    Description: 'Latest AMI ID',
                    Value: ami.image,
                    Type: 'String',
                    Overwrite: true,
                    Tier: 'Standard',
                });
                const response = await ssmClient.send(putParameterCommand);
                console.info('SSM Updated:', response);
                // add tags to the SSM parameter
                const addTagsToResourceCommand = new client_ssm_1.AddTagsToResourceCommand({
                    ResourceType: 'Parameter',
                    ResourceId: ssmParameterName,
                    Tags: [
                        {
                            Key: 'Source',
                            Value: 'EC2 Image Builder',
                        },
                        {
                            Key: 'AMI_REGION',
                            Value: ami.region,
                        },
                        {
                            Key: 'AMI_ID',
                            Value: ami.image,
                        },
                        {
                            Key: 'AMI_NAME',
                            Value: ami.name,
                        },
                        {
                            Key: 'RECIPE_NAME',
                            Value: recipeName,
                        },
                        {
                            Key: 'SOURCE_PIPELINE_ARN',
                            Value: messageJson.sourcePipelineArn,
                        },
                    ],
                });
                await ssmClient.send(addTagsToResourceCommand);
            }
        }
    }
    return;
}
//# sourceMappingURL=data:application/json;base64,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