"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildStateType = buildStateType;
function buildStateType(stateDef, indent = 2) {
    let stateType = 'Partial<{\n';
    const indentTabs = '  '.repeat(indent);
    const closeIndents = '  '.repeat(indent - 1);
    if (stateDef === null) {
        // we're going to return an any here because while it's null now, maybe it'll be an any later.
        return 'any';
    }
    if (typeof stateDef === 'string') {
        return 'string';
    }
    if (Number.isInteger(stateDef)) {
        return 'number';
    }
    for (const prop of Object.keys(stateDef)) {
        const propValue = stateDef[prop];
        const safeProp = prop.replace(/'/g, '\\\'');
        if (typeof propValue === 'string') {
            stateType += `${indentTabs}'${safeProp}': string;\n`;
        }
        else if (Array.isArray(propValue)) {
            const arrayPropTypes = propValue.map(pv => buildStateType(pv, indent + 1));
            stateType += `${indentTabs}'${safeProp}': Partial<[${arrayPropTypes.join(', ')}]>;\n`;
        }
        else {
            stateType += `${indentTabs}'${safeProp}': ${buildStateType(propValue, indent + 1)};\n`;
        }
    }
    stateType += `${closeIndents}}>`;
    return stateType;
}
//# sourceMappingURL=data:application/json;base64,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