"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateMachine = void 0;
const aws_stepfunctions = require("aws-cdk-lib/aws-stepfunctions");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const yaml = require("js-yaml");
const lodash_1 = require("lodash");
class StateMachine extends aws_stepfunctions.StateMachine {
    constructor(scope, id, props) {
        const mergedDefinition = (0, lodash_1.merge)(props.definition, { States: props.overrides });
        let definitionString;
        if (props.aslYaml) {
            definitionString = yaml.dump(mergedDefinition);
        }
        else {
            definitionString = JSON.stringify(mergedDefinition);
        }
        const propsMinusDefinition = {
            ...props,
            definition: undefined,
        };
        delete propsMinusDefinition.definition;
        super(scope, id, {
            ...propsMinusDefinition,
            definitionBody: aws_stepfunctions_1.DefinitionBody.fromString(definitionString),
        });
    }
}
exports.StateMachine = StateMachine;
//# sourceMappingURL=data:application/json;base64,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