import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeCapacityBlockStatusCommand, se_DescribeCapacityBlockStatusCommand } from "../protocols/Aws_ec2";
export { $Command };
export class DescribeCapacityBlockStatusCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2", "DescribeCapacityBlockStatus", {})
    .n("EC2Client", "DescribeCapacityBlockStatusCommand")
    .f(void 0, void 0)
    .ser(se_DescribeCapacityBlockStatusCommand)
    .de(de_DescribeCapacityBlockStatusCommand)
    .build() {
}
