import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeImageUsageReportsCommand, se_DescribeImageUsageReportsCommand } from "../protocols/Aws_ec2";
export { $Command };
export class DescribeImageUsageReportsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2", "DescribeImageUsageReports", {})
    .n("EC2Client", "DescribeImageUsageReportsCommand")
    .f(void 0, void 0)
    .ser(se_DescribeImageUsageReportsCommand)
    .de(de_DescribeImageUsageReportsCommand)
    .build() {
}
