import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResult } from "../models/models_2";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateNetworkInterfacePermissionCommand}.
 */
export interface CreateNetworkInterfacePermissionCommandInput extends CreateNetworkInterfacePermissionRequest {
}
/**
 * @public
 *
 * The output of {@link CreateNetworkInterfacePermissionCommand}.
 */
export interface CreateNetworkInterfacePermissionCommandOutput extends CreateNetworkInterfacePermissionResult, __MetadataBearer {
}
declare const CreateNetworkInterfacePermissionCommand_base: {
    new (input: CreateNetworkInterfacePermissionCommandInput): import("@smithy/smithy-client").CommandImpl<CreateNetworkInterfacePermissionCommandInput, CreateNetworkInterfacePermissionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateNetworkInterfacePermissionCommandInput): import("@smithy/smithy-client").CommandImpl<CreateNetworkInterfacePermissionCommandInput, CreateNetworkInterfacePermissionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Grants an Amazon Web Services-authorized account permission to attach the specified
 *             network interface to an instance in their account.</p>
 *          <p>You can grant permission to a single Amazon Web Services account only, and only one
 *             account at a time.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateNetworkInterfacePermissionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateNetworkInterfacePermissionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // CreateNetworkInterfacePermissionRequest
 *   NetworkInterfaceId: "STRING_VALUE", // required
 *   AwsAccountId: "STRING_VALUE",
 *   AwsService: "STRING_VALUE",
 *   Permission: "INSTANCE-ATTACH" || "EIP-ASSOCIATE", // required
 *   DryRun: true || false,
 * };
 * const command = new CreateNetworkInterfacePermissionCommand(input);
 * const response = await client.send(command);
 * // { // CreateNetworkInterfacePermissionResult
 * //   InterfacePermission: { // NetworkInterfacePermission
 * //     NetworkInterfacePermissionId: "STRING_VALUE",
 * //     NetworkInterfaceId: "STRING_VALUE",
 * //     AwsAccountId: "STRING_VALUE",
 * //     AwsService: "STRING_VALUE",
 * //     Permission: "INSTANCE-ATTACH" || "EIP-ASSOCIATE",
 * //     PermissionState: { // NetworkInterfacePermissionState
 * //       State: "pending" || "granted" || "revoking" || "revoked",
 * //       StatusMessage: "STRING_VALUE",
 * //     },
 * //   },
 * // };
 *
 * ```
 *
 * @param CreateNetworkInterfacePermissionCommandInput - {@link CreateNetworkInterfacePermissionCommandInput}
 * @returns {@link CreateNetworkInterfacePermissionCommandOutput}
 * @see {@link CreateNetworkInterfacePermissionCommandInput} for command's `input` shape.
 * @see {@link CreateNetworkInterfacePermissionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class CreateNetworkInterfacePermissionCommand extends CreateNetworkInterfacePermissionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateNetworkInterfacePermissionRequest;
            output: CreateNetworkInterfacePermissionResult;
        };
        sdk: {
            input: CreateNetworkInterfacePermissionCommandInput;
            output: CreateNetworkInterfacePermissionCommandOutput;
        };
    };
}
