import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisassociateAddressRequest } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DisassociateAddressCommand}.
 */
export interface DisassociateAddressCommandInput extends DisassociateAddressRequest {
}
/**
 * @public
 *
 * The output of {@link DisassociateAddressCommand}.
 */
export interface DisassociateAddressCommandOutput extends __MetadataBearer {
}
declare const DisassociateAddressCommand_base: {
    new (input: DisassociateAddressCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateAddressCommandInput, DisassociateAddressCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DisassociateAddressCommandInput]): import("@smithy/smithy-client").CommandImpl<DisassociateAddressCommandInput, DisassociateAddressCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disassociates an Elastic IP address from the instance or network interface it's associated with.</p>
 *          <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.</p>
 *          <p>An address cannot be disassociated if the all of the following conditions are met:</p>
 *          <ul>
 *             <li>
 *                <p>Network interface has a <code>publicDualStackDnsName</code> publicDnsName</p>
 *             </li>
 *             <li>
 *                <p>Public IPv4 address is the primary public IPv4 address</p>
 *             </li>
 *             <li>
 *                <p>Network interface only has one remaining public IPv4 address</p>
 *             </li>
 *          </ul>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisassociateAddressCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisassociateAddressCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // DisassociateAddressRequest
 *   AssociationId: "STRING_VALUE",
 *   PublicIp: "STRING_VALUE",
 *   DryRun: true || false,
 * };
 * const command = new DisassociateAddressCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DisassociateAddressCommandInput - {@link DisassociateAddressCommandInput}
 * @returns {@link DisassociateAddressCommandOutput}
 * @see {@link DisassociateAddressCommandInput} for command's `input` shape.
 * @see {@link DisassociateAddressCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @example To disassociate an Elastic IP address
 * ```javascript
 * // This example disassociates an Elastic IP address from an instance.
 * const input = {
 *   AssociationId: "eipassoc-2bebb745"
 * };
 * const command = new DisassociateAddressCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @public
 */
export declare class DisassociateAddressCommand extends DisassociateAddressCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DisassociateAddressRequest;
            output: {};
        };
        sdk: {
            input: DisassociateAddressCommandInput;
            output: DisassociateAddressCommandOutput;
        };
    };
}
