export interface AcceleratorCount {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface AcceleratorCountRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export declare const AcceleratorManufacturer: {
  readonly AMAZON_WEB_SERVICES: "amazon-web-services";
  readonly AMD: "amd";
  readonly HABANA: "habana";
  readonly NVIDIA: "nvidia";
  readonly XILINX: "xilinx";
};
export type AcceleratorManufacturer =
  (typeof AcceleratorManufacturer)[keyof typeof AcceleratorManufacturer];
export declare const AcceleratorName: {
  readonly A100: "a100";
  readonly A10G: "a10g";
  readonly H100: "h100";
  readonly INFERENTIA: "inferentia";
  readonly K520: "k520";
  readonly K80: "k80";
  readonly M60: "m60";
  readonly RADEON_PRO_V520: "radeon-pro-v520";
  readonly T4: "t4";
  readonly T4G: "t4g";
  readonly V100: "v100";
  readonly VU9P: "vu9p";
};
export type AcceleratorName =
  (typeof AcceleratorName)[keyof typeof AcceleratorName];
export interface AcceleratorTotalMemoryMiB {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface AcceleratorTotalMemoryMiBRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export declare const AcceleratorType: {
  readonly FPGA: "fpga";
  readonly GPU: "gpu";
  readonly INFERENCE: "inference";
};
export type AcceleratorType =
  (typeof AcceleratorType)[keyof typeof AcceleratorType];
export declare const ResourceType: {
  readonly capacity_block: "capacity-block";
  readonly capacity_reservation: "capacity-reservation";
  readonly capacity_reservation_fleet: "capacity-reservation-fleet";
  readonly carrier_gateway: "carrier-gateway";
  readonly client_vpn_endpoint: "client-vpn-endpoint";
  readonly coip_pool: "coip-pool";
  readonly customer_gateway: "customer-gateway";
  readonly declarative_policies_report: "declarative-policies-report";
  readonly dedicated_host: "dedicated-host";
  readonly dhcp_options: "dhcp-options";
  readonly egress_only_internet_gateway: "egress-only-internet-gateway";
  readonly elastic_gpu: "elastic-gpu";
  readonly elastic_ip: "elastic-ip";
  readonly export_image_task: "export-image-task";
  readonly export_instance_task: "export-instance-task";
  readonly fleet: "fleet";
  readonly fpga_image: "fpga-image";
  readonly host_reservation: "host-reservation";
  readonly image: "image";
  readonly image_usage_report: "image-usage-report";
  readonly import_image_task: "import-image-task";
  readonly import_snapshot_task: "import-snapshot-task";
  readonly instance: "instance";
  readonly instance_connect_endpoint: "instance-connect-endpoint";
  readonly instance_event_window: "instance-event-window";
  readonly internet_gateway: "internet-gateway";
  readonly ipam: "ipam";
  readonly ipam_external_resource_verification_token: "ipam-external-resource-verification-token";
  readonly ipam_pool: "ipam-pool";
  readonly ipam_resource_discovery: "ipam-resource-discovery";
  readonly ipam_resource_discovery_association: "ipam-resource-discovery-association";
  readonly ipam_scope: "ipam-scope";
  readonly ipv4pool_ec2: "ipv4pool-ec2";
  readonly ipv6pool_ec2: "ipv6pool-ec2";
  readonly key_pair: "key-pair";
  readonly launch_template: "launch-template";
  readonly local_gateway: "local-gateway";
  readonly local_gateway_route_table: "local-gateway-route-table";
  readonly local_gateway_route_table_virtual_interface_group_association: "local-gateway-route-table-virtual-interface-group-association";
  readonly local_gateway_route_table_vpc_association: "local-gateway-route-table-vpc-association";
  readonly local_gateway_virtual_interface: "local-gateway-virtual-interface";
  readonly local_gateway_virtual_interface_group: "local-gateway-virtual-interface-group";
  readonly mac_modification_task: "mac-modification-task";
  readonly natgateway: "natgateway";
  readonly network_acl: "network-acl";
  readonly network_insights_access_scope: "network-insights-access-scope";
  readonly network_insights_access_scope_analysis: "network-insights-access-scope-analysis";
  readonly network_insights_analysis: "network-insights-analysis";
  readonly network_insights_path: "network-insights-path";
  readonly network_interface: "network-interface";
  readonly outpost_lag: "outpost-lag";
  readonly placement_group: "placement-group";
  readonly prefix_list: "prefix-list";
  readonly replace_root_volume_task: "replace-root-volume-task";
  readonly reserved_instances: "reserved-instances";
  readonly route_server: "route-server";
  readonly route_server_endpoint: "route-server-endpoint";
  readonly route_server_peer: "route-server-peer";
  readonly route_table: "route-table";
  readonly security_group: "security-group";
  readonly security_group_rule: "security-group-rule";
  readonly service_link_virtual_interface: "service-link-virtual-interface";
  readonly snapshot: "snapshot";
  readonly spot_fleet_request: "spot-fleet-request";
  readonly spot_instances_request: "spot-instances-request";
  readonly subnet: "subnet";
  readonly subnet_cidr_reservation: "subnet-cidr-reservation";
  readonly traffic_mirror_filter: "traffic-mirror-filter";
  readonly traffic_mirror_filter_rule: "traffic-mirror-filter-rule";
  readonly traffic_mirror_session: "traffic-mirror-session";
  readonly traffic_mirror_target: "traffic-mirror-target";
  readonly transit_gateway: "transit-gateway";
  readonly transit_gateway_attachment: "transit-gateway-attachment";
  readonly transit_gateway_connect_peer: "transit-gateway-connect-peer";
  readonly transit_gateway_multicast_domain: "transit-gateway-multicast-domain";
  readonly transit_gateway_policy_table: "transit-gateway-policy-table";
  readonly transit_gateway_route_table: "transit-gateway-route-table";
  readonly transit_gateway_route_table_announcement: "transit-gateway-route-table-announcement";
  readonly verified_access_endpoint: "verified-access-endpoint";
  readonly verified_access_endpoint_target: "verified-access-endpoint-target";
  readonly verified_access_group: "verified-access-group";
  readonly verified_access_instance: "verified-access-instance";
  readonly verified_access_policy: "verified-access-policy";
  readonly verified_access_trust_provider: "verified-access-trust-provider";
  readonly volume: "volume";
  readonly vpc: "vpc";
  readonly vpc_block_public_access_exclusion: "vpc-block-public-access-exclusion";
  readonly vpc_endpoint: "vpc-endpoint";
  readonly vpc_endpoint_connection: "vpc-endpoint-connection";
  readonly vpc_endpoint_connection_device_type: "vpc-endpoint-connection-device-type";
  readonly vpc_endpoint_service: "vpc-endpoint-service";
  readonly vpc_endpoint_service_permission: "vpc-endpoint-service-permission";
  readonly vpc_flow_log: "vpc-flow-log";
  readonly vpc_peering_connection: "vpc-peering-connection";
  readonly vpn_connection: "vpn-connection";
  readonly vpn_connection_device_type: "vpn-connection-device-type";
  readonly vpn_gateway: "vpn-gateway";
};
export type ResourceType = (typeof ResourceType)[keyof typeof ResourceType];
export interface Tag {
  Key?: string | undefined;
  Value?: string | undefined;
}
export interface TagSpecification {
  ResourceType?: ResourceType | undefined;
  Tags?: Tag[] | undefined;
}
export interface AcceptAddressTransferRequest {
  Address: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const AddressTransferStatus: {
  readonly accepted: "accepted";
  readonly disabled: "disabled";
  readonly pending: "pending";
};
export type AddressTransferStatus =
  (typeof AddressTransferStatus)[keyof typeof AddressTransferStatus];
export interface AddressTransfer {
  PublicIp?: string | undefined;
  AllocationId?: string | undefined;
  TransferAccountId?: string | undefined;
  TransferOfferExpirationTimestamp?: Date | undefined;
  TransferOfferAcceptedTimestamp?: Date | undefined;
  AddressTransferStatus?: AddressTransferStatus | undefined;
}
export interface AcceptAddressTransferResult {
  AddressTransfer?: AddressTransfer | undefined;
}
export interface AcceptCapacityReservationBillingOwnershipRequest {
  DryRun?: boolean | undefined;
  CapacityReservationId: string | undefined;
}
export interface AcceptCapacityReservationBillingOwnershipResult {
  Return?: boolean | undefined;
}
export interface TargetConfigurationRequest {
  InstanceCount?: number | undefined;
  OfferingId: string | undefined;
}
export interface AcceptReservedInstancesExchangeQuoteRequest {
  DryRun?: boolean | undefined;
  ReservedInstanceIds: string[] | undefined;
  TargetConfigurations?: TargetConfigurationRequest[] | undefined;
}
export interface AcceptReservedInstancesExchangeQuoteResult {
  ExchangeId?: string | undefined;
}
export interface AcceptTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId?: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  SubnetIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayAttachmentResourceType: {
  readonly connect: "connect";
  readonly direct_connect_gateway: "direct-connect-gateway";
  readonly network_function: "network-function";
  readonly peering: "peering";
  readonly tgw_peering: "tgw-peering";
  readonly vpc: "vpc";
  readonly vpn: "vpn";
};
export type TransitGatewayAttachmentResourceType =
  (typeof TransitGatewayAttachmentResourceType)[keyof typeof TransitGatewayAttachmentResourceType];
export declare const TransitGatewayMulitcastDomainAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
  readonly pendingAcceptance: "pendingAcceptance";
  readonly rejected: "rejected";
};
export type TransitGatewayMulitcastDomainAssociationState =
  (typeof TransitGatewayMulitcastDomainAssociationState)[keyof typeof TransitGatewayMulitcastDomainAssociationState];
export interface SubnetAssociation {
  SubnetId?: string | undefined;
  State?: TransitGatewayMulitcastDomainAssociationState | undefined;
}
export interface TransitGatewayMulticastDomainAssociations {
  TransitGatewayMulticastDomainId?: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  ResourceOwnerId?: string | undefined;
  Subnets?: SubnetAssociation[] | undefined;
}
export interface AcceptTransitGatewayMulticastDomainAssociationsResult {
  Associations?: TransitGatewayMulticastDomainAssociations | undefined;
}
export interface AcceptTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface PeeringTgwInfo {
  TransitGatewayId?: string | undefined;
  CoreNetworkId?: string | undefined;
  OwnerId?: string | undefined;
  Region?: string | undefined;
}
export declare const DynamicRoutingValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DynamicRoutingValue =
  (typeof DynamicRoutingValue)[keyof typeof DynamicRoutingValue];
export interface TransitGatewayPeeringAttachmentOptions {
  DynamicRouting?: DynamicRoutingValue | undefined;
}
export declare const TransitGatewayAttachmentState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly failed: "failed";
  readonly failing: "failing";
  readonly initiating: "initiating";
  readonly initiatingRequest: "initiatingRequest";
  readonly modifying: "modifying";
  readonly pending: "pending";
  readonly pendingAcceptance: "pendingAcceptance";
  readonly rejected: "rejected";
  readonly rejecting: "rejecting";
  readonly rollingBack: "rollingBack";
};
export type TransitGatewayAttachmentState =
  (typeof TransitGatewayAttachmentState)[keyof typeof TransitGatewayAttachmentState];
export interface PeeringAttachmentStatus {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface TransitGatewayPeeringAttachment {
  TransitGatewayAttachmentId?: string | undefined;
  AccepterTransitGatewayAttachmentId?: string | undefined;
  RequesterTgwInfo?: PeeringTgwInfo | undefined;
  AccepterTgwInfo?: PeeringTgwInfo | undefined;
  Options?: TransitGatewayPeeringAttachmentOptions | undefined;
  Status?: PeeringAttachmentStatus | undefined;
  State?: TransitGatewayAttachmentState | undefined;
  CreationTime?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface AcceptTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment | undefined;
}
export interface AcceptTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const ApplianceModeSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type ApplianceModeSupportValue =
  (typeof ApplianceModeSupportValue)[keyof typeof ApplianceModeSupportValue];
export declare const DnsSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DnsSupportValue =
  (typeof DnsSupportValue)[keyof typeof DnsSupportValue];
export declare const Ipv6SupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type Ipv6SupportValue =
  (typeof Ipv6SupportValue)[keyof typeof Ipv6SupportValue];
export declare const SecurityGroupReferencingSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type SecurityGroupReferencingSupportValue =
  (typeof SecurityGroupReferencingSupportValue)[keyof typeof SecurityGroupReferencingSupportValue];
export interface TransitGatewayVpcAttachmentOptions {
  DnsSupport?: DnsSupportValue | undefined;
  SecurityGroupReferencingSupport?:
    | SecurityGroupReferencingSupportValue
    | undefined;
  Ipv6Support?: Ipv6SupportValue | undefined;
  ApplianceModeSupport?: ApplianceModeSupportValue | undefined;
}
export interface TransitGatewayVpcAttachment {
  TransitGatewayAttachmentId?: string | undefined;
  TransitGatewayId?: string | undefined;
  VpcId?: string | undefined;
  VpcOwnerId?: string | undefined;
  State?: TransitGatewayAttachmentState | undefined;
  SubnetIds?: string[] | undefined;
  CreationTime?: Date | undefined;
  Options?: TransitGatewayVpcAttachmentOptions | undefined;
  Tags?: Tag[] | undefined;
}
export interface AcceptTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment | undefined;
}
export interface AcceptVpcEndpointConnectionsRequest {
  DryRun?: boolean | undefined;
  ServiceId: string | undefined;
  VpcEndpointIds: string[] | undefined;
}
export interface UnsuccessfulItemError {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface UnsuccessfulItem {
  Error?: UnsuccessfulItemError | undefined;
  ResourceId?: string | undefined;
}
export interface AcceptVpcEndpointConnectionsResult {
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface AcceptVpcPeeringConnectionRequest {
  DryRun?: boolean | undefined;
  VpcPeeringConnectionId: string | undefined;
}
export interface CidrBlock {
  CidrBlock?: string | undefined;
}
export interface Ipv6CidrBlock {
  Ipv6CidrBlock?: string | undefined;
}
export interface VpcPeeringConnectionOptionsDescription {
  AllowDnsResolutionFromRemoteVpc?: boolean | undefined;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean | undefined;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean | undefined;
}
export interface VpcPeeringConnectionVpcInfo {
  CidrBlock?: string | undefined;
  Ipv6CidrBlockSet?: Ipv6CidrBlock[] | undefined;
  CidrBlockSet?: CidrBlock[] | undefined;
  OwnerId?: string | undefined;
  PeeringOptions?: VpcPeeringConnectionOptionsDescription | undefined;
  VpcId?: string | undefined;
  Region?: string | undefined;
}
export declare const VpcPeeringConnectionStateReasonCode: {
  readonly active: "active";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly expired: "expired";
  readonly failed: "failed";
  readonly initiating_request: "initiating-request";
  readonly pending_acceptance: "pending-acceptance";
  readonly provisioning: "provisioning";
  readonly rejected: "rejected";
};
export type VpcPeeringConnectionStateReasonCode =
  (typeof VpcPeeringConnectionStateReasonCode)[keyof typeof VpcPeeringConnectionStateReasonCode];
export interface VpcPeeringConnectionStateReason {
  Code?: VpcPeeringConnectionStateReasonCode | undefined;
  Message?: string | undefined;
}
export interface VpcPeeringConnection {
  AccepterVpcInfo?: VpcPeeringConnectionVpcInfo | undefined;
  ExpirationTime?: Date | undefined;
  RequesterVpcInfo?: VpcPeeringConnectionVpcInfo | undefined;
  Status?: VpcPeeringConnectionStateReason | undefined;
  Tags?: Tag[] | undefined;
  VpcPeeringConnectionId?: string | undefined;
}
export interface AcceptVpcPeeringConnectionResult {
  VpcPeeringConnection?: VpcPeeringConnection | undefined;
}
export interface PortRange {
  From?: number | undefined;
  To?: number | undefined;
}
export interface AnalysisAclRule {
  Cidr?: string | undefined;
  Egress?: boolean | undefined;
  PortRange?: PortRange | undefined;
  Protocol?: string | undefined;
  RuleAction?: string | undefined;
  RuleNumber?: number | undefined;
}
export interface AnalysisComponent {
  Id?: string | undefined;
  Arn?: string | undefined;
  Name?: string | undefined;
}
export interface RuleOption {
  Keyword?: string | undefined;
  Settings?: string[] | undefined;
}
export interface RuleGroupRuleOptionsPair {
  RuleGroupArn?: string | undefined;
  RuleOptions?: RuleOption[] | undefined;
}
export interface RuleGroupTypePair {
  RuleGroupArn?: string | undefined;
  RuleGroupType?: string | undefined;
}
export interface AdditionalDetail {
  AdditionalDetailType?: string | undefined;
  Component?: AnalysisComponent | undefined;
  VpcEndpointService?: AnalysisComponent | undefined;
  RuleOptions?: RuleOption[] | undefined;
  RuleGroupTypePairs?: RuleGroupTypePair[] | undefined;
  RuleGroupRuleOptionsPairs?: RuleGroupRuleOptionsPair[] | undefined;
  ServiceName?: string | undefined;
  LoadBalancers?: AnalysisComponent[] | undefined;
}
export interface AnalysisLoadBalancerListener {
  LoadBalancerPort?: number | undefined;
  InstancePort?: number | undefined;
}
export interface FirewallStatefulRule {
  RuleGroupArn?: string | undefined;
  Sources?: string[] | undefined;
  Destinations?: string[] | undefined;
  SourcePorts?: PortRange[] | undefined;
  DestinationPorts?: PortRange[] | undefined;
  Protocol?: string | undefined;
  RuleAction?: string | undefined;
  Direction?: string | undefined;
}
export interface FirewallStatelessRule {
  RuleGroupArn?: string | undefined;
  Sources?: string[] | undefined;
  Destinations?: string[] | undefined;
  SourcePorts?: PortRange[] | undefined;
  DestinationPorts?: PortRange[] | undefined;
  Protocols?: number[] | undefined;
  RuleAction?: string | undefined;
  Priority?: number | undefined;
}
export interface AnalysisLoadBalancerTarget {
  Address?: string | undefined;
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  Instance?: AnalysisComponent | undefined;
  Port?: number | undefined;
}
export interface AnalysisRouteTableRoute {
  DestinationCidr?: string | undefined;
  DestinationPrefixListId?: string | undefined;
  EgressOnlyInternetGatewayId?: string | undefined;
  GatewayId?: string | undefined;
  InstanceId?: string | undefined;
  NatGatewayId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  Origin?: string | undefined;
  TransitGatewayId?: string | undefined;
  VpcPeeringConnectionId?: string | undefined;
  State?: string | undefined;
  CarrierGatewayId?: string | undefined;
  CoreNetworkArn?: string | undefined;
  LocalGatewayId?: string | undefined;
}
export interface AnalysisSecurityGroupRule {
  Cidr?: string | undefined;
  Direction?: string | undefined;
  SecurityGroupId?: string | undefined;
  PortRange?: PortRange | undefined;
  PrefixListId?: string | undefined;
  Protocol?: string | undefined;
}
export interface TransitGatewayRouteTableRoute {
  DestinationCidr?: string | undefined;
  State?: string | undefined;
  RouteOrigin?: string | undefined;
  PrefixListId?: string | undefined;
  AttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: string | undefined;
}
export interface Explanation {
  Acl?: AnalysisComponent | undefined;
  AclRule?: AnalysisAclRule | undefined;
  Address?: string | undefined;
  Addresses?: string[] | undefined;
  AttachedTo?: AnalysisComponent | undefined;
  AvailabilityZones?: string[] | undefined;
  AvailabilityZoneIds?: string[] | undefined;
  Cidrs?: string[] | undefined;
  Component?: AnalysisComponent | undefined;
  CustomerGateway?: AnalysisComponent | undefined;
  Destination?: AnalysisComponent | undefined;
  DestinationVpc?: AnalysisComponent | undefined;
  Direction?: string | undefined;
  ExplanationCode?: string | undefined;
  IngressRouteTable?: AnalysisComponent | undefined;
  InternetGateway?: AnalysisComponent | undefined;
  LoadBalancerArn?: string | undefined;
  ClassicLoadBalancerListener?: AnalysisLoadBalancerListener | undefined;
  LoadBalancerListenerPort?: number | undefined;
  LoadBalancerTarget?: AnalysisLoadBalancerTarget | undefined;
  LoadBalancerTargetGroup?: AnalysisComponent | undefined;
  LoadBalancerTargetGroups?: AnalysisComponent[] | undefined;
  LoadBalancerTargetPort?: number | undefined;
  ElasticLoadBalancerListener?: AnalysisComponent | undefined;
  MissingComponent?: string | undefined;
  NatGateway?: AnalysisComponent | undefined;
  NetworkInterface?: AnalysisComponent | undefined;
  PacketField?: string | undefined;
  VpcPeeringConnection?: AnalysisComponent | undefined;
  Port?: number | undefined;
  PortRanges?: PortRange[] | undefined;
  PrefixList?: AnalysisComponent | undefined;
  Protocols?: string[] | undefined;
  RouteTableRoute?: AnalysisRouteTableRoute | undefined;
  RouteTable?: AnalysisComponent | undefined;
  SecurityGroup?: AnalysisComponent | undefined;
  SecurityGroupRule?: AnalysisSecurityGroupRule | undefined;
  SecurityGroups?: AnalysisComponent[] | undefined;
  SourceVpc?: AnalysisComponent | undefined;
  State?: string | undefined;
  Subnet?: AnalysisComponent | undefined;
  SubnetRouteTable?: AnalysisComponent | undefined;
  Vpc?: AnalysisComponent | undefined;
  VpcEndpoint?: AnalysisComponent | undefined;
  VpnConnection?: AnalysisComponent | undefined;
  VpnGateway?: AnalysisComponent | undefined;
  TransitGateway?: AnalysisComponent | undefined;
  TransitGatewayRouteTable?: AnalysisComponent | undefined;
  TransitGatewayRouteTableRoute?: TransitGatewayRouteTableRoute | undefined;
  TransitGatewayAttachment?: AnalysisComponent | undefined;
  ComponentAccount?: string | undefined;
  ComponentRegion?: string | undefined;
  FirewallStatelessRule?: FirewallStatelessRule | undefined;
  FirewallStatefulRule?: FirewallStatefulRule | undefined;
}
export interface AnalysisPacketHeader {
  DestinationAddresses?: string[] | undefined;
  DestinationPortRanges?: PortRange[] | undefined;
  Protocol?: string | undefined;
  SourceAddresses?: string[] | undefined;
  SourcePortRanges?: PortRange[] | undefined;
}
export interface PathComponent {
  SequenceNumber?: number | undefined;
  AclRule?: AnalysisAclRule | undefined;
  AttachedTo?: AnalysisComponent | undefined;
  Component?: AnalysisComponent | undefined;
  DestinationVpc?: AnalysisComponent | undefined;
  OutboundHeader?: AnalysisPacketHeader | undefined;
  InboundHeader?: AnalysisPacketHeader | undefined;
  RouteTableRoute?: AnalysisRouteTableRoute | undefined;
  SecurityGroupRule?: AnalysisSecurityGroupRule | undefined;
  SourceVpc?: AnalysisComponent | undefined;
  Subnet?: AnalysisComponent | undefined;
  Vpc?: AnalysisComponent | undefined;
  AdditionalDetails?: AdditionalDetail[] | undefined;
  TransitGateway?: AnalysisComponent | undefined;
  TransitGatewayRouteTableRoute?: TransitGatewayRouteTableRoute | undefined;
  Explanations?: Explanation[] | undefined;
  ElasticLoadBalancerListener?: AnalysisComponent | undefined;
  FirewallStatelessRule?: FirewallStatelessRule | undefined;
  FirewallStatefulRule?: FirewallStatefulRule | undefined;
  ServiceName?: string | undefined;
}
export interface AccessScopeAnalysisFinding {
  NetworkInsightsAccessScopeAnalysisId?: string | undefined;
  NetworkInsightsAccessScopeId?: string | undefined;
  FindingId?: string | undefined;
  FindingComponents?: PathComponent[] | undefined;
}
export declare const Protocol: {
  readonly tcp: "tcp";
  readonly udp: "udp";
};
export type Protocol = (typeof Protocol)[keyof typeof Protocol];
export interface PacketHeaderStatement {
  SourceAddresses?: string[] | undefined;
  DestinationAddresses?: string[] | undefined;
  SourcePorts?: string[] | undefined;
  DestinationPorts?: string[] | undefined;
  SourcePrefixLists?: string[] | undefined;
  DestinationPrefixLists?: string[] | undefined;
  Protocols?: Protocol[] | undefined;
}
export interface ResourceStatement {
  Resources?: string[] | undefined;
  ResourceTypes?: string[] | undefined;
}
export interface PathStatement {
  PacketHeaderStatement?: PacketHeaderStatement | undefined;
  ResourceStatement?: ResourceStatement | undefined;
}
export interface ThroughResourcesStatement {
  ResourceStatement?: ResourceStatement | undefined;
}
export interface AccessScopePath {
  Source?: PathStatement | undefined;
  Destination?: PathStatement | undefined;
  ThroughResources?: ThroughResourcesStatement[] | undefined;
}
export interface PacketHeaderStatementRequest {
  SourceAddresses?: string[] | undefined;
  DestinationAddresses?: string[] | undefined;
  SourcePorts?: string[] | undefined;
  DestinationPorts?: string[] | undefined;
  SourcePrefixLists?: string[] | undefined;
  DestinationPrefixLists?: string[] | undefined;
  Protocols?: Protocol[] | undefined;
}
export interface ResourceStatementRequest {
  Resources?: string[] | undefined;
  ResourceTypes?: string[] | undefined;
}
export interface PathStatementRequest {
  PacketHeaderStatement?: PacketHeaderStatementRequest | undefined;
  ResourceStatement?: ResourceStatementRequest | undefined;
}
export interface ThroughResourcesStatementRequest {
  ResourceStatement?: ResourceStatementRequest | undefined;
}
export interface AccessScopePathRequest {
  Source?: PathStatementRequest | undefined;
  Destination?: PathStatementRequest | undefined;
  ThroughResources?: ThroughResourcesStatementRequest[] | undefined;
}
export interface AccountAttributeValue {
  AttributeValue?: string | undefined;
}
export interface AccountAttribute {
  AttributeName?: string | undefined;
  AttributeValues?: AccountAttributeValue[] | undefined;
}
export declare const AccountAttributeName: {
  readonly default_vpc: "default-vpc";
  readonly supported_platforms: "supported-platforms";
};
export type AccountAttributeName =
  (typeof AccountAttributeName)[keyof typeof AccountAttributeName];
export declare const InstanceHealthStatus: {
  readonly HEALTHY_STATUS: "healthy";
  readonly UNHEALTHY_STATUS: "unhealthy";
};
export type InstanceHealthStatus =
  (typeof InstanceHealthStatus)[keyof typeof InstanceHealthStatus];
export interface ActiveInstance {
  InstanceId?: string | undefined;
  InstanceType?: string | undefined;
  SpotInstanceRequestId?: string | undefined;
  InstanceHealth?: InstanceHealthStatus | undefined;
}
export declare const VpnTunnelProvisioningStatus: {
  readonly available: "available";
  readonly failed: "failed";
  readonly pending: "pending";
};
export type VpnTunnelProvisioningStatus =
  (typeof VpnTunnelProvisioningStatus)[keyof typeof VpnTunnelProvisioningStatus];
export interface ActiveVpnTunnelStatus {
  Phase1EncryptionAlgorithm?: string | undefined;
  Phase2EncryptionAlgorithm?: string | undefined;
  Phase1IntegrityAlgorithm?: string | undefined;
  Phase2IntegrityAlgorithm?: string | undefined;
  Phase1DHGroup?: number | undefined;
  Phase2DHGroup?: number | undefined;
  IkeVersion?: string | undefined;
  ProvisioningStatus?: VpnTunnelProvisioningStatus | undefined;
  ProvisioningStatusReason?: string | undefined;
}
export declare const ActivityStatus: {
  readonly ERROR: "error";
  readonly FULFILLED: "fulfilled";
  readonly PENDING_FULFILLMENT: "pending_fulfillment";
  readonly PENDING_TERMINATION: "pending_termination";
};
export type ActivityStatus =
  (typeof ActivityStatus)[keyof typeof ActivityStatus];
export declare const PrincipalType: {
  readonly Account: "Account";
  readonly All: "All";
  readonly OrganizationUnit: "OrganizationUnit";
  readonly Role: "Role";
  readonly Service: "Service";
  readonly User: "User";
};
export type PrincipalType = (typeof PrincipalType)[keyof typeof PrincipalType];
export interface AddedPrincipal {
  PrincipalType?: PrincipalType | undefined;
  Principal?: string | undefined;
  ServicePermissionId?: string | undefined;
  ServiceId?: string | undefined;
}
export interface AddIpamOperatingRegion {
  RegionName?: string | undefined;
}
export interface AddIpamOrganizationalUnitExclusion {
  OrganizationsEntityPath?: string | undefined;
}
export interface AddPrefixListEntry {
  Cidr: string | undefined;
  Description?: string | undefined;
}
export declare const DomainType: {
  readonly standard: "standard";
  readonly vpc: "vpc";
};
export type DomainType = (typeof DomainType)[keyof typeof DomainType];
export declare const ServiceManaged: {
  readonly alb: "alb";
  readonly nlb: "nlb";
  readonly rnat: "rnat";
};
export type ServiceManaged =
  (typeof ServiceManaged)[keyof typeof ServiceManaged];
export interface Address {
  AllocationId?: string | undefined;
  AssociationId?: string | undefined;
  Domain?: DomainType | undefined;
  NetworkInterfaceId?: string | undefined;
  NetworkInterfaceOwnerId?: string | undefined;
  PrivateIpAddress?: string | undefined;
  Tags?: Tag[] | undefined;
  PublicIpv4Pool?: string | undefined;
  NetworkBorderGroup?: string | undefined;
  CustomerOwnedIp?: string | undefined;
  CustomerOwnedIpv4Pool?: string | undefined;
  CarrierIp?: string | undefined;
  SubnetId?: string | undefined;
  ServiceManaged?: ServiceManaged | undefined;
  InstanceId?: string | undefined;
  PublicIp?: string | undefined;
}
export interface PtrUpdateStatus {
  Value?: string | undefined;
  Status?: string | undefined;
  Reason?: string | undefined;
}
export interface AddressAttribute {
  PublicIp?: string | undefined;
  AllocationId?: string | undefined;
  PtrRecord?: string | undefined;
  PtrRecordUpdate?: PtrUpdateStatus | undefined;
}
export declare const AddressAttributeName: {
  readonly domain_name: "domain-name";
};
export type AddressAttributeName =
  (typeof AddressAttributeName)[keyof typeof AddressAttributeName];
export declare const AddressFamily: {
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type AddressFamily = (typeof AddressFamily)[keyof typeof AddressFamily];
export interface AdvertiseByoipCidrRequest {
  Cidr: string | undefined;
  Asn?: string | undefined;
  DryRun?: boolean | undefined;
  NetworkBorderGroup?: string | undefined;
}
export declare const AsnAssociationState: {
  readonly associated: "associated";
  readonly disassociated: "disassociated";
  readonly failed_association: "failed-association";
  readonly failed_disassociation: "failed-disassociation";
  readonly pending_association: "pending-association";
  readonly pending_disassociation: "pending-disassociation";
};
export type AsnAssociationState =
  (typeof AsnAssociationState)[keyof typeof AsnAssociationState];
export interface AsnAssociation {
  Asn?: string | undefined;
  Cidr?: string | undefined;
  StatusMessage?: string | undefined;
  State?: AsnAssociationState | undefined;
}
export declare const ByoipCidrState: {
  readonly advertised: "advertised";
  readonly deprovisioned: "deprovisioned";
  readonly failed_deprovision: "failed-deprovision";
  readonly failed_provision: "failed-provision";
  readonly pending_deprovision: "pending-deprovision";
  readonly pending_provision: "pending-provision";
  readonly provisioned: "provisioned";
  readonly provisioned_not_publicly_advertisable: "provisioned-not-publicly-advertisable";
};
export type ByoipCidrState =
  (typeof ByoipCidrState)[keyof typeof ByoipCidrState];
export interface ByoipCidr {
  Cidr?: string | undefined;
  Description?: string | undefined;
  AsnAssociations?: AsnAssociation[] | undefined;
  StatusMessage?: string | undefined;
  State?: ByoipCidrState | undefined;
  NetworkBorderGroup?: string | undefined;
}
export interface AdvertiseByoipCidrResult {
  ByoipCidr?: ByoipCidr | undefined;
}
export declare const Affinity: {
  readonly default: "default";
  readonly host: "host";
};
export type Affinity = (typeof Affinity)[keyof typeof Affinity];
export interface AllocateAddressRequest {
  Domain?: DomainType | undefined;
  Address?: string | undefined;
  PublicIpv4Pool?: string | undefined;
  NetworkBorderGroup?: string | undefined;
  CustomerOwnedIpv4Pool?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  IpamPoolId?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface AllocateAddressResult {
  AllocationId?: string | undefined;
  PublicIpv4Pool?: string | undefined;
  NetworkBorderGroup?: string | undefined;
  Domain?: DomainType | undefined;
  CustomerOwnedIp?: string | undefined;
  CustomerOwnedIpv4Pool?: string | undefined;
  CarrierIp?: string | undefined;
  PublicIp?: string | undefined;
}
export declare const AutoPlacement: {
  readonly off: "off";
  readonly on: "on";
};
export type AutoPlacement = (typeof AutoPlacement)[keyof typeof AutoPlacement];
export declare const HostMaintenance: {
  readonly off: "off";
  readonly on: "on";
};
export type HostMaintenance =
  (typeof HostMaintenance)[keyof typeof HostMaintenance];
export declare const HostRecovery: {
  readonly off: "off";
  readonly on: "on";
};
export type HostRecovery = (typeof HostRecovery)[keyof typeof HostRecovery];
export interface AllocateHostsRequest {
  InstanceFamily?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  HostRecovery?: HostRecovery | undefined;
  OutpostArn?: string | undefined;
  HostMaintenance?: HostMaintenance | undefined;
  AssetIds?: string[] | undefined;
  AvailabilityZoneId?: string | undefined;
  AutoPlacement?: AutoPlacement | undefined;
  ClientToken?: string | undefined;
  InstanceType?: string | undefined;
  Quantity?: number | undefined;
  AvailabilityZone?: string | undefined;
}
export interface AllocateHostsResult {
  HostIds?: string[] | undefined;
}
export interface AllocateIpamPoolCidrRequest {
  DryRun?: boolean | undefined;
  IpamPoolId: string | undefined;
  Cidr?: string | undefined;
  NetmaskLength?: number | undefined;
  ClientToken?: string | undefined;
  Description?: string | undefined;
  PreviewNextCidr?: boolean | undefined;
  AllowedCidrs?: string[] | undefined;
  DisallowedCidrs?: string[] | undefined;
}
export declare const IpamPoolAllocationResourceType: {
  readonly custom: "custom";
  readonly ec2_public_ipv4_pool: "ec2-public-ipv4-pool";
  readonly eip: "eip";
  readonly ipam_pool: "ipam-pool";
  readonly subnet: "subnet";
  readonly vpc: "vpc";
};
export type IpamPoolAllocationResourceType =
  (typeof IpamPoolAllocationResourceType)[keyof typeof IpamPoolAllocationResourceType];
export interface IpamPoolAllocation {
  Cidr?: string | undefined;
  IpamPoolAllocationId?: string | undefined;
  Description?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: IpamPoolAllocationResourceType | undefined;
  ResourceRegion?: string | undefined;
  ResourceOwner?: string | undefined;
}
export interface AllocateIpamPoolCidrResult {
  IpamPoolAllocation?: IpamPoolAllocation | undefined;
}
export declare const AllocationState: {
  readonly available: "available";
  readonly pending: "pending";
  readonly permanent_failure: "permanent-failure";
  readonly released: "released";
  readonly released_permanent_failure: "released-permanent-failure";
  readonly under_assessment: "under-assessment";
};
export type AllocationState =
  (typeof AllocationState)[keyof typeof AllocationState];
export declare const AllocationStrategy: {
  readonly CAPACITY_OPTIMIZED: "capacityOptimized";
  readonly CAPACITY_OPTIMIZED_PRIORITIZED: "capacityOptimizedPrioritized";
  readonly DIVERSIFIED: "diversified";
  readonly LOWEST_PRICE: "lowestPrice";
  readonly PRICE_CAPACITY_OPTIMIZED: "priceCapacityOptimized";
};
export type AllocationStrategy =
  (typeof AllocationStrategy)[keyof typeof AllocationStrategy];
export declare const AllocationType: {
  readonly future: "future";
  readonly used: "used";
};
export type AllocationType =
  (typeof AllocationType)[keyof typeof AllocationType];
export declare const AllowedImagesSettingsDisabledState: {
  readonly disabled: "disabled";
};
export type AllowedImagesSettingsDisabledState =
  (typeof AllowedImagesSettingsDisabledState)[keyof typeof AllowedImagesSettingsDisabledState];
export declare const AllowedImagesSettingsEnabledState: {
  readonly audit_mode: "audit-mode";
  readonly enabled: "enabled";
};
export type AllowedImagesSettingsEnabledState =
  (typeof AllowedImagesSettingsEnabledState)[keyof typeof AllowedImagesSettingsEnabledState];
export interface AllowedPrincipal {
  PrincipalType?: PrincipalType | undefined;
  Principal?: string | undefined;
  ServicePermissionId?: string | undefined;
  Tags?: Tag[] | undefined;
  ServiceId?: string | undefined;
}
export declare const AllowsMultipleInstanceTypes: {
  readonly off: "off";
  readonly on: "on";
};
export type AllowsMultipleInstanceTypes =
  (typeof AllowsMultipleInstanceTypes)[keyof typeof AllowsMultipleInstanceTypes];
export interface AlternatePathHint {
  ComponentId?: string | undefined;
  ComponentArn?: string | undefined;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  VpcId: string | undefined;
  SecurityGroupIds: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkResult {
  SecurityGroupIds?: string[] | undefined;
}
export interface AssignIpv6AddressesRequest {
  Ipv6PrefixCount?: number | undefined;
  Ipv6Prefixes?: string[] | undefined;
  NetworkInterfaceId: string | undefined;
  Ipv6Addresses?: string[] | undefined;
  Ipv6AddressCount?: number | undefined;
}
export interface AssignIpv6AddressesResult {
  AssignedIpv6Addresses?: string[] | undefined;
  AssignedIpv6Prefixes?: string[] | undefined;
  NetworkInterfaceId?: string | undefined;
}
export interface AssignPrivateIpAddressesRequest {
  Ipv4Prefixes?: string[] | undefined;
  Ipv4PrefixCount?: number | undefined;
  NetworkInterfaceId: string | undefined;
  PrivateIpAddresses?: string[] | undefined;
  SecondaryPrivateIpAddressCount?: number | undefined;
  AllowReassignment?: boolean | undefined;
}
export interface Ipv4PrefixSpecification {
  Ipv4Prefix?: string | undefined;
}
export interface AssignedPrivateIpAddress {
  PrivateIpAddress?: string | undefined;
}
export interface AssignPrivateIpAddressesResult {
  NetworkInterfaceId?: string | undefined;
  AssignedPrivateIpAddresses?: AssignedPrivateIpAddress[] | undefined;
  AssignedIpv4Prefixes?: Ipv4PrefixSpecification[] | undefined;
}
export interface AssignPrivateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  PrivateIpAddresses?: string[] | undefined;
  PrivateIpAddressCount?: number | undefined;
  DryRun?: boolean | undefined;
}
export declare const NatGatewayAddressStatus: {
  readonly ASSIGNING: "assigning";
  readonly ASSOCIATING: "associating";
  readonly DISASSOCIATING: "disassociating";
  readonly FAILED: "failed";
  readonly SUCCEEDED: "succeeded";
  readonly UNASSIGNING: "unassigning";
};
export type NatGatewayAddressStatus =
  (typeof NatGatewayAddressStatus)[keyof typeof NatGatewayAddressStatus];
export interface NatGatewayAddress {
  AllocationId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  PrivateIp?: string | undefined;
  PublicIp?: string | undefined;
  AssociationId?: string | undefined;
  IsPrimary?: boolean | undefined;
  FailureMessage?: string | undefined;
  Status?: NatGatewayAddressStatus | undefined;
}
export interface AssignPrivateNatGatewayAddressResult {
  NatGatewayId?: string | undefined;
  NatGatewayAddresses?: NatGatewayAddress[] | undefined;
}
export interface AssociateAddressRequest {
  AllocationId?: string | undefined;
  InstanceId?: string | undefined;
  PublicIp?: string | undefined;
  DryRun?: boolean | undefined;
  NetworkInterfaceId?: string | undefined;
  PrivateIpAddress?: string | undefined;
  AllowReassociation?: boolean | undefined;
}
export interface AssociateAddressResult {
  AssociationId?: string | undefined;
}
export interface AssociateCapacityReservationBillingOwnerRequest {
  DryRun?: boolean | undefined;
  CapacityReservationId: string | undefined;
  UnusedReservationBillingOwnerId: string | undefined;
}
export interface AssociateCapacityReservationBillingOwnerResult {
  Return?: boolean | undefined;
}
export interface AssociateClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  SubnetId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const AssociationStatusCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly association_failed: "association-failed";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
};
export type AssociationStatusCode =
  (typeof AssociationStatusCode)[keyof typeof AssociationStatusCode];
export interface AssociationStatus {
  Code?: AssociationStatusCode | undefined;
  Message?: string | undefined;
}
export interface AssociateClientVpnTargetNetworkResult {
  AssociationId?: string | undefined;
  Status?: AssociationStatus | undefined;
}
export interface AssociateDhcpOptionsRequest {
  DhcpOptionsId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface AssociateEnclaveCertificateIamRoleRequest {
  CertificateArn: string | undefined;
  RoleArn: string | undefined;
  DryRun?: boolean | undefined;
}
export interface AssociateEnclaveCertificateIamRoleResult {
  CertificateS3BucketName?: string | undefined;
  CertificateS3ObjectKey?: string | undefined;
  EncryptionKmsKeyId?: string | undefined;
}
export interface IamInstanceProfileSpecification {
  Arn?: string | undefined;
  Name?: string | undefined;
}
export interface AssociateIamInstanceProfileRequest {
  IamInstanceProfile: IamInstanceProfileSpecification | undefined;
  InstanceId: string | undefined;
}
export interface IamInstanceProfile {
  Arn?: string | undefined;
  Id?: string | undefined;
}
export declare const IamInstanceProfileAssociationState: {
  readonly ASSOCIATED: "associated";
  readonly ASSOCIATING: "associating";
  readonly DISASSOCIATED: "disassociated";
  readonly DISASSOCIATING: "disassociating";
};
export type IamInstanceProfileAssociationState =
  (typeof IamInstanceProfileAssociationState)[keyof typeof IamInstanceProfileAssociationState];
export interface IamInstanceProfileAssociation {
  AssociationId?: string | undefined;
  InstanceId?: string | undefined;
  IamInstanceProfile?: IamInstanceProfile | undefined;
  State?: IamInstanceProfileAssociationState | undefined;
  Timestamp?: Date | undefined;
}
export interface AssociateIamInstanceProfileResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation | undefined;
}
export interface InstanceEventWindowAssociationRequest {
  InstanceIds?: string[] | undefined;
  InstanceTags?: Tag[] | undefined;
  DedicatedHostIds?: string[] | undefined;
}
export interface AssociateInstanceEventWindowRequest {
  DryRun?: boolean | undefined;
  InstanceEventWindowId: string | undefined;
  AssociationTarget: InstanceEventWindowAssociationRequest | undefined;
}
export interface InstanceEventWindowAssociationTarget {
  InstanceIds?: string[] | undefined;
  Tags?: Tag[] | undefined;
  DedicatedHostIds?: string[] | undefined;
}
export declare const InstanceEventWindowState: {
  readonly active: "active";
  readonly creating: "creating";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
};
export type InstanceEventWindowState =
  (typeof InstanceEventWindowState)[keyof typeof InstanceEventWindowState];
export declare const WeekDay: {
  readonly friday: "friday";
  readonly monday: "monday";
  readonly saturday: "saturday";
  readonly sunday: "sunday";
  readonly thursday: "thursday";
  readonly tuesday: "tuesday";
  readonly wednesday: "wednesday";
};
export type WeekDay = (typeof WeekDay)[keyof typeof WeekDay];
export interface InstanceEventWindowTimeRange {
  StartWeekDay?: WeekDay | undefined;
  StartHour?: number | undefined;
  EndWeekDay?: WeekDay | undefined;
  EndHour?: number | undefined;
}
export interface InstanceEventWindow {
  InstanceEventWindowId?: string | undefined;
  TimeRanges?: InstanceEventWindowTimeRange[] | undefined;
  Name?: string | undefined;
  CronExpression?: string | undefined;
  AssociationTarget?: InstanceEventWindowAssociationTarget | undefined;
  State?: InstanceEventWindowState | undefined;
  Tags?: Tag[] | undefined;
}
export interface AssociateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow | undefined;
}
export interface AssociateIpamByoasnRequest {
  DryRun?: boolean | undefined;
  Asn: string | undefined;
  Cidr: string | undefined;
}
export interface AssociateIpamByoasnResult {
  AsnAssociation?: AsnAssociation | undefined;
}
export interface AssociateIpamResourceDiscoveryRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  IpamResourceDiscoveryId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
}
export declare const IpamAssociatedResourceDiscoveryStatus: {
  readonly ACTIVE: "active";
  readonly NOT_FOUND: "not-found";
};
export type IpamAssociatedResourceDiscoveryStatus =
  (typeof IpamAssociatedResourceDiscoveryStatus)[keyof typeof IpamAssociatedResourceDiscoveryStatus];
export declare const IpamResourceDiscoveryAssociationState: {
  readonly ASSOCIATE_COMPLETE: "associate-complete";
  readonly ASSOCIATE_FAILED: "associate-failed";
  readonly ASSOCIATE_IN_PROGRESS: "associate-in-progress";
  readonly DISASSOCIATE_COMPLETE: "disassociate-complete";
  readonly DISASSOCIATE_FAILED: "disassociate-failed";
  readonly DISASSOCIATE_IN_PROGRESS: "disassociate-in-progress";
  readonly ISOLATE_COMPLETE: "isolate-complete";
  readonly ISOLATE_IN_PROGRESS: "isolate-in-progress";
  readonly RESTORE_IN_PROGRESS: "restore-in-progress";
};
export type IpamResourceDiscoveryAssociationState =
  (typeof IpamResourceDiscoveryAssociationState)[keyof typeof IpamResourceDiscoveryAssociationState];
export interface IpamResourceDiscoveryAssociation {
  OwnerId?: string | undefined;
  IpamResourceDiscoveryAssociationId?: string | undefined;
  IpamResourceDiscoveryAssociationArn?: string | undefined;
  IpamResourceDiscoveryId?: string | undefined;
  IpamId?: string | undefined;
  IpamArn?: string | undefined;
  IpamRegion?: string | undefined;
  IsDefault?: boolean | undefined;
  ResourceDiscoveryStatus?: IpamAssociatedResourceDiscoveryStatus | undefined;
  State?: IpamResourceDiscoveryAssociationState | undefined;
  Tags?: Tag[] | undefined;
}
export interface AssociateIpamResourceDiscoveryResult {
  IpamResourceDiscoveryAssociation?:
    | IpamResourceDiscoveryAssociation
    | undefined;
}
export interface AssociateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  AllocationIds: string[] | undefined;
  PrivateIpAddresses?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface AssociateNatGatewayAddressResult {
  NatGatewayId?: string | undefined;
  NatGatewayAddresses?: NatGatewayAddress[] | undefined;
}
export interface AssociateRouteServerRequest {
  RouteServerId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const RouteServerAssociationState: {
  readonly ASSOCIATED: "associated";
  readonly ASSOCIATING: "associating";
  readonly DISASSOCIATING: "disassociating";
};
export type RouteServerAssociationState =
  (typeof RouteServerAssociationState)[keyof typeof RouteServerAssociationState];
export interface RouteServerAssociation {
  RouteServerId?: string | undefined;
  VpcId?: string | undefined;
  State?: RouteServerAssociationState | undefined;
}
export interface AssociateRouteServerResult {
  RouteServerAssociation?: RouteServerAssociation | undefined;
}
export interface AssociateRouteTableRequest {
  GatewayId?: string | undefined;
  PublicIpv4Pool?: string | undefined;
  DryRun?: boolean | undefined;
  SubnetId?: string | undefined;
  RouteTableId: string | undefined;
}
export declare const RouteTableAssociationStateCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
};
export type RouteTableAssociationStateCode =
  (typeof RouteTableAssociationStateCode)[keyof typeof RouteTableAssociationStateCode];
export interface RouteTableAssociationState {
  State?: RouteTableAssociationStateCode | undefined;
  StatusMessage?: string | undefined;
}
export interface AssociateRouteTableResult {
  AssociationId?: string | undefined;
  AssociationState?: RouteTableAssociationState | undefined;
}
export interface AssociateSecurityGroupVpcRequest {
  GroupId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const SecurityGroupVpcAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly association_failed: "association-failed";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly disassociation_failed: "disassociation-failed";
};
export type SecurityGroupVpcAssociationState =
  (typeof SecurityGroupVpcAssociationState)[keyof typeof SecurityGroupVpcAssociationState];
export interface AssociateSecurityGroupVpcResult {
  State?: SecurityGroupVpcAssociationState | undefined;
}
export interface AssociateSubnetCidrBlockRequest {
  Ipv6IpamPoolId?: string | undefined;
  Ipv6NetmaskLength?: number | undefined;
  SubnetId: string | undefined;
  Ipv6CidrBlock?: string | undefined;
}
export declare const IpSource: {
  readonly amazon: "amazon";
  readonly byoip: "byoip";
  readonly none: "none";
};
export type IpSource = (typeof IpSource)[keyof typeof IpSource];
export declare const Ipv6AddressAttribute: {
  readonly private: "private";
  readonly public: "public";
};
export type Ipv6AddressAttribute =
  (typeof Ipv6AddressAttribute)[keyof typeof Ipv6AddressAttribute];
export declare const SubnetCidrBlockStateCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
  readonly failing: "failing";
};
export type SubnetCidrBlockStateCode =
  (typeof SubnetCidrBlockStateCode)[keyof typeof SubnetCidrBlockStateCode];
export interface SubnetCidrBlockState {
  State?: SubnetCidrBlockStateCode | undefined;
  StatusMessage?: string | undefined;
}
export interface SubnetIpv6CidrBlockAssociation {
  AssociationId?: string | undefined;
  Ipv6CidrBlock?: string | undefined;
  Ipv6CidrBlockState?: SubnetCidrBlockState | undefined;
  Ipv6AddressAttribute?: Ipv6AddressAttribute | undefined;
  IpSource?: IpSource | undefined;
}
export interface AssociateSubnetCidrBlockResult {
  Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation | undefined;
  SubnetId?: string | undefined;
}
export interface AssociateTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  SubnetIds: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface AssociateTransitGatewayMulticastDomainResult {
  Associations?: TransitGatewayMulticastDomainAssociations | undefined;
}
export interface AssociateTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const TransitGatewayAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
};
export type TransitGatewayAssociationState =
  (typeof TransitGatewayAssociationState)[keyof typeof TransitGatewayAssociationState];
export interface TransitGatewayPolicyTableAssociation {
  TransitGatewayPolicyTableId?: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  State?: TransitGatewayAssociationState | undefined;
}
export interface AssociateTransitGatewayPolicyTableResult {
  Association?: TransitGatewayPolicyTableAssociation | undefined;
}
export interface AssociateTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayAssociation {
  TransitGatewayRouteTableId?: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  State?: TransitGatewayAssociationState | undefined;
}
export interface AssociateTransitGatewayRouteTableResult {
  Association?: TransitGatewayAssociation | undefined;
}
export interface AssociateTrunkInterfaceRequest {
  BranchInterfaceId: string | undefined;
  TrunkInterfaceId: string | undefined;
  VlanId?: number | undefined;
  GreKey?: number | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const InterfaceProtocolType: {
  readonly GRE: "GRE";
  readonly VLAN: "VLAN";
};
export type InterfaceProtocolType =
  (typeof InterfaceProtocolType)[keyof typeof InterfaceProtocolType];
export interface TrunkInterfaceAssociation {
  AssociationId?: string | undefined;
  BranchInterfaceId?: string | undefined;
  TrunkInterfaceId?: string | undefined;
  InterfaceProtocol?: InterfaceProtocolType | undefined;
  VlanId?: number | undefined;
  GreKey?: number | undefined;
  Tags?: Tag[] | undefined;
}
export interface AssociateTrunkInterfaceResult {
  InterfaceAssociation?: TrunkInterfaceAssociation | undefined;
  ClientToken?: string | undefined;
}
export interface AssociateVpcCidrBlockRequest {
  CidrBlock?: string | undefined;
  Ipv6CidrBlockNetworkBorderGroup?: string | undefined;
  Ipv6Pool?: string | undefined;
  Ipv6CidrBlock?: string | undefined;
  Ipv4IpamPoolId?: string | undefined;
  Ipv4NetmaskLength?: number | undefined;
  Ipv6IpamPoolId?: string | undefined;
  Ipv6NetmaskLength?: number | undefined;
  VpcId: string | undefined;
  AmazonProvidedIpv6CidrBlock?: boolean | undefined;
}
export declare const VpcCidrBlockStateCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
  readonly failing: "failing";
};
export type VpcCidrBlockStateCode =
  (typeof VpcCidrBlockStateCode)[keyof typeof VpcCidrBlockStateCode];
export interface VpcCidrBlockState {
  State?: VpcCidrBlockStateCode | undefined;
  StatusMessage?: string | undefined;
}
export interface VpcCidrBlockAssociation {
  AssociationId?: string | undefined;
  CidrBlock?: string | undefined;
  CidrBlockState?: VpcCidrBlockState | undefined;
}
export interface VpcIpv6CidrBlockAssociation {
  AssociationId?: string | undefined;
  Ipv6CidrBlock?: string | undefined;
  Ipv6CidrBlockState?: VpcCidrBlockState | undefined;
  NetworkBorderGroup?: string | undefined;
  Ipv6Pool?: string | undefined;
  Ipv6AddressAttribute?: Ipv6AddressAttribute | undefined;
  IpSource?: IpSource | undefined;
}
export interface AssociateVpcCidrBlockResult {
  Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation | undefined;
  CidrBlockAssociation?: VpcCidrBlockAssociation | undefined;
  VpcId?: string | undefined;
}
export interface AttachClassicLinkVpcRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  VpcId: string | undefined;
  Groups: string[] | undefined;
}
export interface AttachClassicLinkVpcResult {
  Return?: boolean | undefined;
}
export interface AttachInternetGatewayRequest {
  DryRun?: boolean | undefined;
  InternetGatewayId: string | undefined;
  VpcId: string | undefined;
}
export interface EnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean | undefined;
}
export interface EnaSrdSpecification {
  EnaSrdEnabled?: boolean | undefined;
  EnaSrdUdpSpecification?: EnaSrdUdpSpecification | undefined;
}
export interface AttachNetworkInterfaceRequest {
  NetworkCardIndex?: number | undefined;
  EnaSrdSpecification?: EnaSrdSpecification | undefined;
  EnaQueueCount?: number | undefined;
  DryRun?: boolean | undefined;
  NetworkInterfaceId: string | undefined;
  InstanceId: string | undefined;
  DeviceIndex: number | undefined;
}
export interface AttachNetworkInterfaceResult {
  AttachmentId?: string | undefined;
  NetworkCardIndex?: number | undefined;
}
export interface AttachVerifiedAccessTrustProviderRequest {
  VerifiedAccessInstanceId: string | undefined;
  VerifiedAccessTrustProviderId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface VerifiedAccessInstanceCustomSubDomain {
  SubDomain?: string | undefined;
  Nameservers?: string[] | undefined;
}
export declare const DeviceTrustProviderType: {
  readonly crowdstrike: "crowdstrike";
  readonly jamf: "jamf";
  readonly jumpcloud: "jumpcloud";
};
export type DeviceTrustProviderType =
  (typeof DeviceTrustProviderType)[keyof typeof DeviceTrustProviderType];
export declare const TrustProviderType: {
  readonly device: "device";
  readonly user: "user";
};
export type TrustProviderType =
  (typeof TrustProviderType)[keyof typeof TrustProviderType];
export declare const UserTrustProviderType: {
  readonly iam_identity_center: "iam-identity-center";
  readonly oidc: "oidc";
};
export type UserTrustProviderType =
  (typeof UserTrustProviderType)[keyof typeof UserTrustProviderType];
export interface VerifiedAccessTrustProviderCondensed {
  VerifiedAccessTrustProviderId?: string | undefined;
  Description?: string | undefined;
  TrustProviderType?: TrustProviderType | undefined;
  UserTrustProviderType?: UserTrustProviderType | undefined;
  DeviceTrustProviderType?: DeviceTrustProviderType | undefined;
}
export interface VerifiedAccessInstance {
  VerifiedAccessInstanceId?: string | undefined;
  Description?: string | undefined;
  VerifiedAccessTrustProviders?:
    | VerifiedAccessTrustProviderCondensed[]
    | undefined;
  CreationTime?: string | undefined;
  LastUpdatedTime?: string | undefined;
  Tags?: Tag[] | undefined;
  FipsEnabled?: boolean | undefined;
  CidrEndpointsCustomSubDomain?:
    | VerifiedAccessInstanceCustomSubDomain
    | undefined;
}
export interface DeviceOptions {
  TenantId?: string | undefined;
  PublicSigningKeyUrl?: string | undefined;
}
export interface NativeApplicationOidcOptions {
  PublicSigningKeyEndpoint?: string | undefined;
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  Scope?: string | undefined;
}
export interface OidcOptions {
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  Scope?: string | undefined;
}
export interface VerifiedAccessSseSpecificationResponse {
  CustomerManagedKeyEnabled?: boolean | undefined;
  KmsKeyArn?: string | undefined;
}
export interface VerifiedAccessTrustProvider {
  VerifiedAccessTrustProviderId?: string | undefined;
  Description?: string | undefined;
  TrustProviderType?: TrustProviderType | undefined;
  UserTrustProviderType?: UserTrustProviderType | undefined;
  DeviceTrustProviderType?: DeviceTrustProviderType | undefined;
  OidcOptions?: OidcOptions | undefined;
  DeviceOptions?: DeviceOptions | undefined;
  PolicyReferenceName?: string | undefined;
  CreationTime?: string | undefined;
  LastUpdatedTime?: string | undefined;
  Tags?: Tag[] | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationResponse | undefined;
  NativeApplicationOidcOptions?: NativeApplicationOidcOptions | undefined;
}
export interface AttachVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider | undefined;
  VerifiedAccessInstance?: VerifiedAccessInstance | undefined;
}
export interface AttachVolumeRequest {
  Device: string | undefined;
  InstanceId: string | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const VolumeAttachmentState: {
  readonly attached: "attached";
  readonly attaching: "attaching";
  readonly busy: "busy";
  readonly detached: "detached";
  readonly detaching: "detaching";
};
export type VolumeAttachmentState =
  (typeof VolumeAttachmentState)[keyof typeof VolumeAttachmentState];
export interface VolumeAttachment {
  DeleteOnTermination?: boolean | undefined;
  AssociatedResource?: string | undefined;
  InstanceOwningService?: string | undefined;
  VolumeId?: string | undefined;
  InstanceId?: string | undefined;
  Device?: string | undefined;
  State?: VolumeAttachmentState | undefined;
  AttachTime?: Date | undefined;
}
export interface AttachVpnGatewayRequest {
  VpcId: string | undefined;
  VpnGatewayId: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const AttachmentStatus: {
  readonly attached: "attached";
  readonly attaching: "attaching";
  readonly detached: "detached";
  readonly detaching: "detaching";
};
export type AttachmentStatus =
  (typeof AttachmentStatus)[keyof typeof AttachmentStatus];
export interface VpcAttachment {
  VpcId?: string | undefined;
  State?: AttachmentStatus | undefined;
}
export interface AttachVpnGatewayResult {
  VpcAttachment?: VpcAttachment | undefined;
}
export interface AuthorizeClientVpnIngressRequest {
  ClientVpnEndpointId: string | undefined;
  TargetNetworkCidr: string | undefined;
  AccessGroupId?: string | undefined;
  AuthorizeAllGroups?: boolean | undefined;
  Description?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const ClientVpnAuthorizationRuleStatusCode: {
  readonly active: "active";
  readonly authorizing: "authorizing";
  readonly failed: "failed";
  readonly revoking: "revoking";
};
export type ClientVpnAuthorizationRuleStatusCode =
  (typeof ClientVpnAuthorizationRuleStatusCode)[keyof typeof ClientVpnAuthorizationRuleStatusCode];
export interface ClientVpnAuthorizationRuleStatus {
  Code?: ClientVpnAuthorizationRuleStatusCode | undefined;
  Message?: string | undefined;
}
export interface AuthorizeClientVpnIngressResult {
  Status?: ClientVpnAuthorizationRuleStatus | undefined;
}
export interface IpRange {
  Description?: string | undefined;
  CidrIp?: string | undefined;
}
export interface Ipv6Range {
  Description?: string | undefined;
  CidrIpv6?: string | undefined;
}
export interface PrefixListId {
  Description?: string | undefined;
  PrefixListId?: string | undefined;
}
export interface UserIdGroupPair {
  Description?: string | undefined;
  UserId?: string | undefined;
  GroupName?: string | undefined;
  GroupId?: string | undefined;
  VpcId?: string | undefined;
  VpcPeeringConnectionId?: string | undefined;
  PeeringStatus?: string | undefined;
}
export interface IpPermission {
  IpProtocol?: string | undefined;
  FromPort?: number | undefined;
  ToPort?: number | undefined;
  UserIdGroupPairs?: UserIdGroupPair[] | undefined;
  IpRanges?: IpRange[] | undefined;
  Ipv6Ranges?: Ipv6Range[] | undefined;
  PrefixListIds?: PrefixListId[] | undefined;
}
export interface AuthorizeSecurityGroupEgressRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  GroupId: string | undefined;
  SourceSecurityGroupName?: string | undefined;
  SourceSecurityGroupOwnerId?: string | undefined;
  IpProtocol?: string | undefined;
  FromPort?: number | undefined;
  ToPort?: number | undefined;
  CidrIp?: string | undefined;
  IpPermissions?: IpPermission[] | undefined;
}
export interface ReferencedSecurityGroup {
  GroupId?: string | undefined;
  PeeringStatus?: string | undefined;
  UserId?: string | undefined;
  VpcId?: string | undefined;
  VpcPeeringConnectionId?: string | undefined;
}
export interface SecurityGroupRule {
  SecurityGroupRuleId?: string | undefined;
  GroupId?: string | undefined;
  GroupOwnerId?: string | undefined;
  IsEgress?: boolean | undefined;
  IpProtocol?: string | undefined;
  FromPort?: number | undefined;
  ToPort?: number | undefined;
  CidrIpv4?: string | undefined;
  CidrIpv6?: string | undefined;
  PrefixListId?: string | undefined;
  ReferencedGroupInfo?: ReferencedSecurityGroup | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
  SecurityGroupRuleArn?: string | undefined;
}
export interface AuthorizeSecurityGroupEgressResult {
  Return?: boolean | undefined;
  SecurityGroupRules?: SecurityGroupRule[] | undefined;
}
export interface AuthorizeSecurityGroupIngressRequest {
  CidrIp?: string | undefined;
  FromPort?: number | undefined;
  GroupId?: string | undefined;
  GroupName?: string | undefined;
  IpPermissions?: IpPermission[] | undefined;
  IpProtocol?: string | undefined;
  SourceSecurityGroupName?: string | undefined;
  SourceSecurityGroupOwnerId?: string | undefined;
  ToPort?: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface AuthorizeSecurityGroupIngressResult {
  Return?: boolean | undefined;
  SecurityGroupRules?: SecurityGroupRule[] | undefined;
}
export interface S3Storage {
  AWSAccessKeyId?: string | undefined;
  Bucket?: string | undefined;
  Prefix?: string | undefined;
  UploadPolicy?: Uint8Array | undefined;
  UploadPolicySignature?: string | undefined;
}
export interface Storage {
  S3?: S3Storage | undefined;
}
export interface BundleInstanceRequest {
  InstanceId: string | undefined;
  Storage: Storage | undefined;
  DryRun?: boolean | undefined;
}
export interface BundleTaskError {
  Code?: string | undefined;
  Message?: string | undefined;
}
export declare const BundleTaskState: {
  readonly bundling: "bundling";
  readonly cancelling: "cancelling";
  readonly complete: "complete";
  readonly failed: "failed";
  readonly pending: "pending";
  readonly storing: "storing";
  readonly waiting_for_shutdown: "waiting-for-shutdown";
};
export type BundleTaskState =
  (typeof BundleTaskState)[keyof typeof BundleTaskState];
export interface BundleTask {
  InstanceId?: string | undefined;
  BundleId?: string | undefined;
  State?: BundleTaskState | undefined;
  StartTime?: Date | undefined;
  UpdateTime?: Date | undefined;
  Storage?: Storage | undefined;
  Progress?: string | undefined;
  BundleTaskError?: BundleTaskError | undefined;
}
export interface BundleInstanceResult {
  BundleTask?: BundleTask | undefined;
}
export interface CancelBundleTaskRequest {
  BundleId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface CancelBundleTaskResult {
  BundleTask?: BundleTask | undefined;
}
export interface CancelCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface CancelCapacityReservationResult {
  Return?: boolean | undefined;
}
export interface CancelCapacityReservationFleetsRequest {
  DryRun?: boolean | undefined;
  CapacityReservationFleetIds: string[] | undefined;
}
export interface CancelCapacityReservationFleetError {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface FailedCapacityReservationFleetCancellationResult {
  CapacityReservationFleetId?: string | undefined;
  CancelCapacityReservationFleetError?:
    | CancelCapacityReservationFleetError
    | undefined;
}
export declare const CapacityReservationFleetState: {
  readonly ACTIVE: "active";
  readonly CANCELLED: "cancelled";
  readonly CANCELLING: "cancelling";
  readonly EXPIRED: "expired";
  readonly EXPIRING: "expiring";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly PARTIALLY_FULFILLED: "partially_fulfilled";
  readonly SUBMITTED: "submitted";
};
export type CapacityReservationFleetState =
  (typeof CapacityReservationFleetState)[keyof typeof CapacityReservationFleetState];
export interface CapacityReservationFleetCancellationState {
  CurrentFleetState?: CapacityReservationFleetState | undefined;
  PreviousFleetState?: CapacityReservationFleetState | undefined;
  CapacityReservationFleetId?: string | undefined;
}
export interface CancelCapacityReservationFleetsResult {
  SuccessfulFleetCancellations?:
    | CapacityReservationFleetCancellationState[]
    | undefined;
  FailedFleetCancellations?:
    | FailedCapacityReservationFleetCancellationResult[]
    | undefined;
}
export interface CancelConversionRequest {
  DryRun?: boolean | undefined;
  ConversionTaskId: string | undefined;
  ReasonMessage?: string | undefined;
}
export interface CancelDeclarativePoliciesReportRequest {
  DryRun?: boolean | undefined;
  ReportId: string | undefined;
}
export interface CancelDeclarativePoliciesReportResult {
  Return?: boolean | undefined;
}
export interface CancelExportTaskRequest {
  ExportTaskId: string | undefined;
}
export interface CancelImageLaunchPermissionRequest {
  ImageId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface CancelImageLaunchPermissionResult {
  Return?: boolean | undefined;
}
export interface CancelImportTaskRequest {
  CancelReason?: string | undefined;
  DryRun?: boolean | undefined;
  ImportTaskId?: string | undefined;
}
export interface CancelImportTaskResult {
  ImportTaskId?: string | undefined;
  PreviousState?: string | undefined;
  State?: string | undefined;
}
export interface CancelReservedInstancesListingRequest {
  ReservedInstancesListingId: string | undefined;
}
export declare const ListingState: {
  readonly available: "available";
  readonly cancelled: "cancelled";
  readonly pending: "pending";
  readonly sold: "sold";
};
export type ListingState = (typeof ListingState)[keyof typeof ListingState];
export interface InstanceCount {
  InstanceCount?: number | undefined;
  State?: ListingState | undefined;
}
export declare const CurrencyCodeValues: {
  readonly USD: "USD";
};
export type CurrencyCodeValues =
  (typeof CurrencyCodeValues)[keyof typeof CurrencyCodeValues];
export interface PriceSchedule {
  Active?: boolean | undefined;
  CurrencyCode?: CurrencyCodeValues | undefined;
  Price?: number | undefined;
  Term?: number | undefined;
}
export declare const ListingStatus: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly closed: "closed";
  readonly pending: "pending";
};
export type ListingStatus = (typeof ListingStatus)[keyof typeof ListingStatus];
export interface ReservedInstancesListing {
  ClientToken?: string | undefined;
  CreateDate?: Date | undefined;
  InstanceCounts?: InstanceCount[] | undefined;
  PriceSchedules?: PriceSchedule[] | undefined;
  ReservedInstancesId?: string | undefined;
  ReservedInstancesListingId?: string | undefined;
  Status?: ListingStatus | undefined;
  StatusMessage?: string | undefined;
  Tags?: Tag[] | undefined;
  UpdateDate?: Date | undefined;
}
export interface CancelReservedInstancesListingResult {
  ReservedInstancesListings?: ReservedInstancesListing[] | undefined;
}
export interface CancelSpotFleetRequestsRequest {
  DryRun?: boolean | undefined;
  SpotFleetRequestIds: string[] | undefined;
  TerminateInstances: boolean | undefined;
}
export declare const BatchState: {
  readonly ACTIVE: "active";
  readonly CANCELLED: "cancelled";
  readonly CANCELLED_RUNNING: "cancelled_running";
  readonly CANCELLED_TERMINATING_INSTANCES: "cancelled_terminating";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly SUBMITTED: "submitted";
};
export type BatchState = (typeof BatchState)[keyof typeof BatchState];
export interface CancelSpotFleetRequestsSuccessItem {
  CurrentSpotFleetRequestState?: BatchState | undefined;
  PreviousSpotFleetRequestState?: BatchState | undefined;
  SpotFleetRequestId?: string | undefined;
}
export declare const CancelBatchErrorCode: {
  readonly FLEET_REQUEST_ID_DOES_NOT_EXIST: "fleetRequestIdDoesNotExist";
  readonly FLEET_REQUEST_ID_MALFORMED: "fleetRequestIdMalformed";
  readonly FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE: "fleetRequestNotInCancellableState";
  readonly UNEXPECTED_ERROR: "unexpectedError";
};
export type CancelBatchErrorCode =
  (typeof CancelBatchErrorCode)[keyof typeof CancelBatchErrorCode];
export interface CancelSpotFleetRequestsError {
  Code?: CancelBatchErrorCode | undefined;
  Message?: string | undefined;
}
export interface CancelSpotFleetRequestsErrorItem {
  Error?: CancelSpotFleetRequestsError | undefined;
  SpotFleetRequestId?: string | undefined;
}
export interface CancelSpotFleetRequestsResponse {
  SuccessfulFleetRequests?: CancelSpotFleetRequestsSuccessItem[] | undefined;
  UnsuccessfulFleetRequests?: CancelSpotFleetRequestsErrorItem[] | undefined;
}
export interface CancelSpotInstanceRequestsRequest {
  DryRun?: boolean | undefined;
  SpotInstanceRequestIds: string[] | undefined;
}
export declare const CancelSpotInstanceRequestState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly closed: "closed";
  readonly completed: "completed";
  readonly open: "open";
};
export type CancelSpotInstanceRequestState =
  (typeof CancelSpotInstanceRequestState)[keyof typeof CancelSpotInstanceRequestState];
export interface CancelledSpotInstanceRequest {
  SpotInstanceRequestId?: string | undefined;
  State?: CancelSpotInstanceRequestState | undefined;
}
export interface CancelSpotInstanceRequestsResult {
  CancelledSpotInstanceRequests?: CancelledSpotInstanceRequest[] | undefined;
}
export interface ConfirmProductInstanceRequest {
  InstanceId: string | undefined;
  ProductCode: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ConfirmProductInstanceResult {
  Return?: boolean | undefined;
  OwnerId?: string | undefined;
}
export declare const OidcOptionsFilterSensitiveLog: (obj: OidcOptions) => any;
export declare const VerifiedAccessTrustProviderFilterSensitiveLog: (
  obj: VerifiedAccessTrustProvider
) => any;
export declare const AttachVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: AttachVerifiedAccessTrustProviderResult
) => any;
export declare const S3StorageFilterSensitiveLog: (obj: S3Storage) => any;
export declare const StorageFilterSensitiveLog: (obj: Storage) => any;
export declare const BundleInstanceRequestFilterSensitiveLog: (
  obj: BundleInstanceRequest
) => any;
export declare const BundleTaskFilterSensitiveLog: (obj: BundleTask) => any;
export declare const BundleInstanceResultFilterSensitiveLog: (
  obj: BundleInstanceResult
) => any;
export declare const CancelBundleTaskResultFilterSensitiveLog: (
  obj: CancelBundleTaskResult
) => any;
