import { createAggregatedClient } from "@smithy/smithy-client";
import { CreateCapacityProviderCommand, } from "./commands/CreateCapacityProviderCommand";
import { CreateClusterCommand, } from "./commands/CreateClusterCommand";
import { CreateServiceCommand, } from "./commands/CreateServiceCommand";
import { CreateTaskSetCommand, } from "./commands/CreateTaskSetCommand";
import { DeleteAccountSettingCommand, } from "./commands/DeleteAccountSettingCommand";
import { DeleteAttributesCommand, } from "./commands/DeleteAttributesCommand";
import { DeleteCapacityProviderCommand, } from "./commands/DeleteCapacityProviderCommand";
import { DeleteClusterCommand, } from "./commands/DeleteClusterCommand";
import { DeleteServiceCommand, } from "./commands/DeleteServiceCommand";
import { DeleteTaskDefinitionsCommand, } from "./commands/DeleteTaskDefinitionsCommand";
import { DeleteTaskSetCommand, } from "./commands/DeleteTaskSetCommand";
import { DeregisterContainerInstanceCommand, } from "./commands/DeregisterContainerInstanceCommand";
import { DeregisterTaskDefinitionCommand, } from "./commands/DeregisterTaskDefinitionCommand";
import { DescribeCapacityProvidersCommand, } from "./commands/DescribeCapacityProvidersCommand";
import { DescribeClustersCommand, } from "./commands/DescribeClustersCommand";
import { DescribeContainerInstancesCommand, } from "./commands/DescribeContainerInstancesCommand";
import { DescribeServiceDeploymentsCommand, } from "./commands/DescribeServiceDeploymentsCommand";
import { DescribeServiceRevisionsCommand, } from "./commands/DescribeServiceRevisionsCommand";
import { DescribeServicesCommand, } from "./commands/DescribeServicesCommand";
import { DescribeTaskDefinitionCommand, } from "./commands/DescribeTaskDefinitionCommand";
import { DescribeTasksCommand, } from "./commands/DescribeTasksCommand";
import { DescribeTaskSetsCommand, } from "./commands/DescribeTaskSetsCommand";
import { DiscoverPollEndpointCommand, } from "./commands/DiscoverPollEndpointCommand";
import { ExecuteCommandCommand, } from "./commands/ExecuteCommandCommand";
import { GetTaskProtectionCommand, } from "./commands/GetTaskProtectionCommand";
import { ListAccountSettingsCommand, } from "./commands/ListAccountSettingsCommand";
import { ListAttributesCommand, } from "./commands/ListAttributesCommand";
import { ListClustersCommand, } from "./commands/ListClustersCommand";
import { ListContainerInstancesCommand, } from "./commands/ListContainerInstancesCommand";
import { ListServiceDeploymentsCommand, } from "./commands/ListServiceDeploymentsCommand";
import { ListServicesByNamespaceCommand, } from "./commands/ListServicesByNamespaceCommand";
import { ListServicesCommand, } from "./commands/ListServicesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { ListTaskDefinitionFamiliesCommand, } from "./commands/ListTaskDefinitionFamiliesCommand";
import { ListTaskDefinitionsCommand, } from "./commands/ListTaskDefinitionsCommand";
import { ListTasksCommand } from "./commands/ListTasksCommand";
import { PutAccountSettingCommand, } from "./commands/PutAccountSettingCommand";
import { PutAccountSettingDefaultCommand, } from "./commands/PutAccountSettingDefaultCommand";
import { PutAttributesCommand, } from "./commands/PutAttributesCommand";
import { PutClusterCapacityProvidersCommand, } from "./commands/PutClusterCapacityProvidersCommand";
import { RegisterContainerInstanceCommand, } from "./commands/RegisterContainerInstanceCommand";
import { RegisterTaskDefinitionCommand, } from "./commands/RegisterTaskDefinitionCommand";
import { RunTaskCommand } from "./commands/RunTaskCommand";
import { StartTaskCommand } from "./commands/StartTaskCommand";
import { StopServiceDeploymentCommand, } from "./commands/StopServiceDeploymentCommand";
import { StopTaskCommand } from "./commands/StopTaskCommand";
import { SubmitAttachmentStateChangesCommand, } from "./commands/SubmitAttachmentStateChangesCommand";
import { SubmitContainerStateChangeCommand, } from "./commands/SubmitContainerStateChangeCommand";
import { SubmitTaskStateChangeCommand, } from "./commands/SubmitTaskStateChangeCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateCapacityProviderCommand, } from "./commands/UpdateCapacityProviderCommand";
import { UpdateClusterCommand, } from "./commands/UpdateClusterCommand";
import { UpdateClusterSettingsCommand, } from "./commands/UpdateClusterSettingsCommand";
import { UpdateContainerAgentCommand, } from "./commands/UpdateContainerAgentCommand";
import { UpdateContainerInstancesStateCommand, } from "./commands/UpdateContainerInstancesStateCommand";
import { UpdateServiceCommand, } from "./commands/UpdateServiceCommand";
import { UpdateServicePrimaryTaskSetCommand, } from "./commands/UpdateServicePrimaryTaskSetCommand";
import { UpdateTaskProtectionCommand, } from "./commands/UpdateTaskProtectionCommand";
import { UpdateTaskSetCommand, } from "./commands/UpdateTaskSetCommand";
import { ECSClient } from "./ECSClient";
const commands = {
    CreateCapacityProviderCommand,
    CreateClusterCommand,
    CreateServiceCommand,
    CreateTaskSetCommand,
    DeleteAccountSettingCommand,
    DeleteAttributesCommand,
    DeleteCapacityProviderCommand,
    DeleteClusterCommand,
    DeleteServiceCommand,
    DeleteTaskDefinitionsCommand,
    DeleteTaskSetCommand,
    DeregisterContainerInstanceCommand,
    DeregisterTaskDefinitionCommand,
    DescribeCapacityProvidersCommand,
    DescribeClustersCommand,
    DescribeContainerInstancesCommand,
    DescribeServiceDeploymentsCommand,
    DescribeServiceRevisionsCommand,
    DescribeServicesCommand,
    DescribeTaskDefinitionCommand,
    DescribeTasksCommand,
    DescribeTaskSetsCommand,
    DiscoverPollEndpointCommand,
    ExecuteCommandCommand,
    GetTaskProtectionCommand,
    ListAccountSettingsCommand,
    ListAttributesCommand,
    ListClustersCommand,
    ListContainerInstancesCommand,
    ListServiceDeploymentsCommand,
    ListServicesCommand,
    ListServicesByNamespaceCommand,
    ListTagsForResourceCommand,
    ListTaskDefinitionFamiliesCommand,
    ListTaskDefinitionsCommand,
    ListTasksCommand,
    PutAccountSettingCommand,
    PutAccountSettingDefaultCommand,
    PutAttributesCommand,
    PutClusterCapacityProvidersCommand,
    RegisterContainerInstanceCommand,
    RegisterTaskDefinitionCommand,
    RunTaskCommand,
    StartTaskCommand,
    StopServiceDeploymentCommand,
    StopTaskCommand,
    SubmitAttachmentStateChangesCommand,
    SubmitContainerStateChangeCommand,
    SubmitTaskStateChangeCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateCapacityProviderCommand,
    UpdateClusterCommand,
    UpdateClusterSettingsCommand,
    UpdateContainerAgentCommand,
    UpdateContainerInstancesStateCommand,
    UpdateServiceCommand,
    UpdateServicePrimaryTaskSetCommand,
    UpdateTaskProtectionCommand,
    UpdateTaskSetCommand,
};
export class ECS extends ECSClient {
}
createAggregatedClient(commands, ECS);
