import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_CreateServiceCommand, se_CreateServiceCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class CreateServiceCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "CreateService", {})
    .n("ECSClient", "CreateServiceCommand")
    .f(void 0, void 0)
    .ser(se_CreateServiceCommand)
    .de(de_CreateServiceCommand)
    .build() {
}
