import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeTaskSetsCommand, se_DescribeTaskSetsCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeTaskSetsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "DescribeTaskSets", {})
    .n("ECSClient", "DescribeTaskSetsCommand")
    .f(void 0, void 0)
    .ser(se_DescribeTaskSetsCommand)
    .de(de_DescribeTaskSetsCommand)
    .build() {
}
