import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_RegisterTaskDefinitionCommand, se_RegisterTaskDefinitionCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class RegisterTaskDefinitionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "RegisterTaskDefinition", {})
    .n("ECSClient", "RegisterTaskDefinitionCommand")
    .f(void 0, void 0)
    .ser(se_RegisterTaskDefinitionCommand)
    .de(de_RegisterTaskDefinitionCommand)
    .build() {
}
