import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import { CreateCapacityProviderCommandInput, CreateCapacityProviderCommandOutput } from "./commands/CreateCapacityProviderCommand";
import { CreateClusterCommandInput, CreateClusterCommandOutput } from "./commands/CreateClusterCommand";
import { CreateServiceCommandInput, CreateServiceCommandOutput } from "./commands/CreateServiceCommand";
import { CreateTaskSetCommandInput, CreateTaskSetCommandOutput } from "./commands/CreateTaskSetCommand";
import { DeleteAccountSettingCommandInput, DeleteAccountSettingCommandOutput } from "./commands/DeleteAccountSettingCommand";
import { DeleteAttributesCommandInput, DeleteAttributesCommandOutput } from "./commands/DeleteAttributesCommand";
import { DeleteCapacityProviderCommandInput, DeleteCapacityProviderCommandOutput } from "./commands/DeleteCapacityProviderCommand";
import { DeleteClusterCommandInput, DeleteClusterCommandOutput } from "./commands/DeleteClusterCommand";
import { DeleteServiceCommandInput, DeleteServiceCommandOutput } from "./commands/DeleteServiceCommand";
import { DeleteTaskDefinitionsCommandInput, DeleteTaskDefinitionsCommandOutput } from "./commands/DeleteTaskDefinitionsCommand";
import { DeleteTaskSetCommandInput, DeleteTaskSetCommandOutput } from "./commands/DeleteTaskSetCommand";
import { DeregisterContainerInstanceCommandInput, DeregisterContainerInstanceCommandOutput } from "./commands/DeregisterContainerInstanceCommand";
import { DeregisterTaskDefinitionCommandInput, DeregisterTaskDefinitionCommandOutput } from "./commands/DeregisterTaskDefinitionCommand";
import { DescribeCapacityProvidersCommandInput, DescribeCapacityProvidersCommandOutput } from "./commands/DescribeCapacityProvidersCommand";
import { DescribeClustersCommandInput, DescribeClustersCommandOutput } from "./commands/DescribeClustersCommand";
import { DescribeContainerInstancesCommandInput, DescribeContainerInstancesCommandOutput } from "./commands/DescribeContainerInstancesCommand";
import { DescribeServiceDeploymentsCommandInput, DescribeServiceDeploymentsCommandOutput } from "./commands/DescribeServiceDeploymentsCommand";
import { DescribeServiceRevisionsCommandInput, DescribeServiceRevisionsCommandOutput } from "./commands/DescribeServiceRevisionsCommand";
import { DescribeServicesCommandInput, DescribeServicesCommandOutput } from "./commands/DescribeServicesCommand";
import { DescribeTaskDefinitionCommandInput, DescribeTaskDefinitionCommandOutput } from "./commands/DescribeTaskDefinitionCommand";
import { DescribeTasksCommandInput, DescribeTasksCommandOutput } from "./commands/DescribeTasksCommand";
import { DescribeTaskSetsCommandInput, DescribeTaskSetsCommandOutput } from "./commands/DescribeTaskSetsCommand";
import { DiscoverPollEndpointCommandInput, DiscoverPollEndpointCommandOutput } from "./commands/DiscoverPollEndpointCommand";
import { ExecuteCommandCommandInput, ExecuteCommandCommandOutput } from "./commands/ExecuteCommandCommand";
import { GetTaskProtectionCommandInput, GetTaskProtectionCommandOutput } from "./commands/GetTaskProtectionCommand";
import { ListAccountSettingsCommandInput, ListAccountSettingsCommandOutput } from "./commands/ListAccountSettingsCommand";
import { ListAttributesCommandInput, ListAttributesCommandOutput } from "./commands/ListAttributesCommand";
import { ListClustersCommandInput, ListClustersCommandOutput } from "./commands/ListClustersCommand";
import { ListContainerInstancesCommandInput, ListContainerInstancesCommandOutput } from "./commands/ListContainerInstancesCommand";
import { ListServiceDeploymentsCommandInput, ListServiceDeploymentsCommandOutput } from "./commands/ListServiceDeploymentsCommand";
import { ListServicesByNamespaceCommandInput, ListServicesByNamespaceCommandOutput } from "./commands/ListServicesByNamespaceCommand";
import { ListServicesCommandInput, ListServicesCommandOutput } from "./commands/ListServicesCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { ListTaskDefinitionFamiliesCommandInput, ListTaskDefinitionFamiliesCommandOutput } from "./commands/ListTaskDefinitionFamiliesCommand";
import { ListTaskDefinitionsCommandInput, ListTaskDefinitionsCommandOutput } from "./commands/ListTaskDefinitionsCommand";
import { ListTasksCommandInput, ListTasksCommandOutput } from "./commands/ListTasksCommand";
import { PutAccountSettingCommandInput, PutAccountSettingCommandOutput } from "./commands/PutAccountSettingCommand";
import { PutAccountSettingDefaultCommandInput, PutAccountSettingDefaultCommandOutput } from "./commands/PutAccountSettingDefaultCommand";
import { PutAttributesCommandInput, PutAttributesCommandOutput } from "./commands/PutAttributesCommand";
import { PutClusterCapacityProvidersCommandInput, PutClusterCapacityProvidersCommandOutput } from "./commands/PutClusterCapacityProvidersCommand";
import { RegisterContainerInstanceCommandInput, RegisterContainerInstanceCommandOutput } from "./commands/RegisterContainerInstanceCommand";
import { RegisterTaskDefinitionCommandInput, RegisterTaskDefinitionCommandOutput } from "./commands/RegisterTaskDefinitionCommand";
import { RunTaskCommandInput, RunTaskCommandOutput } from "./commands/RunTaskCommand";
import { StartTaskCommandInput, StartTaskCommandOutput } from "./commands/StartTaskCommand";
import { StopServiceDeploymentCommandInput, StopServiceDeploymentCommandOutput } from "./commands/StopServiceDeploymentCommand";
import { StopTaskCommandInput, StopTaskCommandOutput } from "./commands/StopTaskCommand";
import { SubmitAttachmentStateChangesCommandInput, SubmitAttachmentStateChangesCommandOutput } from "./commands/SubmitAttachmentStateChangesCommand";
import { SubmitContainerStateChangeCommandInput, SubmitContainerStateChangeCommandOutput } from "./commands/SubmitContainerStateChangeCommand";
import { SubmitTaskStateChangeCommandInput, SubmitTaskStateChangeCommandOutput } from "./commands/SubmitTaskStateChangeCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateCapacityProviderCommandInput, UpdateCapacityProviderCommandOutput } from "./commands/UpdateCapacityProviderCommand";
import { UpdateClusterCommandInput, UpdateClusterCommandOutput } from "./commands/UpdateClusterCommand";
import { UpdateClusterSettingsCommandInput, UpdateClusterSettingsCommandOutput } from "./commands/UpdateClusterSettingsCommand";
import { UpdateContainerAgentCommandInput, UpdateContainerAgentCommandOutput } from "./commands/UpdateContainerAgentCommand";
import { UpdateContainerInstancesStateCommandInput, UpdateContainerInstancesStateCommandOutput } from "./commands/UpdateContainerInstancesStateCommand";
import { UpdateServiceCommandInput, UpdateServiceCommandOutput } from "./commands/UpdateServiceCommand";
import { UpdateServicePrimaryTaskSetCommandInput, UpdateServicePrimaryTaskSetCommandOutput } from "./commands/UpdateServicePrimaryTaskSetCommand";
import { UpdateTaskProtectionCommandInput, UpdateTaskProtectionCommandOutput } from "./commands/UpdateTaskProtectionCommand";
import { UpdateTaskSetCommandInput, UpdateTaskSetCommandOutput } from "./commands/UpdateTaskSetCommand";
import { ECSClient } from "./ECSClient";
export interface ECS {
    /**
     * @see {@link CreateCapacityProviderCommand}
     */
    createCapacityProvider(args: CreateCapacityProviderCommandInput, options?: __HttpHandlerOptions): Promise<CreateCapacityProviderCommandOutput>;
    createCapacityProvider(args: CreateCapacityProviderCommandInput, cb: (err: any, data?: CreateCapacityProviderCommandOutput) => void): void;
    createCapacityProvider(args: CreateCapacityProviderCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateCapacityProviderCommandOutput) => void): void;
    /**
     * @see {@link CreateClusterCommand}
     */
    createCluster(): Promise<CreateClusterCommandOutput>;
    createCluster(args: CreateClusterCommandInput, options?: __HttpHandlerOptions): Promise<CreateClusterCommandOutput>;
    createCluster(args: CreateClusterCommandInput, cb: (err: any, data?: CreateClusterCommandOutput) => void): void;
    createCluster(args: CreateClusterCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateClusterCommandOutput) => void): void;
    /**
     * @see {@link CreateServiceCommand}
     */
    createService(args: CreateServiceCommandInput, options?: __HttpHandlerOptions): Promise<CreateServiceCommandOutput>;
    createService(args: CreateServiceCommandInput, cb: (err: any, data?: CreateServiceCommandOutput) => void): void;
    createService(args: CreateServiceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateServiceCommandOutput) => void): void;
    /**
     * @see {@link CreateTaskSetCommand}
     */
    createTaskSet(args: CreateTaskSetCommandInput, options?: __HttpHandlerOptions): Promise<CreateTaskSetCommandOutput>;
    createTaskSet(args: CreateTaskSetCommandInput, cb: (err: any, data?: CreateTaskSetCommandOutput) => void): void;
    createTaskSet(args: CreateTaskSetCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateTaskSetCommandOutput) => void): void;
    /**
     * @see {@link DeleteAccountSettingCommand}
     */
    deleteAccountSetting(args: DeleteAccountSettingCommandInput, options?: __HttpHandlerOptions): Promise<DeleteAccountSettingCommandOutput>;
    deleteAccountSetting(args: DeleteAccountSettingCommandInput, cb: (err: any, data?: DeleteAccountSettingCommandOutput) => void): void;
    deleteAccountSetting(args: DeleteAccountSettingCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteAccountSettingCommandOutput) => void): void;
    /**
     * @see {@link DeleteAttributesCommand}
     */
    deleteAttributes(args: DeleteAttributesCommandInput, options?: __HttpHandlerOptions): Promise<DeleteAttributesCommandOutput>;
    deleteAttributes(args: DeleteAttributesCommandInput, cb: (err: any, data?: DeleteAttributesCommandOutput) => void): void;
    deleteAttributes(args: DeleteAttributesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteAttributesCommandOutput) => void): void;
    /**
     * @see {@link DeleteCapacityProviderCommand}
     */
    deleteCapacityProvider(args: DeleteCapacityProviderCommandInput, options?: __HttpHandlerOptions): Promise<DeleteCapacityProviderCommandOutput>;
    deleteCapacityProvider(args: DeleteCapacityProviderCommandInput, cb: (err: any, data?: DeleteCapacityProviderCommandOutput) => void): void;
    deleteCapacityProvider(args: DeleteCapacityProviderCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteCapacityProviderCommandOutput) => void): void;
    /**
     * @see {@link DeleteClusterCommand}
     */
    deleteCluster(args: DeleteClusterCommandInput, options?: __HttpHandlerOptions): Promise<DeleteClusterCommandOutput>;
    deleteCluster(args: DeleteClusterCommandInput, cb: (err: any, data?: DeleteClusterCommandOutput) => void): void;
    deleteCluster(args: DeleteClusterCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteClusterCommandOutput) => void): void;
    /**
     * @see {@link DeleteServiceCommand}
     */
    deleteService(args: DeleteServiceCommandInput, options?: __HttpHandlerOptions): Promise<DeleteServiceCommandOutput>;
    deleteService(args: DeleteServiceCommandInput, cb: (err: any, data?: DeleteServiceCommandOutput) => void): void;
    deleteService(args: DeleteServiceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteServiceCommandOutput) => void): void;
    /**
     * @see {@link DeleteTaskDefinitionsCommand}
     */
    deleteTaskDefinitions(args: DeleteTaskDefinitionsCommandInput, options?: __HttpHandlerOptions): Promise<DeleteTaskDefinitionsCommandOutput>;
    deleteTaskDefinitions(args: DeleteTaskDefinitionsCommandInput, cb: (err: any, data?: DeleteTaskDefinitionsCommandOutput) => void): void;
    deleteTaskDefinitions(args: DeleteTaskDefinitionsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteTaskDefinitionsCommandOutput) => void): void;
    /**
     * @see {@link DeleteTaskSetCommand}
     */
    deleteTaskSet(args: DeleteTaskSetCommandInput, options?: __HttpHandlerOptions): Promise<DeleteTaskSetCommandOutput>;
    deleteTaskSet(args: DeleteTaskSetCommandInput, cb: (err: any, data?: DeleteTaskSetCommandOutput) => void): void;
    deleteTaskSet(args: DeleteTaskSetCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteTaskSetCommandOutput) => void): void;
    /**
     * @see {@link DeregisterContainerInstanceCommand}
     */
    deregisterContainerInstance(args: DeregisterContainerInstanceCommandInput, options?: __HttpHandlerOptions): Promise<DeregisterContainerInstanceCommandOutput>;
    deregisterContainerInstance(args: DeregisterContainerInstanceCommandInput, cb: (err: any, data?: DeregisterContainerInstanceCommandOutput) => void): void;
    deregisterContainerInstance(args: DeregisterContainerInstanceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeregisterContainerInstanceCommandOutput) => void): void;
    /**
     * @see {@link DeregisterTaskDefinitionCommand}
     */
    deregisterTaskDefinition(args: DeregisterTaskDefinitionCommandInput, options?: __HttpHandlerOptions): Promise<DeregisterTaskDefinitionCommandOutput>;
    deregisterTaskDefinition(args: DeregisterTaskDefinitionCommandInput, cb: (err: any, data?: DeregisterTaskDefinitionCommandOutput) => void): void;
    deregisterTaskDefinition(args: DeregisterTaskDefinitionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeregisterTaskDefinitionCommandOutput) => void): void;
    /**
     * @see {@link DescribeCapacityProvidersCommand}
     */
    describeCapacityProviders(): Promise<DescribeCapacityProvidersCommandOutput>;
    describeCapacityProviders(args: DescribeCapacityProvidersCommandInput, options?: __HttpHandlerOptions): Promise<DescribeCapacityProvidersCommandOutput>;
    describeCapacityProviders(args: DescribeCapacityProvidersCommandInput, cb: (err: any, data?: DescribeCapacityProvidersCommandOutput) => void): void;
    describeCapacityProviders(args: DescribeCapacityProvidersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeCapacityProvidersCommandOutput) => void): void;
    /**
     * @see {@link DescribeClustersCommand}
     */
    describeClusters(): Promise<DescribeClustersCommandOutput>;
    describeClusters(args: DescribeClustersCommandInput, options?: __HttpHandlerOptions): Promise<DescribeClustersCommandOutput>;
    describeClusters(args: DescribeClustersCommandInput, cb: (err: any, data?: DescribeClustersCommandOutput) => void): void;
    describeClusters(args: DescribeClustersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeClustersCommandOutput) => void): void;
    /**
     * @see {@link DescribeContainerInstancesCommand}
     */
    describeContainerInstances(args: DescribeContainerInstancesCommandInput, options?: __HttpHandlerOptions): Promise<DescribeContainerInstancesCommandOutput>;
    describeContainerInstances(args: DescribeContainerInstancesCommandInput, cb: (err: any, data?: DescribeContainerInstancesCommandOutput) => void): void;
    describeContainerInstances(args: DescribeContainerInstancesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeContainerInstancesCommandOutput) => void): void;
    /**
     * @see {@link DescribeServiceDeploymentsCommand}
     */
    describeServiceDeployments(args: DescribeServiceDeploymentsCommandInput, options?: __HttpHandlerOptions): Promise<DescribeServiceDeploymentsCommandOutput>;
    describeServiceDeployments(args: DescribeServiceDeploymentsCommandInput, cb: (err: any, data?: DescribeServiceDeploymentsCommandOutput) => void): void;
    describeServiceDeployments(args: DescribeServiceDeploymentsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeServiceDeploymentsCommandOutput) => void): void;
    /**
     * @see {@link DescribeServiceRevisionsCommand}
     */
    describeServiceRevisions(args: DescribeServiceRevisionsCommandInput, options?: __HttpHandlerOptions): Promise<DescribeServiceRevisionsCommandOutput>;
    describeServiceRevisions(args: DescribeServiceRevisionsCommandInput, cb: (err: any, data?: DescribeServiceRevisionsCommandOutput) => void): void;
    describeServiceRevisions(args: DescribeServiceRevisionsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeServiceRevisionsCommandOutput) => void): void;
    /**
     * @see {@link DescribeServicesCommand}
     */
    describeServices(args: DescribeServicesCommandInput, options?: __HttpHandlerOptions): Promise<DescribeServicesCommandOutput>;
    describeServices(args: DescribeServicesCommandInput, cb: (err: any, data?: DescribeServicesCommandOutput) => void): void;
    describeServices(args: DescribeServicesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeServicesCommandOutput) => void): void;
    /**
     * @see {@link DescribeTaskDefinitionCommand}
     */
    describeTaskDefinition(args: DescribeTaskDefinitionCommandInput, options?: __HttpHandlerOptions): Promise<DescribeTaskDefinitionCommandOutput>;
    describeTaskDefinition(args: DescribeTaskDefinitionCommandInput, cb: (err: any, data?: DescribeTaskDefinitionCommandOutput) => void): void;
    describeTaskDefinition(args: DescribeTaskDefinitionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeTaskDefinitionCommandOutput) => void): void;
    /**
     * @see {@link DescribeTasksCommand}
     */
    describeTasks(args: DescribeTasksCommandInput, options?: __HttpHandlerOptions): Promise<DescribeTasksCommandOutput>;
    describeTasks(args: DescribeTasksCommandInput, cb: (err: any, data?: DescribeTasksCommandOutput) => void): void;
    describeTasks(args: DescribeTasksCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeTasksCommandOutput) => void): void;
    /**
     * @see {@link DescribeTaskSetsCommand}
     */
    describeTaskSets(args: DescribeTaskSetsCommandInput, options?: __HttpHandlerOptions): Promise<DescribeTaskSetsCommandOutput>;
    describeTaskSets(args: DescribeTaskSetsCommandInput, cb: (err: any, data?: DescribeTaskSetsCommandOutput) => void): void;
    describeTaskSets(args: DescribeTaskSetsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeTaskSetsCommandOutput) => void): void;
    /**
     * @see {@link DiscoverPollEndpointCommand}
     */
    discoverPollEndpoint(): Promise<DiscoverPollEndpointCommandOutput>;
    discoverPollEndpoint(args: DiscoverPollEndpointCommandInput, options?: __HttpHandlerOptions): Promise<DiscoverPollEndpointCommandOutput>;
    discoverPollEndpoint(args: DiscoverPollEndpointCommandInput, cb: (err: any, data?: DiscoverPollEndpointCommandOutput) => void): void;
    discoverPollEndpoint(args: DiscoverPollEndpointCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DiscoverPollEndpointCommandOutput) => void): void;
    /**
     * @see {@link ExecuteCommandCommand}
     */
    executeCommand(args: ExecuteCommandCommandInput, options?: __HttpHandlerOptions): Promise<ExecuteCommandCommandOutput>;
    executeCommand(args: ExecuteCommandCommandInput, cb: (err: any, data?: ExecuteCommandCommandOutput) => void): void;
    executeCommand(args: ExecuteCommandCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ExecuteCommandCommandOutput) => void): void;
    /**
     * @see {@link GetTaskProtectionCommand}
     */
    getTaskProtection(args: GetTaskProtectionCommandInput, options?: __HttpHandlerOptions): Promise<GetTaskProtectionCommandOutput>;
    getTaskProtection(args: GetTaskProtectionCommandInput, cb: (err: any, data?: GetTaskProtectionCommandOutput) => void): void;
    getTaskProtection(args: GetTaskProtectionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetTaskProtectionCommandOutput) => void): void;
    /**
     * @see {@link ListAccountSettingsCommand}
     */
    listAccountSettings(): Promise<ListAccountSettingsCommandOutput>;
    listAccountSettings(args: ListAccountSettingsCommandInput, options?: __HttpHandlerOptions): Promise<ListAccountSettingsCommandOutput>;
    listAccountSettings(args: ListAccountSettingsCommandInput, cb: (err: any, data?: ListAccountSettingsCommandOutput) => void): void;
    listAccountSettings(args: ListAccountSettingsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListAccountSettingsCommandOutput) => void): void;
    /**
     * @see {@link ListAttributesCommand}
     */
    listAttributes(args: ListAttributesCommandInput, options?: __HttpHandlerOptions): Promise<ListAttributesCommandOutput>;
    listAttributes(args: ListAttributesCommandInput, cb: (err: any, data?: ListAttributesCommandOutput) => void): void;
    listAttributes(args: ListAttributesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListAttributesCommandOutput) => void): void;
    /**
     * @see {@link ListClustersCommand}
     */
    listClusters(): Promise<ListClustersCommandOutput>;
    listClusters(args: ListClustersCommandInput, options?: __HttpHandlerOptions): Promise<ListClustersCommandOutput>;
    listClusters(args: ListClustersCommandInput, cb: (err: any, data?: ListClustersCommandOutput) => void): void;
    listClusters(args: ListClustersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListClustersCommandOutput) => void): void;
    /**
     * @see {@link ListContainerInstancesCommand}
     */
    listContainerInstances(): Promise<ListContainerInstancesCommandOutput>;
    listContainerInstances(args: ListContainerInstancesCommandInput, options?: __HttpHandlerOptions): Promise<ListContainerInstancesCommandOutput>;
    listContainerInstances(args: ListContainerInstancesCommandInput, cb: (err: any, data?: ListContainerInstancesCommandOutput) => void): void;
    listContainerInstances(args: ListContainerInstancesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListContainerInstancesCommandOutput) => void): void;
    /**
     * @see {@link ListServiceDeploymentsCommand}
     */
    listServiceDeployments(args: ListServiceDeploymentsCommandInput, options?: __HttpHandlerOptions): Promise<ListServiceDeploymentsCommandOutput>;
    listServiceDeployments(args: ListServiceDeploymentsCommandInput, cb: (err: any, data?: ListServiceDeploymentsCommandOutput) => void): void;
    listServiceDeployments(args: ListServiceDeploymentsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListServiceDeploymentsCommandOutput) => void): void;
    /**
     * @see {@link ListServicesCommand}
     */
    listServices(): Promise<ListServicesCommandOutput>;
    listServices(args: ListServicesCommandInput, options?: __HttpHandlerOptions): Promise<ListServicesCommandOutput>;
    listServices(args: ListServicesCommandInput, cb: (err: any, data?: ListServicesCommandOutput) => void): void;
    listServices(args: ListServicesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListServicesCommandOutput) => void): void;
    /**
     * @see {@link ListServicesByNamespaceCommand}
     */
    listServicesByNamespace(args: ListServicesByNamespaceCommandInput, options?: __HttpHandlerOptions): Promise<ListServicesByNamespaceCommandOutput>;
    listServicesByNamespace(args: ListServicesByNamespaceCommandInput, cb: (err: any, data?: ListServicesByNamespaceCommandOutput) => void): void;
    listServicesByNamespace(args: ListServicesByNamespaceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListServicesByNamespaceCommandOutput) => void): void;
    /**
     * @see {@link ListTagsForResourceCommand}
     */
    listTagsForResource(args: ListTagsForResourceCommandInput, options?: __HttpHandlerOptions): Promise<ListTagsForResourceCommandOutput>;
    listTagsForResource(args: ListTagsForResourceCommandInput, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    listTagsForResource(args: ListTagsForResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    /**
     * @see {@link ListTaskDefinitionFamiliesCommand}
     */
    listTaskDefinitionFamilies(): Promise<ListTaskDefinitionFamiliesCommandOutput>;
    listTaskDefinitionFamilies(args: ListTaskDefinitionFamiliesCommandInput, options?: __HttpHandlerOptions): Promise<ListTaskDefinitionFamiliesCommandOutput>;
    listTaskDefinitionFamilies(args: ListTaskDefinitionFamiliesCommandInput, cb: (err: any, data?: ListTaskDefinitionFamiliesCommandOutput) => void): void;
    listTaskDefinitionFamilies(args: ListTaskDefinitionFamiliesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTaskDefinitionFamiliesCommandOutput) => void): void;
    /**
     * @see {@link ListTaskDefinitionsCommand}
     */
    listTaskDefinitions(): Promise<ListTaskDefinitionsCommandOutput>;
    listTaskDefinitions(args: ListTaskDefinitionsCommandInput, options?: __HttpHandlerOptions): Promise<ListTaskDefinitionsCommandOutput>;
    listTaskDefinitions(args: ListTaskDefinitionsCommandInput, cb: (err: any, data?: ListTaskDefinitionsCommandOutput) => void): void;
    listTaskDefinitions(args: ListTaskDefinitionsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTaskDefinitionsCommandOutput) => void): void;
    /**
     * @see {@link ListTasksCommand}
     */
    listTasks(): Promise<ListTasksCommandOutput>;
    listTasks(args: ListTasksCommandInput, options?: __HttpHandlerOptions): Promise<ListTasksCommandOutput>;
    listTasks(args: ListTasksCommandInput, cb: (err: any, data?: ListTasksCommandOutput) => void): void;
    listTasks(args: ListTasksCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTasksCommandOutput) => void): void;
    /**
     * @see {@link PutAccountSettingCommand}
     */
    putAccountSetting(args: PutAccountSettingCommandInput, options?: __HttpHandlerOptions): Promise<PutAccountSettingCommandOutput>;
    putAccountSetting(args: PutAccountSettingCommandInput, cb: (err: any, data?: PutAccountSettingCommandOutput) => void): void;
    putAccountSetting(args: PutAccountSettingCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutAccountSettingCommandOutput) => void): void;
    /**
     * @see {@link PutAccountSettingDefaultCommand}
     */
    putAccountSettingDefault(args: PutAccountSettingDefaultCommandInput, options?: __HttpHandlerOptions): Promise<PutAccountSettingDefaultCommandOutput>;
    putAccountSettingDefault(args: PutAccountSettingDefaultCommandInput, cb: (err: any, data?: PutAccountSettingDefaultCommandOutput) => void): void;
    putAccountSettingDefault(args: PutAccountSettingDefaultCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutAccountSettingDefaultCommandOutput) => void): void;
    /**
     * @see {@link PutAttributesCommand}
     */
    putAttributes(args: PutAttributesCommandInput, options?: __HttpHandlerOptions): Promise<PutAttributesCommandOutput>;
    putAttributes(args: PutAttributesCommandInput, cb: (err: any, data?: PutAttributesCommandOutput) => void): void;
    putAttributes(args: PutAttributesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutAttributesCommandOutput) => void): void;
    /**
     * @see {@link PutClusterCapacityProvidersCommand}
     */
    putClusterCapacityProviders(args: PutClusterCapacityProvidersCommandInput, options?: __HttpHandlerOptions): Promise<PutClusterCapacityProvidersCommandOutput>;
    putClusterCapacityProviders(args: PutClusterCapacityProvidersCommandInput, cb: (err: any, data?: PutClusterCapacityProvidersCommandOutput) => void): void;
    putClusterCapacityProviders(args: PutClusterCapacityProvidersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutClusterCapacityProvidersCommandOutput) => void): void;
    /**
     * @see {@link RegisterContainerInstanceCommand}
     */
    registerContainerInstance(): Promise<RegisterContainerInstanceCommandOutput>;
    registerContainerInstance(args: RegisterContainerInstanceCommandInput, options?: __HttpHandlerOptions): Promise<RegisterContainerInstanceCommandOutput>;
    registerContainerInstance(args: RegisterContainerInstanceCommandInput, cb: (err: any, data?: RegisterContainerInstanceCommandOutput) => void): void;
    registerContainerInstance(args: RegisterContainerInstanceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RegisterContainerInstanceCommandOutput) => void): void;
    /**
     * @see {@link RegisterTaskDefinitionCommand}
     */
    registerTaskDefinition(args: RegisterTaskDefinitionCommandInput, options?: __HttpHandlerOptions): Promise<RegisterTaskDefinitionCommandOutput>;
    registerTaskDefinition(args: RegisterTaskDefinitionCommandInput, cb: (err: any, data?: RegisterTaskDefinitionCommandOutput) => void): void;
    registerTaskDefinition(args: RegisterTaskDefinitionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RegisterTaskDefinitionCommandOutput) => void): void;
    /**
     * @see {@link RunTaskCommand}
     */
    runTask(args: RunTaskCommandInput, options?: __HttpHandlerOptions): Promise<RunTaskCommandOutput>;
    runTask(args: RunTaskCommandInput, cb: (err: any, data?: RunTaskCommandOutput) => void): void;
    runTask(args: RunTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RunTaskCommandOutput) => void): void;
    /**
     * @see {@link StartTaskCommand}
     */
    startTask(args: StartTaskCommandInput, options?: __HttpHandlerOptions): Promise<StartTaskCommandOutput>;
    startTask(args: StartTaskCommandInput, cb: (err: any, data?: StartTaskCommandOutput) => void): void;
    startTask(args: StartTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StartTaskCommandOutput) => void): void;
    /**
     * @see {@link StopServiceDeploymentCommand}
     */
    stopServiceDeployment(args: StopServiceDeploymentCommandInput, options?: __HttpHandlerOptions): Promise<StopServiceDeploymentCommandOutput>;
    stopServiceDeployment(args: StopServiceDeploymentCommandInput, cb: (err: any, data?: StopServiceDeploymentCommandOutput) => void): void;
    stopServiceDeployment(args: StopServiceDeploymentCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StopServiceDeploymentCommandOutput) => void): void;
    /**
     * @see {@link StopTaskCommand}
     */
    stopTask(args: StopTaskCommandInput, options?: __HttpHandlerOptions): Promise<StopTaskCommandOutput>;
    stopTask(args: StopTaskCommandInput, cb: (err: any, data?: StopTaskCommandOutput) => void): void;
    stopTask(args: StopTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StopTaskCommandOutput) => void): void;
    /**
     * @see {@link SubmitAttachmentStateChangesCommand}
     */
    submitAttachmentStateChanges(args: SubmitAttachmentStateChangesCommandInput, options?: __HttpHandlerOptions): Promise<SubmitAttachmentStateChangesCommandOutput>;
    submitAttachmentStateChanges(args: SubmitAttachmentStateChangesCommandInput, cb: (err: any, data?: SubmitAttachmentStateChangesCommandOutput) => void): void;
    submitAttachmentStateChanges(args: SubmitAttachmentStateChangesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SubmitAttachmentStateChangesCommandOutput) => void): void;
    /**
     * @see {@link SubmitContainerStateChangeCommand}
     */
    submitContainerStateChange(): Promise<SubmitContainerStateChangeCommandOutput>;
    submitContainerStateChange(args: SubmitContainerStateChangeCommandInput, options?: __HttpHandlerOptions): Promise<SubmitContainerStateChangeCommandOutput>;
    submitContainerStateChange(args: SubmitContainerStateChangeCommandInput, cb: (err: any, data?: SubmitContainerStateChangeCommandOutput) => void): void;
    submitContainerStateChange(args: SubmitContainerStateChangeCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SubmitContainerStateChangeCommandOutput) => void): void;
    /**
     * @see {@link SubmitTaskStateChangeCommand}
     */
    submitTaskStateChange(): Promise<SubmitTaskStateChangeCommandOutput>;
    submitTaskStateChange(args: SubmitTaskStateChangeCommandInput, options?: __HttpHandlerOptions): Promise<SubmitTaskStateChangeCommandOutput>;
    submitTaskStateChange(args: SubmitTaskStateChangeCommandInput, cb: (err: any, data?: SubmitTaskStateChangeCommandOutput) => void): void;
    submitTaskStateChange(args: SubmitTaskStateChangeCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SubmitTaskStateChangeCommandOutput) => void): void;
    /**
     * @see {@link TagResourceCommand}
     */
    tagResource(args: TagResourceCommandInput, options?: __HttpHandlerOptions): Promise<TagResourceCommandOutput>;
    tagResource(args: TagResourceCommandInput, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    tagResource(args: TagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    /**
     * @see {@link UntagResourceCommand}
     */
    untagResource(args: UntagResourceCommandInput, options?: __HttpHandlerOptions): Promise<UntagResourceCommandOutput>;
    untagResource(args: UntagResourceCommandInput, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    untagResource(args: UntagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    /**
     * @see {@link UpdateCapacityProviderCommand}
     */
    updateCapacityProvider(args: UpdateCapacityProviderCommandInput, options?: __HttpHandlerOptions): Promise<UpdateCapacityProviderCommandOutput>;
    updateCapacityProvider(args: UpdateCapacityProviderCommandInput, cb: (err: any, data?: UpdateCapacityProviderCommandOutput) => void): void;
    updateCapacityProvider(args: UpdateCapacityProviderCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateCapacityProviderCommandOutput) => void): void;
    /**
     * @see {@link UpdateClusterCommand}
     */
    updateCluster(args: UpdateClusterCommandInput, options?: __HttpHandlerOptions): Promise<UpdateClusterCommandOutput>;
    updateCluster(args: UpdateClusterCommandInput, cb: (err: any, data?: UpdateClusterCommandOutput) => void): void;
    updateCluster(args: UpdateClusterCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateClusterCommandOutput) => void): void;
    /**
     * @see {@link UpdateClusterSettingsCommand}
     */
    updateClusterSettings(args: UpdateClusterSettingsCommandInput, options?: __HttpHandlerOptions): Promise<UpdateClusterSettingsCommandOutput>;
    updateClusterSettings(args: UpdateClusterSettingsCommandInput, cb: (err: any, data?: UpdateClusterSettingsCommandOutput) => void): void;
    updateClusterSettings(args: UpdateClusterSettingsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateClusterSettingsCommandOutput) => void): void;
    /**
     * @see {@link UpdateContainerAgentCommand}
     */
    updateContainerAgent(args: UpdateContainerAgentCommandInput, options?: __HttpHandlerOptions): Promise<UpdateContainerAgentCommandOutput>;
    updateContainerAgent(args: UpdateContainerAgentCommandInput, cb: (err: any, data?: UpdateContainerAgentCommandOutput) => void): void;
    updateContainerAgent(args: UpdateContainerAgentCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateContainerAgentCommandOutput) => void): void;
    /**
     * @see {@link UpdateContainerInstancesStateCommand}
     */
    updateContainerInstancesState(args: UpdateContainerInstancesStateCommandInput, options?: __HttpHandlerOptions): Promise<UpdateContainerInstancesStateCommandOutput>;
    updateContainerInstancesState(args: UpdateContainerInstancesStateCommandInput, cb: (err: any, data?: UpdateContainerInstancesStateCommandOutput) => void): void;
    updateContainerInstancesState(args: UpdateContainerInstancesStateCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateContainerInstancesStateCommandOutput) => void): void;
    /**
     * @see {@link UpdateServiceCommand}
     */
    updateService(args: UpdateServiceCommandInput, options?: __HttpHandlerOptions): Promise<UpdateServiceCommandOutput>;
    updateService(args: UpdateServiceCommandInput, cb: (err: any, data?: UpdateServiceCommandOutput) => void): void;
    updateService(args: UpdateServiceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateServiceCommandOutput) => void): void;
    /**
     * @see {@link UpdateServicePrimaryTaskSetCommand}
     */
    updateServicePrimaryTaskSet(args: UpdateServicePrimaryTaskSetCommandInput, options?: __HttpHandlerOptions): Promise<UpdateServicePrimaryTaskSetCommandOutput>;
    updateServicePrimaryTaskSet(args: UpdateServicePrimaryTaskSetCommandInput, cb: (err: any, data?: UpdateServicePrimaryTaskSetCommandOutput) => void): void;
    updateServicePrimaryTaskSet(args: UpdateServicePrimaryTaskSetCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateServicePrimaryTaskSetCommandOutput) => void): void;
    /**
     * @see {@link UpdateTaskProtectionCommand}
     */
    updateTaskProtection(args: UpdateTaskProtectionCommandInput, options?: __HttpHandlerOptions): Promise<UpdateTaskProtectionCommandOutput>;
    updateTaskProtection(args: UpdateTaskProtectionCommandInput, cb: (err: any, data?: UpdateTaskProtectionCommandOutput) => void): void;
    updateTaskProtection(args: UpdateTaskProtectionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateTaskProtectionCommandOutput) => void): void;
    /**
     * @see {@link UpdateTaskSetCommand}
     */
    updateTaskSet(args: UpdateTaskSetCommandInput, options?: __HttpHandlerOptions): Promise<UpdateTaskSetCommandOutput>;
    updateTaskSet(args: UpdateTaskSetCommandInput, cb: (err: any, data?: UpdateTaskSetCommandOutput) => void): void;
    updateTaskSet(args: UpdateTaskSetCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateTaskSetCommandOutput) => void): void;
}
/**
 * <fullname>Amazon Elastic Container Service</fullname>
 *          <p>Amazon Elastic Container Service (Amazon ECS) is a highly scalable, fast, container management service. It makes
 * 			it easy to run, stop, and manage Docker containers. You can host your cluster on a
 * 			serverless infrastructure that's managed by Amazon ECS by launching your services or tasks on
 * 			Fargate. For more control, you can host your tasks on a cluster of Amazon Elastic Compute Cloud (Amazon EC2)
 * 			or External (on-premises) instances that you manage.</p>
 *          <p>Amazon ECS makes it easy to launch and stop container-based applications with simple API
 * 			calls. This makes it easy to get the state of your cluster from a centralized service,
 * 			and gives you access to many familiar Amazon EC2 features.</p>
 *          <p>You can use Amazon ECS to schedule the placement of containers across your cluster based on
 * 			your resource needs, isolation policies, and availability requirements. With Amazon ECS, you
 * 			don't need to operate your own cluster management and configuration management systems.
 * 			You also don't need to worry about scaling your management infrastructure. </p>
 * @public
 */
export declare class ECS extends ECSClient implements ECS {
}
