import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ECSServiceException as __BaseException } from "./ECSServiceException";
import {
  AvailabilityZoneRebalancing,
  CapacityProvider,
  CapacityProviderStrategyItem,
  Cluster,
  ClusterConfiguration,
  ClusterServiceConnectDefaultsRequest,
  ClusterSetting,
  ContainerInstance,
  ContainerInstanceStatus,
  DeploymentConfiguration,
  DeploymentController,
  Failure,
  LoadBalancer,
  ManagedAgentName,
  ManagedDraining,
  ManagedScaling,
  ManagedTerminationProtection,
  NetworkBinding,
  NetworkConfiguration,
  PlacementConstraint,
  PlacementStrategy,
  PropagateTags,
  ProtectedTask,
  Scale,
  Service,
  ServiceConnectConfiguration,
  ServiceRegistry,
  ServiceVolumeConfiguration,
  Tag,
  Task,
  TaskSet,
  VpcLatticeConfiguration,
} from "./models_0";
export interface StopTaskResponse {
  task?: Task | undefined;
}
export interface AttachmentStateChange {
  attachmentArn: string | undefined;
  status: string | undefined;
}
export interface SubmitAttachmentStateChangesRequest {
  cluster?: string | undefined;
  attachments: AttachmentStateChange[] | undefined;
}
export interface SubmitAttachmentStateChangesResponse {
  acknowledgment?: string | undefined;
}
export interface SubmitContainerStateChangeRequest {
  cluster?: string | undefined;
  task?: string | undefined;
  containerName?: string | undefined;
  runtimeId?: string | undefined;
  status?: string | undefined;
  exitCode?: number | undefined;
  reason?: string | undefined;
  networkBindings?: NetworkBinding[] | undefined;
}
export interface SubmitContainerStateChangeResponse {
  acknowledgment?: string | undefined;
}
export interface ContainerStateChange {
  containerName?: string | undefined;
  imageDigest?: string | undefined;
  runtimeId?: string | undefined;
  exitCode?: number | undefined;
  networkBindings?: NetworkBinding[] | undefined;
  reason?: string | undefined;
  status?: string | undefined;
}
export interface ManagedAgentStateChange {
  containerName: string | undefined;
  managedAgentName: ManagedAgentName | undefined;
  status: string | undefined;
  reason?: string | undefined;
}
export interface SubmitTaskStateChangeRequest {
  cluster?: string | undefined;
  task?: string | undefined;
  status?: string | undefined;
  reason?: string | undefined;
  containers?: ContainerStateChange[] | undefined;
  attachments?: AttachmentStateChange[] | undefined;
  managedAgents?: ManagedAgentStateChange[] | undefined;
  pullStartedAt?: Date | undefined;
  pullStoppedAt?: Date | undefined;
  executionStoppedAt?: Date | undefined;
}
export interface SubmitTaskStateChangeResponse {
  acknowledgment?: string | undefined;
}
export interface TagResourceRequest {
  resourceArn: string | undefined;
  tags: Tag[] | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface AutoScalingGroupProviderUpdate {
  managedScaling?: ManagedScaling | undefined;
  managedTerminationProtection?: ManagedTerminationProtection | undefined;
  managedDraining?: ManagedDraining | undefined;
}
export interface UpdateCapacityProviderRequest {
  name: string | undefined;
  autoScalingGroupProvider: AutoScalingGroupProviderUpdate | undefined;
}
export interface UpdateCapacityProviderResponse {
  capacityProvider?: CapacityProvider | undefined;
}
export interface UpdateClusterRequest {
  cluster: string | undefined;
  settings?: ClusterSetting[] | undefined;
  configuration?: ClusterConfiguration | undefined;
  serviceConnectDefaults?: ClusterServiceConnectDefaultsRequest | undefined;
}
export interface UpdateClusterResponse {
  cluster?: Cluster | undefined;
}
export interface UpdateClusterSettingsRequest {
  cluster: string | undefined;
  settings: ClusterSetting[] | undefined;
}
export interface UpdateClusterSettingsResponse {
  cluster?: Cluster | undefined;
}
export declare class MissingVersionException extends __BaseException {
  readonly name: "MissingVersionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MissingVersionException, __BaseException>
  );
}
export declare class NoUpdateAvailableException extends __BaseException {
  readonly name: "NoUpdateAvailableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NoUpdateAvailableException, __BaseException>
  );
}
export interface UpdateContainerAgentRequest {
  cluster?: string | undefined;
  containerInstance: string | undefined;
}
export interface UpdateContainerAgentResponse {
  containerInstance?: ContainerInstance | undefined;
}
export interface UpdateContainerInstancesStateRequest {
  cluster?: string | undefined;
  containerInstances: string[] | undefined;
  status: ContainerInstanceStatus | undefined;
}
export interface UpdateContainerInstancesStateResponse {
  containerInstances?: ContainerInstance[] | undefined;
  failures?: Failure[] | undefined;
}
export interface UpdateServiceRequest {
  cluster?: string | undefined;
  service: string | undefined;
  desiredCount?: number | undefined;
  taskDefinition?: string | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  deploymentConfiguration?: DeploymentConfiguration | undefined;
  availabilityZoneRebalancing?: AvailabilityZoneRebalancing | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  placementConstraints?: PlacementConstraint[] | undefined;
  placementStrategy?: PlacementStrategy[] | undefined;
  platformVersion?: string | undefined;
  forceNewDeployment?: boolean | undefined;
  healthCheckGracePeriodSeconds?: number | undefined;
  deploymentController?: DeploymentController | undefined;
  enableExecuteCommand?: boolean | undefined;
  enableECSManagedTags?: boolean | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  propagateTags?: PropagateTags | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  serviceConnectConfiguration?: ServiceConnectConfiguration | undefined;
  volumeConfigurations?: ServiceVolumeConfiguration[] | undefined;
  vpcLatticeConfigurations?: VpcLatticeConfiguration[] | undefined;
}
export interface UpdateServiceResponse {
  service?: Service | undefined;
}
export interface UpdateServicePrimaryTaskSetRequest {
  cluster: string | undefined;
  service: string | undefined;
  primaryTaskSet: string | undefined;
}
export interface UpdateServicePrimaryTaskSetResponse {
  taskSet?: TaskSet | undefined;
}
export interface UpdateTaskProtectionRequest {
  cluster: string | undefined;
  tasks: string[] | undefined;
  protectionEnabled: boolean | undefined;
  expiresInMinutes?: number | undefined;
}
export interface UpdateTaskProtectionResponse {
  protectedTasks?: ProtectedTask[] | undefined;
  failures?: Failure[] | undefined;
}
export interface UpdateTaskSetRequest {
  cluster: string | undefined;
  service: string | undefined;
  taskSet: string | undefined;
  scale: Scale | undefined;
}
export interface UpdateTaskSetResponse {
  taskSet?: TaskSet | undefined;
}
