"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  ActivityAlreadyExists: () => ActivityAlreadyExists,
  ActivityDoesNotExist: () => ActivityDoesNotExist,
  ActivityFailedEventDetailsFilterSensitiveLog: () => ActivityFailedEventDetailsFilterSensitiveLog,
  ActivityLimitExceeded: () => ActivityLimitExceeded,
  ActivityScheduleFailedEventDetailsFilterSensitiveLog: () => ActivityScheduleFailedEventDetailsFilterSensitiveLog,
  ActivityScheduledEventDetailsFilterSensitiveLog: () => ActivityScheduledEventDetailsFilterSensitiveLog,
  ActivitySucceededEventDetailsFilterSensitiveLog: () => ActivitySucceededEventDetailsFilterSensitiveLog,
  ActivityTimedOutEventDetailsFilterSensitiveLog: () => ActivityTimedOutEventDetailsFilterSensitiveLog,
  ActivityWorkerLimitExceeded: () => ActivityWorkerLimitExceeded,
  ConflictException: () => ConflictException,
  CreateActivityCommand: () => CreateActivityCommand,
  CreateStateMachineAliasCommand: () => CreateStateMachineAliasCommand,
  CreateStateMachineAliasInputFilterSensitiveLog: () => CreateStateMachineAliasInputFilterSensitiveLog,
  CreateStateMachineCommand: () => CreateStateMachineCommand,
  CreateStateMachineInputFilterSensitiveLog: () => CreateStateMachineInputFilterSensitiveLog,
  DeleteActivityCommand: () => DeleteActivityCommand,
  DeleteStateMachineAliasCommand: () => DeleteStateMachineAliasCommand,
  DeleteStateMachineCommand: () => DeleteStateMachineCommand,
  DeleteStateMachineVersionCommand: () => DeleteStateMachineVersionCommand,
  DescribeActivityCommand: () => DescribeActivityCommand,
  DescribeExecutionCommand: () => DescribeExecutionCommand,
  DescribeExecutionOutputFilterSensitiveLog: () => DescribeExecutionOutputFilterSensitiveLog,
  DescribeMapRunCommand: () => DescribeMapRunCommand,
  DescribeStateMachineAliasCommand: () => DescribeStateMachineAliasCommand,
  DescribeStateMachineAliasOutputFilterSensitiveLog: () => DescribeStateMachineAliasOutputFilterSensitiveLog,
  DescribeStateMachineCommand: () => DescribeStateMachineCommand,
  DescribeStateMachineForExecutionCommand: () => DescribeStateMachineForExecutionCommand,
  DescribeStateMachineForExecutionOutputFilterSensitiveLog: () => DescribeStateMachineForExecutionOutputFilterSensitiveLog,
  DescribeStateMachineOutputFilterSensitiveLog: () => DescribeStateMachineOutputFilterSensitiveLog,
  EncryptionType: () => EncryptionType,
  EvaluationFailedEventDetailsFilterSensitiveLog: () => EvaluationFailedEventDetailsFilterSensitiveLog,
  ExecutionAbortedEventDetailsFilterSensitiveLog: () => ExecutionAbortedEventDetailsFilterSensitiveLog,
  ExecutionAlreadyExists: () => ExecutionAlreadyExists,
  ExecutionDoesNotExist: () => ExecutionDoesNotExist,
  ExecutionFailedEventDetailsFilterSensitiveLog: () => ExecutionFailedEventDetailsFilterSensitiveLog,
  ExecutionLimitExceeded: () => ExecutionLimitExceeded,
  ExecutionNotRedrivable: () => ExecutionNotRedrivable,
  ExecutionRedriveFilter: () => ExecutionRedriveFilter,
  ExecutionRedriveStatus: () => ExecutionRedriveStatus,
  ExecutionStartedEventDetailsFilterSensitiveLog: () => ExecutionStartedEventDetailsFilterSensitiveLog,
  ExecutionStatus: () => ExecutionStatus,
  ExecutionSucceededEventDetailsFilterSensitiveLog: () => ExecutionSucceededEventDetailsFilterSensitiveLog,
  ExecutionTimedOutEventDetailsFilterSensitiveLog: () => ExecutionTimedOutEventDetailsFilterSensitiveLog,
  GetActivityTaskCommand: () => GetActivityTaskCommand,
  GetActivityTaskOutputFilterSensitiveLog: () => GetActivityTaskOutputFilterSensitiveLog,
  GetExecutionHistoryCommand: () => GetExecutionHistoryCommand,
  GetExecutionHistoryOutputFilterSensitiveLog: () => GetExecutionHistoryOutputFilterSensitiveLog,
  HistoryEventFilterSensitiveLog: () => HistoryEventFilterSensitiveLog,
  HistoryEventType: () => HistoryEventType,
  IncludedData: () => IncludedData,
  InspectionDataFilterSensitiveLog: () => InspectionDataFilterSensitiveLog,
  InspectionLevel: () => InspectionLevel,
  InvalidArn: () => InvalidArn,
  InvalidDefinition: () => InvalidDefinition,
  InvalidEncryptionConfiguration: () => InvalidEncryptionConfiguration,
  InvalidExecutionInput: () => InvalidExecutionInput,
  InvalidLoggingConfiguration: () => InvalidLoggingConfiguration,
  InvalidName: () => InvalidName,
  InvalidOutput: () => InvalidOutput,
  InvalidToken: () => InvalidToken,
  InvalidTracingConfiguration: () => InvalidTracingConfiguration,
  KmsAccessDeniedException: () => KmsAccessDeniedException,
  KmsInvalidStateException: () => KmsInvalidStateException,
  KmsKeyState: () => KmsKeyState,
  KmsThrottlingException: () => KmsThrottlingException,
  LambdaFunctionFailedEventDetailsFilterSensitiveLog: () => LambdaFunctionFailedEventDetailsFilterSensitiveLog,
  LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog: () => LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog,
  LambdaFunctionScheduledEventDetailsFilterSensitiveLog: () => LambdaFunctionScheduledEventDetailsFilterSensitiveLog,
  LambdaFunctionStartFailedEventDetailsFilterSensitiveLog: () => LambdaFunctionStartFailedEventDetailsFilterSensitiveLog,
  LambdaFunctionSucceededEventDetailsFilterSensitiveLog: () => LambdaFunctionSucceededEventDetailsFilterSensitiveLog,
  LambdaFunctionTimedOutEventDetailsFilterSensitiveLog: () => LambdaFunctionTimedOutEventDetailsFilterSensitiveLog,
  ListActivitiesCommand: () => ListActivitiesCommand,
  ListExecutionsCommand: () => ListExecutionsCommand,
  ListMapRunsCommand: () => ListMapRunsCommand,
  ListStateMachineAliasesCommand: () => ListStateMachineAliasesCommand,
  ListStateMachineVersionsCommand: () => ListStateMachineVersionsCommand,
  ListStateMachinesCommand: () => ListStateMachinesCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  LogLevel: () => LogLevel,
  MapRunFailedEventDetailsFilterSensitiveLog: () => MapRunFailedEventDetailsFilterSensitiveLog,
  MapRunStatus: () => MapRunStatus,
  MissingRequiredParameter: () => MissingRequiredParameter,
  PublishStateMachineVersionCommand: () => PublishStateMachineVersionCommand,
  PublishStateMachineVersionInputFilterSensitiveLog: () => PublishStateMachineVersionInputFilterSensitiveLog,
  RedriveExecutionCommand: () => RedriveExecutionCommand,
  ResourceNotFound: () => ResourceNotFound,
  SFN: () => SFN,
  SFNClient: () => SFNClient,
  SFNServiceException: () => SFNServiceException,
  SendTaskFailureCommand: () => SendTaskFailureCommand,
  SendTaskFailureInputFilterSensitiveLog: () => SendTaskFailureInputFilterSensitiveLog,
  SendTaskHeartbeatCommand: () => SendTaskHeartbeatCommand,
  SendTaskSuccessCommand: () => SendTaskSuccessCommand,
  SendTaskSuccessInputFilterSensitiveLog: () => SendTaskSuccessInputFilterSensitiveLog,
  ServiceQuotaExceededException: () => ServiceQuotaExceededException,
  StartExecutionCommand: () => StartExecutionCommand,
  StartExecutionInputFilterSensitiveLog: () => StartExecutionInputFilterSensitiveLog,
  StartSyncExecutionCommand: () => StartSyncExecutionCommand,
  StartSyncExecutionInputFilterSensitiveLog: () => StartSyncExecutionInputFilterSensitiveLog,
  StartSyncExecutionOutputFilterSensitiveLog: () => StartSyncExecutionOutputFilterSensitiveLog,
  StateEnteredEventDetailsFilterSensitiveLog: () => StateEnteredEventDetailsFilterSensitiveLog,
  StateExitedEventDetailsFilterSensitiveLog: () => StateExitedEventDetailsFilterSensitiveLog,
  StateMachineAlreadyExists: () => StateMachineAlreadyExists,
  StateMachineDeleting: () => StateMachineDeleting,
  StateMachineDoesNotExist: () => StateMachineDoesNotExist,
  StateMachineLimitExceeded: () => StateMachineLimitExceeded,
  StateMachineStatus: () => StateMachineStatus,
  StateMachineType: () => StateMachineType,
  StateMachineTypeNotSupported: () => StateMachineTypeNotSupported,
  StopExecutionCommand: () => StopExecutionCommand,
  StopExecutionInputFilterSensitiveLog: () => StopExecutionInputFilterSensitiveLog,
  SyncExecutionStatus: () => SyncExecutionStatus,
  TagResourceCommand: () => TagResourceCommand,
  TaskDoesNotExist: () => TaskDoesNotExist,
  TaskFailedEventDetailsFilterSensitiveLog: () => TaskFailedEventDetailsFilterSensitiveLog,
  TaskScheduledEventDetailsFilterSensitiveLog: () => TaskScheduledEventDetailsFilterSensitiveLog,
  TaskStartFailedEventDetailsFilterSensitiveLog: () => TaskStartFailedEventDetailsFilterSensitiveLog,
  TaskSubmitFailedEventDetailsFilterSensitiveLog: () => TaskSubmitFailedEventDetailsFilterSensitiveLog,
  TaskSubmittedEventDetailsFilterSensitiveLog: () => TaskSubmittedEventDetailsFilterSensitiveLog,
  TaskSucceededEventDetailsFilterSensitiveLog: () => TaskSucceededEventDetailsFilterSensitiveLog,
  TaskTimedOut: () => TaskTimedOut,
  TaskTimedOutEventDetailsFilterSensitiveLog: () => TaskTimedOutEventDetailsFilterSensitiveLog,
  TestExecutionStatus: () => TestExecutionStatus,
  TestStateCommand: () => TestStateCommand,
  TestStateInputFilterSensitiveLog: () => TestStateInputFilterSensitiveLog,
  TestStateOutputFilterSensitiveLog: () => TestStateOutputFilterSensitiveLog,
  TooManyTags: () => TooManyTags,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateMapRunCommand: () => UpdateMapRunCommand,
  UpdateStateMachineAliasCommand: () => UpdateStateMachineAliasCommand,
  UpdateStateMachineAliasInputFilterSensitiveLog: () => UpdateStateMachineAliasInputFilterSensitiveLog,
  UpdateStateMachineCommand: () => UpdateStateMachineCommand,
  UpdateStateMachineInputFilterSensitiveLog: () => UpdateStateMachineInputFilterSensitiveLog,
  ValidateStateMachineDefinitionCommand: () => ValidateStateMachineDefinitionCommand,
  ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog: () => ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog,
  ValidateStateMachineDefinitionInputFilterSensitiveLog: () => ValidateStateMachineDefinitionInputFilterSensitiveLog,
  ValidateStateMachineDefinitionOutputFilterSensitiveLog: () => ValidateStateMachineDefinitionOutputFilterSensitiveLog,
  ValidateStateMachineDefinitionResultCode: () => ValidateStateMachineDefinitionResultCode,
  ValidateStateMachineDefinitionSeverity: () => ValidateStateMachineDefinitionSeverity,
  ValidationException: () => ValidationException,
  ValidationExceptionReason: () => ValidationExceptionReason,
  __Client: () => import_smithy_client.Client,
  paginateGetExecutionHistory: () => paginateGetExecutionHistory,
  paginateListActivities: () => paginateListActivities,
  paginateListExecutions: () => paginateListExecutions,
  paginateListMapRuns: () => paginateListMapRuns,
  paginateListStateMachines: () => paginateListStateMachines
});
module.exports = __toCommonJS(index_exports);

// src/SFNClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "states"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/SFNClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/SFNClient.ts
var SFNClient = class extends import_smithy_client.Client {
  static {
    __name(this, "SFNClient");
  }
  /**
   * The resolved configuration of SFNClient class. This is resolved and normalized from the {@link SFNClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultSFNHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/SFN.ts


// src/commands/CreateActivityCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_json1_0.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("@smithy/uuid");

// src/models/models_0.ts


// src/models/SFNServiceException.ts

var SFNServiceException = class _SFNServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "SFNServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _SFNServiceException.prototype);
  }
};

// src/models/models_0.ts
var ActivityAlreadyExists = class _ActivityAlreadyExists extends SFNServiceException {
  static {
    __name(this, "ActivityAlreadyExists");
  }
  name = "ActivityAlreadyExists";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ActivityAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ActivityAlreadyExists.prototype);
  }
};
var ActivityDoesNotExist = class _ActivityDoesNotExist extends SFNServiceException {
  static {
    __name(this, "ActivityDoesNotExist");
  }
  name = "ActivityDoesNotExist";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ActivityDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ActivityDoesNotExist.prototype);
  }
};
var ActivityLimitExceeded = class _ActivityLimitExceeded extends SFNServiceException {
  static {
    __name(this, "ActivityLimitExceeded");
  }
  name = "ActivityLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ActivityLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ActivityLimitExceeded.prototype);
  }
};
var ActivityWorkerLimitExceeded = class _ActivityWorkerLimitExceeded extends SFNServiceException {
  static {
    __name(this, "ActivityWorkerLimitExceeded");
  }
  name = "ActivityWorkerLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ActivityWorkerLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ActivityWorkerLimitExceeded.prototype);
  }
};
var EncryptionType = {
  AWS_OWNED_KEY: "AWS_OWNED_KEY",
  CUSTOMER_MANAGED_KMS_KEY: "CUSTOMER_MANAGED_KMS_KEY"
};
var InvalidEncryptionConfiguration = class _InvalidEncryptionConfiguration extends SFNServiceException {
  static {
    __name(this, "InvalidEncryptionConfiguration");
  }
  name = "InvalidEncryptionConfiguration";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidEncryptionConfiguration",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidEncryptionConfiguration.prototype);
  }
};
var InvalidName = class _InvalidName extends SFNServiceException {
  static {
    __name(this, "InvalidName");
  }
  name = "InvalidName";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidName",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidName.prototype);
  }
};
var KmsAccessDeniedException = class _KmsAccessDeniedException extends SFNServiceException {
  static {
    __name(this, "KmsAccessDeniedException");
  }
  name = "KmsAccessDeniedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KmsAccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KmsAccessDeniedException.prototype);
  }
};
var KmsThrottlingException = class _KmsThrottlingException extends SFNServiceException {
  static {
    __name(this, "KmsThrottlingException");
  }
  name = "KmsThrottlingException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KmsThrottlingException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KmsThrottlingException.prototype);
  }
};
var TooManyTags = class _TooManyTags extends SFNServiceException {
  static {
    __name(this, "TooManyTags");
  }
  name = "TooManyTags";
  $fault = "client";
  resourceName;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyTags",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyTags.prototype);
    this.resourceName = opts.resourceName;
  }
};
var ConflictException = class _ConflictException extends SFNServiceException {
  static {
    __name(this, "ConflictException");
  }
  name = "ConflictException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ConflictException.prototype);
  }
};
var LogLevel = {
  ALL: "ALL",
  ERROR: "ERROR",
  FATAL: "FATAL",
  OFF: "OFF"
};
var StateMachineType = {
  EXPRESS: "EXPRESS",
  STANDARD: "STANDARD"
};
var InvalidArn = class _InvalidArn extends SFNServiceException {
  static {
    __name(this, "InvalidArn");
  }
  name = "InvalidArn";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidArn",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidArn.prototype);
  }
};
var InvalidDefinition = class _InvalidDefinition extends SFNServiceException {
  static {
    __name(this, "InvalidDefinition");
  }
  name = "InvalidDefinition";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDefinition",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDefinition.prototype);
  }
};
var InvalidLoggingConfiguration = class _InvalidLoggingConfiguration extends SFNServiceException {
  static {
    __name(this, "InvalidLoggingConfiguration");
  }
  name = "InvalidLoggingConfiguration";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidLoggingConfiguration",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidLoggingConfiguration.prototype);
  }
};
var InvalidTracingConfiguration = class _InvalidTracingConfiguration extends SFNServiceException {
  static {
    __name(this, "InvalidTracingConfiguration");
  }
  name = "InvalidTracingConfiguration";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTracingConfiguration",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTracingConfiguration.prototype);
  }
};
var StateMachineAlreadyExists = class _StateMachineAlreadyExists extends SFNServiceException {
  static {
    __name(this, "StateMachineAlreadyExists");
  }
  name = "StateMachineAlreadyExists";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StateMachineAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StateMachineAlreadyExists.prototype);
  }
};
var StateMachineDeleting = class _StateMachineDeleting extends SFNServiceException {
  static {
    __name(this, "StateMachineDeleting");
  }
  name = "StateMachineDeleting";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StateMachineDeleting",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StateMachineDeleting.prototype);
  }
};
var StateMachineLimitExceeded = class _StateMachineLimitExceeded extends SFNServiceException {
  static {
    __name(this, "StateMachineLimitExceeded");
  }
  name = "StateMachineLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StateMachineLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StateMachineLimitExceeded.prototype);
  }
};
var StateMachineTypeNotSupported = class _StateMachineTypeNotSupported extends SFNServiceException {
  static {
    __name(this, "StateMachineTypeNotSupported");
  }
  name = "StateMachineTypeNotSupported";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StateMachineTypeNotSupported",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StateMachineTypeNotSupported.prototype);
  }
};
var ValidationExceptionReason = {
  API_DOES_NOT_SUPPORT_LABELED_ARNS: "API_DOES_NOT_SUPPORT_LABELED_ARNS",
  CANNOT_UPDATE_COMPLETED_MAP_RUN: "CANNOT_UPDATE_COMPLETED_MAP_RUN",
  INVALID_ROUTING_CONFIGURATION: "INVALID_ROUTING_CONFIGURATION",
  MISSING_REQUIRED_PARAMETER: "MISSING_REQUIRED_PARAMETER"
};
var ValidationException = class _ValidationException extends SFNServiceException {
  static {
    __name(this, "ValidationException");
  }
  name = "ValidationException";
  $fault = "client";
  /**
   * <p>The input does not satisfy the constraints specified by an Amazon Web Services service.</p>
   * @public
   */
  reason;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ValidationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ValidationException.prototype);
    this.reason = opts.reason;
  }
};
var ResourceNotFound = class _ResourceNotFound extends SFNServiceException {
  static {
    __name(this, "ResourceNotFound");
  }
  name = "ResourceNotFound";
  $fault = "client";
  resourceName;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFound",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFound.prototype);
    this.resourceName = opts.resourceName;
  }
};
var ServiceQuotaExceededException = class _ServiceQuotaExceededException extends SFNServiceException {
  static {
    __name(this, "ServiceQuotaExceededException");
  }
  name = "ServiceQuotaExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceQuotaExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceQuotaExceededException.prototype);
  }
};
var IncludedData = {
  ALL_DATA: "ALL_DATA",
  METADATA_ONLY: "METADATA_ONLY"
};
var ExecutionRedriveStatus = {
  NOT_REDRIVABLE: "NOT_REDRIVABLE",
  REDRIVABLE: "REDRIVABLE",
  REDRIVABLE_BY_MAP_RUN: "REDRIVABLE_BY_MAP_RUN"
};
var ExecutionStatus = {
  ABORTED: "ABORTED",
  FAILED: "FAILED",
  PENDING_REDRIVE: "PENDING_REDRIVE",
  RUNNING: "RUNNING",
  SUCCEEDED: "SUCCEEDED",
  TIMED_OUT: "TIMED_OUT"
};
var ExecutionDoesNotExist = class _ExecutionDoesNotExist extends SFNServiceException {
  static {
    __name(this, "ExecutionDoesNotExist");
  }
  name = "ExecutionDoesNotExist";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExecutionDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExecutionDoesNotExist.prototype);
  }
};
var KmsKeyState = {
  CREATING: "CREATING",
  DISABLED: "DISABLED",
  PENDING_DELETION: "PENDING_DELETION",
  PENDING_IMPORT: "PENDING_IMPORT",
  UNAVAILABLE: "UNAVAILABLE"
};
var KmsInvalidStateException = class _KmsInvalidStateException extends SFNServiceException {
  static {
    __name(this, "KmsInvalidStateException");
  }
  name = "KmsInvalidStateException";
  $fault = "client";
  /**
   * <p>Current status of the KMS; key. For example: <code>DISABLED</code>, <code>PENDING_DELETION</code>, <code>PENDING_IMPORT</code>, <code>UNAVAILABLE</code>, <code>CREATING</code>.</p>
   * @public
   */
  kmsKeyState;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KmsInvalidStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KmsInvalidStateException.prototype);
    this.kmsKeyState = opts.kmsKeyState;
  }
};
var MapRunStatus = {
  ABORTED: "ABORTED",
  FAILED: "FAILED",
  RUNNING: "RUNNING",
  SUCCEEDED: "SUCCEEDED"
};
var StateMachineStatus = {
  ACTIVE: "ACTIVE",
  DELETING: "DELETING"
};
var StateMachineDoesNotExist = class _StateMachineDoesNotExist extends SFNServiceException {
  static {
    __name(this, "StateMachineDoesNotExist");
  }
  name = "StateMachineDoesNotExist";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StateMachineDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StateMachineDoesNotExist.prototype);
  }
};
var HistoryEventType = {
  ActivityFailed: "ActivityFailed",
  ActivityScheduleFailed: "ActivityScheduleFailed",
  ActivityScheduled: "ActivityScheduled",
  ActivityStarted: "ActivityStarted",
  ActivitySucceeded: "ActivitySucceeded",
  ActivityTimedOut: "ActivityTimedOut",
  ChoiceStateEntered: "ChoiceStateEntered",
  ChoiceStateExited: "ChoiceStateExited",
  EvaluationFailed: "EvaluationFailed",
  ExecutionAborted: "ExecutionAborted",
  ExecutionFailed: "ExecutionFailed",
  ExecutionRedriven: "ExecutionRedriven",
  ExecutionStarted: "ExecutionStarted",
  ExecutionSucceeded: "ExecutionSucceeded",
  ExecutionTimedOut: "ExecutionTimedOut",
  FailStateEntered: "FailStateEntered",
  LambdaFunctionFailed: "LambdaFunctionFailed",
  LambdaFunctionScheduleFailed: "LambdaFunctionScheduleFailed",
  LambdaFunctionScheduled: "LambdaFunctionScheduled",
  LambdaFunctionStartFailed: "LambdaFunctionStartFailed",
  LambdaFunctionStarted: "LambdaFunctionStarted",
  LambdaFunctionSucceeded: "LambdaFunctionSucceeded",
  LambdaFunctionTimedOut: "LambdaFunctionTimedOut",
  MapIterationAborted: "MapIterationAborted",
  MapIterationFailed: "MapIterationFailed",
  MapIterationStarted: "MapIterationStarted",
  MapIterationSucceeded: "MapIterationSucceeded",
  MapRunAborted: "MapRunAborted",
  MapRunFailed: "MapRunFailed",
  MapRunRedriven: "MapRunRedriven",
  MapRunStarted: "MapRunStarted",
  MapRunSucceeded: "MapRunSucceeded",
  MapStateAborted: "MapStateAborted",
  MapStateEntered: "MapStateEntered",
  MapStateExited: "MapStateExited",
  MapStateFailed: "MapStateFailed",
  MapStateStarted: "MapStateStarted",
  MapStateSucceeded: "MapStateSucceeded",
  ParallelStateAborted: "ParallelStateAborted",
  ParallelStateEntered: "ParallelStateEntered",
  ParallelStateExited: "ParallelStateExited",
  ParallelStateFailed: "ParallelStateFailed",
  ParallelStateStarted: "ParallelStateStarted",
  ParallelStateSucceeded: "ParallelStateSucceeded",
  PassStateEntered: "PassStateEntered",
  PassStateExited: "PassStateExited",
  SucceedStateEntered: "SucceedStateEntered",
  SucceedStateExited: "SucceedStateExited",
  TaskFailed: "TaskFailed",
  TaskScheduled: "TaskScheduled",
  TaskStartFailed: "TaskStartFailed",
  TaskStarted: "TaskStarted",
  TaskStateAborted: "TaskStateAborted",
  TaskStateEntered: "TaskStateEntered",
  TaskStateExited: "TaskStateExited",
  TaskSubmitFailed: "TaskSubmitFailed",
  TaskSubmitted: "TaskSubmitted",
  TaskSucceeded: "TaskSucceeded",
  TaskTimedOut: "TaskTimedOut",
  WaitStateAborted: "WaitStateAborted",
  WaitStateEntered: "WaitStateEntered",
  WaitStateExited: "WaitStateExited"
};
var InvalidToken = class _InvalidToken extends SFNServiceException {
  static {
    __name(this, "InvalidToken");
  }
  name = "InvalidToken";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidToken",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidToken.prototype);
  }
};
var ExecutionRedriveFilter = {
  NOT_REDRIVEN: "NOT_REDRIVEN",
  REDRIVEN: "REDRIVEN"
};
var ExecutionLimitExceeded = class _ExecutionLimitExceeded extends SFNServiceException {
  static {
    __name(this, "ExecutionLimitExceeded");
  }
  name = "ExecutionLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExecutionLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExecutionLimitExceeded.prototype);
  }
};
var ExecutionNotRedrivable = class _ExecutionNotRedrivable extends SFNServiceException {
  static {
    __name(this, "ExecutionNotRedrivable");
  }
  name = "ExecutionNotRedrivable";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExecutionNotRedrivable",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExecutionNotRedrivable.prototype);
  }
};
var TaskDoesNotExist = class _TaskDoesNotExist extends SFNServiceException {
  static {
    __name(this, "TaskDoesNotExist");
  }
  name = "TaskDoesNotExist";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TaskDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TaskDoesNotExist.prototype);
  }
};
var TaskTimedOut = class _TaskTimedOut extends SFNServiceException {
  static {
    __name(this, "TaskTimedOut");
  }
  name = "TaskTimedOut";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TaskTimedOut",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TaskTimedOut.prototype);
  }
};
var InvalidOutput = class _InvalidOutput extends SFNServiceException {
  static {
    __name(this, "InvalidOutput");
  }
  name = "InvalidOutput";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOutput",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOutput.prototype);
  }
};
var ExecutionAlreadyExists = class _ExecutionAlreadyExists extends SFNServiceException {
  static {
    __name(this, "ExecutionAlreadyExists");
  }
  name = "ExecutionAlreadyExists";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExecutionAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExecutionAlreadyExists.prototype);
  }
};
var InvalidExecutionInput = class _InvalidExecutionInput extends SFNServiceException {
  static {
    __name(this, "InvalidExecutionInput");
  }
  name = "InvalidExecutionInput";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidExecutionInput",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidExecutionInput.prototype);
  }
};
var SyncExecutionStatus = {
  FAILED: "FAILED",
  SUCCEEDED: "SUCCEEDED",
  TIMED_OUT: "TIMED_OUT"
};
var InspectionLevel = {
  DEBUG: "DEBUG",
  INFO: "INFO",
  TRACE: "TRACE"
};
var TestExecutionStatus = {
  CAUGHT_ERROR: "CAUGHT_ERROR",
  FAILED: "FAILED",
  RETRIABLE: "RETRIABLE",
  SUCCEEDED: "SUCCEEDED"
};
var MissingRequiredParameter = class _MissingRequiredParameter extends SFNServiceException {
  static {
    __name(this, "MissingRequiredParameter");
  }
  name = "MissingRequiredParameter";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MissingRequiredParameter",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MissingRequiredParameter.prototype);
  }
};
var ValidateStateMachineDefinitionSeverity = {
  ERROR: "ERROR",
  WARNING: "WARNING"
};
var ValidateStateMachineDefinitionResultCode = {
  FAIL: "FAIL",
  OK: "OK"
};
var ActivityFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "ActivityFailedEventDetailsFilterSensitiveLog");
var ActivityScheduledEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "ActivityScheduledEventDetailsFilterSensitiveLog");
var ActivityScheduleFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "ActivityScheduleFailedEventDetailsFilterSensitiveLog");
var ActivitySucceededEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "ActivitySucceededEventDetailsFilterSensitiveLog");
var ActivityTimedOutEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "ActivityTimedOutEventDetailsFilterSensitiveLog");
var CreateStateMachineInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.definition && { definition: import_smithy_client.SENSITIVE_STRING },
  ...obj.versionDescription && { versionDescription: import_smithy_client.SENSITIVE_STRING }
}), "CreateStateMachineInputFilterSensitiveLog");
var CreateStateMachineAliasInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.description && { description: import_smithy_client.SENSITIVE_STRING }
}), "CreateStateMachineAliasInputFilterSensitiveLog");
var DescribeExecutionOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING },
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING },
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING },
  ...obj.redriveStatusReason && { redriveStatusReason: import_smithy_client.SENSITIVE_STRING }
}), "DescribeExecutionOutputFilterSensitiveLog");
var DescribeStateMachineOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.definition && { definition: import_smithy_client.SENSITIVE_STRING },
  ...obj.description && { description: import_smithy_client.SENSITIVE_STRING },
  ...obj.variableReferences && { variableReferences: import_smithy_client.SENSITIVE_STRING }
}), "DescribeStateMachineOutputFilterSensitiveLog");
var DescribeStateMachineAliasOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.description && { description: import_smithy_client.SENSITIVE_STRING }
}), "DescribeStateMachineAliasOutputFilterSensitiveLog");
var DescribeStateMachineForExecutionOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.definition && { definition: import_smithy_client.SENSITIVE_STRING },
  ...obj.variableReferences && { variableReferences: import_smithy_client.SENSITIVE_STRING }
}), "DescribeStateMachineForExecutionOutputFilterSensitiveLog");
var GetActivityTaskOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "GetActivityTaskOutputFilterSensitiveLog");
var EvaluationFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING },
  ...obj.location && { location: import_smithy_client.SENSITIVE_STRING }
}), "EvaluationFailedEventDetailsFilterSensitiveLog");
var ExecutionAbortedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "ExecutionAbortedEventDetailsFilterSensitiveLog");
var ExecutionFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "ExecutionFailedEventDetailsFilterSensitiveLog");
var ExecutionStartedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "ExecutionStartedEventDetailsFilterSensitiveLog");
var ExecutionSucceededEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "ExecutionSucceededEventDetailsFilterSensitiveLog");
var ExecutionTimedOutEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "ExecutionTimedOutEventDetailsFilterSensitiveLog");
var LambdaFunctionFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "LambdaFunctionFailedEventDetailsFilterSensitiveLog");
var LambdaFunctionScheduledEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "LambdaFunctionScheduledEventDetailsFilterSensitiveLog");
var LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog");
var LambdaFunctionStartFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "LambdaFunctionStartFailedEventDetailsFilterSensitiveLog");
var LambdaFunctionSucceededEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "LambdaFunctionSucceededEventDetailsFilterSensitiveLog");
var LambdaFunctionTimedOutEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "LambdaFunctionTimedOutEventDetailsFilterSensitiveLog");
var MapRunFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "MapRunFailedEventDetailsFilterSensitiveLog");
var StateEnteredEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "StateEnteredEventDetailsFilterSensitiveLog");
var StateExitedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING },
  ...obj.assignedVariables && { assignedVariables: import_smithy_client.SENSITIVE_STRING }
}), "StateExitedEventDetailsFilterSensitiveLog");
var TaskFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "TaskFailedEventDetailsFilterSensitiveLog");
var TaskScheduledEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.parameters && { parameters: import_smithy_client.SENSITIVE_STRING }
}), "TaskScheduledEventDetailsFilterSensitiveLog");
var TaskStartFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "TaskStartFailedEventDetailsFilterSensitiveLog");
var TaskSubmitFailedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "TaskSubmitFailedEventDetailsFilterSensitiveLog");
var TaskSubmittedEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "TaskSubmittedEventDetailsFilterSensitiveLog");
var TaskSucceededEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "TaskSucceededEventDetailsFilterSensitiveLog");
var TaskTimedOutEventDetailsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "TaskTimedOutEventDetailsFilterSensitiveLog");
var HistoryEventFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.activityFailedEventDetails && {
    activityFailedEventDetails: ActivityFailedEventDetailsFilterSensitiveLog(obj.activityFailedEventDetails)
  },
  ...obj.activityScheduleFailedEventDetails && {
    activityScheduleFailedEventDetails: ActivityScheduleFailedEventDetailsFilterSensitiveLog(
      obj.activityScheduleFailedEventDetails
    )
  },
  ...obj.activityScheduledEventDetails && {
    activityScheduledEventDetails: ActivityScheduledEventDetailsFilterSensitiveLog(obj.activityScheduledEventDetails)
  },
  ...obj.activitySucceededEventDetails && {
    activitySucceededEventDetails: ActivitySucceededEventDetailsFilterSensitiveLog(obj.activitySucceededEventDetails)
  },
  ...obj.activityTimedOutEventDetails && {
    activityTimedOutEventDetails: ActivityTimedOutEventDetailsFilterSensitiveLog(obj.activityTimedOutEventDetails)
  },
  ...obj.taskFailedEventDetails && {
    taskFailedEventDetails: TaskFailedEventDetailsFilterSensitiveLog(obj.taskFailedEventDetails)
  },
  ...obj.taskScheduledEventDetails && {
    taskScheduledEventDetails: TaskScheduledEventDetailsFilterSensitiveLog(obj.taskScheduledEventDetails)
  },
  ...obj.taskStartFailedEventDetails && {
    taskStartFailedEventDetails: TaskStartFailedEventDetailsFilterSensitiveLog(obj.taskStartFailedEventDetails)
  },
  ...obj.taskSubmitFailedEventDetails && {
    taskSubmitFailedEventDetails: TaskSubmitFailedEventDetailsFilterSensitiveLog(obj.taskSubmitFailedEventDetails)
  },
  ...obj.taskSubmittedEventDetails && {
    taskSubmittedEventDetails: TaskSubmittedEventDetailsFilterSensitiveLog(obj.taskSubmittedEventDetails)
  },
  ...obj.taskSucceededEventDetails && {
    taskSucceededEventDetails: TaskSucceededEventDetailsFilterSensitiveLog(obj.taskSucceededEventDetails)
  },
  ...obj.taskTimedOutEventDetails && {
    taskTimedOutEventDetails: TaskTimedOutEventDetailsFilterSensitiveLog(obj.taskTimedOutEventDetails)
  },
  ...obj.executionFailedEventDetails && {
    executionFailedEventDetails: ExecutionFailedEventDetailsFilterSensitiveLog(obj.executionFailedEventDetails)
  },
  ...obj.executionStartedEventDetails && {
    executionStartedEventDetails: ExecutionStartedEventDetailsFilterSensitiveLog(obj.executionStartedEventDetails)
  },
  ...obj.executionSucceededEventDetails && {
    executionSucceededEventDetails: ExecutionSucceededEventDetailsFilterSensitiveLog(
      obj.executionSucceededEventDetails
    )
  },
  ...obj.executionAbortedEventDetails && {
    executionAbortedEventDetails: ExecutionAbortedEventDetailsFilterSensitiveLog(obj.executionAbortedEventDetails)
  },
  ...obj.executionTimedOutEventDetails && {
    executionTimedOutEventDetails: ExecutionTimedOutEventDetailsFilterSensitiveLog(obj.executionTimedOutEventDetails)
  },
  ...obj.lambdaFunctionFailedEventDetails && {
    lambdaFunctionFailedEventDetails: LambdaFunctionFailedEventDetailsFilterSensitiveLog(
      obj.lambdaFunctionFailedEventDetails
    )
  },
  ...obj.lambdaFunctionScheduleFailedEventDetails && {
    lambdaFunctionScheduleFailedEventDetails: LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog(
      obj.lambdaFunctionScheduleFailedEventDetails
    )
  },
  ...obj.lambdaFunctionScheduledEventDetails && {
    lambdaFunctionScheduledEventDetails: LambdaFunctionScheduledEventDetailsFilterSensitiveLog(
      obj.lambdaFunctionScheduledEventDetails
    )
  },
  ...obj.lambdaFunctionStartFailedEventDetails && {
    lambdaFunctionStartFailedEventDetails: LambdaFunctionStartFailedEventDetailsFilterSensitiveLog(
      obj.lambdaFunctionStartFailedEventDetails
    )
  },
  ...obj.lambdaFunctionSucceededEventDetails && {
    lambdaFunctionSucceededEventDetails: LambdaFunctionSucceededEventDetailsFilterSensitiveLog(
      obj.lambdaFunctionSucceededEventDetails
    )
  },
  ...obj.lambdaFunctionTimedOutEventDetails && {
    lambdaFunctionTimedOutEventDetails: LambdaFunctionTimedOutEventDetailsFilterSensitiveLog(
      obj.lambdaFunctionTimedOutEventDetails
    )
  },
  ...obj.stateEnteredEventDetails && {
    stateEnteredEventDetails: StateEnteredEventDetailsFilterSensitiveLog(obj.stateEnteredEventDetails)
  },
  ...obj.stateExitedEventDetails && {
    stateExitedEventDetails: StateExitedEventDetailsFilterSensitiveLog(obj.stateExitedEventDetails)
  },
  ...obj.mapRunFailedEventDetails && {
    mapRunFailedEventDetails: MapRunFailedEventDetailsFilterSensitiveLog(obj.mapRunFailedEventDetails)
  },
  ...obj.evaluationFailedEventDetails && {
    evaluationFailedEventDetails: EvaluationFailedEventDetailsFilterSensitiveLog(obj.evaluationFailedEventDetails)
  }
}), "HistoryEventFilterSensitiveLog");
var GetExecutionHistoryOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.events && { events: obj.events.map((item) => HistoryEventFilterSensitiveLog(item)) }
}), "GetExecutionHistoryOutputFilterSensitiveLog");
var PublishStateMachineVersionInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.description && { description: import_smithy_client.SENSITIVE_STRING }
}), "PublishStateMachineVersionInputFilterSensitiveLog");
var SendTaskFailureInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "SendTaskFailureInputFilterSensitiveLog");
var SendTaskSuccessInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "SendTaskSuccessInputFilterSensitiveLog");
var StartExecutionInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "StartExecutionInputFilterSensitiveLog");
var StartSyncExecutionInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING }
}), "StartSyncExecutionInputFilterSensitiveLog");
var StartSyncExecutionOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING },
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING },
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING }
}), "StartSyncExecutionOutputFilterSensitiveLog");
var StopExecutionInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING }
}), "StopExecutionInputFilterSensitiveLog");
var TestStateInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.definition && { definition: import_smithy_client.SENSITIVE_STRING },
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING },
  ...obj.variables && { variables: import_smithy_client.SENSITIVE_STRING }
}), "TestStateInputFilterSensitiveLog");
var InspectionDataFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.input && { input: import_smithy_client.SENSITIVE_STRING },
  ...obj.afterArguments && { afterArguments: import_smithy_client.SENSITIVE_STRING },
  ...obj.afterInputPath && { afterInputPath: import_smithy_client.SENSITIVE_STRING },
  ...obj.afterParameters && { afterParameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.result && { result: import_smithy_client.SENSITIVE_STRING },
  ...obj.afterResultSelector && { afterResultSelector: import_smithy_client.SENSITIVE_STRING },
  ...obj.afterResultPath && { afterResultPath: import_smithy_client.SENSITIVE_STRING },
  ...obj.variables && { variables: import_smithy_client.SENSITIVE_STRING }
}), "InspectionDataFilterSensitiveLog");
var TestStateOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.output && { output: import_smithy_client.SENSITIVE_STRING },
  ...obj.error && { error: import_smithy_client.SENSITIVE_STRING },
  ...obj.cause && { cause: import_smithy_client.SENSITIVE_STRING },
  ...obj.inspectionData && { inspectionData: import_smithy_client.SENSITIVE_STRING }
}), "TestStateOutputFilterSensitiveLog");
var UpdateStateMachineInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.definition && { definition: import_smithy_client.SENSITIVE_STRING },
  ...obj.versionDescription && { versionDescription: import_smithy_client.SENSITIVE_STRING }
}), "UpdateStateMachineInputFilterSensitiveLog");
var UpdateStateMachineAliasInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.description && { description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateStateMachineAliasInputFilterSensitiveLog");
var ValidateStateMachineDefinitionInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.definition && { definition: import_smithy_client.SENSITIVE_STRING }
}), "ValidateStateMachineDefinitionInputFilterSensitiveLog");
var ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.code && { code: import_smithy_client.SENSITIVE_STRING },
  ...obj.message && { message: import_smithy_client.SENSITIVE_STRING },
  ...obj.location && { location: import_smithy_client.SENSITIVE_STRING }
}), "ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog");
var ValidateStateMachineDefinitionOutputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.diagnostics && {
    diagnostics: obj.diagnostics.map((item) => ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog(item))
  }
}), "ValidateStateMachineDefinitionOutputFilterSensitiveLog");

// src/protocols/Aws_json1_0.ts
var se_CreateActivityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateActivity");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateActivityCommand");
var se_CreateStateMachineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateStateMachine");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateStateMachineCommand");
var se_CreateStateMachineAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateStateMachineAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateStateMachineAliasCommand");
var se_DeleteActivityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteActivity");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteActivityCommand");
var se_DeleteStateMachineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteStateMachine");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteStateMachineCommand");
var se_DeleteStateMachineAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteStateMachineAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteStateMachineAliasCommand");
var se_DeleteStateMachineVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteStateMachineVersion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteStateMachineVersionCommand");
var se_DescribeActivityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeActivity");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeActivityCommand");
var se_DescribeExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeExecutionCommand");
var se_DescribeMapRunCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMapRun");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMapRunCommand");
var se_DescribeStateMachineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeStateMachine");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStateMachineCommand");
var se_DescribeStateMachineAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeStateMachineAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStateMachineAliasCommand");
var se_DescribeStateMachineForExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeStateMachineForExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStateMachineForExecutionCommand");
var se_GetActivityTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetActivityTask");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetActivityTaskCommand");
var se_GetExecutionHistoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetExecutionHistory");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetExecutionHistoryCommand");
var se_ListActivitiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListActivities");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListActivitiesCommand");
var se_ListExecutionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListExecutions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListExecutionsCommand");
var se_ListMapRunsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListMapRuns");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListMapRunsCommand");
var se_ListStateMachineAliasesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListStateMachineAliases");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStateMachineAliasesCommand");
var se_ListStateMachinesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListStateMachines");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStateMachinesCommand");
var se_ListStateMachineVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListStateMachineVersions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStateMachineVersionsCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTagsForResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_PublishStateMachineVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PublishStateMachineVersion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PublishStateMachineVersionCommand");
var se_RedriveExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RedriveExecution");
  let body;
  body = JSON.stringify(se_RedriveExecutionInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RedriveExecutionCommand");
var se_SendTaskFailureCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SendTaskFailure");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SendTaskFailureCommand");
var se_SendTaskHeartbeatCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SendTaskHeartbeat");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SendTaskHeartbeatCommand");
var se_SendTaskSuccessCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SendTaskSuccess");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SendTaskSuccessCommand");
var se_StartExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartExecutionCommand");
var se_StartSyncExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartSyncExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  let { hostname: resolvedHostname } = await context.endpoint();
  if (context.disableHostPrefix !== true) {
    resolvedHostname = "sync-" + resolvedHostname;
    if (!(0, import_protocol_http.isValidHostname)(resolvedHostname)) {
      throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
    }
  }
  return buildHttpRpcRequest(context, headers, "/", resolvedHostname, body);
}, "se_StartSyncExecutionCommand");
var se_StopExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StopExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopExecutionCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_TestStateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TestState");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  let { hostname: resolvedHostname } = await context.endpoint();
  if (context.disableHostPrefix !== true) {
    resolvedHostname = "sync-" + resolvedHostname;
    if (!(0, import_protocol_http.isValidHostname)(resolvedHostname)) {
      throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
    }
  }
  return buildHttpRpcRequest(context, headers, "/", resolvedHostname, body);
}, "se_TestStateCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UntagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_UpdateMapRunCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateMapRun");
  let body;
  body = JSON.stringify(se_UpdateMapRunInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateMapRunCommand");
var se_UpdateStateMachineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateStateMachine");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateStateMachineCommand");
var se_UpdateStateMachineAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateStateMachineAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateStateMachineAliasCommand");
var se_ValidateStateMachineDefinitionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ValidateStateMachineDefinition");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ValidateStateMachineDefinitionCommand");
var de_CreateActivityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateActivityOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateActivityCommand");
var de_CreateStateMachineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateStateMachineOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateStateMachineCommand");
var de_CreateStateMachineAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateStateMachineAliasOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateStateMachineAliasCommand");
var de_DeleteActivityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteActivityCommand");
var de_DeleteStateMachineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteStateMachineCommand");
var de_DeleteStateMachineAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteStateMachineAliasCommand");
var de_DeleteStateMachineVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteStateMachineVersionCommand");
var de_DescribeActivityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeActivityOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeActivityCommand");
var de_DescribeExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeExecutionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeExecutionCommand");
var de_DescribeMapRunCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeMapRunOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMapRunCommand");
var de_DescribeStateMachineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStateMachineOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStateMachineCommand");
var de_DescribeStateMachineAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStateMachineAliasOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStateMachineAliasCommand");
var de_DescribeStateMachineForExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStateMachineForExecutionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStateMachineForExecutionCommand");
var de_GetActivityTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetActivityTaskCommand");
var de_GetExecutionHistoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetExecutionHistoryOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetExecutionHistoryCommand");
var de_ListActivitiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListActivitiesOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListActivitiesCommand");
var de_ListExecutionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListExecutionsOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListExecutionsCommand");
var de_ListMapRunsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListMapRunsOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListMapRunsCommand");
var de_ListStateMachineAliasesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListStateMachineAliasesOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStateMachineAliasesCommand");
var de_ListStateMachinesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListStateMachinesOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStateMachinesCommand");
var de_ListStateMachineVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListStateMachineVersionsOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStateMachineVersionsCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_PublishStateMachineVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_PublishStateMachineVersionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PublishStateMachineVersionCommand");
var de_RedriveExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_RedriveExecutionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RedriveExecutionCommand");
var de_SendTaskFailureCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SendTaskFailureCommand");
var de_SendTaskHeartbeatCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SendTaskHeartbeatCommand");
var de_SendTaskSuccessCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SendTaskSuccessCommand");
var de_StartExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_StartExecutionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartExecutionCommand");
var de_StartSyncExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_StartSyncExecutionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartSyncExecutionCommand");
var de_StopExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_StopExecutionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopExecutionCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TagResourceCommand");
var de_TestStateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TestStateCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UntagResourceCommand");
var de_UpdateMapRunCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateMapRunCommand");
var de_UpdateStateMachineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateStateMachineOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateStateMachineCommand");
var de_UpdateStateMachineAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateStateMachineAliasOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateStateMachineAliasCommand");
var de_ValidateStateMachineDefinitionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ValidateStateMachineDefinitionCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "ActivityAlreadyExists":
    case "com.amazonaws.sfn#ActivityAlreadyExists":
      throw await de_ActivityAlreadyExistsRes(parsedOutput, context);
    case "ActivityLimitExceeded":
    case "com.amazonaws.sfn#ActivityLimitExceeded":
      throw await de_ActivityLimitExceededRes(parsedOutput, context);
    case "InvalidEncryptionConfiguration":
    case "com.amazonaws.sfn#InvalidEncryptionConfiguration":
      throw await de_InvalidEncryptionConfigurationRes(parsedOutput, context);
    case "InvalidName":
    case "com.amazonaws.sfn#InvalidName":
      throw await de_InvalidNameRes(parsedOutput, context);
    case "KmsAccessDeniedException":
    case "com.amazonaws.sfn#KmsAccessDeniedException":
      throw await de_KmsAccessDeniedExceptionRes(parsedOutput, context);
    case "KmsThrottlingException":
    case "com.amazonaws.sfn#KmsThrottlingException":
      throw await de_KmsThrottlingExceptionRes(parsedOutput, context);
    case "TooManyTags":
    case "com.amazonaws.sfn#TooManyTags":
      throw await de_TooManyTagsRes(parsedOutput, context);
    case "ConflictException":
    case "com.amazonaws.sfn#ConflictException":
      throw await de_ConflictExceptionRes(parsedOutput, context);
    case "InvalidArn":
    case "com.amazonaws.sfn#InvalidArn":
      throw await de_InvalidArnRes(parsedOutput, context);
    case "InvalidDefinition":
    case "com.amazonaws.sfn#InvalidDefinition":
      throw await de_InvalidDefinitionRes(parsedOutput, context);
    case "InvalidLoggingConfiguration":
    case "com.amazonaws.sfn#InvalidLoggingConfiguration":
      throw await de_InvalidLoggingConfigurationRes(parsedOutput, context);
    case "InvalidTracingConfiguration":
    case "com.amazonaws.sfn#InvalidTracingConfiguration":
      throw await de_InvalidTracingConfigurationRes(parsedOutput, context);
    case "StateMachineAlreadyExists":
    case "com.amazonaws.sfn#StateMachineAlreadyExists":
      throw await de_StateMachineAlreadyExistsRes(parsedOutput, context);
    case "StateMachineDeleting":
    case "com.amazonaws.sfn#StateMachineDeleting":
      throw await de_StateMachineDeletingRes(parsedOutput, context);
    case "StateMachineLimitExceeded":
    case "com.amazonaws.sfn#StateMachineLimitExceeded":
      throw await de_StateMachineLimitExceededRes(parsedOutput, context);
    case "StateMachineTypeNotSupported":
    case "com.amazonaws.sfn#StateMachineTypeNotSupported":
      throw await de_StateMachineTypeNotSupportedRes(parsedOutput, context);
    case "ValidationException":
    case "com.amazonaws.sfn#ValidationException":
      throw await de_ValidationExceptionRes(parsedOutput, context);
    case "ResourceNotFound":
    case "com.amazonaws.sfn#ResourceNotFound":
      throw await de_ResourceNotFoundRes(parsedOutput, context);
    case "ServiceQuotaExceededException":
    case "com.amazonaws.sfn#ServiceQuotaExceededException":
      throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
    case "ActivityDoesNotExist":
    case "com.amazonaws.sfn#ActivityDoesNotExist":
      throw await de_ActivityDoesNotExistRes(parsedOutput, context);
    case "ExecutionDoesNotExist":
    case "com.amazonaws.sfn#ExecutionDoesNotExist":
      throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
    case "KmsInvalidStateException":
    case "com.amazonaws.sfn#KmsInvalidStateException":
      throw await de_KmsInvalidStateExceptionRes(parsedOutput, context);
    case "StateMachineDoesNotExist":
    case "com.amazonaws.sfn#StateMachineDoesNotExist":
      throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
    case "ActivityWorkerLimitExceeded":
    case "com.amazonaws.sfn#ActivityWorkerLimitExceeded":
      throw await de_ActivityWorkerLimitExceededRes(parsedOutput, context);
    case "InvalidToken":
    case "com.amazonaws.sfn#InvalidToken":
      throw await de_InvalidTokenRes(parsedOutput, context);
    case "ExecutionLimitExceeded":
    case "com.amazonaws.sfn#ExecutionLimitExceeded":
      throw await de_ExecutionLimitExceededRes(parsedOutput, context);
    case "ExecutionNotRedrivable":
    case "com.amazonaws.sfn#ExecutionNotRedrivable":
      throw await de_ExecutionNotRedrivableRes(parsedOutput, context);
    case "TaskDoesNotExist":
    case "com.amazonaws.sfn#TaskDoesNotExist":
      throw await de_TaskDoesNotExistRes(parsedOutput, context);
    case "TaskTimedOut":
    case "com.amazonaws.sfn#TaskTimedOut":
      throw await de_TaskTimedOutRes(parsedOutput, context);
    case "InvalidOutput":
    case "com.amazonaws.sfn#InvalidOutput":
      throw await de_InvalidOutputRes(parsedOutput, context);
    case "ExecutionAlreadyExists":
    case "com.amazonaws.sfn#ExecutionAlreadyExists":
      throw await de_ExecutionAlreadyExistsRes(parsedOutput, context);
    case "InvalidExecutionInput":
    case "com.amazonaws.sfn#InvalidExecutionInput":
      throw await de_InvalidExecutionInputRes(parsedOutput, context);
    case "MissingRequiredParameter":
    case "com.amazonaws.sfn#MissingRequiredParameter":
      throw await de_MissingRequiredParameterRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_ActivityAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ActivityAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ActivityAlreadyExistsRes");
var de_ActivityDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ActivityDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ActivityDoesNotExistRes");
var de_ActivityLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ActivityLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ActivityLimitExceededRes");
var de_ActivityWorkerLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ActivityWorkerLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ActivityWorkerLimitExceededRes");
var de_ConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConflictExceptionRes");
var de_ExecutionAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ExecutionAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExecutionAlreadyExistsRes");
var de_ExecutionDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ExecutionDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExecutionDoesNotExistRes");
var de_ExecutionLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ExecutionLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExecutionLimitExceededRes");
var de_ExecutionNotRedrivableRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ExecutionNotRedrivable({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExecutionNotRedrivableRes");
var de_InvalidArnRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidArn({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidArnRes");
var de_InvalidDefinitionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDefinition({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDefinitionRes");
var de_InvalidEncryptionConfigurationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidEncryptionConfiguration({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidEncryptionConfigurationRes");
var de_InvalidExecutionInputRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidExecutionInput({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidExecutionInputRes");
var de_InvalidLoggingConfigurationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidLoggingConfiguration({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidLoggingConfigurationRes");
var de_InvalidNameRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidName({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidNameRes");
var de_InvalidOutputRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidOutput({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOutputRes");
var de_InvalidTokenRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidToken({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTokenRes");
var de_InvalidTracingConfigurationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTracingConfiguration({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTracingConfigurationRes");
var de_KmsAccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KmsAccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KmsAccessDeniedExceptionRes");
var de_KmsInvalidStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KmsInvalidStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KmsInvalidStateExceptionRes");
var de_KmsThrottlingExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KmsThrottlingException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KmsThrottlingExceptionRes");
var de_MissingRequiredParameterRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MissingRequiredParameter({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MissingRequiredParameterRes");
var de_ResourceNotFoundRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceNotFound({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundRes");
var de_ServiceQuotaExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceQuotaExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceQuotaExceededExceptionRes");
var de_StateMachineAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new StateMachineAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StateMachineAlreadyExistsRes");
var de_StateMachineDeletingRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new StateMachineDeleting({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StateMachineDeletingRes");
var de_StateMachineDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new StateMachineDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StateMachineDoesNotExistRes");
var de_StateMachineLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new StateMachineLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StateMachineLimitExceededRes");
var de_StateMachineTypeNotSupportedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new StateMachineTypeNotSupported({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StateMachineTypeNotSupportedRes");
var de_TaskDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TaskDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TaskDoesNotExistRes");
var de_TaskTimedOutRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TaskTimedOut({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TaskTimedOutRes");
var de_TooManyTagsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TooManyTags({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TooManyTagsRes");
var de_ValidationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ValidationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ValidationExceptionRes");
var se_RedriveExecutionInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    clientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    executionArn: []
  });
}, "se_RedriveExecutionInput");
var se_UpdateMapRunInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    mapRunArn: [],
    maxConcurrency: [],
    toleratedFailureCount: [],
    toleratedFailurePercentage: import_smithy_client.serializeFloat
  });
}, "se_UpdateMapRunInput");
var de_ActivityList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ActivityListItem(entry, context);
  });
  return retVal;
}, "de_ActivityList");
var de_ActivityListItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    activityArn: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    name: import_smithy_client.expectString
  });
}, "de_ActivityListItem");
var de_CreateActivityOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    activityArn: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate")
  });
}, "de_CreateActivityOutput");
var de_CreateStateMachineAliasOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    stateMachineAliasArn: import_smithy_client.expectString
  });
}, "de_CreateStateMachineAliasOutput");
var de_CreateStateMachineOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    stateMachineArn: import_smithy_client.expectString,
    stateMachineVersionArn: import_smithy_client.expectString
  });
}, "de_CreateStateMachineOutput");
var de_DescribeActivityOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    activityArn: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    encryptionConfiguration: import_smithy_client._json,
    name: import_smithy_client.expectString
  });
}, "de_DescribeActivityOutput");
var de_DescribeExecutionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    cause: import_smithy_client.expectString,
    error: import_smithy_client.expectString,
    executionArn: import_smithy_client.expectString,
    input: import_smithy_client.expectString,
    inputDetails: import_smithy_client._json,
    mapRunArn: import_smithy_client.expectString,
    name: import_smithy_client.expectString,
    output: import_smithy_client.expectString,
    outputDetails: import_smithy_client._json,
    redriveCount: import_smithy_client.expectInt32,
    redriveDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "redriveDate"),
    redriveStatus: import_smithy_client.expectString,
    redriveStatusReason: import_smithy_client.expectString,
    startDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startDate"),
    stateMachineAliasArn: import_smithy_client.expectString,
    stateMachineArn: import_smithy_client.expectString,
    stateMachineVersionArn: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    stopDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stopDate"),
    traceHeader: import_smithy_client.expectString
  });
}, "de_DescribeExecutionOutput");
var de_DescribeMapRunOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    executionArn: import_smithy_client.expectString,
    executionCounts: import_smithy_client._json,
    itemCounts: import_smithy_client._json,
    mapRunArn: import_smithy_client.expectString,
    maxConcurrency: import_smithy_client.expectInt32,
    redriveCount: import_smithy_client.expectInt32,
    redriveDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "redriveDate"),
    startDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startDate"),
    status: import_smithy_client.expectString,
    stopDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stopDate"),
    toleratedFailureCount: import_smithy_client.expectLong,
    toleratedFailurePercentage: import_smithy_client.limitedParseFloat32
  });
}, "de_DescribeMapRunOutput");
var de_DescribeStateMachineAliasOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    description: import_smithy_client.expectString,
    name: import_smithy_client.expectString,
    routingConfiguration: import_smithy_client._json,
    stateMachineAliasArn: import_smithy_client.expectString,
    updateDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updateDate")
  });
}, "de_DescribeStateMachineAliasOutput");
var de_DescribeStateMachineForExecutionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    definition: import_smithy_client.expectString,
    encryptionConfiguration: import_smithy_client._json,
    label: import_smithy_client.expectString,
    loggingConfiguration: import_smithy_client._json,
    mapRunArn: import_smithy_client.expectString,
    name: import_smithy_client.expectString,
    revisionId: import_smithy_client.expectString,
    roleArn: import_smithy_client.expectString,
    stateMachineArn: import_smithy_client.expectString,
    tracingConfiguration: import_smithy_client._json,
    updateDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updateDate"),
    variableReferences: import_smithy_client._json
  });
}, "de_DescribeStateMachineForExecutionOutput");
var de_DescribeStateMachineOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    definition: import_smithy_client.expectString,
    description: import_smithy_client.expectString,
    encryptionConfiguration: import_smithy_client._json,
    label: import_smithy_client.expectString,
    loggingConfiguration: import_smithy_client._json,
    name: import_smithy_client.expectString,
    revisionId: import_smithy_client.expectString,
    roleArn: import_smithy_client.expectString,
    stateMachineArn: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    tracingConfiguration: import_smithy_client._json,
    type: import_smithy_client.expectString,
    variableReferences: import_smithy_client._json
  });
}, "de_DescribeStateMachineOutput");
var de_ExecutionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ExecutionListItem(entry, context);
  });
  return retVal;
}, "de_ExecutionList");
var de_ExecutionListItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    executionArn: import_smithy_client.expectString,
    itemCount: import_smithy_client.expectInt32,
    mapRunArn: import_smithy_client.expectString,
    name: import_smithy_client.expectString,
    redriveCount: import_smithy_client.expectInt32,
    redriveDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "redriveDate"),
    startDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startDate"),
    stateMachineAliasArn: import_smithy_client.expectString,
    stateMachineArn: import_smithy_client.expectString,
    stateMachineVersionArn: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    stopDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stopDate")
  });
}, "de_ExecutionListItem");
var de_GetExecutionHistoryOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    events: /* @__PURE__ */ __name((_) => de_HistoryEventList(_, context), "events"),
    nextToken: import_smithy_client.expectString
  });
}, "de_GetExecutionHistoryOutput");
var de_HistoryEvent = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    activityFailedEventDetails: import_smithy_client._json,
    activityScheduleFailedEventDetails: import_smithy_client._json,
    activityScheduledEventDetails: import_smithy_client._json,
    activityStartedEventDetails: import_smithy_client._json,
    activitySucceededEventDetails: import_smithy_client._json,
    activityTimedOutEventDetails: import_smithy_client._json,
    evaluationFailedEventDetails: import_smithy_client._json,
    executionAbortedEventDetails: import_smithy_client._json,
    executionFailedEventDetails: import_smithy_client._json,
    executionRedrivenEventDetails: import_smithy_client._json,
    executionStartedEventDetails: import_smithy_client._json,
    executionSucceededEventDetails: import_smithy_client._json,
    executionTimedOutEventDetails: import_smithy_client._json,
    id: import_smithy_client.expectLong,
    lambdaFunctionFailedEventDetails: import_smithy_client._json,
    lambdaFunctionScheduleFailedEventDetails: import_smithy_client._json,
    lambdaFunctionScheduledEventDetails: import_smithy_client._json,
    lambdaFunctionStartFailedEventDetails: import_smithy_client._json,
    lambdaFunctionSucceededEventDetails: import_smithy_client._json,
    lambdaFunctionTimedOutEventDetails: import_smithy_client._json,
    mapIterationAbortedEventDetails: import_smithy_client._json,
    mapIterationFailedEventDetails: import_smithy_client._json,
    mapIterationStartedEventDetails: import_smithy_client._json,
    mapIterationSucceededEventDetails: import_smithy_client._json,
    mapRunFailedEventDetails: import_smithy_client._json,
    mapRunRedrivenEventDetails: import_smithy_client._json,
    mapRunStartedEventDetails: import_smithy_client._json,
    mapStateStartedEventDetails: import_smithy_client._json,
    previousEventId: import_smithy_client.expectLong,
    stateEnteredEventDetails: import_smithy_client._json,
    stateExitedEventDetails: import_smithy_client._json,
    taskFailedEventDetails: import_smithy_client._json,
    taskScheduledEventDetails: import_smithy_client._json,
    taskStartFailedEventDetails: import_smithy_client._json,
    taskStartedEventDetails: import_smithy_client._json,
    taskSubmitFailedEventDetails: import_smithy_client._json,
    taskSubmittedEventDetails: import_smithy_client._json,
    taskSucceededEventDetails: import_smithy_client._json,
    taskTimedOutEventDetails: import_smithy_client._json,
    timestamp: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "timestamp"),
    type: import_smithy_client.expectString
  });
}, "de_HistoryEvent");
var de_HistoryEventList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_HistoryEvent(entry, context);
  });
  return retVal;
}, "de_HistoryEventList");
var de_ListActivitiesOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    activities: /* @__PURE__ */ __name((_) => de_ActivityList(_, context), "activities"),
    nextToken: import_smithy_client.expectString
  });
}, "de_ListActivitiesOutput");
var de_ListExecutionsOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    executions: /* @__PURE__ */ __name((_) => de_ExecutionList(_, context), "executions"),
    nextToken: import_smithy_client.expectString
  });
}, "de_ListExecutionsOutput");
var de_ListMapRunsOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    mapRuns: /* @__PURE__ */ __name((_) => de_MapRunList(_, context), "mapRuns"),
    nextToken: import_smithy_client.expectString
  });
}, "de_ListMapRunsOutput");
var de_ListStateMachineAliasesOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    nextToken: import_smithy_client.expectString,
    stateMachineAliases: /* @__PURE__ */ __name((_) => de_StateMachineAliasList(_, context), "stateMachineAliases")
  });
}, "de_ListStateMachineAliasesOutput");
var de_ListStateMachinesOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    nextToken: import_smithy_client.expectString,
    stateMachines: /* @__PURE__ */ __name((_) => de_StateMachineList(_, context), "stateMachines")
  });
}, "de_ListStateMachinesOutput");
var de_ListStateMachineVersionsOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    nextToken: import_smithy_client.expectString,
    stateMachineVersions: /* @__PURE__ */ __name((_) => de_StateMachineVersionList(_, context), "stateMachineVersions")
  });
}, "de_ListStateMachineVersionsOutput");
var de_MapRunList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_MapRunListItem(entry, context);
  });
  return retVal;
}, "de_MapRunList");
var de_MapRunListItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    executionArn: import_smithy_client.expectString,
    mapRunArn: import_smithy_client.expectString,
    startDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startDate"),
    stateMachineArn: import_smithy_client.expectString,
    stopDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stopDate")
  });
}, "de_MapRunListItem");
var de_PublishStateMachineVersionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    stateMachineVersionArn: import_smithy_client.expectString
  });
}, "de_PublishStateMachineVersionOutput");
var de_RedriveExecutionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    redriveDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "redriveDate")
  });
}, "de_RedriveExecutionOutput");
var de_StartExecutionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    executionArn: import_smithy_client.expectString,
    startDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startDate")
  });
}, "de_StartExecutionOutput");
var de_StartSyncExecutionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    billingDetails: import_smithy_client._json,
    cause: import_smithy_client.expectString,
    error: import_smithy_client.expectString,
    executionArn: import_smithy_client.expectString,
    input: import_smithy_client.expectString,
    inputDetails: import_smithy_client._json,
    name: import_smithy_client.expectString,
    output: import_smithy_client.expectString,
    outputDetails: import_smithy_client._json,
    startDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startDate"),
    stateMachineArn: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    stopDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stopDate"),
    traceHeader: import_smithy_client.expectString
  });
}, "de_StartSyncExecutionOutput");
var de_StateMachineAliasList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_StateMachineAliasListItem(entry, context);
  });
  return retVal;
}, "de_StateMachineAliasList");
var de_StateMachineAliasListItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    stateMachineAliasArn: import_smithy_client.expectString
  });
}, "de_StateMachineAliasListItem");
var de_StateMachineList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_StateMachineListItem(entry, context);
  });
  return retVal;
}, "de_StateMachineList");
var de_StateMachineListItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    name: import_smithy_client.expectString,
    stateMachineArn: import_smithy_client.expectString,
    type: import_smithy_client.expectString
  });
}, "de_StateMachineListItem");
var de_StateMachineVersionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_StateMachineVersionListItem(entry, context);
  });
  return retVal;
}, "de_StateMachineVersionList");
var de_StateMachineVersionListItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    stateMachineVersionArn: import_smithy_client.expectString
  });
}, "de_StateMachineVersionListItem");
var de_StopExecutionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    stopDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stopDate")
  });
}, "de_StopExecutionOutput");
var de_UpdateStateMachineAliasOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    updateDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updateDate")
  });
}, "de_UpdateStateMachineAliasOutput");
var de_UpdateStateMachineOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    revisionId: import_smithy_client.expectString,
    stateMachineVersionArn: import_smithy_client.expectString,
    updateDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updateDate")
  });
}, "de_UpdateStateMachineOutput");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(SFNServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.0",
    "x-amz-target": `AWSStepFunctions.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/CreateActivityCommand.ts
var CreateActivityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "CreateActivity", {}).n("SFNClient", "CreateActivityCommand").f(void 0, void 0).ser(se_CreateActivityCommand).de(de_CreateActivityCommand).build() {
  static {
    __name(this, "CreateActivityCommand");
  }
};

// src/commands/CreateStateMachineAliasCommand.ts



var CreateStateMachineAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "CreateStateMachineAlias", {}).n("SFNClient", "CreateStateMachineAliasCommand").f(CreateStateMachineAliasInputFilterSensitiveLog, void 0).ser(se_CreateStateMachineAliasCommand).de(de_CreateStateMachineAliasCommand).build() {
  static {
    __name(this, "CreateStateMachineAliasCommand");
  }
};

// src/commands/CreateStateMachineCommand.ts



var CreateStateMachineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "CreateStateMachine", {}).n("SFNClient", "CreateStateMachineCommand").f(CreateStateMachineInputFilterSensitiveLog, void 0).ser(se_CreateStateMachineCommand).de(de_CreateStateMachineCommand).build() {
  static {
    __name(this, "CreateStateMachineCommand");
  }
};

// src/commands/DeleteActivityCommand.ts



var DeleteActivityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DeleteActivity", {}).n("SFNClient", "DeleteActivityCommand").f(void 0, void 0).ser(se_DeleteActivityCommand).de(de_DeleteActivityCommand).build() {
  static {
    __name(this, "DeleteActivityCommand");
  }
};

// src/commands/DeleteStateMachineAliasCommand.ts



var DeleteStateMachineAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DeleteStateMachineAlias", {}).n("SFNClient", "DeleteStateMachineAliasCommand").f(void 0, void 0).ser(se_DeleteStateMachineAliasCommand).de(de_DeleteStateMachineAliasCommand).build() {
  static {
    __name(this, "DeleteStateMachineAliasCommand");
  }
};

// src/commands/DeleteStateMachineCommand.ts



var DeleteStateMachineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DeleteStateMachine", {}).n("SFNClient", "DeleteStateMachineCommand").f(void 0, void 0).ser(se_DeleteStateMachineCommand).de(de_DeleteStateMachineCommand).build() {
  static {
    __name(this, "DeleteStateMachineCommand");
  }
};

// src/commands/DeleteStateMachineVersionCommand.ts



var DeleteStateMachineVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DeleteStateMachineVersion", {}).n("SFNClient", "DeleteStateMachineVersionCommand").f(void 0, void 0).ser(se_DeleteStateMachineVersionCommand).de(de_DeleteStateMachineVersionCommand).build() {
  static {
    __name(this, "DeleteStateMachineVersionCommand");
  }
};

// src/commands/DescribeActivityCommand.ts



var DescribeActivityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DescribeActivity", {}).n("SFNClient", "DescribeActivityCommand").f(void 0, void 0).ser(se_DescribeActivityCommand).de(de_DescribeActivityCommand).build() {
  static {
    __name(this, "DescribeActivityCommand");
  }
};

// src/commands/DescribeExecutionCommand.ts



var DescribeExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DescribeExecution", {}).n("SFNClient", "DescribeExecutionCommand").f(void 0, DescribeExecutionOutputFilterSensitiveLog).ser(se_DescribeExecutionCommand).de(de_DescribeExecutionCommand).build() {
  static {
    __name(this, "DescribeExecutionCommand");
  }
};

// src/commands/DescribeMapRunCommand.ts



var DescribeMapRunCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DescribeMapRun", {}).n("SFNClient", "DescribeMapRunCommand").f(void 0, void 0).ser(se_DescribeMapRunCommand).de(de_DescribeMapRunCommand).build() {
  static {
    __name(this, "DescribeMapRunCommand");
  }
};

// src/commands/DescribeStateMachineAliasCommand.ts



var DescribeStateMachineAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DescribeStateMachineAlias", {}).n("SFNClient", "DescribeStateMachineAliasCommand").f(void 0, DescribeStateMachineAliasOutputFilterSensitiveLog).ser(se_DescribeStateMachineAliasCommand).de(de_DescribeStateMachineAliasCommand).build() {
  static {
    __name(this, "DescribeStateMachineAliasCommand");
  }
};

// src/commands/DescribeStateMachineCommand.ts



var DescribeStateMachineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DescribeStateMachine", {}).n("SFNClient", "DescribeStateMachineCommand").f(void 0, DescribeStateMachineOutputFilterSensitiveLog).ser(se_DescribeStateMachineCommand).de(de_DescribeStateMachineCommand).build() {
  static {
    __name(this, "DescribeStateMachineCommand");
  }
};

// src/commands/DescribeStateMachineForExecutionCommand.ts



var DescribeStateMachineForExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "DescribeStateMachineForExecution", {}).n("SFNClient", "DescribeStateMachineForExecutionCommand").f(void 0, DescribeStateMachineForExecutionOutputFilterSensitiveLog).ser(se_DescribeStateMachineForExecutionCommand).de(de_DescribeStateMachineForExecutionCommand).build() {
  static {
    __name(this, "DescribeStateMachineForExecutionCommand");
  }
};

// src/commands/GetActivityTaskCommand.ts



var GetActivityTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "GetActivityTask", {}).n("SFNClient", "GetActivityTaskCommand").f(void 0, GetActivityTaskOutputFilterSensitiveLog).ser(se_GetActivityTaskCommand).de(de_GetActivityTaskCommand).build() {
  static {
    __name(this, "GetActivityTaskCommand");
  }
};

// src/commands/GetExecutionHistoryCommand.ts



var GetExecutionHistoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "GetExecutionHistory", {}).n("SFNClient", "GetExecutionHistoryCommand").f(void 0, GetExecutionHistoryOutputFilterSensitiveLog).ser(se_GetExecutionHistoryCommand).de(de_GetExecutionHistoryCommand).build() {
  static {
    __name(this, "GetExecutionHistoryCommand");
  }
};

// src/commands/ListActivitiesCommand.ts



var ListActivitiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListActivities", {}).n("SFNClient", "ListActivitiesCommand").f(void 0, void 0).ser(se_ListActivitiesCommand).de(de_ListActivitiesCommand).build() {
  static {
    __name(this, "ListActivitiesCommand");
  }
};

// src/commands/ListExecutionsCommand.ts



var ListExecutionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListExecutions", {}).n("SFNClient", "ListExecutionsCommand").f(void 0, void 0).ser(se_ListExecutionsCommand).de(de_ListExecutionsCommand).build() {
  static {
    __name(this, "ListExecutionsCommand");
  }
};

// src/commands/ListMapRunsCommand.ts



var ListMapRunsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListMapRuns", {}).n("SFNClient", "ListMapRunsCommand").f(void 0, void 0).ser(se_ListMapRunsCommand).de(de_ListMapRunsCommand).build() {
  static {
    __name(this, "ListMapRunsCommand");
  }
};

// src/commands/ListStateMachineAliasesCommand.ts



var ListStateMachineAliasesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListStateMachineAliases", {}).n("SFNClient", "ListStateMachineAliasesCommand").f(void 0, void 0).ser(se_ListStateMachineAliasesCommand).de(de_ListStateMachineAliasesCommand).build() {
  static {
    __name(this, "ListStateMachineAliasesCommand");
  }
};

// src/commands/ListStateMachinesCommand.ts



var ListStateMachinesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListStateMachines", {}).n("SFNClient", "ListStateMachinesCommand").f(void 0, void 0).ser(se_ListStateMachinesCommand).de(de_ListStateMachinesCommand).build() {
  static {
    __name(this, "ListStateMachinesCommand");
  }
};

// src/commands/ListStateMachineVersionsCommand.ts



var ListStateMachineVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListStateMachineVersions", {}).n("SFNClient", "ListStateMachineVersionsCommand").f(void 0, void 0).ser(se_ListStateMachineVersionsCommand).de(de_ListStateMachineVersionsCommand).build() {
  static {
    __name(this, "ListStateMachineVersionsCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ListTagsForResource", {}).n("SFNClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/PublishStateMachineVersionCommand.ts



var PublishStateMachineVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "PublishStateMachineVersion", {}).n("SFNClient", "PublishStateMachineVersionCommand").f(PublishStateMachineVersionInputFilterSensitiveLog, void 0).ser(se_PublishStateMachineVersionCommand).de(de_PublishStateMachineVersionCommand).build() {
  static {
    __name(this, "PublishStateMachineVersionCommand");
  }
};

// src/commands/RedriveExecutionCommand.ts



var RedriveExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "RedriveExecution", {}).n("SFNClient", "RedriveExecutionCommand").f(void 0, void 0).ser(se_RedriveExecutionCommand).de(de_RedriveExecutionCommand).build() {
  static {
    __name(this, "RedriveExecutionCommand");
  }
};

// src/commands/SendTaskFailureCommand.ts



var SendTaskFailureCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "SendTaskFailure", {}).n("SFNClient", "SendTaskFailureCommand").f(SendTaskFailureInputFilterSensitiveLog, void 0).ser(se_SendTaskFailureCommand).de(de_SendTaskFailureCommand).build() {
  static {
    __name(this, "SendTaskFailureCommand");
  }
};

// src/commands/SendTaskHeartbeatCommand.ts



var SendTaskHeartbeatCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "SendTaskHeartbeat", {}).n("SFNClient", "SendTaskHeartbeatCommand").f(void 0, void 0).ser(se_SendTaskHeartbeatCommand).de(de_SendTaskHeartbeatCommand).build() {
  static {
    __name(this, "SendTaskHeartbeatCommand");
  }
};

// src/commands/SendTaskSuccessCommand.ts



var SendTaskSuccessCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "SendTaskSuccess", {}).n("SFNClient", "SendTaskSuccessCommand").f(SendTaskSuccessInputFilterSensitiveLog, void 0).ser(se_SendTaskSuccessCommand).de(de_SendTaskSuccessCommand).build() {
  static {
    __name(this, "SendTaskSuccessCommand");
  }
};

// src/commands/StartExecutionCommand.ts



var StartExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "StartExecution", {}).n("SFNClient", "StartExecutionCommand").f(StartExecutionInputFilterSensitiveLog, void 0).ser(se_StartExecutionCommand).de(de_StartExecutionCommand).build() {
  static {
    __name(this, "StartExecutionCommand");
  }
};

// src/commands/StartSyncExecutionCommand.ts



var StartSyncExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "StartSyncExecution", {}).n("SFNClient", "StartSyncExecutionCommand").f(StartSyncExecutionInputFilterSensitiveLog, StartSyncExecutionOutputFilterSensitiveLog).ser(se_StartSyncExecutionCommand).de(de_StartSyncExecutionCommand).build() {
  static {
    __name(this, "StartSyncExecutionCommand");
  }
};

// src/commands/StopExecutionCommand.ts



var StopExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "StopExecution", {}).n("SFNClient", "StopExecutionCommand").f(StopExecutionInputFilterSensitiveLog, void 0).ser(se_StopExecutionCommand).de(de_StopExecutionCommand).build() {
  static {
    __name(this, "StopExecutionCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "TagResource", {}).n("SFNClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/TestStateCommand.ts



var TestStateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "TestState", {}).n("SFNClient", "TestStateCommand").f(TestStateInputFilterSensitiveLog, TestStateOutputFilterSensitiveLog).ser(se_TestStateCommand).de(de_TestStateCommand).build() {
  static {
    __name(this, "TestStateCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "UntagResource", {}).n("SFNClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateMapRunCommand.ts



var UpdateMapRunCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "UpdateMapRun", {}).n("SFNClient", "UpdateMapRunCommand").f(void 0, void 0).ser(se_UpdateMapRunCommand).de(de_UpdateMapRunCommand).build() {
  static {
    __name(this, "UpdateMapRunCommand");
  }
};

// src/commands/UpdateStateMachineAliasCommand.ts



var UpdateStateMachineAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "UpdateStateMachineAlias", {}).n("SFNClient", "UpdateStateMachineAliasCommand").f(UpdateStateMachineAliasInputFilterSensitiveLog, void 0).ser(se_UpdateStateMachineAliasCommand).de(de_UpdateStateMachineAliasCommand).build() {
  static {
    __name(this, "UpdateStateMachineAliasCommand");
  }
};

// src/commands/UpdateStateMachineCommand.ts



var UpdateStateMachineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "UpdateStateMachine", {}).n("SFNClient", "UpdateStateMachineCommand").f(UpdateStateMachineInputFilterSensitiveLog, void 0).ser(se_UpdateStateMachineCommand).de(de_UpdateStateMachineCommand).build() {
  static {
    __name(this, "UpdateStateMachineCommand");
  }
};

// src/commands/ValidateStateMachineDefinitionCommand.ts



var ValidateStateMachineDefinitionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSStepFunctions", "ValidateStateMachineDefinition", {}).n("SFNClient", "ValidateStateMachineDefinitionCommand").f(ValidateStateMachineDefinitionInputFilterSensitiveLog, ValidateStateMachineDefinitionOutputFilterSensitiveLog).ser(se_ValidateStateMachineDefinitionCommand).de(de_ValidateStateMachineDefinitionCommand).build() {
  static {
    __name(this, "ValidateStateMachineDefinitionCommand");
  }
};

// src/SFN.ts
var commands = {
  CreateActivityCommand,
  CreateStateMachineCommand,
  CreateStateMachineAliasCommand,
  DeleteActivityCommand,
  DeleteStateMachineCommand,
  DeleteStateMachineAliasCommand,
  DeleteStateMachineVersionCommand,
  DescribeActivityCommand,
  DescribeExecutionCommand,
  DescribeMapRunCommand,
  DescribeStateMachineCommand,
  DescribeStateMachineAliasCommand,
  DescribeStateMachineForExecutionCommand,
  GetActivityTaskCommand,
  GetExecutionHistoryCommand,
  ListActivitiesCommand,
  ListExecutionsCommand,
  ListMapRunsCommand,
  ListStateMachineAliasesCommand,
  ListStateMachinesCommand,
  ListStateMachineVersionsCommand,
  ListTagsForResourceCommand,
  PublishStateMachineVersionCommand,
  RedriveExecutionCommand,
  SendTaskFailureCommand,
  SendTaskHeartbeatCommand,
  SendTaskSuccessCommand,
  StartExecutionCommand,
  StartSyncExecutionCommand,
  StopExecutionCommand,
  TagResourceCommand,
  TestStateCommand,
  UntagResourceCommand,
  UpdateMapRunCommand,
  UpdateStateMachineCommand,
  UpdateStateMachineAliasCommand,
  ValidateStateMachineDefinitionCommand
};
var SFN = class extends SFNClient {
  static {
    __name(this, "SFN");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, SFN);

// src/pagination/GetExecutionHistoryPaginator.ts

var paginateGetExecutionHistory = (0, import_core.createPaginator)(SFNClient, GetExecutionHistoryCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListActivitiesPaginator.ts

var paginateListActivities = (0, import_core.createPaginator)(SFNClient, ListActivitiesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListExecutionsPaginator.ts

var paginateListExecutions = (0, import_core.createPaginator)(SFNClient, ListExecutionsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListMapRunsPaginator.ts

var paginateListMapRuns = (0, import_core.createPaginator)(SFNClient, ListMapRunsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListStateMachinesPaginator.ts

var paginateListStateMachines = (0, import_core.createPaginator)(SFNClient, ListStateMachinesCommand, "nextToken", "nextToken", "maxResults");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  SFNServiceException,
  __Client,
  SFNClient,
  SFN,
  $Command,
  CreateActivityCommand,
  CreateStateMachineAliasCommand,
  CreateStateMachineCommand,
  DeleteActivityCommand,
  DeleteStateMachineAliasCommand,
  DeleteStateMachineCommand,
  DeleteStateMachineVersionCommand,
  DescribeActivityCommand,
  DescribeExecutionCommand,
  DescribeMapRunCommand,
  DescribeStateMachineAliasCommand,
  DescribeStateMachineCommand,
  DescribeStateMachineForExecutionCommand,
  GetActivityTaskCommand,
  GetExecutionHistoryCommand,
  ListActivitiesCommand,
  ListExecutionsCommand,
  ListMapRunsCommand,
  ListStateMachineAliasesCommand,
  ListStateMachineVersionsCommand,
  ListStateMachinesCommand,
  ListTagsForResourceCommand,
  PublishStateMachineVersionCommand,
  RedriveExecutionCommand,
  SendTaskFailureCommand,
  SendTaskHeartbeatCommand,
  SendTaskSuccessCommand,
  StartExecutionCommand,
  StartSyncExecutionCommand,
  StopExecutionCommand,
  TagResourceCommand,
  TestStateCommand,
  UntagResourceCommand,
  UpdateMapRunCommand,
  UpdateStateMachineAliasCommand,
  UpdateStateMachineCommand,
  ValidateStateMachineDefinitionCommand,
  paginateGetExecutionHistory,
  paginateListActivities,
  paginateListExecutions,
  paginateListMapRuns,
  paginateListStateMachines,
  ActivityAlreadyExists,
  ActivityDoesNotExist,
  ActivityLimitExceeded,
  ActivityWorkerLimitExceeded,
  EncryptionType,
  InvalidEncryptionConfiguration,
  InvalidName,
  KmsAccessDeniedException,
  KmsThrottlingException,
  TooManyTags,
  ConflictException,
  LogLevel,
  StateMachineType,
  InvalidArn,
  InvalidDefinition,
  InvalidLoggingConfiguration,
  InvalidTracingConfiguration,
  StateMachineAlreadyExists,
  StateMachineDeleting,
  StateMachineLimitExceeded,
  StateMachineTypeNotSupported,
  ValidationExceptionReason,
  ValidationException,
  ResourceNotFound,
  ServiceQuotaExceededException,
  IncludedData,
  ExecutionRedriveStatus,
  ExecutionStatus,
  ExecutionDoesNotExist,
  KmsKeyState,
  KmsInvalidStateException,
  MapRunStatus,
  StateMachineStatus,
  StateMachineDoesNotExist,
  HistoryEventType,
  InvalidToken,
  ExecutionRedriveFilter,
  ExecutionLimitExceeded,
  ExecutionNotRedrivable,
  TaskDoesNotExist,
  TaskTimedOut,
  InvalidOutput,
  ExecutionAlreadyExists,
  InvalidExecutionInput,
  SyncExecutionStatus,
  InspectionLevel,
  TestExecutionStatus,
  MissingRequiredParameter,
  ValidateStateMachineDefinitionSeverity,
  ValidateStateMachineDefinitionResultCode,
  ActivityFailedEventDetailsFilterSensitiveLog,
  ActivityScheduledEventDetailsFilterSensitiveLog,
  ActivityScheduleFailedEventDetailsFilterSensitiveLog,
  ActivitySucceededEventDetailsFilterSensitiveLog,
  ActivityTimedOutEventDetailsFilterSensitiveLog,
  CreateStateMachineInputFilterSensitiveLog,
  CreateStateMachineAliasInputFilterSensitiveLog,
  DescribeExecutionOutputFilterSensitiveLog,
  DescribeStateMachineOutputFilterSensitiveLog,
  DescribeStateMachineAliasOutputFilterSensitiveLog,
  DescribeStateMachineForExecutionOutputFilterSensitiveLog,
  GetActivityTaskOutputFilterSensitiveLog,
  EvaluationFailedEventDetailsFilterSensitiveLog,
  ExecutionAbortedEventDetailsFilterSensitiveLog,
  ExecutionFailedEventDetailsFilterSensitiveLog,
  ExecutionStartedEventDetailsFilterSensitiveLog,
  ExecutionSucceededEventDetailsFilterSensitiveLog,
  ExecutionTimedOutEventDetailsFilterSensitiveLog,
  LambdaFunctionFailedEventDetailsFilterSensitiveLog,
  LambdaFunctionScheduledEventDetailsFilterSensitiveLog,
  LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog,
  LambdaFunctionStartFailedEventDetailsFilterSensitiveLog,
  LambdaFunctionSucceededEventDetailsFilterSensitiveLog,
  LambdaFunctionTimedOutEventDetailsFilterSensitiveLog,
  MapRunFailedEventDetailsFilterSensitiveLog,
  StateEnteredEventDetailsFilterSensitiveLog,
  StateExitedEventDetailsFilterSensitiveLog,
  TaskFailedEventDetailsFilterSensitiveLog,
  TaskScheduledEventDetailsFilterSensitiveLog,
  TaskStartFailedEventDetailsFilterSensitiveLog,
  TaskSubmitFailedEventDetailsFilterSensitiveLog,
  TaskSubmittedEventDetailsFilterSensitiveLog,
  TaskSucceededEventDetailsFilterSensitiveLog,
  TaskTimedOutEventDetailsFilterSensitiveLog,
  HistoryEventFilterSensitiveLog,
  GetExecutionHistoryOutputFilterSensitiveLog,
  PublishStateMachineVersionInputFilterSensitiveLog,
  SendTaskFailureInputFilterSensitiveLog,
  SendTaskSuccessInputFilterSensitiveLog,
  StartExecutionInputFilterSensitiveLog,
  StartSyncExecutionInputFilterSensitiveLog,
  StartSyncExecutionOutputFilterSensitiveLog,
  StopExecutionInputFilterSensitiveLog,
  TestStateInputFilterSensitiveLog,
  InspectionDataFilterSensitiveLog,
  TestStateOutputFilterSensitiveLog,
  UpdateStateMachineInputFilterSensitiveLog,
  UpdateStateMachineAliasInputFilterSensitiveLog,
  ValidateStateMachineDefinitionInputFilterSensitiveLog,
  ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog,
  ValidateStateMachineDefinitionOutputFilterSensitiveLog
});

