import { loadRestJsonErrorCode, parseJsonBody as parseBody, parseJsonErrorBody as parseErrorBody } from "@aws-sdk/core";
import { HttpRequest as __HttpRequest, isValidHostname as __isValidHostname, } from "@smithy/protocol-http";
import { _json, collectBody, decorateServiceException as __decorateServiceException, expectInt32 as __expectInt32, expectLong as __expectLong, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectString as __expectString, limitedParseFloat32 as __limitedParseFloat32, parseEpochTimestamp as __parseEpochTimestamp, serializeFloat as __serializeFloat, take, withBaseException, } from "@smithy/smithy-client";
import { v4 as generateIdempotencyToken } from "@smithy/uuid";
import { ActivityAlreadyExists, ActivityDoesNotExist, ActivityLimitExceeded, ActivityWorkerLimitExceeded, ConflictException, ExecutionAlreadyExists, ExecutionDoesNotExist, ExecutionLimitExceeded, ExecutionNotRedrivable, InvalidArn, InvalidDefinition, InvalidEncryptionConfiguration, InvalidExecutionInput, InvalidLoggingConfiguration, InvalidName, InvalidOutput, InvalidToken, InvalidTracingConfiguration, KmsAccessDeniedException, KmsInvalidStateException, KmsThrottlingException, MissingRequiredParameter, ResourceNotFound, ServiceQuotaExceededException, StateMachineAlreadyExists, StateMachineDeleting, StateMachineDoesNotExist, StateMachineLimitExceeded, StateMachineTypeNotSupported, TaskDoesNotExist, TaskTimedOut, TooManyTags, ValidationException, } from "../models/models_0";
import { SFNServiceException as __BaseException } from "../models/SFNServiceException";
export const se_CreateActivityCommand = async (input, context) => {
    const headers = sharedHeaders("CreateActivity");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateStateMachineCommand = async (input, context) => {
    const headers = sharedHeaders("CreateStateMachine");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateStateMachineAliasCommand = async (input, context) => {
    const headers = sharedHeaders("CreateStateMachineAlias");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteActivityCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteActivity");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteStateMachineCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteStateMachine");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteStateMachineAliasCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteStateMachineAlias");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteStateMachineVersionCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteStateMachineVersion");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeActivityCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeActivity");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeExecutionCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeExecution");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeMapRunCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeMapRun");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStateMachineCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeStateMachine");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStateMachineAliasCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeStateMachineAlias");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStateMachineForExecutionCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeStateMachineForExecution");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetActivityTaskCommand = async (input, context) => {
    const headers = sharedHeaders("GetActivityTask");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetExecutionHistoryCommand = async (input, context) => {
    const headers = sharedHeaders("GetExecutionHistory");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListActivitiesCommand = async (input, context) => {
    const headers = sharedHeaders("ListActivities");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListExecutionsCommand = async (input, context) => {
    const headers = sharedHeaders("ListExecutions");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListMapRunsCommand = async (input, context) => {
    const headers = sharedHeaders("ListMapRuns");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStateMachineAliasesCommand = async (input, context) => {
    const headers = sharedHeaders("ListStateMachineAliases");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStateMachinesCommand = async (input, context) => {
    const headers = sharedHeaders("ListStateMachines");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListStateMachineVersionsCommand = async (input, context) => {
    const headers = sharedHeaders("ListStateMachineVersions");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const headers = sharedHeaders("ListTagsForResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PublishStateMachineVersionCommand = async (input, context) => {
    const headers = sharedHeaders("PublishStateMachineVersion");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RedriveExecutionCommand = async (input, context) => {
    const headers = sharedHeaders("RedriveExecution");
    let body;
    body = JSON.stringify(se_RedriveExecutionInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SendTaskFailureCommand = async (input, context) => {
    const headers = sharedHeaders("SendTaskFailure");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SendTaskHeartbeatCommand = async (input, context) => {
    const headers = sharedHeaders("SendTaskHeartbeat");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SendTaskSuccessCommand = async (input, context) => {
    const headers = sharedHeaders("SendTaskSuccess");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartExecutionCommand = async (input, context) => {
    const headers = sharedHeaders("StartExecution");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartSyncExecutionCommand = async (input, context) => {
    const headers = sharedHeaders("StartSyncExecution");
    let body;
    body = JSON.stringify(_json(input));
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "sync-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return buildHttpRpcRequest(context, headers, "/", resolvedHostname, body);
};
export const se_StopExecutionCommand = async (input, context) => {
    const headers = sharedHeaders("StopExecution");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("TagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TestStateCommand = async (input, context) => {
    const headers = sharedHeaders("TestState");
    let body;
    body = JSON.stringify(_json(input));
    let { hostname: resolvedHostname } = await context.endpoint();
    if (context.disableHostPrefix !== true) {
        resolvedHostname = "sync-" + resolvedHostname;
        if (!__isValidHostname(resolvedHostname)) {
            throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
    }
    return buildHttpRpcRequest(context, headers, "/", resolvedHostname, body);
};
export const se_UntagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("UntagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateMapRunCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateMapRun");
    let body;
    body = JSON.stringify(se_UpdateMapRunInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateStateMachineCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateStateMachine");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateStateMachineAliasCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateStateMachineAlias");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ValidateStateMachineDefinitionCommand = async (input, context) => {
    const headers = sharedHeaders("ValidateStateMachineDefinition");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_CreateActivityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateActivityOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateStateMachineCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateStateMachineOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateStateMachineAliasCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateStateMachineAliasOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteActivityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteStateMachineCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteStateMachineAliasCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteStateMachineVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeActivityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeActivityOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeExecutionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeExecutionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeMapRunCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeMapRunOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeStateMachineCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStateMachineOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeStateMachineAliasCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStateMachineAliasOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeStateMachineForExecutionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStateMachineForExecutionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetActivityTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetExecutionHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetExecutionHistoryOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListActivitiesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListActivitiesOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListExecutionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListExecutionsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListMapRunsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListMapRunsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListStateMachineAliasesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStateMachineAliasesOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListStateMachinesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStateMachinesOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListStateMachineVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListStateMachineVersionsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PublishStateMachineVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PublishStateMachineVersionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RedriveExecutionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RedriveExecutionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SendTaskFailureCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SendTaskHeartbeatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SendTaskSuccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartExecutionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartExecutionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartSyncExecutionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartSyncExecutionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StopExecutionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopExecutionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_TestStateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateMapRunCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateStateMachineCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateStateMachineOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateStateMachineAliasCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateStateMachineAliasOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ValidateStateMachineDefinitionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ActivityAlreadyExists":
        case "com.amazonaws.sfn#ActivityAlreadyExists":
            throw await de_ActivityAlreadyExistsRes(parsedOutput, context);
        case "ActivityLimitExceeded":
        case "com.amazonaws.sfn#ActivityLimitExceeded":
            throw await de_ActivityLimitExceededRes(parsedOutput, context);
        case "InvalidEncryptionConfiguration":
        case "com.amazonaws.sfn#InvalidEncryptionConfiguration":
            throw await de_InvalidEncryptionConfigurationRes(parsedOutput, context);
        case "InvalidName":
        case "com.amazonaws.sfn#InvalidName":
            throw await de_InvalidNameRes(parsedOutput, context);
        case "KmsAccessDeniedException":
        case "com.amazonaws.sfn#KmsAccessDeniedException":
            throw await de_KmsAccessDeniedExceptionRes(parsedOutput, context);
        case "KmsThrottlingException":
        case "com.amazonaws.sfn#KmsThrottlingException":
            throw await de_KmsThrottlingExceptionRes(parsedOutput, context);
        case "TooManyTags":
        case "com.amazonaws.sfn#TooManyTags":
            throw await de_TooManyTagsRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
            throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidDefinition":
        case "com.amazonaws.sfn#InvalidDefinition":
            throw await de_InvalidDefinitionRes(parsedOutput, context);
        case "InvalidLoggingConfiguration":
        case "com.amazonaws.sfn#InvalidLoggingConfiguration":
            throw await de_InvalidLoggingConfigurationRes(parsedOutput, context);
        case "InvalidTracingConfiguration":
        case "com.amazonaws.sfn#InvalidTracingConfiguration":
            throw await de_InvalidTracingConfigurationRes(parsedOutput, context);
        case "StateMachineAlreadyExists":
        case "com.amazonaws.sfn#StateMachineAlreadyExists":
            throw await de_StateMachineAlreadyExistsRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
            throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineLimitExceeded":
        case "com.amazonaws.sfn#StateMachineLimitExceeded":
            throw await de_StateMachineLimitExceededRes(parsedOutput, context);
        case "StateMachineTypeNotSupported":
        case "com.amazonaws.sfn#StateMachineTypeNotSupported":
            throw await de_StateMachineTypeNotSupportedRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
            throw await de_ValidationExceptionRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
            throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "ServiceQuotaExceededException":
        case "com.amazonaws.sfn#ServiceQuotaExceededException":
            throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
        case "ActivityDoesNotExist":
        case "com.amazonaws.sfn#ActivityDoesNotExist":
            throw await de_ActivityDoesNotExistRes(parsedOutput, context);
        case "ExecutionDoesNotExist":
        case "com.amazonaws.sfn#ExecutionDoesNotExist":
            throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
        case "KmsInvalidStateException":
        case "com.amazonaws.sfn#KmsInvalidStateException":
            throw await de_KmsInvalidStateExceptionRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
            throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        case "ActivityWorkerLimitExceeded":
        case "com.amazonaws.sfn#ActivityWorkerLimitExceeded":
            throw await de_ActivityWorkerLimitExceededRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
            throw await de_InvalidTokenRes(parsedOutput, context);
        case "ExecutionLimitExceeded":
        case "com.amazonaws.sfn#ExecutionLimitExceeded":
            throw await de_ExecutionLimitExceededRes(parsedOutput, context);
        case "ExecutionNotRedrivable":
        case "com.amazonaws.sfn#ExecutionNotRedrivable":
            throw await de_ExecutionNotRedrivableRes(parsedOutput, context);
        case "TaskDoesNotExist":
        case "com.amazonaws.sfn#TaskDoesNotExist":
            throw await de_TaskDoesNotExistRes(parsedOutput, context);
        case "TaskTimedOut":
        case "com.amazonaws.sfn#TaskTimedOut":
            throw await de_TaskTimedOutRes(parsedOutput, context);
        case "InvalidOutput":
        case "com.amazonaws.sfn#InvalidOutput":
            throw await de_InvalidOutputRes(parsedOutput, context);
        case "ExecutionAlreadyExists":
        case "com.amazonaws.sfn#ExecutionAlreadyExists":
            throw await de_ExecutionAlreadyExistsRes(parsedOutput, context);
        case "InvalidExecutionInput":
        case "com.amazonaws.sfn#InvalidExecutionInput":
            throw await de_InvalidExecutionInputRes(parsedOutput, context);
        case "MissingRequiredParameter":
        case "com.amazonaws.sfn#MissingRequiredParameter":
            throw await de_MissingRequiredParameterRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ActivityAlreadyExistsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ActivityAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ActivityDoesNotExistRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ActivityDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ActivityLimitExceededRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ActivityLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ActivityWorkerLimitExceededRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ActivityWorkerLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ConflictExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ExecutionAlreadyExistsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ExecutionAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ExecutionDoesNotExistRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ExecutionDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ExecutionLimitExceededRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ExecutionLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ExecutionNotRedrivableRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ExecutionNotRedrivable({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidArnRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidArn({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDefinitionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDefinition({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidEncryptionConfigurationRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidEncryptionConfiguration({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidExecutionInputRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidExecutionInput({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidLoggingConfigurationRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidLoggingConfiguration({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidNameRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidName({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOutputRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidOutput({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTokenRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidToken({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTracingConfigurationRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTracingConfiguration({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_KmsAccessDeniedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new KmsAccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_KmsInvalidStateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new KmsInvalidStateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_KmsThrottlingExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new KmsThrottlingException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MissingRequiredParameterRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MissingRequiredParameter({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ResourceNotFoundRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ResourceNotFound({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ServiceQuotaExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ServiceQuotaExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StateMachineAlreadyExistsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new StateMachineAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StateMachineDeletingRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new StateMachineDeleting({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StateMachineDoesNotExistRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new StateMachineDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StateMachineLimitExceededRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new StateMachineLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StateMachineTypeNotSupportedRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new StateMachineTypeNotSupported({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TaskDoesNotExistRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TaskDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TaskTimedOutRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TaskTimedOut({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TooManyTagsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TooManyTags({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ValidationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ValidationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const se_RedriveExecutionInput = (input, context) => {
    return take(input, {
        clientToken: [true, (_) => _ ?? generateIdempotencyToken()],
        executionArn: [],
    });
};
const se_UpdateMapRunInput = (input, context) => {
    return take(input, {
        mapRunArn: [],
        maxConcurrency: [],
        toleratedFailureCount: [],
        toleratedFailurePercentage: __serializeFloat,
    });
};
const de_ActivityList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ActivityListItem(entry, context);
    });
    return retVal;
};
const de_ActivityListItem = (output, context) => {
    return take(output, {
        activityArn: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        name: __expectString,
    });
};
const de_CreateActivityOutput = (output, context) => {
    return take(output, {
        activityArn: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_CreateStateMachineAliasOutput = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineAliasArn: __expectString,
    });
};
const de_CreateStateMachineOutput = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineArn: __expectString,
        stateMachineVersionArn: __expectString,
    });
};
const de_DescribeActivityOutput = (output, context) => {
    return take(output, {
        activityArn: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        encryptionConfiguration: _json,
        name: __expectString,
    });
};
const de_DescribeExecutionOutput = (output, context) => {
    return take(output, {
        cause: __expectString,
        error: __expectString,
        executionArn: __expectString,
        input: __expectString,
        inputDetails: _json,
        mapRunArn: __expectString,
        name: __expectString,
        output: __expectString,
        outputDetails: _json,
        redriveCount: __expectInt32,
        redriveDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        redriveStatus: __expectString,
        redriveStatusReason: __expectString,
        startDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineAliasArn: __expectString,
        stateMachineArn: __expectString,
        stateMachineVersionArn: __expectString,
        status: __expectString,
        stopDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        traceHeader: __expectString,
    });
};
const de_DescribeMapRunOutput = (output, context) => {
    return take(output, {
        executionArn: __expectString,
        executionCounts: _json,
        itemCounts: _json,
        mapRunArn: __expectString,
        maxConcurrency: __expectInt32,
        redriveCount: __expectInt32,
        redriveDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        startDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        status: __expectString,
        stopDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        toleratedFailureCount: __expectLong,
        toleratedFailurePercentage: __limitedParseFloat32,
    });
};
const de_DescribeStateMachineAliasOutput = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        description: __expectString,
        name: __expectString,
        routingConfiguration: _json,
        stateMachineAliasArn: __expectString,
        updateDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_DescribeStateMachineForExecutionOutput = (output, context) => {
    return take(output, {
        definition: __expectString,
        encryptionConfiguration: _json,
        label: __expectString,
        loggingConfiguration: _json,
        mapRunArn: __expectString,
        name: __expectString,
        revisionId: __expectString,
        roleArn: __expectString,
        stateMachineArn: __expectString,
        tracingConfiguration: _json,
        updateDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        variableReferences: _json,
    });
};
const de_DescribeStateMachineOutput = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        definition: __expectString,
        description: __expectString,
        encryptionConfiguration: _json,
        label: __expectString,
        loggingConfiguration: _json,
        name: __expectString,
        revisionId: __expectString,
        roleArn: __expectString,
        stateMachineArn: __expectString,
        status: __expectString,
        tracingConfiguration: _json,
        type: __expectString,
        variableReferences: _json,
    });
};
const de_ExecutionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ExecutionListItem(entry, context);
    });
    return retVal;
};
const de_ExecutionListItem = (output, context) => {
    return take(output, {
        executionArn: __expectString,
        itemCount: __expectInt32,
        mapRunArn: __expectString,
        name: __expectString,
        redriveCount: __expectInt32,
        redriveDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        startDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineAliasArn: __expectString,
        stateMachineArn: __expectString,
        stateMachineVersionArn: __expectString,
        status: __expectString,
        stopDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_GetExecutionHistoryOutput = (output, context) => {
    return take(output, {
        events: (_) => de_HistoryEventList(_, context),
        nextToken: __expectString,
    });
};
const de_HistoryEvent = (output, context) => {
    return take(output, {
        activityFailedEventDetails: _json,
        activityScheduleFailedEventDetails: _json,
        activityScheduledEventDetails: _json,
        activityStartedEventDetails: _json,
        activitySucceededEventDetails: _json,
        activityTimedOutEventDetails: _json,
        evaluationFailedEventDetails: _json,
        executionAbortedEventDetails: _json,
        executionFailedEventDetails: _json,
        executionRedrivenEventDetails: _json,
        executionStartedEventDetails: _json,
        executionSucceededEventDetails: _json,
        executionTimedOutEventDetails: _json,
        id: __expectLong,
        lambdaFunctionFailedEventDetails: _json,
        lambdaFunctionScheduleFailedEventDetails: _json,
        lambdaFunctionScheduledEventDetails: _json,
        lambdaFunctionStartFailedEventDetails: _json,
        lambdaFunctionSucceededEventDetails: _json,
        lambdaFunctionTimedOutEventDetails: _json,
        mapIterationAbortedEventDetails: _json,
        mapIterationFailedEventDetails: _json,
        mapIterationStartedEventDetails: _json,
        mapIterationSucceededEventDetails: _json,
        mapRunFailedEventDetails: _json,
        mapRunRedrivenEventDetails: _json,
        mapRunStartedEventDetails: _json,
        mapStateStartedEventDetails: _json,
        previousEventId: __expectLong,
        stateEnteredEventDetails: _json,
        stateExitedEventDetails: _json,
        taskFailedEventDetails: _json,
        taskScheduledEventDetails: _json,
        taskStartFailedEventDetails: _json,
        taskStartedEventDetails: _json,
        taskSubmitFailedEventDetails: _json,
        taskSubmittedEventDetails: _json,
        taskSucceededEventDetails: _json,
        taskTimedOutEventDetails: _json,
        timestamp: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        type: __expectString,
    });
};
const de_HistoryEventList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_HistoryEvent(entry, context);
    });
    return retVal;
};
const de_ListActivitiesOutput = (output, context) => {
    return take(output, {
        activities: (_) => de_ActivityList(_, context),
        nextToken: __expectString,
    });
};
const de_ListExecutionsOutput = (output, context) => {
    return take(output, {
        executions: (_) => de_ExecutionList(_, context),
        nextToken: __expectString,
    });
};
const de_ListMapRunsOutput = (output, context) => {
    return take(output, {
        mapRuns: (_) => de_MapRunList(_, context),
        nextToken: __expectString,
    });
};
const de_ListStateMachineAliasesOutput = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        stateMachineAliases: (_) => de_StateMachineAliasList(_, context),
    });
};
const de_ListStateMachinesOutput = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        stateMachines: (_) => de_StateMachineList(_, context),
    });
};
const de_ListStateMachineVersionsOutput = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        stateMachineVersions: (_) => de_StateMachineVersionList(_, context),
    });
};
const de_MapRunList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_MapRunListItem(entry, context);
    });
    return retVal;
};
const de_MapRunListItem = (output, context) => {
    return take(output, {
        executionArn: __expectString,
        mapRunArn: __expectString,
        startDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineArn: __expectString,
        stopDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_PublishStateMachineVersionOutput = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineVersionArn: __expectString,
    });
};
const de_RedriveExecutionOutput = (output, context) => {
    return take(output, {
        redriveDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_StartExecutionOutput = (output, context) => {
    return take(output, {
        executionArn: __expectString,
        startDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_StartSyncExecutionOutput = (output, context) => {
    return take(output, {
        billingDetails: _json,
        cause: __expectString,
        error: __expectString,
        executionArn: __expectString,
        input: __expectString,
        inputDetails: _json,
        name: __expectString,
        output: __expectString,
        outputDetails: _json,
        startDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineArn: __expectString,
        status: __expectString,
        stopDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        traceHeader: __expectString,
    });
};
const de_StateMachineAliasList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StateMachineAliasListItem(entry, context);
    });
    return retVal;
};
const de_StateMachineAliasListItem = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineAliasArn: __expectString,
    });
};
const de_StateMachineList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StateMachineListItem(entry, context);
    });
    return retVal;
};
const de_StateMachineListItem = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        name: __expectString,
        stateMachineArn: __expectString,
        type: __expectString,
    });
};
const de_StateMachineVersionList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StateMachineVersionListItem(entry, context);
    });
    return retVal;
};
const de_StateMachineVersionListItem = (output, context) => {
    return take(output, {
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        stateMachineVersionArn: __expectString,
    });
};
const de_StopExecutionOutput = (output, context) => {
    return take(output, {
        stopDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_UpdateStateMachineAliasOutput = (output, context) => {
    return take(output, {
        updateDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_UpdateStateMachineOutput = (output, context) => {
    return take(output, {
        revisionId: __expectString,
        stateMachineVersionArn: __expectString,
        updateDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = withBaseException(__BaseException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
function sharedHeaders(operation) {
    return {
        "content-type": "application/x-amz-json-1.0",
        "x-amz-target": `AWSStepFunctions.${operation}`,
    };
}
