import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { SFNServiceException as __BaseException } from "./SFNServiceException";
export declare class ActivityAlreadyExists extends __BaseException {
  readonly name: "ActivityAlreadyExists";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ActivityAlreadyExists, __BaseException>
  );
}
export declare class ActivityDoesNotExist extends __BaseException {
  readonly name: "ActivityDoesNotExist";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ActivityDoesNotExist, __BaseException>
  );
}
export interface ActivityFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export declare class ActivityLimitExceeded extends __BaseException {
  readonly name: "ActivityLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ActivityLimitExceeded, __BaseException>
  );
}
export interface ActivityListItem {
  activityArn: string | undefined;
  name: string | undefined;
  creationDate: Date | undefined;
}
export interface HistoryEventExecutionDataDetails {
  truncated?: boolean | undefined;
}
export interface ActivityScheduledEventDetails {
  resource: string | undefined;
  input?: string | undefined;
  inputDetails?: HistoryEventExecutionDataDetails | undefined;
  timeoutInSeconds?: number | undefined;
  heartbeatInSeconds?: number | undefined;
}
export interface ActivityScheduleFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface ActivityStartedEventDetails {
  workerName?: string | undefined;
}
export interface ActivitySucceededEventDetails {
  output?: string | undefined;
  outputDetails?: HistoryEventExecutionDataDetails | undefined;
}
export interface ActivityTimedOutEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export declare class ActivityWorkerLimitExceeded extends __BaseException {
  readonly name: "ActivityWorkerLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ActivityWorkerLimitExceeded, __BaseException>
  );
}
export interface AssignedVariablesDetails {
  truncated?: boolean | undefined;
}
export declare const EncryptionType: {
  readonly AWS_OWNED_KEY: "AWS_OWNED_KEY";
  readonly CUSTOMER_MANAGED_KMS_KEY: "CUSTOMER_MANAGED_KMS_KEY";
};
export type EncryptionType =
  (typeof EncryptionType)[keyof typeof EncryptionType];
export interface EncryptionConfiguration {
  kmsKeyId?: string | undefined;
  kmsDataKeyReusePeriodSeconds?: number | undefined;
  type: EncryptionType | undefined;
}
export interface Tag {
  key?: string | undefined;
  value?: string | undefined;
}
export interface CreateActivityInput {
  name: string | undefined;
  tags?: Tag[] | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
}
export interface CreateActivityOutput {
  activityArn: string | undefined;
  creationDate: Date | undefined;
}
export declare class InvalidEncryptionConfiguration extends __BaseException {
  readonly name: "InvalidEncryptionConfiguration";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidEncryptionConfiguration, __BaseException>
  );
}
export declare class InvalidName extends __BaseException {
  readonly name: "InvalidName";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidName, __BaseException>);
}
export declare class KmsAccessDeniedException extends __BaseException {
  readonly name: "KmsAccessDeniedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KmsAccessDeniedException, __BaseException>
  );
}
export declare class KmsThrottlingException extends __BaseException {
  readonly name: "KmsThrottlingException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KmsThrottlingException, __BaseException>
  );
}
export declare class TooManyTags extends __BaseException {
  readonly name: "TooManyTags";
  readonly $fault: "client";
  resourceName?: string | undefined;
  constructor(opts: __ExceptionOptionType<TooManyTags, __BaseException>);
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface CloudWatchLogsLogGroup {
  logGroupArn?: string | undefined;
}
export interface LogDestination {
  cloudWatchLogsLogGroup?: CloudWatchLogsLogGroup | undefined;
}
export declare const LogLevel: {
  readonly ALL: "ALL";
  readonly ERROR: "ERROR";
  readonly FATAL: "FATAL";
  readonly OFF: "OFF";
};
export type LogLevel = (typeof LogLevel)[keyof typeof LogLevel];
export interface LoggingConfiguration {
  level?: LogLevel | undefined;
  includeExecutionData?: boolean | undefined;
  destinations?: LogDestination[] | undefined;
}
export interface TracingConfiguration {
  enabled?: boolean | undefined;
}
export declare const StateMachineType: {
  readonly EXPRESS: "EXPRESS";
  readonly STANDARD: "STANDARD";
};
export type StateMachineType =
  (typeof StateMachineType)[keyof typeof StateMachineType];
export interface CreateStateMachineInput {
  name: string | undefined;
  definition: string | undefined;
  roleArn: string | undefined;
  type?: StateMachineType | undefined;
  loggingConfiguration?: LoggingConfiguration | undefined;
  tags?: Tag[] | undefined;
  tracingConfiguration?: TracingConfiguration | undefined;
  publish?: boolean | undefined;
  versionDescription?: string | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
}
export interface CreateStateMachineOutput {
  stateMachineArn: string | undefined;
  creationDate: Date | undefined;
  stateMachineVersionArn?: string | undefined;
}
export declare class InvalidArn extends __BaseException {
  readonly name: "InvalidArn";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidArn, __BaseException>);
}
export declare class InvalidDefinition extends __BaseException {
  readonly name: "InvalidDefinition";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidDefinition, __BaseException>);
}
export declare class InvalidLoggingConfiguration extends __BaseException {
  readonly name: "InvalidLoggingConfiguration";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidLoggingConfiguration, __BaseException>
  );
}
export declare class InvalidTracingConfiguration extends __BaseException {
  readonly name: "InvalidTracingConfiguration";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTracingConfiguration, __BaseException>
  );
}
export declare class StateMachineAlreadyExists extends __BaseException {
  readonly name: "StateMachineAlreadyExists";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StateMachineAlreadyExists, __BaseException>
  );
}
export declare class StateMachineDeleting extends __BaseException {
  readonly name: "StateMachineDeleting";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StateMachineDeleting, __BaseException>
  );
}
export declare class StateMachineLimitExceeded extends __BaseException {
  readonly name: "StateMachineLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StateMachineLimitExceeded, __BaseException>
  );
}
export declare class StateMachineTypeNotSupported extends __BaseException {
  readonly name: "StateMachineTypeNotSupported";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StateMachineTypeNotSupported, __BaseException>
  );
}
export declare const ValidationExceptionReason: {
  readonly API_DOES_NOT_SUPPORT_LABELED_ARNS: "API_DOES_NOT_SUPPORT_LABELED_ARNS";
  readonly CANNOT_UPDATE_COMPLETED_MAP_RUN: "CANNOT_UPDATE_COMPLETED_MAP_RUN";
  readonly INVALID_ROUTING_CONFIGURATION: "INVALID_ROUTING_CONFIGURATION";
  readonly MISSING_REQUIRED_PARAMETER: "MISSING_REQUIRED_PARAMETER";
};
export type ValidationExceptionReason =
  (typeof ValidationExceptionReason)[keyof typeof ValidationExceptionReason];
export declare class ValidationException extends __BaseException {
  readonly name: "ValidationException";
  readonly $fault: "client";
  reason?: ValidationExceptionReason | undefined;
  constructor(
    opts: __ExceptionOptionType<ValidationException, __BaseException>
  );
}
export interface RoutingConfigurationListItem {
  stateMachineVersionArn: string | undefined;
  weight: number | undefined;
}
export interface CreateStateMachineAliasInput {
  description?: string | undefined;
  name: string | undefined;
  routingConfiguration: RoutingConfigurationListItem[] | undefined;
}
export interface CreateStateMachineAliasOutput {
  stateMachineAliasArn: string | undefined;
  creationDate: Date | undefined;
}
export declare class ResourceNotFound extends __BaseException {
  readonly name: "ResourceNotFound";
  readonly $fault: "client";
  resourceName?: string | undefined;
  constructor(opts: __ExceptionOptionType<ResourceNotFound, __BaseException>);
}
export declare class ServiceQuotaExceededException extends __BaseException {
  readonly name: "ServiceQuotaExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ServiceQuotaExceededException, __BaseException>
  );
}
export interface DeleteActivityInput {
  activityArn: string | undefined;
}
export interface DeleteActivityOutput {}
export interface DeleteStateMachineInput {
  stateMachineArn: string | undefined;
}
export interface DeleteStateMachineOutput {}
export interface DeleteStateMachineAliasInput {
  stateMachineAliasArn: string | undefined;
}
export interface DeleteStateMachineAliasOutput {}
export interface DeleteStateMachineVersionInput {
  stateMachineVersionArn: string | undefined;
}
export interface DeleteStateMachineVersionOutput {}
export interface DescribeActivityInput {
  activityArn: string | undefined;
}
export interface DescribeActivityOutput {
  activityArn: string | undefined;
  name: string | undefined;
  creationDate: Date | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
}
export declare const IncludedData: {
  readonly ALL_DATA: "ALL_DATA";
  readonly METADATA_ONLY: "METADATA_ONLY";
};
export type IncludedData = (typeof IncludedData)[keyof typeof IncludedData];
export interface DescribeExecutionInput {
  executionArn: string | undefined;
  includedData?: IncludedData | undefined;
}
export interface CloudWatchEventsExecutionDataDetails {
  included?: boolean | undefined;
}
export declare const ExecutionRedriveStatus: {
  readonly NOT_REDRIVABLE: "NOT_REDRIVABLE";
  readonly REDRIVABLE: "REDRIVABLE";
  readonly REDRIVABLE_BY_MAP_RUN: "REDRIVABLE_BY_MAP_RUN";
};
export type ExecutionRedriveStatus =
  (typeof ExecutionRedriveStatus)[keyof typeof ExecutionRedriveStatus];
export declare const ExecutionStatus: {
  readonly ABORTED: "ABORTED";
  readonly FAILED: "FAILED";
  readonly PENDING_REDRIVE: "PENDING_REDRIVE";
  readonly RUNNING: "RUNNING";
  readonly SUCCEEDED: "SUCCEEDED";
  readonly TIMED_OUT: "TIMED_OUT";
};
export type ExecutionStatus =
  (typeof ExecutionStatus)[keyof typeof ExecutionStatus];
export interface DescribeExecutionOutput {
  executionArn: string | undefined;
  stateMachineArn: string | undefined;
  name?: string | undefined;
  status: ExecutionStatus | undefined;
  startDate: Date | undefined;
  stopDate?: Date | undefined;
  input?: string | undefined;
  inputDetails?: CloudWatchEventsExecutionDataDetails | undefined;
  output?: string | undefined;
  outputDetails?: CloudWatchEventsExecutionDataDetails | undefined;
  traceHeader?: string | undefined;
  mapRunArn?: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
  stateMachineVersionArn?: string | undefined;
  stateMachineAliasArn?: string | undefined;
  redriveCount?: number | undefined;
  redriveDate?: Date | undefined;
  redriveStatus?: ExecutionRedriveStatus | undefined;
  redriveStatusReason?: string | undefined;
}
export declare class ExecutionDoesNotExist extends __BaseException {
  readonly name: "ExecutionDoesNotExist";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExecutionDoesNotExist, __BaseException>
  );
}
export declare const KmsKeyState: {
  readonly CREATING: "CREATING";
  readonly DISABLED: "DISABLED";
  readonly PENDING_DELETION: "PENDING_DELETION";
  readonly PENDING_IMPORT: "PENDING_IMPORT";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type KmsKeyState = (typeof KmsKeyState)[keyof typeof KmsKeyState];
export declare class KmsInvalidStateException extends __BaseException {
  readonly name: "KmsInvalidStateException";
  readonly $fault: "client";
  kmsKeyState?: KmsKeyState | undefined;
  constructor(
    opts: __ExceptionOptionType<KmsInvalidStateException, __BaseException>
  );
}
export interface DescribeMapRunInput {
  mapRunArn: string | undefined;
}
export interface MapRunExecutionCounts {
  pending: number | undefined;
  running: number | undefined;
  succeeded: number | undefined;
  failed: number | undefined;
  timedOut: number | undefined;
  aborted: number | undefined;
  total: number | undefined;
  resultsWritten: number | undefined;
  failuresNotRedrivable?: number | undefined;
  pendingRedrive?: number | undefined;
}
export interface MapRunItemCounts {
  pending: number | undefined;
  running: number | undefined;
  succeeded: number | undefined;
  failed: number | undefined;
  timedOut: number | undefined;
  aborted: number | undefined;
  total: number | undefined;
  resultsWritten: number | undefined;
  failuresNotRedrivable?: number | undefined;
  pendingRedrive?: number | undefined;
}
export declare const MapRunStatus: {
  readonly ABORTED: "ABORTED";
  readonly FAILED: "FAILED";
  readonly RUNNING: "RUNNING";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type MapRunStatus = (typeof MapRunStatus)[keyof typeof MapRunStatus];
export interface DescribeMapRunOutput {
  mapRunArn: string | undefined;
  executionArn: string | undefined;
  status: MapRunStatus | undefined;
  startDate: Date | undefined;
  stopDate?: Date | undefined;
  maxConcurrency: number | undefined;
  toleratedFailurePercentage: number | undefined;
  toleratedFailureCount: number | undefined;
  itemCounts: MapRunItemCounts | undefined;
  executionCounts: MapRunExecutionCounts | undefined;
  redriveCount?: number | undefined;
  redriveDate?: Date | undefined;
}
export interface DescribeStateMachineInput {
  stateMachineArn: string | undefined;
  includedData?: IncludedData | undefined;
}
export declare const StateMachineStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DELETING: "DELETING";
};
export type StateMachineStatus =
  (typeof StateMachineStatus)[keyof typeof StateMachineStatus];
export interface DescribeStateMachineOutput {
  stateMachineArn: string | undefined;
  name: string | undefined;
  status?: StateMachineStatus | undefined;
  definition: string | undefined;
  roleArn: string | undefined;
  type: StateMachineType | undefined;
  creationDate: Date | undefined;
  loggingConfiguration?: LoggingConfiguration | undefined;
  tracingConfiguration?: TracingConfiguration | undefined;
  label?: string | undefined;
  revisionId?: string | undefined;
  description?: string | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
  variableReferences?: Record<string, string[]> | undefined;
}
export declare class StateMachineDoesNotExist extends __BaseException {
  readonly name: "StateMachineDoesNotExist";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StateMachineDoesNotExist, __BaseException>
  );
}
export interface DescribeStateMachineAliasInput {
  stateMachineAliasArn: string | undefined;
}
export interface DescribeStateMachineAliasOutput {
  stateMachineAliasArn?: string | undefined;
  name?: string | undefined;
  description?: string | undefined;
  routingConfiguration?: RoutingConfigurationListItem[] | undefined;
  creationDate?: Date | undefined;
  updateDate?: Date | undefined;
}
export interface DescribeStateMachineForExecutionInput {
  executionArn: string | undefined;
  includedData?: IncludedData | undefined;
}
export interface DescribeStateMachineForExecutionOutput {
  stateMachineArn: string | undefined;
  name: string | undefined;
  definition: string | undefined;
  roleArn: string | undefined;
  updateDate: Date | undefined;
  loggingConfiguration?: LoggingConfiguration | undefined;
  tracingConfiguration?: TracingConfiguration | undefined;
  mapRunArn?: string | undefined;
  label?: string | undefined;
  revisionId?: string | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
  variableReferences?: Record<string, string[]> | undefined;
}
export interface GetActivityTaskInput {
  activityArn: string | undefined;
  workerName?: string | undefined;
}
export interface GetActivityTaskOutput {
  taskToken?: string | undefined;
  input?: string | undefined;
}
export interface GetExecutionHistoryInput {
  executionArn: string | undefined;
  maxResults?: number | undefined;
  reverseOrder?: boolean | undefined;
  nextToken?: string | undefined;
  includeExecutionData?: boolean | undefined;
}
export interface EvaluationFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
  location?: string | undefined;
  state: string | undefined;
}
export interface ExecutionAbortedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface ExecutionFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface ExecutionRedrivenEventDetails {
  redriveCount?: number | undefined;
}
export interface ExecutionStartedEventDetails {
  input?: string | undefined;
  inputDetails?: HistoryEventExecutionDataDetails | undefined;
  roleArn?: string | undefined;
  stateMachineAliasArn?: string | undefined;
  stateMachineVersionArn?: string | undefined;
}
export interface ExecutionSucceededEventDetails {
  output?: string | undefined;
  outputDetails?: HistoryEventExecutionDataDetails | undefined;
}
export interface ExecutionTimedOutEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface LambdaFunctionFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface TaskCredentials {
  roleArn?: string | undefined;
}
export interface LambdaFunctionScheduledEventDetails {
  resource: string | undefined;
  input?: string | undefined;
  inputDetails?: HistoryEventExecutionDataDetails | undefined;
  timeoutInSeconds?: number | undefined;
  taskCredentials?: TaskCredentials | undefined;
}
export interface LambdaFunctionScheduleFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface LambdaFunctionStartFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface LambdaFunctionSucceededEventDetails {
  output?: string | undefined;
  outputDetails?: HistoryEventExecutionDataDetails | undefined;
}
export interface LambdaFunctionTimedOutEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface MapIterationEventDetails {
  name?: string | undefined;
  index?: number | undefined;
}
export interface MapRunFailedEventDetails {
  error?: string | undefined;
  cause?: string | undefined;
}
export interface MapRunRedrivenEventDetails {
  mapRunArn?: string | undefined;
  redriveCount?: number | undefined;
}
export interface MapRunStartedEventDetails {
  mapRunArn?: string | undefined;
}
export interface MapStateStartedEventDetails {
  length?: number | undefined;
}
export interface StateEnteredEventDetails {
  name: string | undefined;
  input?: string | undefined;
  inputDetails?: HistoryEventExecutionDataDetails | undefined;
}
export interface StateExitedEventDetails {
  name: string | undefined;
  output?: string | undefined;
  outputDetails?: HistoryEventExecutionDataDetails | undefined;
  assignedVariables?: Record<string, string> | undefined;
  assignedVariablesDetails?: AssignedVariablesDetails | undefined;
}
export interface TaskFailedEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
}
export interface TaskScheduledEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  region: string | undefined;
  parameters: string | undefined;
  timeoutInSeconds?: number | undefined;
  heartbeatInSeconds?: number | undefined;
  taskCredentials?: TaskCredentials | undefined;
}
export interface TaskStartedEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
}
export interface TaskStartFailedEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
}
export interface TaskSubmitFailedEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
}
export interface TaskSubmittedEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  output?: string | undefined;
  outputDetails?: HistoryEventExecutionDataDetails | undefined;
}
export interface TaskSucceededEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  output?: string | undefined;
  outputDetails?: HistoryEventExecutionDataDetails | undefined;
}
export interface TaskTimedOutEventDetails {
  resourceType: string | undefined;
  resource: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
}
export declare const HistoryEventType: {
  readonly ActivityFailed: "ActivityFailed";
  readonly ActivityScheduleFailed: "ActivityScheduleFailed";
  readonly ActivityScheduled: "ActivityScheduled";
  readonly ActivityStarted: "ActivityStarted";
  readonly ActivitySucceeded: "ActivitySucceeded";
  readonly ActivityTimedOut: "ActivityTimedOut";
  readonly ChoiceStateEntered: "ChoiceStateEntered";
  readonly ChoiceStateExited: "ChoiceStateExited";
  readonly EvaluationFailed: "EvaluationFailed";
  readonly ExecutionAborted: "ExecutionAborted";
  readonly ExecutionFailed: "ExecutionFailed";
  readonly ExecutionRedriven: "ExecutionRedriven";
  readonly ExecutionStarted: "ExecutionStarted";
  readonly ExecutionSucceeded: "ExecutionSucceeded";
  readonly ExecutionTimedOut: "ExecutionTimedOut";
  readonly FailStateEntered: "FailStateEntered";
  readonly LambdaFunctionFailed: "LambdaFunctionFailed";
  readonly LambdaFunctionScheduleFailed: "LambdaFunctionScheduleFailed";
  readonly LambdaFunctionScheduled: "LambdaFunctionScheduled";
  readonly LambdaFunctionStartFailed: "LambdaFunctionStartFailed";
  readonly LambdaFunctionStarted: "LambdaFunctionStarted";
  readonly LambdaFunctionSucceeded: "LambdaFunctionSucceeded";
  readonly LambdaFunctionTimedOut: "LambdaFunctionTimedOut";
  readonly MapIterationAborted: "MapIterationAborted";
  readonly MapIterationFailed: "MapIterationFailed";
  readonly MapIterationStarted: "MapIterationStarted";
  readonly MapIterationSucceeded: "MapIterationSucceeded";
  readonly MapRunAborted: "MapRunAborted";
  readonly MapRunFailed: "MapRunFailed";
  readonly MapRunRedriven: "MapRunRedriven";
  readonly MapRunStarted: "MapRunStarted";
  readonly MapRunSucceeded: "MapRunSucceeded";
  readonly MapStateAborted: "MapStateAborted";
  readonly MapStateEntered: "MapStateEntered";
  readonly MapStateExited: "MapStateExited";
  readonly MapStateFailed: "MapStateFailed";
  readonly MapStateStarted: "MapStateStarted";
  readonly MapStateSucceeded: "MapStateSucceeded";
  readonly ParallelStateAborted: "ParallelStateAborted";
  readonly ParallelStateEntered: "ParallelStateEntered";
  readonly ParallelStateExited: "ParallelStateExited";
  readonly ParallelStateFailed: "ParallelStateFailed";
  readonly ParallelStateStarted: "ParallelStateStarted";
  readonly ParallelStateSucceeded: "ParallelStateSucceeded";
  readonly PassStateEntered: "PassStateEntered";
  readonly PassStateExited: "PassStateExited";
  readonly SucceedStateEntered: "SucceedStateEntered";
  readonly SucceedStateExited: "SucceedStateExited";
  readonly TaskFailed: "TaskFailed";
  readonly TaskScheduled: "TaskScheduled";
  readonly TaskStartFailed: "TaskStartFailed";
  readonly TaskStarted: "TaskStarted";
  readonly TaskStateAborted: "TaskStateAborted";
  readonly TaskStateEntered: "TaskStateEntered";
  readonly TaskStateExited: "TaskStateExited";
  readonly TaskSubmitFailed: "TaskSubmitFailed";
  readonly TaskSubmitted: "TaskSubmitted";
  readonly TaskSucceeded: "TaskSucceeded";
  readonly TaskTimedOut: "TaskTimedOut";
  readonly WaitStateAborted: "WaitStateAborted";
  readonly WaitStateEntered: "WaitStateEntered";
  readonly WaitStateExited: "WaitStateExited";
};
export type HistoryEventType =
  (typeof HistoryEventType)[keyof typeof HistoryEventType];
export interface HistoryEvent {
  timestamp: Date | undefined;
  type: HistoryEventType | undefined;
  id: number | undefined;
  previousEventId?: number | undefined;
  activityFailedEventDetails?: ActivityFailedEventDetails | undefined;
  activityScheduleFailedEventDetails?:
    | ActivityScheduleFailedEventDetails
    | undefined;
  activityScheduledEventDetails?: ActivityScheduledEventDetails | undefined;
  activityStartedEventDetails?: ActivityStartedEventDetails | undefined;
  activitySucceededEventDetails?: ActivitySucceededEventDetails | undefined;
  activityTimedOutEventDetails?: ActivityTimedOutEventDetails | undefined;
  taskFailedEventDetails?: TaskFailedEventDetails | undefined;
  taskScheduledEventDetails?: TaskScheduledEventDetails | undefined;
  taskStartFailedEventDetails?: TaskStartFailedEventDetails | undefined;
  taskStartedEventDetails?: TaskStartedEventDetails | undefined;
  taskSubmitFailedEventDetails?: TaskSubmitFailedEventDetails | undefined;
  taskSubmittedEventDetails?: TaskSubmittedEventDetails | undefined;
  taskSucceededEventDetails?: TaskSucceededEventDetails | undefined;
  taskTimedOutEventDetails?: TaskTimedOutEventDetails | undefined;
  executionFailedEventDetails?: ExecutionFailedEventDetails | undefined;
  executionStartedEventDetails?: ExecutionStartedEventDetails | undefined;
  executionSucceededEventDetails?: ExecutionSucceededEventDetails | undefined;
  executionAbortedEventDetails?: ExecutionAbortedEventDetails | undefined;
  executionTimedOutEventDetails?: ExecutionTimedOutEventDetails | undefined;
  executionRedrivenEventDetails?: ExecutionRedrivenEventDetails | undefined;
  mapStateStartedEventDetails?: MapStateStartedEventDetails | undefined;
  mapIterationStartedEventDetails?: MapIterationEventDetails | undefined;
  mapIterationSucceededEventDetails?: MapIterationEventDetails | undefined;
  mapIterationFailedEventDetails?: MapIterationEventDetails | undefined;
  mapIterationAbortedEventDetails?: MapIterationEventDetails | undefined;
  lambdaFunctionFailedEventDetails?:
    | LambdaFunctionFailedEventDetails
    | undefined;
  lambdaFunctionScheduleFailedEventDetails?:
    | LambdaFunctionScheduleFailedEventDetails
    | undefined;
  lambdaFunctionScheduledEventDetails?:
    | LambdaFunctionScheduledEventDetails
    | undefined;
  lambdaFunctionStartFailedEventDetails?:
    | LambdaFunctionStartFailedEventDetails
    | undefined;
  lambdaFunctionSucceededEventDetails?:
    | LambdaFunctionSucceededEventDetails
    | undefined;
  lambdaFunctionTimedOutEventDetails?:
    | LambdaFunctionTimedOutEventDetails
    | undefined;
  stateEnteredEventDetails?: StateEnteredEventDetails | undefined;
  stateExitedEventDetails?: StateExitedEventDetails | undefined;
  mapRunStartedEventDetails?: MapRunStartedEventDetails | undefined;
  mapRunFailedEventDetails?: MapRunFailedEventDetails | undefined;
  mapRunRedrivenEventDetails?: MapRunRedrivenEventDetails | undefined;
  evaluationFailedEventDetails?: EvaluationFailedEventDetails | undefined;
}
export interface GetExecutionHistoryOutput {
  events: HistoryEvent[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidToken extends __BaseException {
  readonly name: "InvalidToken";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidToken, __BaseException>);
}
export interface ListActivitiesInput {
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListActivitiesOutput {
  activities: ActivityListItem[] | undefined;
  nextToken?: string | undefined;
}
export declare const ExecutionRedriveFilter: {
  readonly NOT_REDRIVEN: "NOT_REDRIVEN";
  readonly REDRIVEN: "REDRIVEN";
};
export type ExecutionRedriveFilter =
  (typeof ExecutionRedriveFilter)[keyof typeof ExecutionRedriveFilter];
export interface ListExecutionsInput {
  stateMachineArn?: string | undefined;
  statusFilter?: ExecutionStatus | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
  mapRunArn?: string | undefined;
  redriveFilter?: ExecutionRedriveFilter | undefined;
}
export interface ExecutionListItem {
  executionArn: string | undefined;
  stateMachineArn: string | undefined;
  name: string | undefined;
  status: ExecutionStatus | undefined;
  startDate: Date | undefined;
  stopDate?: Date | undefined;
  mapRunArn?: string | undefined;
  itemCount?: number | undefined;
  stateMachineVersionArn?: string | undefined;
  stateMachineAliasArn?: string | undefined;
  redriveCount?: number | undefined;
  redriveDate?: Date | undefined;
}
export interface ListExecutionsOutput {
  executions: ExecutionListItem[] | undefined;
  nextToken?: string | undefined;
}
export interface ListMapRunsInput {
  executionArn: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface MapRunListItem {
  executionArn: string | undefined;
  mapRunArn: string | undefined;
  stateMachineArn: string | undefined;
  startDate: Date | undefined;
  stopDate?: Date | undefined;
}
export interface ListMapRunsOutput {
  mapRuns: MapRunListItem[] | undefined;
  nextToken?: string | undefined;
}
export interface ListStateMachineAliasesInput {
  stateMachineArn: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface StateMachineAliasListItem {
  stateMachineAliasArn: string | undefined;
  creationDate: Date | undefined;
}
export interface ListStateMachineAliasesOutput {
  stateMachineAliases: StateMachineAliasListItem[] | undefined;
  nextToken?: string | undefined;
}
export interface ListStateMachinesInput {
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface StateMachineListItem {
  stateMachineArn: string | undefined;
  name: string | undefined;
  type: StateMachineType | undefined;
  creationDate: Date | undefined;
}
export interface ListStateMachinesOutput {
  stateMachines: StateMachineListItem[] | undefined;
  nextToken?: string | undefined;
}
export interface ListStateMachineVersionsInput {
  stateMachineArn: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface StateMachineVersionListItem {
  stateMachineVersionArn: string | undefined;
  creationDate: Date | undefined;
}
export interface ListStateMachineVersionsOutput {
  stateMachineVersions: StateMachineVersionListItem[] | undefined;
  nextToken?: string | undefined;
}
export interface ListTagsForResourceInput {
  resourceArn: string | undefined;
}
export interface ListTagsForResourceOutput {
  tags?: Tag[] | undefined;
}
export interface PublishStateMachineVersionInput {
  stateMachineArn: string | undefined;
  revisionId?: string | undefined;
  description?: string | undefined;
}
export interface PublishStateMachineVersionOutput {
  creationDate: Date | undefined;
  stateMachineVersionArn: string | undefined;
}
export declare class ExecutionLimitExceeded extends __BaseException {
  readonly name: "ExecutionLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExecutionLimitExceeded, __BaseException>
  );
}
export declare class ExecutionNotRedrivable extends __BaseException {
  readonly name: "ExecutionNotRedrivable";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExecutionNotRedrivable, __BaseException>
  );
}
export interface RedriveExecutionInput {
  executionArn: string | undefined;
  clientToken?: string | undefined;
}
export interface RedriveExecutionOutput {
  redriveDate: Date | undefined;
}
export interface SendTaskFailureInput {
  taskToken: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
}
export interface SendTaskFailureOutput {}
export declare class TaskDoesNotExist extends __BaseException {
  readonly name: "TaskDoesNotExist";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<TaskDoesNotExist, __BaseException>);
}
export declare class TaskTimedOut extends __BaseException {
  readonly name: "TaskTimedOut";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<TaskTimedOut, __BaseException>);
}
export interface SendTaskHeartbeatInput {
  taskToken: string | undefined;
}
export interface SendTaskHeartbeatOutput {}
export declare class InvalidOutput extends __BaseException {
  readonly name: "InvalidOutput";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidOutput, __BaseException>);
}
export interface SendTaskSuccessInput {
  taskToken: string | undefined;
  output: string | undefined;
}
export interface SendTaskSuccessOutput {}
export declare class ExecutionAlreadyExists extends __BaseException {
  readonly name: "ExecutionAlreadyExists";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExecutionAlreadyExists, __BaseException>
  );
}
export declare class InvalidExecutionInput extends __BaseException {
  readonly name: "InvalidExecutionInput";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExecutionInput, __BaseException>
  );
}
export interface StartExecutionInput {
  stateMachineArn: string | undefined;
  name?: string | undefined;
  input?: string | undefined;
  traceHeader?: string | undefined;
}
export interface StartExecutionOutput {
  executionArn: string | undefined;
  startDate: Date | undefined;
}
export interface StartSyncExecutionInput {
  stateMachineArn: string | undefined;
  name?: string | undefined;
  input?: string | undefined;
  traceHeader?: string | undefined;
  includedData?: IncludedData | undefined;
}
export interface BillingDetails {
  billedMemoryUsedInMB?: number | undefined;
  billedDurationInMilliseconds?: number | undefined;
}
export declare const SyncExecutionStatus: {
  readonly FAILED: "FAILED";
  readonly SUCCEEDED: "SUCCEEDED";
  readonly TIMED_OUT: "TIMED_OUT";
};
export type SyncExecutionStatus =
  (typeof SyncExecutionStatus)[keyof typeof SyncExecutionStatus];
export interface StartSyncExecutionOutput {
  executionArn: string | undefined;
  stateMachineArn?: string | undefined;
  name?: string | undefined;
  startDate: Date | undefined;
  stopDate: Date | undefined;
  status: SyncExecutionStatus | undefined;
  error?: string | undefined;
  cause?: string | undefined;
  input?: string | undefined;
  inputDetails?: CloudWatchEventsExecutionDataDetails | undefined;
  output?: string | undefined;
  outputDetails?: CloudWatchEventsExecutionDataDetails | undefined;
  traceHeader?: string | undefined;
  billingDetails?: BillingDetails | undefined;
}
export interface StopExecutionInput {
  executionArn: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
}
export interface StopExecutionOutput {
  stopDate: Date | undefined;
}
export interface TagResourceInput {
  resourceArn: string | undefined;
  tags: Tag[] | undefined;
}
export interface TagResourceOutput {}
export declare const InspectionLevel: {
  readonly DEBUG: "DEBUG";
  readonly INFO: "INFO";
  readonly TRACE: "TRACE";
};
export type InspectionLevel =
  (typeof InspectionLevel)[keyof typeof InspectionLevel];
export interface TestStateInput {
  definition: string | undefined;
  roleArn?: string | undefined;
  input?: string | undefined;
  inspectionLevel?: InspectionLevel | undefined;
  revealSecrets?: boolean | undefined;
  variables?: string | undefined;
}
export interface InspectionDataRequest {
  protocol?: string | undefined;
  method?: string | undefined;
  url?: string | undefined;
  headers?: string | undefined;
  body?: string | undefined;
}
export interface InspectionDataResponse {
  protocol?: string | undefined;
  statusCode?: string | undefined;
  statusMessage?: string | undefined;
  headers?: string | undefined;
  body?: string | undefined;
}
export interface InspectionData {
  input?: string | undefined;
  afterArguments?: string | undefined;
  afterInputPath?: string | undefined;
  afterParameters?: string | undefined;
  result?: string | undefined;
  afterResultSelector?: string | undefined;
  afterResultPath?: string | undefined;
  request?: InspectionDataRequest | undefined;
  response?: InspectionDataResponse | undefined;
  variables?: string | undefined;
}
export declare const TestExecutionStatus: {
  readonly CAUGHT_ERROR: "CAUGHT_ERROR";
  readonly FAILED: "FAILED";
  readonly RETRIABLE: "RETRIABLE";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type TestExecutionStatus =
  (typeof TestExecutionStatus)[keyof typeof TestExecutionStatus];
export interface TestStateOutput {
  output?: string | undefined;
  error?: string | undefined;
  cause?: string | undefined;
  inspectionData?: InspectionData | undefined;
  nextState?: string | undefined;
  status?: TestExecutionStatus | undefined;
}
export interface UntagResourceInput {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export interface UntagResourceOutput {}
export interface UpdateMapRunInput {
  mapRunArn: string | undefined;
  maxConcurrency?: number | undefined;
  toleratedFailurePercentage?: number | undefined;
  toleratedFailureCount?: number | undefined;
}
export interface UpdateMapRunOutput {}
export declare class MissingRequiredParameter extends __BaseException {
  readonly name: "MissingRequiredParameter";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MissingRequiredParameter, __BaseException>
  );
}
export interface UpdateStateMachineInput {
  stateMachineArn: string | undefined;
  definition?: string | undefined;
  roleArn?: string | undefined;
  loggingConfiguration?: LoggingConfiguration | undefined;
  tracingConfiguration?: TracingConfiguration | undefined;
  publish?: boolean | undefined;
  versionDescription?: string | undefined;
  encryptionConfiguration?: EncryptionConfiguration | undefined;
}
export interface UpdateStateMachineOutput {
  updateDate: Date | undefined;
  revisionId?: string | undefined;
  stateMachineVersionArn?: string | undefined;
}
export interface UpdateStateMachineAliasInput {
  stateMachineAliasArn: string | undefined;
  description?: string | undefined;
  routingConfiguration?: RoutingConfigurationListItem[] | undefined;
}
export interface UpdateStateMachineAliasOutput {
  updateDate: Date | undefined;
}
export declare const ValidateStateMachineDefinitionSeverity: {
  readonly ERROR: "ERROR";
  readonly WARNING: "WARNING";
};
export type ValidateStateMachineDefinitionSeverity =
  (typeof ValidateStateMachineDefinitionSeverity)[keyof typeof ValidateStateMachineDefinitionSeverity];
export interface ValidateStateMachineDefinitionInput {
  definition: string | undefined;
  type?: StateMachineType | undefined;
  severity?: ValidateStateMachineDefinitionSeverity | undefined;
  maxResults?: number | undefined;
}
export interface ValidateStateMachineDefinitionDiagnostic {
  severity: ValidateStateMachineDefinitionSeverity | undefined;
  code: string | undefined;
  message: string | undefined;
  location?: string | undefined;
}
export declare const ValidateStateMachineDefinitionResultCode: {
  readonly FAIL: "FAIL";
  readonly OK: "OK";
};
export type ValidateStateMachineDefinitionResultCode =
  (typeof ValidateStateMachineDefinitionResultCode)[keyof typeof ValidateStateMachineDefinitionResultCode];
export interface ValidateStateMachineDefinitionOutput {
  result: ValidateStateMachineDefinitionResultCode | undefined;
  diagnostics: ValidateStateMachineDefinitionDiagnostic[] | undefined;
  truncated?: boolean | undefined;
}
export declare const ActivityFailedEventDetailsFilterSensitiveLog: (
  obj: ActivityFailedEventDetails
) => any;
export declare const ActivityScheduledEventDetailsFilterSensitiveLog: (
  obj: ActivityScheduledEventDetails
) => any;
export declare const ActivityScheduleFailedEventDetailsFilterSensitiveLog: (
  obj: ActivityScheduleFailedEventDetails
) => any;
export declare const ActivitySucceededEventDetailsFilterSensitiveLog: (
  obj: ActivitySucceededEventDetails
) => any;
export declare const ActivityTimedOutEventDetailsFilterSensitiveLog: (
  obj: ActivityTimedOutEventDetails
) => any;
export declare const CreateStateMachineInputFilterSensitiveLog: (
  obj: CreateStateMachineInput
) => any;
export declare const CreateStateMachineAliasInputFilterSensitiveLog: (
  obj: CreateStateMachineAliasInput
) => any;
export declare const DescribeExecutionOutputFilterSensitiveLog: (
  obj: DescribeExecutionOutput
) => any;
export declare const DescribeStateMachineOutputFilterSensitiveLog: (
  obj: DescribeStateMachineOutput
) => any;
export declare const DescribeStateMachineAliasOutputFilterSensitiveLog: (
  obj: DescribeStateMachineAliasOutput
) => any;
export declare const DescribeStateMachineForExecutionOutputFilterSensitiveLog: (
  obj: DescribeStateMachineForExecutionOutput
) => any;
export declare const GetActivityTaskOutputFilterSensitiveLog: (
  obj: GetActivityTaskOutput
) => any;
export declare const EvaluationFailedEventDetailsFilterSensitiveLog: (
  obj: EvaluationFailedEventDetails
) => any;
export declare const ExecutionAbortedEventDetailsFilterSensitiveLog: (
  obj: ExecutionAbortedEventDetails
) => any;
export declare const ExecutionFailedEventDetailsFilterSensitiveLog: (
  obj: ExecutionFailedEventDetails
) => any;
export declare const ExecutionStartedEventDetailsFilterSensitiveLog: (
  obj: ExecutionStartedEventDetails
) => any;
export declare const ExecutionSucceededEventDetailsFilterSensitiveLog: (
  obj: ExecutionSucceededEventDetails
) => any;
export declare const ExecutionTimedOutEventDetailsFilterSensitiveLog: (
  obj: ExecutionTimedOutEventDetails
) => any;
export declare const LambdaFunctionFailedEventDetailsFilterSensitiveLog: (
  obj: LambdaFunctionFailedEventDetails
) => any;
export declare const LambdaFunctionScheduledEventDetailsFilterSensitiveLog: (
  obj: LambdaFunctionScheduledEventDetails
) => any;
export declare const LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog: (
  obj: LambdaFunctionScheduleFailedEventDetails
) => any;
export declare const LambdaFunctionStartFailedEventDetailsFilterSensitiveLog: (
  obj: LambdaFunctionStartFailedEventDetails
) => any;
export declare const LambdaFunctionSucceededEventDetailsFilterSensitiveLog: (
  obj: LambdaFunctionSucceededEventDetails
) => any;
export declare const LambdaFunctionTimedOutEventDetailsFilterSensitiveLog: (
  obj: LambdaFunctionTimedOutEventDetails
) => any;
export declare const MapRunFailedEventDetailsFilterSensitiveLog: (
  obj: MapRunFailedEventDetails
) => any;
export declare const StateEnteredEventDetailsFilterSensitiveLog: (
  obj: StateEnteredEventDetails
) => any;
export declare const StateExitedEventDetailsFilterSensitiveLog: (
  obj: StateExitedEventDetails
) => any;
export declare const TaskFailedEventDetailsFilterSensitiveLog: (
  obj: TaskFailedEventDetails
) => any;
export declare const TaskScheduledEventDetailsFilterSensitiveLog: (
  obj: TaskScheduledEventDetails
) => any;
export declare const TaskStartFailedEventDetailsFilterSensitiveLog: (
  obj: TaskStartFailedEventDetails
) => any;
export declare const TaskSubmitFailedEventDetailsFilterSensitiveLog: (
  obj: TaskSubmitFailedEventDetails
) => any;
export declare const TaskSubmittedEventDetailsFilterSensitiveLog: (
  obj: TaskSubmittedEventDetails
) => any;
export declare const TaskSucceededEventDetailsFilterSensitiveLog: (
  obj: TaskSucceededEventDetails
) => any;
export declare const TaskTimedOutEventDetailsFilterSensitiveLog: (
  obj: TaskTimedOutEventDetails
) => any;
export declare const HistoryEventFilterSensitiveLog: (obj: HistoryEvent) => any;
export declare const GetExecutionHistoryOutputFilterSensitiveLog: (
  obj: GetExecutionHistoryOutput
) => any;
export declare const PublishStateMachineVersionInputFilterSensitiveLog: (
  obj: PublishStateMachineVersionInput
) => any;
export declare const SendTaskFailureInputFilterSensitiveLog: (
  obj: SendTaskFailureInput
) => any;
export declare const SendTaskSuccessInputFilterSensitiveLog: (
  obj: SendTaskSuccessInput
) => any;
export declare const StartExecutionInputFilterSensitiveLog: (
  obj: StartExecutionInput
) => any;
export declare const StartSyncExecutionInputFilterSensitiveLog: (
  obj: StartSyncExecutionInput
) => any;
export declare const StartSyncExecutionOutputFilterSensitiveLog: (
  obj: StartSyncExecutionOutput
) => any;
export declare const StopExecutionInputFilterSensitiveLog: (
  obj: StopExecutionInput
) => any;
export declare const TestStateInputFilterSensitiveLog: (
  obj: TestStateInput
) => any;
export declare const InspectionDataFilterSensitiveLog: (
  obj: InspectionData
) => any;
export declare const TestStateOutputFilterSensitiveLog: (
  obj: TestStateOutput
) => any;
export declare const UpdateStateMachineInputFilterSensitiveLog: (
  obj: UpdateStateMachineInput
) => any;
export declare const UpdateStateMachineAliasInputFilterSensitiveLog: (
  obj: UpdateStateMachineAliasInput
) => any;
export declare const ValidateStateMachineDefinitionInputFilterSensitiveLog: (
  obj: ValidateStateMachineDefinitionInput
) => any;
export declare const ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog: (
  obj: ValidateStateMachineDefinitionDiagnostic
) => any;
export declare const ValidateStateMachineDefinitionOutputFilterSensitiveLog: (
  obj: ValidateStateMachineDefinitionOutput
) => any;
