"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AddPermissionCommand: () => AddPermissionCommand,
  AuthorizationErrorException: () => AuthorizationErrorException,
  BatchEntryIdsNotDistinctException: () => BatchEntryIdsNotDistinctException,
  BatchRequestTooLongException: () => BatchRequestTooLongException,
  CheckIfPhoneNumberIsOptedOutCommand: () => CheckIfPhoneNumberIsOptedOutCommand,
  CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog: () => CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog,
  ConcurrentAccessException: () => ConcurrentAccessException,
  ConfirmSubscriptionCommand: () => ConfirmSubscriptionCommand,
  CreatePlatformApplicationCommand: () => CreatePlatformApplicationCommand,
  CreatePlatformEndpointCommand: () => CreatePlatformEndpointCommand,
  CreateSMSSandboxPhoneNumberCommand: () => CreateSMSSandboxPhoneNumberCommand,
  CreateSMSSandboxPhoneNumberInputFilterSensitiveLog: () => CreateSMSSandboxPhoneNumberInputFilterSensitiveLog,
  CreateTopicCommand: () => CreateTopicCommand,
  DeleteEndpointCommand: () => DeleteEndpointCommand,
  DeletePlatformApplicationCommand: () => DeletePlatformApplicationCommand,
  DeleteSMSSandboxPhoneNumberCommand: () => DeleteSMSSandboxPhoneNumberCommand,
  DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog: () => DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog,
  DeleteTopicCommand: () => DeleteTopicCommand,
  EmptyBatchRequestException: () => EmptyBatchRequestException,
  EndpointDisabledException: () => EndpointDisabledException,
  FilterPolicyLimitExceededException: () => FilterPolicyLimitExceededException,
  GetDataProtectionPolicyCommand: () => GetDataProtectionPolicyCommand,
  GetEndpointAttributesCommand: () => GetEndpointAttributesCommand,
  GetPlatformApplicationAttributesCommand: () => GetPlatformApplicationAttributesCommand,
  GetSMSAttributesCommand: () => GetSMSAttributesCommand,
  GetSMSSandboxAccountStatusCommand: () => GetSMSSandboxAccountStatusCommand,
  GetSubscriptionAttributesCommand: () => GetSubscriptionAttributesCommand,
  GetTopicAttributesCommand: () => GetTopicAttributesCommand,
  InternalErrorException: () => InternalErrorException,
  InvalidBatchEntryIdException: () => InvalidBatchEntryIdException,
  InvalidParameterException: () => InvalidParameterException,
  InvalidParameterValueException: () => InvalidParameterValueException,
  InvalidSecurityException: () => InvalidSecurityException,
  InvalidStateException: () => InvalidStateException,
  KMSAccessDeniedException: () => KMSAccessDeniedException,
  KMSDisabledException: () => KMSDisabledException,
  KMSInvalidStateException: () => KMSInvalidStateException,
  KMSNotFoundException: () => KMSNotFoundException,
  KMSOptInRequired: () => KMSOptInRequired,
  KMSThrottlingException: () => KMSThrottlingException,
  LanguageCodeString: () => LanguageCodeString,
  ListEndpointsByPlatformApplicationCommand: () => ListEndpointsByPlatformApplicationCommand,
  ListOriginationNumbersCommand: () => ListOriginationNumbersCommand,
  ListOriginationNumbersResultFilterSensitiveLog: () => ListOriginationNumbersResultFilterSensitiveLog,
  ListPhoneNumbersOptedOutCommand: () => ListPhoneNumbersOptedOutCommand,
  ListPhoneNumbersOptedOutResponseFilterSensitiveLog: () => ListPhoneNumbersOptedOutResponseFilterSensitiveLog,
  ListPlatformApplicationsCommand: () => ListPlatformApplicationsCommand,
  ListSMSSandboxPhoneNumbersCommand: () => ListSMSSandboxPhoneNumbersCommand,
  ListSMSSandboxPhoneNumbersResultFilterSensitiveLog: () => ListSMSSandboxPhoneNumbersResultFilterSensitiveLog,
  ListSubscriptionsByTopicCommand: () => ListSubscriptionsByTopicCommand,
  ListSubscriptionsCommand: () => ListSubscriptionsCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  ListTopicsCommand: () => ListTopicsCommand,
  NotFoundException: () => NotFoundException,
  NumberCapability: () => NumberCapability,
  OptInPhoneNumberCommand: () => OptInPhoneNumberCommand,
  OptInPhoneNumberInputFilterSensitiveLog: () => OptInPhoneNumberInputFilterSensitiveLog,
  OptedOutException: () => OptedOutException,
  PhoneNumberInformationFilterSensitiveLog: () => PhoneNumberInformationFilterSensitiveLog,
  PlatformApplicationDisabledException: () => PlatformApplicationDisabledException,
  PublishBatchCommand: () => PublishBatchCommand,
  PublishCommand: () => PublishCommand,
  PublishInputFilterSensitiveLog: () => PublishInputFilterSensitiveLog,
  PutDataProtectionPolicyCommand: () => PutDataProtectionPolicyCommand,
  RemovePermissionCommand: () => RemovePermissionCommand,
  ReplayLimitExceededException: () => ReplayLimitExceededException,
  ResourceNotFoundException: () => ResourceNotFoundException,
  RouteType: () => RouteType,
  SMSSandboxPhoneNumberFilterSensitiveLog: () => SMSSandboxPhoneNumberFilterSensitiveLog,
  SMSSandboxPhoneNumberVerificationStatus: () => SMSSandboxPhoneNumberVerificationStatus,
  SNS: () => SNS,
  SNSClient: () => SNSClient,
  SNSServiceException: () => SNSServiceException,
  SetEndpointAttributesCommand: () => SetEndpointAttributesCommand,
  SetPlatformApplicationAttributesCommand: () => SetPlatformApplicationAttributesCommand,
  SetSMSAttributesCommand: () => SetSMSAttributesCommand,
  SetSubscriptionAttributesCommand: () => SetSubscriptionAttributesCommand,
  SetTopicAttributesCommand: () => SetTopicAttributesCommand,
  StaleTagException: () => StaleTagException,
  SubscribeCommand: () => SubscribeCommand,
  SubscriptionLimitExceededException: () => SubscriptionLimitExceededException,
  TagLimitExceededException: () => TagLimitExceededException,
  TagPolicyException: () => TagPolicyException,
  TagResourceCommand: () => TagResourceCommand,
  ThrottledException: () => ThrottledException,
  TooManyEntriesInBatchRequestException: () => TooManyEntriesInBatchRequestException,
  TopicLimitExceededException: () => TopicLimitExceededException,
  UnsubscribeCommand: () => UnsubscribeCommand,
  UntagResourceCommand: () => UntagResourceCommand,
  UserErrorException: () => UserErrorException,
  ValidationException: () => ValidationException,
  VerificationException: () => VerificationException,
  VerifySMSSandboxPhoneNumberCommand: () => VerifySMSSandboxPhoneNumberCommand,
  VerifySMSSandboxPhoneNumberInputFilterSensitiveLog: () => VerifySMSSandboxPhoneNumberInputFilterSensitiveLog,
  __Client: () => import_smithy_client.Client,
  paginateListEndpointsByPlatformApplication: () => paginateListEndpointsByPlatformApplication,
  paginateListOriginationNumbers: () => paginateListOriginationNumbers,
  paginateListPhoneNumbersOptedOut: () => paginateListPhoneNumbersOptedOut,
  paginateListPlatformApplications: () => paginateListPlatformApplications,
  paginateListSMSSandboxPhoneNumbers: () => paginateListSMSSandboxPhoneNumbers,
  paginateListSubscriptions: () => paginateListSubscriptions,
  paginateListSubscriptionsByTopic: () => paginateListSubscriptionsByTopic,
  paginateListTopics: () => paginateListTopics
});
module.exports = __toCommonJS(index_exports);

// src/SNSClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "sns"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/SNSClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/SNSClient.ts
var SNSClient = class extends import_smithy_client.Client {
  static {
    __name(this, "SNSClient");
  }
  /**
   * The resolved configuration of SNSClient class. This is resolved and normalized from the {@link SNSClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultSNSHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/SNS.ts


// src/commands/AddPermissionCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_query.ts
var import_core2 = require("@aws-sdk/core");



// src/models/models_0.ts


// src/models/SNSServiceException.ts

var SNSServiceException = class _SNSServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "SNSServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _SNSServiceException.prototype);
  }
};

// src/models/models_0.ts
var AuthorizationErrorException = class _AuthorizationErrorException extends SNSServiceException {
  static {
    __name(this, "AuthorizationErrorException");
  }
  name = "AuthorizationErrorException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AuthorizationErrorException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AuthorizationErrorException.prototype);
  }
};
var InternalErrorException = class _InternalErrorException extends SNSServiceException {
  static {
    __name(this, "InternalErrorException");
  }
  name = "InternalErrorException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InternalErrorException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _InternalErrorException.prototype);
  }
};
var InvalidParameterException = class _InvalidParameterException extends SNSServiceException {
  static {
    __name(this, "InvalidParameterException");
  }
  name = "InvalidParameterException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParameterException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidParameterException.prototype);
  }
};
var NotFoundException = class _NotFoundException extends SNSServiceException {
  static {
    __name(this, "NotFoundException");
  }
  name = "NotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NotFoundException.prototype);
  }
};
var ThrottledException = class _ThrottledException extends SNSServiceException {
  static {
    __name(this, "ThrottledException");
  }
  name = "ThrottledException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ThrottledException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ThrottledException.prototype);
  }
};
var FilterPolicyLimitExceededException = class _FilterPolicyLimitExceededException extends SNSServiceException {
  static {
    __name(this, "FilterPolicyLimitExceededException");
  }
  name = "FilterPolicyLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FilterPolicyLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FilterPolicyLimitExceededException.prototype);
  }
};
var ReplayLimitExceededException = class _ReplayLimitExceededException extends SNSServiceException {
  static {
    __name(this, "ReplayLimitExceededException");
  }
  name = "ReplayLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReplayLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReplayLimitExceededException.prototype);
  }
};
var SubscriptionLimitExceededException = class _SubscriptionLimitExceededException extends SNSServiceException {
  static {
    __name(this, "SubscriptionLimitExceededException");
  }
  name = "SubscriptionLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SubscriptionLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SubscriptionLimitExceededException.prototype);
  }
};
var LanguageCodeString = {
  de_DE: "de-DE",
  en_GB: "en-GB",
  en_US: "en-US",
  es_419: "es-419",
  es_ES: "es-ES",
  fr_CA: "fr-CA",
  fr_FR: "fr-FR",
  it_IT: "it-IT",
  jp_JP: "ja-JP",
  kr_KR: "kr-KR",
  pt_BR: "pt-BR",
  zh_CN: "zh-CN",
  zh_TW: "zh-TW"
};
var OptedOutException = class _OptedOutException extends SNSServiceException {
  static {
    __name(this, "OptedOutException");
  }
  name = "OptedOutException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OptedOutException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OptedOutException.prototype);
  }
};
var UserErrorException = class _UserErrorException extends SNSServiceException {
  static {
    __name(this, "UserErrorException");
  }
  name = "UserErrorException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UserErrorException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UserErrorException.prototype);
  }
};
var ConcurrentAccessException = class _ConcurrentAccessException extends SNSServiceException {
  static {
    __name(this, "ConcurrentAccessException");
  }
  name = "ConcurrentAccessException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConcurrentAccessException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ConcurrentAccessException.prototype);
  }
};
var InvalidSecurityException = class _InvalidSecurityException extends SNSServiceException {
  static {
    __name(this, "InvalidSecurityException");
  }
  name = "InvalidSecurityException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidSecurityException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidSecurityException.prototype);
  }
};
var StaleTagException = class _StaleTagException extends SNSServiceException {
  static {
    __name(this, "StaleTagException");
  }
  name = "StaleTagException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StaleTagException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StaleTagException.prototype);
  }
};
var TagLimitExceededException = class _TagLimitExceededException extends SNSServiceException {
  static {
    __name(this, "TagLimitExceededException");
  }
  name = "TagLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TagLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TagLimitExceededException.prototype);
  }
};
var TagPolicyException = class _TagPolicyException extends SNSServiceException {
  static {
    __name(this, "TagPolicyException");
  }
  name = "TagPolicyException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TagPolicyException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TagPolicyException.prototype);
  }
};
var TopicLimitExceededException = class _TopicLimitExceededException extends SNSServiceException {
  static {
    __name(this, "TopicLimitExceededException");
  }
  name = "TopicLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TopicLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TopicLimitExceededException.prototype);
  }
};
var ResourceNotFoundException = class _ResourceNotFoundException extends SNSServiceException {
  static {
    __name(this, "ResourceNotFoundException");
  }
  name = "ResourceNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
  }
};
var InvalidStateException = class _InvalidStateException extends SNSServiceException {
  static {
    __name(this, "InvalidStateException");
  }
  name = "InvalidStateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidStateException.prototype);
  }
};
var NumberCapability = {
  MMS: "MMS",
  SMS: "SMS",
  VOICE: "VOICE"
};
var RouteType = {
  Premium: "Premium",
  Promotional: "Promotional",
  Transactional: "Transactional"
};
var ValidationException = class _ValidationException extends SNSServiceException {
  static {
    __name(this, "ValidationException");
  }
  name = "ValidationException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ValidationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ValidationException.prototype);
    this.Message = opts.Message;
  }
};
var SMSSandboxPhoneNumberVerificationStatus = {
  Pending: "Pending",
  Verified: "Verified"
};
var EndpointDisabledException = class _EndpointDisabledException extends SNSServiceException {
  static {
    __name(this, "EndpointDisabledException");
  }
  name = "EndpointDisabledException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EndpointDisabledException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EndpointDisabledException.prototype);
  }
};
var InvalidParameterValueException = class _InvalidParameterValueException extends SNSServiceException {
  static {
    __name(this, "InvalidParameterValueException");
  }
  name = "InvalidParameterValueException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParameterValueException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidParameterValueException.prototype);
  }
};
var KMSAccessDeniedException = class _KMSAccessDeniedException extends SNSServiceException {
  static {
    __name(this, "KMSAccessDeniedException");
  }
  name = "KMSAccessDeniedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSAccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSAccessDeniedException.prototype);
  }
};
var KMSDisabledException = class _KMSDisabledException extends SNSServiceException {
  static {
    __name(this, "KMSDisabledException");
  }
  name = "KMSDisabledException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSDisabledException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSDisabledException.prototype);
  }
};
var KMSInvalidStateException = class _KMSInvalidStateException extends SNSServiceException {
  static {
    __name(this, "KMSInvalidStateException");
  }
  name = "KMSInvalidStateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSInvalidStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSInvalidStateException.prototype);
  }
};
var KMSNotFoundException = class _KMSNotFoundException extends SNSServiceException {
  static {
    __name(this, "KMSNotFoundException");
  }
  name = "KMSNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSNotFoundException.prototype);
  }
};
var KMSOptInRequired = class _KMSOptInRequired extends SNSServiceException {
  static {
    __name(this, "KMSOptInRequired");
  }
  name = "KMSOptInRequired";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSOptInRequired",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSOptInRequired.prototype);
  }
};
var KMSThrottlingException = class _KMSThrottlingException extends SNSServiceException {
  static {
    __name(this, "KMSThrottlingException");
  }
  name = "KMSThrottlingException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSThrottlingException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSThrottlingException.prototype);
  }
};
var PlatformApplicationDisabledException = class _PlatformApplicationDisabledException extends SNSServiceException {
  static {
    __name(this, "PlatformApplicationDisabledException");
  }
  name = "PlatformApplicationDisabledException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PlatformApplicationDisabledException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PlatformApplicationDisabledException.prototype);
  }
};
var BatchEntryIdsNotDistinctException = class _BatchEntryIdsNotDistinctException extends SNSServiceException {
  static {
    __name(this, "BatchEntryIdsNotDistinctException");
  }
  name = "BatchEntryIdsNotDistinctException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BatchEntryIdsNotDistinctException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BatchEntryIdsNotDistinctException.prototype);
  }
};
var BatchRequestTooLongException = class _BatchRequestTooLongException extends SNSServiceException {
  static {
    __name(this, "BatchRequestTooLongException");
  }
  name = "BatchRequestTooLongException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BatchRequestTooLongException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BatchRequestTooLongException.prototype);
  }
};
var EmptyBatchRequestException = class _EmptyBatchRequestException extends SNSServiceException {
  static {
    __name(this, "EmptyBatchRequestException");
  }
  name = "EmptyBatchRequestException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EmptyBatchRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EmptyBatchRequestException.prototype);
  }
};
var InvalidBatchEntryIdException = class _InvalidBatchEntryIdException extends SNSServiceException {
  static {
    __name(this, "InvalidBatchEntryIdException");
  }
  name = "InvalidBatchEntryIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidBatchEntryIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidBatchEntryIdException.prototype);
  }
};
var TooManyEntriesInBatchRequestException = class _TooManyEntriesInBatchRequestException extends SNSServiceException {
  static {
    __name(this, "TooManyEntriesInBatchRequestException");
  }
  name = "TooManyEntriesInBatchRequestException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyEntriesInBatchRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyEntriesInBatchRequestException.prototype);
  }
};
var VerificationException = class _VerificationException extends SNSServiceException {
  static {
    __name(this, "VerificationException");
  }
  name = "VerificationException";
  $fault = "client";
  Message;
  /**
   * <p>The status of the verification error.</p>
   * @public
   */
  Status;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "VerificationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _VerificationException.prototype);
    this.Message = opts.Message;
    this.Status = opts.Status;
  }
};
var CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.phoneNumber && { phoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog");
var CreateSMSSandboxPhoneNumberInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumber && { PhoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "CreateSMSSandboxPhoneNumberInputFilterSensitiveLog");
var DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumber && { PhoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog");
var PhoneNumberInformationFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumber && { PhoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "PhoneNumberInformationFilterSensitiveLog");
var ListOriginationNumbersResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumbers && {
    PhoneNumbers: obj.PhoneNumbers.map((item) => PhoneNumberInformationFilterSensitiveLog(item))
  }
}), "ListOriginationNumbersResultFilterSensitiveLog");
var ListPhoneNumbersOptedOutResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.phoneNumbers && { phoneNumbers: import_smithy_client.SENSITIVE_STRING }
}), "ListPhoneNumbersOptedOutResponseFilterSensitiveLog");
var SMSSandboxPhoneNumberFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumber && { PhoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "SMSSandboxPhoneNumberFilterSensitiveLog");
var ListSMSSandboxPhoneNumbersResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumbers && {
    PhoneNumbers: obj.PhoneNumbers.map((item) => SMSSandboxPhoneNumberFilterSensitiveLog(item))
  }
}), "ListSMSSandboxPhoneNumbersResultFilterSensitiveLog");
var OptInPhoneNumberInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.phoneNumber && { phoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "OptInPhoneNumberInputFilterSensitiveLog");
var PublishInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumber && { PhoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "PublishInputFilterSensitiveLog");
var VerifySMSSandboxPhoneNumberInputFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PhoneNumber && { PhoneNumber: import_smithy_client.SENSITIVE_STRING }
}), "VerifySMSSandboxPhoneNumberInputFilterSensitiveLog");

// src/protocols/Aws_query.ts
var se_AddPermissionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_AddPermissionInput(input, context),
    [_A]: _AP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AddPermissionCommand");
var se_CheckIfPhoneNumberIsOptedOutCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CheckIfPhoneNumberIsOptedOutInput(input, context),
    [_A]: _CIPNIOO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CheckIfPhoneNumberIsOptedOutCommand");
var se_ConfirmSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ConfirmSubscriptionInput(input, context),
    [_A]: _CS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ConfirmSubscriptionCommand");
var se_CreatePlatformApplicationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreatePlatformApplicationInput(input, context),
    [_A]: _CPA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreatePlatformApplicationCommand");
var se_CreatePlatformEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreatePlatformEndpointInput(input, context),
    [_A]: _CPE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreatePlatformEndpointCommand");
var se_CreateSMSSandboxPhoneNumberCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateSMSSandboxPhoneNumberInput(input, context),
    [_A]: _CSMSSPN,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateSMSSandboxPhoneNumberCommand");
var se_CreateTopicCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateTopicInput(input, context),
    [_A]: _CT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateTopicCommand");
var se_DeleteEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteEndpointInput(input, context),
    [_A]: _DE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteEndpointCommand");
var se_DeletePlatformApplicationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeletePlatformApplicationInput(input, context),
    [_A]: _DPA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeletePlatformApplicationCommand");
var se_DeleteSMSSandboxPhoneNumberCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteSMSSandboxPhoneNumberInput(input, context),
    [_A]: _DSMSSPN,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteSMSSandboxPhoneNumberCommand");
var se_DeleteTopicCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteTopicInput(input, context),
    [_A]: _DT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteTopicCommand");
var se_GetDataProtectionPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetDataProtectionPolicyInput(input, context),
    [_A]: _GDPP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetDataProtectionPolicyCommand");
var se_GetEndpointAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetEndpointAttributesInput(input, context),
    [_A]: _GEA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetEndpointAttributesCommand");
var se_GetPlatformApplicationAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetPlatformApplicationAttributesInput(input, context),
    [_A]: _GPAA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPlatformApplicationAttributesCommand");
var se_GetSMSAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetSMSAttributesInput(input, context),
    [_A]: _GSMSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetSMSAttributesCommand");
var se_GetSMSSandboxAccountStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetSMSSandboxAccountStatusInput(input, context),
    [_A]: _GSMSSAS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetSMSSandboxAccountStatusCommand");
var se_GetSubscriptionAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetSubscriptionAttributesInput(input, context),
    [_A]: _GSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetSubscriptionAttributesCommand");
var se_GetTopicAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetTopicAttributesInput(input, context),
    [_A]: _GTA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetTopicAttributesCommand");
var se_ListEndpointsByPlatformApplicationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListEndpointsByPlatformApplicationInput(input, context),
    [_A]: _LEBPA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListEndpointsByPlatformApplicationCommand");
var se_ListOriginationNumbersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListOriginationNumbersRequest(input, context),
    [_A]: _LON,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListOriginationNumbersCommand");
var se_ListPhoneNumbersOptedOutCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListPhoneNumbersOptedOutInput(input, context),
    [_A]: _LPNOO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListPhoneNumbersOptedOutCommand");
var se_ListPlatformApplicationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListPlatformApplicationsInput(input, context),
    [_A]: _LPA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListPlatformApplicationsCommand");
var se_ListSMSSandboxPhoneNumbersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListSMSSandboxPhoneNumbersInput(input, context),
    [_A]: _LSMSSPN,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListSMSSandboxPhoneNumbersCommand");
var se_ListSubscriptionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListSubscriptionsInput(input, context),
    [_A]: _LS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListSubscriptionsCommand");
var se_ListSubscriptionsByTopicCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListSubscriptionsByTopicInput(input, context),
    [_A]: _LSBT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListSubscriptionsByTopicCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListTagsForResourceRequest(input, context),
    [_A]: _LTFR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_ListTopicsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListTopicsInput(input, context),
    [_A]: _LT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTopicsCommand");
var se_OptInPhoneNumberCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_OptInPhoneNumberInput(input, context),
    [_A]: _OIPN,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_OptInPhoneNumberCommand");
var se_PublishCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PublishInput(input, context),
    [_A]: _P,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PublishCommand");
var se_PublishBatchCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PublishBatchInput(input, context),
    [_A]: _PB,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PublishBatchCommand");
var se_PutDataProtectionPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PutDataProtectionPolicyInput(input, context),
    [_A]: _PDPP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutDataProtectionPolicyCommand");
var se_RemovePermissionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RemovePermissionInput(input, context),
    [_A]: _RP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemovePermissionCommand");
var se_SetEndpointAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetEndpointAttributesInput(input, context),
    [_A]: _SEA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetEndpointAttributesCommand");
var se_SetPlatformApplicationAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetPlatformApplicationAttributesInput(input, context),
    [_A]: _SPAA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetPlatformApplicationAttributesCommand");
var se_SetSMSAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetSMSAttributesInput(input, context),
    [_A]: _SSMSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetSMSAttributesCommand");
var se_SetSubscriptionAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetSubscriptionAttributesInput(input, context),
    [_A]: _SSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetSubscriptionAttributesCommand");
var se_SetTopicAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetTopicAttributesInput(input, context),
    [_A]: _STA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetTopicAttributesCommand");
var se_SubscribeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SubscribeInput(input, context),
    [_A]: _S,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SubscribeCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_TagResourceRequest(input, context),
    [_A]: _TR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_UnsubscribeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UnsubscribeInput(input, context),
    [_A]: _U,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UnsubscribeCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UntagResourceRequest(input, context),
    [_A]: _UR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_VerifySMSSandboxPhoneNumberCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_VerifySMSSandboxPhoneNumberInput(input, context),
    [_A]: _VSMSSPN,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_VerifySMSSandboxPhoneNumberCommand");
var de_AddPermissionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_AddPermissionCommand");
var de_CheckIfPhoneNumberIsOptedOutCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CheckIfPhoneNumberIsOptedOutResponse(data.CheckIfPhoneNumberIsOptedOutResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CheckIfPhoneNumberIsOptedOutCommand");
var de_ConfirmSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ConfirmSubscriptionResponse(data.ConfirmSubscriptionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ConfirmSubscriptionCommand");
var de_CreatePlatformApplicationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreatePlatformApplicationResponse(data.CreatePlatformApplicationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreatePlatformApplicationCommand");
var de_CreatePlatformEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateEndpointResponse(data.CreatePlatformEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreatePlatformEndpointCommand");
var de_CreateSMSSandboxPhoneNumberCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateSMSSandboxPhoneNumberResult(data.CreateSMSSandboxPhoneNumberResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateSMSSandboxPhoneNumberCommand");
var de_CreateTopicCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateTopicResponse(data.CreateTopicResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateTopicCommand");
var de_DeleteEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteEndpointCommand");
var de_DeletePlatformApplicationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeletePlatformApplicationCommand");
var de_DeleteSMSSandboxPhoneNumberCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteSMSSandboxPhoneNumberResult(data.DeleteSMSSandboxPhoneNumberResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteSMSSandboxPhoneNumberCommand");
var de_DeleteTopicCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteTopicCommand");
var de_GetDataProtectionPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetDataProtectionPolicyResponse(data.GetDataProtectionPolicyResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetDataProtectionPolicyCommand");
var de_GetEndpointAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetEndpointAttributesResponse(data.GetEndpointAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetEndpointAttributesCommand");
var de_GetPlatformApplicationAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetPlatformApplicationAttributesResponse(data.GetPlatformApplicationAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPlatformApplicationAttributesCommand");
var de_GetSMSAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetSMSAttributesResponse(data.GetSMSAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetSMSAttributesCommand");
var de_GetSMSSandboxAccountStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetSMSSandboxAccountStatusResult(data.GetSMSSandboxAccountStatusResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetSMSSandboxAccountStatusCommand");
var de_GetSubscriptionAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetSubscriptionAttributesResponse(data.GetSubscriptionAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetSubscriptionAttributesCommand");
var de_GetTopicAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetTopicAttributesResponse(data.GetTopicAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetTopicAttributesCommand");
var de_ListEndpointsByPlatformApplicationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListEndpointsByPlatformApplicationResponse(data.ListEndpointsByPlatformApplicationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListEndpointsByPlatformApplicationCommand");
var de_ListOriginationNumbersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListOriginationNumbersResult(data.ListOriginationNumbersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListOriginationNumbersCommand");
var de_ListPhoneNumbersOptedOutCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListPhoneNumbersOptedOutResponse(data.ListPhoneNumbersOptedOutResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListPhoneNumbersOptedOutCommand");
var de_ListPlatformApplicationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListPlatformApplicationsResponse(data.ListPlatformApplicationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListPlatformApplicationsCommand");
var de_ListSMSSandboxPhoneNumbersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListSMSSandboxPhoneNumbersResult(data.ListSMSSandboxPhoneNumbersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListSMSSandboxPhoneNumbersCommand");
var de_ListSubscriptionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListSubscriptionsResponse(data.ListSubscriptionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListSubscriptionsCommand");
var de_ListSubscriptionsByTopicCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListSubscriptionsByTopicResponse(data.ListSubscriptionsByTopicResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListSubscriptionsByTopicCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListTagsForResourceResponse(data.ListTagsForResourceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_ListTopicsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListTopicsResponse(data.ListTopicsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTopicsCommand");
var de_OptInPhoneNumberCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_OptInPhoneNumberResponse(data.OptInPhoneNumberResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_OptInPhoneNumberCommand");
var de_PublishCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PublishResponse(data.PublishResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PublishCommand");
var de_PublishBatchCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PublishBatchResponse(data.PublishBatchResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PublishBatchCommand");
var de_PutDataProtectionPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_PutDataProtectionPolicyCommand");
var de_RemovePermissionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_RemovePermissionCommand");
var de_SetEndpointAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SetEndpointAttributesCommand");
var de_SetPlatformApplicationAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SetPlatformApplicationAttributesCommand");
var de_SetSMSAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SetSMSAttributesResponse(data.SetSMSAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SetSMSAttributesCommand");
var de_SetSubscriptionAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SetSubscriptionAttributesCommand");
var de_SetTopicAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SetTopicAttributesCommand");
var de_SubscribeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SubscribeResponse(data.SubscribeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SubscribeCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_TagResourceResponse(data.TagResourceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TagResourceCommand");
var de_UnsubscribeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UnsubscribeCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_UntagResourceResponse(data.UntagResourceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UntagResourceCommand");
var de_VerifySMSSandboxPhoneNumberCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_VerifySMSSandboxPhoneNumberResult(data.VerifySMSSandboxPhoneNumberResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_VerifySMSSandboxPhoneNumberCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseXmlErrorBody)(output.body, context)
  };
  const errorCode = loadQueryErrorCode(output, parsedOutput.body);
  switch (errorCode) {
    case "AuthorizationError":
    case "com.amazonaws.sns#AuthorizationErrorException":
      throw await de_AuthorizationErrorExceptionRes(parsedOutput, context);
    case "InternalError":
    case "com.amazonaws.sns#InternalErrorException":
      throw await de_InternalErrorExceptionRes(parsedOutput, context);
    case "InvalidParameter":
    case "com.amazonaws.sns#InvalidParameterException":
      throw await de_InvalidParameterExceptionRes(parsedOutput, context);
    case "NotFound":
    case "com.amazonaws.sns#NotFoundException":
      throw await de_NotFoundExceptionRes(parsedOutput, context);
    case "Throttled":
    case "com.amazonaws.sns#ThrottledException":
      throw await de_ThrottledExceptionRes(parsedOutput, context);
    case "FilterPolicyLimitExceeded":
    case "com.amazonaws.sns#FilterPolicyLimitExceededException":
      throw await de_FilterPolicyLimitExceededExceptionRes(parsedOutput, context);
    case "ReplayLimitExceeded":
    case "com.amazonaws.sns#ReplayLimitExceededException":
      throw await de_ReplayLimitExceededExceptionRes(parsedOutput, context);
    case "SubscriptionLimitExceeded":
    case "com.amazonaws.sns#SubscriptionLimitExceededException":
      throw await de_SubscriptionLimitExceededExceptionRes(parsedOutput, context);
    case "OptedOut":
    case "com.amazonaws.sns#OptedOutException":
      throw await de_OptedOutExceptionRes(parsedOutput, context);
    case "UserError":
    case "com.amazonaws.sns#UserErrorException":
      throw await de_UserErrorExceptionRes(parsedOutput, context);
    case "ConcurrentAccess":
    case "com.amazonaws.sns#ConcurrentAccessException":
      throw await de_ConcurrentAccessExceptionRes(parsedOutput, context);
    case "InvalidSecurity":
    case "com.amazonaws.sns#InvalidSecurityException":
      throw await de_InvalidSecurityExceptionRes(parsedOutput, context);
    case "StaleTag":
    case "com.amazonaws.sns#StaleTagException":
      throw await de_StaleTagExceptionRes(parsedOutput, context);
    case "TagLimitExceeded":
    case "com.amazonaws.sns#TagLimitExceededException":
      throw await de_TagLimitExceededExceptionRes(parsedOutput, context);
    case "TagPolicy":
    case "com.amazonaws.sns#TagPolicyException":
      throw await de_TagPolicyExceptionRes(parsedOutput, context);
    case "TopicLimitExceeded":
    case "com.amazonaws.sns#TopicLimitExceededException":
      throw await de_TopicLimitExceededExceptionRes(parsedOutput, context);
    case "ResourceNotFound":
    case "com.amazonaws.sns#ResourceNotFoundException":
      throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
    case "InvalidState":
    case "com.amazonaws.sns#InvalidStateException":
      throw await de_InvalidStateExceptionRes(parsedOutput, context);
    case "ValidationException":
    case "com.amazonaws.sns#ValidationException":
      throw await de_ValidationExceptionRes(parsedOutput, context);
    case "EndpointDisabled":
    case "com.amazonaws.sns#EndpointDisabledException":
      throw await de_EndpointDisabledExceptionRes(parsedOutput, context);
    case "KMSAccessDenied":
    case "com.amazonaws.sns#KMSAccessDeniedException":
      throw await de_KMSAccessDeniedExceptionRes(parsedOutput, context);
    case "KMSDisabled":
    case "com.amazonaws.sns#KMSDisabledException":
      throw await de_KMSDisabledExceptionRes(parsedOutput, context);
    case "KMSInvalidState":
    case "com.amazonaws.sns#KMSInvalidStateException":
      throw await de_KMSInvalidStateExceptionRes(parsedOutput, context);
    case "KMSNotFound":
    case "com.amazonaws.sns#KMSNotFoundException":
      throw await de_KMSNotFoundExceptionRes(parsedOutput, context);
    case "KMSOptInRequired":
    case "com.amazonaws.sns#KMSOptInRequired":
      throw await de_KMSOptInRequiredRes(parsedOutput, context);
    case "KMSThrottling":
    case "com.amazonaws.sns#KMSThrottlingException":
      throw await de_KMSThrottlingExceptionRes(parsedOutput, context);
    case "ParameterValueInvalid":
    case "com.amazonaws.sns#InvalidParameterValueException":
      throw await de_InvalidParameterValueExceptionRes(parsedOutput, context);
    case "PlatformApplicationDisabled":
    case "com.amazonaws.sns#PlatformApplicationDisabledException":
      throw await de_PlatformApplicationDisabledExceptionRes(parsedOutput, context);
    case "BatchEntryIdsNotDistinct":
    case "com.amazonaws.sns#BatchEntryIdsNotDistinctException":
      throw await de_BatchEntryIdsNotDistinctExceptionRes(parsedOutput, context);
    case "BatchRequestTooLong":
    case "com.amazonaws.sns#BatchRequestTooLongException":
      throw await de_BatchRequestTooLongExceptionRes(parsedOutput, context);
    case "EmptyBatchRequest":
    case "com.amazonaws.sns#EmptyBatchRequestException":
      throw await de_EmptyBatchRequestExceptionRes(parsedOutput, context);
    case "InvalidBatchEntryId":
    case "com.amazonaws.sns#InvalidBatchEntryIdException":
      throw await de_InvalidBatchEntryIdExceptionRes(parsedOutput, context);
    case "TooManyEntriesInBatchRequest":
    case "com.amazonaws.sns#TooManyEntriesInBatchRequestException":
      throw await de_TooManyEntriesInBatchRequestExceptionRes(parsedOutput, context);
    case "VerificationException":
    case "com.amazonaws.sns#VerificationException":
      throw await de_VerificationExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode
      });
  }
}, "de_CommandError");
var de_AuthorizationErrorExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_AuthorizationErrorException(body.Error, context);
  const exception = new AuthorizationErrorException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AuthorizationErrorExceptionRes");
var de_BatchEntryIdsNotDistinctExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_BatchEntryIdsNotDistinctException(body.Error, context);
  const exception = new BatchEntryIdsNotDistinctException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BatchEntryIdsNotDistinctExceptionRes");
var de_BatchRequestTooLongExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_BatchRequestTooLongException(body.Error, context);
  const exception = new BatchRequestTooLongException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BatchRequestTooLongExceptionRes");
var de_ConcurrentAccessExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ConcurrentAccessException(body.Error, context);
  const exception = new ConcurrentAccessException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConcurrentAccessExceptionRes");
var de_EmptyBatchRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_EmptyBatchRequestException(body.Error, context);
  const exception = new EmptyBatchRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EmptyBatchRequestExceptionRes");
var de_EndpointDisabledExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_EndpointDisabledException(body.Error, context);
  const exception = new EndpointDisabledException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EndpointDisabledExceptionRes");
var de_FilterPolicyLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_FilterPolicyLimitExceededException(body.Error, context);
  const exception = new FilterPolicyLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FilterPolicyLimitExceededExceptionRes");
var de_InternalErrorExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InternalErrorException(body.Error, context);
  const exception = new InternalErrorException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InternalErrorExceptionRes");
var de_InvalidBatchEntryIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidBatchEntryIdException(body.Error, context);
  const exception = new InvalidBatchEntryIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidBatchEntryIdExceptionRes");
var de_InvalidParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidParameterException(body.Error, context);
  const exception = new InvalidParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidParameterExceptionRes");
var de_InvalidParameterValueExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidParameterValueException(body.Error, context);
  const exception = new InvalidParameterValueException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidParameterValueExceptionRes");
var de_InvalidSecurityExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidSecurityException(body.Error, context);
  const exception = new InvalidSecurityException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidSecurityExceptionRes");
var de_InvalidStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidStateException(body.Error, context);
  const exception = new InvalidStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidStateExceptionRes");
var de_KMSAccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSAccessDeniedException(body.Error, context);
  const exception = new KMSAccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSAccessDeniedExceptionRes");
var de_KMSDisabledExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSDisabledException(body.Error, context);
  const exception = new KMSDisabledException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSDisabledExceptionRes");
var de_KMSInvalidStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSInvalidStateException(body.Error, context);
  const exception = new KMSInvalidStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSInvalidStateExceptionRes");
var de_KMSNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSNotFoundException(body.Error, context);
  const exception = new KMSNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSNotFoundExceptionRes");
var de_KMSOptInRequiredRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSOptInRequired(body.Error, context);
  const exception = new KMSOptInRequired({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSOptInRequiredRes");
var de_KMSThrottlingExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSThrottlingException(body.Error, context);
  const exception = new KMSThrottlingException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSThrottlingExceptionRes");
var de_NotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_NotFoundException(body.Error, context);
  const exception = new NotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NotFoundExceptionRes");
var de_OptedOutExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OptedOutException(body.Error, context);
  const exception = new OptedOutException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OptedOutExceptionRes");
var de_PlatformApplicationDisabledExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_PlatformApplicationDisabledException(body.Error, context);
  const exception = new PlatformApplicationDisabledException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PlatformApplicationDisabledExceptionRes");
var de_ReplayLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ReplayLimitExceededException(body.Error, context);
  const exception = new ReplayLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReplayLimitExceededExceptionRes");
var de_ResourceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ResourceNotFoundException(body.Error, context);
  const exception = new ResourceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundExceptionRes");
var de_StaleTagExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StaleTagException(body.Error, context);
  const exception = new StaleTagException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StaleTagExceptionRes");
var de_SubscriptionLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SubscriptionLimitExceededException(body.Error, context);
  const exception = new SubscriptionLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SubscriptionLimitExceededExceptionRes");
var de_TagLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TagLimitExceededException(body.Error, context);
  const exception = new TagLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TagLimitExceededExceptionRes");
var de_TagPolicyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TagPolicyException(body.Error, context);
  const exception = new TagPolicyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TagPolicyExceptionRes");
var de_ThrottledExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ThrottledException(body.Error, context);
  const exception = new ThrottledException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ThrottledExceptionRes");
var de_TooManyEntriesInBatchRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TooManyEntriesInBatchRequestException(body.Error, context);
  const exception = new TooManyEntriesInBatchRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TooManyEntriesInBatchRequestExceptionRes");
var de_TopicLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TopicLimitExceededException(body.Error, context);
  const exception = new TopicLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TopicLimitExceededExceptionRes");
var de_UserErrorExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_UserErrorException(body.Error, context);
  const exception = new UserErrorException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UserErrorExceptionRes");
var de_ValidationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ValidationException(body.Error, context);
  const exception = new ValidationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ValidationExceptionRes");
var de_VerificationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_VerificationException(body.Error, context);
  const exception = new VerificationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_VerificationExceptionRes");
var se_ActionsList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_ActionsList");
var se_AddPermissionInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_L] != null) {
    entries[_L] = input[_L];
  }
  if (input[_AWSAI] != null) {
    const memberEntries = se_DelegatesList(input[_AWSAI], context);
    if (input[_AWSAI]?.length === 0) {
      entries.AWSAccountId = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AWSAccountId.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AN] != null) {
    const memberEntries = se_ActionsList(input[_AN], context);
    if (input[_AN]?.length === 0) {
      entries.ActionName = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ActionName.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_AddPermissionInput");
var se_CheckIfPhoneNumberIsOptedOutInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_pN] != null) {
    entries[_pN] = input[_pN];
  }
  return entries;
}, "se_CheckIfPhoneNumberIsOptedOutInput");
var se_ConfirmSubscriptionInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_AOU] != null) {
    entries[_AOU] = input[_AOU];
  }
  return entries;
}, "se_ConfirmSubscriptionInput");
var se_CreatePlatformApplicationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_Pl] != null) {
    entries[_Pl] = input[_Pl];
  }
  if (input[_At] != null) {
    const memberEntries = se_MapStringToString(input[_At], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Attributes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreatePlatformApplicationInput");
var se_CreatePlatformEndpointInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PAA] != null) {
    entries[_PAA] = input[_PAA];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_CUD] != null) {
    entries[_CUD] = input[_CUD];
  }
  if (input[_At] != null) {
    const memberEntries = se_MapStringToString(input[_At], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Attributes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreatePlatformEndpointInput");
var se_CreateSMSSandboxPhoneNumberInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PN] != null) {
    entries[_PN] = input[_PN];
  }
  if (input[_LC] != null) {
    entries[_LC] = input[_LC];
  }
  return entries;
}, "se_CreateSMSSandboxPhoneNumberInput");
var se_CreateTopicInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_At] != null) {
    const memberEntries = se_TopicAttributesMap(input[_At], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Attributes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ta] != null) {
    const memberEntries = se_TagList(input[_Ta], context);
    if (input[_Ta]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DPP] != null) {
    entries[_DPP] = input[_DPP];
  }
  return entries;
}, "se_CreateTopicInput");
var se_DelegatesList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_DelegatesList");
var se_DeleteEndpointInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_EA] != null) {
    entries[_EA] = input[_EA];
  }
  return entries;
}, "se_DeleteEndpointInput");
var se_DeletePlatformApplicationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PAA] != null) {
    entries[_PAA] = input[_PAA];
  }
  return entries;
}, "se_DeletePlatformApplicationInput");
var se_DeleteSMSSandboxPhoneNumberInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PN] != null) {
    entries[_PN] = input[_PN];
  }
  return entries;
}, "se_DeleteSMSSandboxPhoneNumberInput");
var se_DeleteTopicInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  return entries;
}, "se_DeleteTopicInput");
var se_GetDataProtectionPolicyInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  return entries;
}, "se_GetDataProtectionPolicyInput");
var se_GetEndpointAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_EA] != null) {
    entries[_EA] = input[_EA];
  }
  return entries;
}, "se_GetEndpointAttributesInput");
var se_GetPlatformApplicationAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PAA] != null) {
    entries[_PAA] = input[_PAA];
  }
  return entries;
}, "se_GetPlatformApplicationAttributesInput");
var se_GetSMSAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_a] != null) {
    const memberEntries = se_ListString(input[_a], context);
    if (input[_a]?.length === 0) {
      entries.attributes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `attributes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_GetSMSAttributesInput");
var se_GetSMSSandboxAccountStatusInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  return entries;
}, "se_GetSMSSandboxAccountStatusInput");
var se_GetSubscriptionAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SA] != null) {
    entries[_SA] = input[_SA];
  }
  return entries;
}, "se_GetSubscriptionAttributesInput");
var se_GetTopicAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  return entries;
}, "se_GetTopicAttributesInput");
var se_ListEndpointsByPlatformApplicationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PAA] != null) {
    entries[_PAA] = input[_PAA];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListEndpointsByPlatformApplicationInput");
var se_ListOriginationNumbersRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_ListOriginationNumbersRequest");
var se_ListPhoneNumbersOptedOutInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_nT] != null) {
    entries[_nT] = input[_nT];
  }
  return entries;
}, "se_ListPhoneNumbersOptedOutInput");
var se_ListPlatformApplicationsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListPlatformApplicationsInput");
var se_ListSMSSandboxPhoneNumbersInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_ListSMSSandboxPhoneNumbersInput");
var se_ListString = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_ListString");
var se_ListSubscriptionsByTopicInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListSubscriptionsByTopicInput");
var se_ListSubscriptionsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListSubscriptionsInput");
var se_ListTagsForResourceRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  return entries;
}, "se_ListTagsForResourceRequest");
var se_ListTopicsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListTopicsInput");
var se_MapStringToString = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.key`] = key;
    entries[`entry.${counter}.value`] = input[key];
    counter++;
  });
  return entries;
}, "se_MapStringToString");
var se_MessageAttributeMap = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.Name`] = key;
    const memberEntries = se_MessageAttributeValue(input[key], context);
    Object.entries(memberEntries).forEach(([key2, value]) => {
      entries[`entry.${counter}.Value.${key2}`] = value;
    });
    counter++;
  });
  return entries;
}, "se_MessageAttributeMap");
var se_MessageAttributeValue = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DTa] != null) {
    entries[_DTa] = input[_DTa];
  }
  if (input[_SV] != null) {
    entries[_SV] = input[_SV];
  }
  if (input[_BV] != null) {
    entries[_BV] = context.base64Encoder(input[_BV]);
  }
  return entries;
}, "se_MessageAttributeValue");
var se_OptInPhoneNumberInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_pN] != null) {
    entries[_pN] = input[_pN];
  }
  return entries;
}, "se_OptInPhoneNumberInput");
var se_PublishBatchInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_PBRE] != null) {
    const memberEntries = se_PublishBatchRequestEntryList(input[_PBRE], context);
    if (input[_PBRE]?.length === 0) {
      entries.PublishBatchRequestEntries = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `PublishBatchRequestEntries.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_PublishBatchInput");
var se_PublishBatchRequestEntry = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_M] != null) {
    entries[_M] = input[_M];
  }
  if (input[_Su] != null) {
    entries[_Su] = input[_Su];
  }
  if (input[_MS] != null) {
    entries[_MS] = input[_MS];
  }
  if (input[_MA] != null) {
    const memberEntries = se_MessageAttributeMap(input[_MA], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `MessageAttributes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MDI] != null) {
    entries[_MDI] = input[_MDI];
  }
  if (input[_MGI] != null) {
    entries[_MGI] = input[_MGI];
  }
  return entries;
}, "se_PublishBatchRequestEntry");
var se_PublishBatchRequestEntryList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_PublishBatchRequestEntry(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_PublishBatchRequestEntryList");
var se_PublishInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_TAa] != null) {
    entries[_TAa] = input[_TAa];
  }
  if (input[_PN] != null) {
    entries[_PN] = input[_PN];
  }
  if (input[_M] != null) {
    entries[_M] = input[_M];
  }
  if (input[_Su] != null) {
    entries[_Su] = input[_Su];
  }
  if (input[_MS] != null) {
    entries[_MS] = input[_MS];
  }
  if (input[_MA] != null) {
    const memberEntries = se_MessageAttributeMap(input[_MA], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `MessageAttributes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MDI] != null) {
    entries[_MDI] = input[_MDI];
  }
  if (input[_MGI] != null) {
    entries[_MGI] = input[_MGI];
  }
  return entries;
}, "se_PublishInput");
var se_PutDataProtectionPolicyInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_DPP] != null) {
    entries[_DPP] = input[_DPP];
  }
  return entries;
}, "se_PutDataProtectionPolicyInput");
var se_RemovePermissionInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_L] != null) {
    entries[_L] = input[_L];
  }
  return entries;
}, "se_RemovePermissionInput");
var se_SetEndpointAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_EA] != null) {
    entries[_EA] = input[_EA];
  }
  if (input[_At] != null) {
    const memberEntries = se_MapStringToString(input[_At], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Attributes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_SetEndpointAttributesInput");
var se_SetPlatformApplicationAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PAA] != null) {
    entries[_PAA] = input[_PAA];
  }
  if (input[_At] != null) {
    const memberEntries = se_MapStringToString(input[_At], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Attributes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_SetPlatformApplicationAttributesInput");
var se_SetSMSAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_a] != null) {
    const memberEntries = se_MapStringToString(input[_a], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `attributes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_SetSMSAttributesInput");
var se_SetSubscriptionAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SA] != null) {
    entries[_SA] = input[_SA];
  }
  if (input[_ANt] != null) {
    entries[_ANt] = input[_ANt];
  }
  if (input[_AV] != null) {
    entries[_AV] = input[_AV];
  }
  return entries;
}, "se_SetSubscriptionAttributesInput");
var se_SetTopicAttributesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_ANt] != null) {
    entries[_ANt] = input[_ANt];
  }
  if (input[_AV] != null) {
    entries[_AV] = input[_AV];
  }
  return entries;
}, "se_SetTopicAttributesInput");
var se_SubscribeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_Pr] != null) {
    entries[_Pr] = input[_Pr];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_At] != null) {
    const memberEntries = se_SubscriptionAttributesMap(input[_At], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Attributes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RSA] != null) {
    entries[_RSA] = input[_RSA];
  }
  return entries;
}, "se_SubscribeInput");
var se_SubscriptionAttributesMap = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.key`] = key;
    entries[`entry.${counter}.value`] = input[key];
    counter++;
  });
  return entries;
}, "se_SubscriptionAttributesMap");
var se_Tag = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_K] != null) {
    entries[_K] = input[_K];
  }
  if (input[_Va] != null) {
    entries[_Va] = input[_Va];
  }
  return entries;
}, "se_Tag");
var se_TagKeyList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_TagKeyList");
var se_TagList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_Tag(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_TagList");
var se_TagResourceRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_Ta] != null) {
    const memberEntries = se_TagList(input[_Ta], context);
    if (input[_Ta]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_TagResourceRequest");
var se_TopicAttributesMap = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.key`] = key;
    entries[`entry.${counter}.value`] = input[key];
    counter++;
  });
  return entries;
}, "se_TopicAttributesMap");
var se_UnsubscribeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SA] != null) {
    entries[_SA] = input[_SA];
  }
  return entries;
}, "se_UnsubscribeInput");
var se_UntagResourceRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_TK] != null) {
    const memberEntries = se_TagKeyList(input[_TK], context);
    if (input[_TK]?.length === 0) {
      entries.TagKeys = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `TagKeys.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_UntagResourceRequest");
var se_VerifySMSSandboxPhoneNumberInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PN] != null) {
    entries[_PN] = input[_PN];
  }
  if (input[_OTP] != null) {
    entries[_OTP] = input[_OTP];
  }
  return entries;
}, "se_VerifySMSSandboxPhoneNumberInput");
var de_AuthorizationErrorException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_AuthorizationErrorException");
var de_BatchEntryIdsNotDistinctException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_BatchEntryIdsNotDistinctException");
var de_BatchRequestTooLongException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_BatchRequestTooLongException");
var de_BatchResultErrorEntry = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.expectString)(output[_I]);
  }
  if (output[_C] != null) {
    contents[_C] = (0, import_smithy_client.expectString)(output[_C]);
  }
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_SF] != null) {
    contents[_SF] = (0, import_smithy_client.parseBoolean)(output[_SF]);
  }
  return contents;
}, "de_BatchResultErrorEntry");
var de_BatchResultErrorEntryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_BatchResultErrorEntry(entry, context);
  });
}, "de_BatchResultErrorEntryList");
var de_CheckIfPhoneNumberIsOptedOutResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_iOO] != null) {
    contents[_iOO] = (0, import_smithy_client.parseBoolean)(output[_iOO]);
  }
  return contents;
}, "de_CheckIfPhoneNumberIsOptedOutResponse");
var de_ConcurrentAccessException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ConcurrentAccessException");
var de_ConfirmSubscriptionResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SA] != null) {
    contents[_SA] = (0, import_smithy_client.expectString)(output[_SA]);
  }
  return contents;
}, "de_ConfirmSubscriptionResponse");
var de_CreateEndpointResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_EA] != null) {
    contents[_EA] = (0, import_smithy_client.expectString)(output[_EA]);
  }
  return contents;
}, "de_CreateEndpointResponse");
var de_CreatePlatformApplicationResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PAA] != null) {
    contents[_PAA] = (0, import_smithy_client.expectString)(output[_PAA]);
  }
  return contents;
}, "de_CreatePlatformApplicationResponse");
var de_CreateSMSSandboxPhoneNumberResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_CreateSMSSandboxPhoneNumberResult");
var de_CreateTopicResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  return contents;
}, "de_CreateTopicResponse");
var de_DeleteSMSSandboxPhoneNumberResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeleteSMSSandboxPhoneNumberResult");
var de_EmptyBatchRequestException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_EmptyBatchRequestException");
var de_Endpoint = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_EA] != null) {
    contents[_EA] = (0, import_smithy_client.expectString)(output[_EA]);
  }
  if (String(output.Attributes).trim() === "") {
    contents[_At] = {};
  } else if (output[_At] != null && output[_At][_e] != null) {
    contents[_At] = de_MapStringToString((0, import_smithy_client.getArrayIfSingleItem)(output[_At][_e]), context);
  }
  return contents;
}, "de_Endpoint");
var de_EndpointDisabledException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_EndpointDisabledException");
var de_FilterPolicyLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_FilterPolicyLimitExceededException");
var de_GetDataProtectionPolicyResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DPP] != null) {
    contents[_DPP] = (0, import_smithy_client.expectString)(output[_DPP]);
  }
  return contents;
}, "de_GetDataProtectionPolicyResponse");
var de_GetEndpointAttributesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Attributes).trim() === "") {
    contents[_At] = {};
  } else if (output[_At] != null && output[_At][_e] != null) {
    contents[_At] = de_MapStringToString((0, import_smithy_client.getArrayIfSingleItem)(output[_At][_e]), context);
  }
  return contents;
}, "de_GetEndpointAttributesResponse");
var de_GetPlatformApplicationAttributesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Attributes).trim() === "") {
    contents[_At] = {};
  } else if (output[_At] != null && output[_At][_e] != null) {
    contents[_At] = de_MapStringToString((0, import_smithy_client.getArrayIfSingleItem)(output[_At][_e]), context);
  }
  return contents;
}, "de_GetPlatformApplicationAttributesResponse");
var de_GetSMSAttributesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.attributes).trim() === "") {
    contents[_a] = {};
  } else if (output[_a] != null && output[_a][_e] != null) {
    contents[_a] = de_MapStringToString((0, import_smithy_client.getArrayIfSingleItem)(output[_a][_e]), context);
  }
  return contents;
}, "de_GetSMSAttributesResponse");
var de_GetSMSSandboxAccountStatusResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_IIS] != null) {
    contents[_IIS] = (0, import_smithy_client.parseBoolean)(output[_IIS]);
  }
  return contents;
}, "de_GetSMSSandboxAccountStatusResult");
var de_GetSubscriptionAttributesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Attributes).trim() === "") {
    contents[_At] = {};
  } else if (output[_At] != null && output[_At][_e] != null) {
    contents[_At] = de_SubscriptionAttributesMap((0, import_smithy_client.getArrayIfSingleItem)(output[_At][_e]), context);
  }
  return contents;
}, "de_GetSubscriptionAttributesResponse");
var de_GetTopicAttributesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Attributes).trim() === "") {
    contents[_At] = {};
  } else if (output[_At] != null && output[_At][_e] != null) {
    contents[_At] = de_TopicAttributesMap((0, import_smithy_client.getArrayIfSingleItem)(output[_At][_e]), context);
  }
  return contents;
}, "de_GetTopicAttributesResponse");
var de_InternalErrorException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InternalErrorException");
var de_InvalidBatchEntryIdException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidBatchEntryIdException");
var de_InvalidParameterException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidParameterException");
var de_InvalidParameterValueException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidParameterValueException");
var de_InvalidSecurityException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidSecurityException");
var de_InvalidStateException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidStateException");
var de_KMSAccessDeniedException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSAccessDeniedException");
var de_KMSDisabledException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSDisabledException");
var de_KMSInvalidStateException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSInvalidStateException");
var de_KMSNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSNotFoundException");
var de_KMSOptInRequired = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSOptInRequired");
var de_KMSThrottlingException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSThrottlingException");
var de_ListEndpointsByPlatformApplicationResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Endpoints).trim() === "") {
    contents[_En] = [];
  } else if (output[_En] != null && output[_En][_me] != null) {
    contents[_En] = de_ListOfEndpoints((0, import_smithy_client.getArrayIfSingleItem)(output[_En][_me]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListEndpointsByPlatformApplicationResponse");
var de_ListOfEndpoints = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Endpoint(entry, context);
  });
}, "de_ListOfEndpoints");
var de_ListOfPlatformApplications = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PlatformApplication(entry, context);
  });
}, "de_ListOfPlatformApplications");
var de_ListOriginationNumbersResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  if (String(output.PhoneNumbers).trim() === "") {
    contents[_PNh] = [];
  } else if (output[_PNh] != null && output[_PNh][_me] != null) {
    contents[_PNh] = de_PhoneNumberInformationList((0, import_smithy_client.getArrayIfSingleItem)(output[_PNh][_me]), context);
  }
  return contents;
}, "de_ListOriginationNumbersResult");
var de_ListPhoneNumbersOptedOutResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.phoneNumbers).trim() === "") {
    contents[_pNh] = [];
  } else if (output[_pNh] != null && output[_pNh][_me] != null) {
    contents[_pNh] = de_PhoneNumberList((0, import_smithy_client.getArrayIfSingleItem)(output[_pNh][_me]), context);
  }
  if (output[_nT] != null) {
    contents[_nT] = (0, import_smithy_client.expectString)(output[_nT]);
  }
  return contents;
}, "de_ListPhoneNumbersOptedOutResponse");
var de_ListPlatformApplicationsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.PlatformApplications).trim() === "") {
    contents[_PA] = [];
  } else if (output[_PA] != null && output[_PA][_me] != null) {
    contents[_PA] = de_ListOfPlatformApplications((0, import_smithy_client.getArrayIfSingleItem)(output[_PA][_me]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListPlatformApplicationsResponse");
var de_ListSMSSandboxPhoneNumbersResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.PhoneNumbers).trim() === "") {
    contents[_PNh] = [];
  } else if (output[_PNh] != null && output[_PNh][_me] != null) {
    contents[_PNh] = de_SMSSandboxPhoneNumberList((0, import_smithy_client.getArrayIfSingleItem)(output[_PNh][_me]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListSMSSandboxPhoneNumbersResult");
var de_ListSubscriptionsByTopicResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Subscriptions).trim() === "") {
    contents[_Sub] = [];
  } else if (output[_Sub] != null && output[_Sub][_me] != null) {
    contents[_Sub] = de_SubscriptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_Sub][_me]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListSubscriptionsByTopicResponse");
var de_ListSubscriptionsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Subscriptions).trim() === "") {
    contents[_Sub] = [];
  } else if (output[_Sub] != null && output[_Sub][_me] != null) {
    contents[_Sub] = de_SubscriptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_Sub][_me]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListSubscriptionsResponse");
var de_ListTagsForResourceResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Tags).trim() === "") {
    contents[_Ta] = [];
  } else if (output[_Ta] != null && output[_Ta][_me] != null) {
    contents[_Ta] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_Ta][_me]), context);
  }
  return contents;
}, "de_ListTagsForResourceResponse");
var de_ListTopicsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Topics).trim() === "") {
    contents[_To] = [];
  } else if (output[_To] != null && output[_To][_me] != null) {
    contents[_To] = de_TopicsList((0, import_smithy_client.getArrayIfSingleItem)(output[_To][_me]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListTopicsResponse");
var de_MapStringToString = /* @__PURE__ */ __name((output, context) => {
  return output.reduce((acc, pair) => {
    if (pair["value"] === null) {
      return acc;
    }
    acc[pair["key"]] = (0, import_smithy_client.expectString)(pair["value"]);
    return acc;
  }, {});
}, "de_MapStringToString");
var de_NotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_NotFoundException");
var de_NumberCapabilityList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_NumberCapabilityList");
var de_OptedOutException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_OptedOutException");
var de_OptInPhoneNumberResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_OptInPhoneNumberResponse");
var de_PhoneNumberInformation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CA] != null) {
    contents[_CA] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CA]));
  }
  if (output[_PN] != null) {
    contents[_PN] = (0, import_smithy_client.expectString)(output[_PN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_ICC] != null) {
    contents[_ICC] = (0, import_smithy_client.expectString)(output[_ICC]);
  }
  if (output[_RT] != null) {
    contents[_RT] = (0, import_smithy_client.expectString)(output[_RT]);
  }
  if (String(output.NumberCapabilities).trim() === "") {
    contents[_NC] = [];
  } else if (output[_NC] != null && output[_NC][_me] != null) {
    contents[_NC] = de_NumberCapabilityList((0, import_smithy_client.getArrayIfSingleItem)(output[_NC][_me]), context);
  }
  return contents;
}, "de_PhoneNumberInformation");
var de_PhoneNumberInformationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PhoneNumberInformation(entry, context);
  });
}, "de_PhoneNumberInformationList");
var de_PhoneNumberList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_PhoneNumberList");
var de_PlatformApplication = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PAA] != null) {
    contents[_PAA] = (0, import_smithy_client.expectString)(output[_PAA]);
  }
  if (String(output.Attributes).trim() === "") {
    contents[_At] = {};
  } else if (output[_At] != null && output[_At][_e] != null) {
    contents[_At] = de_MapStringToString((0, import_smithy_client.getArrayIfSingleItem)(output[_At][_e]), context);
  }
  return contents;
}, "de_PlatformApplication");
var de_PlatformApplicationDisabledException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_PlatformApplicationDisabledException");
var de_PublishBatchResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (String(output.Successful).trim() === "") {
    contents[_Suc] = [];
  } else if (output[_Suc] != null && output[_Suc][_me] != null) {
    contents[_Suc] = de_PublishBatchResultEntryList((0, import_smithy_client.getArrayIfSingleItem)(output[_Suc][_me]), context);
  }
  if (String(output.Failed).trim() === "") {
    contents[_F] = [];
  } else if (output[_F] != null && output[_F][_me] != null) {
    contents[_F] = de_BatchResultErrorEntryList((0, import_smithy_client.getArrayIfSingleItem)(output[_F][_me]), context);
  }
  return contents;
}, "de_PublishBatchResponse");
var de_PublishBatchResultEntry = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.expectString)(output[_I]);
  }
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.expectString)(output[_MI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  return contents;
}, "de_PublishBatchResultEntry");
var de_PublishBatchResultEntryList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PublishBatchResultEntry(entry, context);
  });
}, "de_PublishBatchResultEntryList");
var de_PublishResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MI] != null) {
    contents[_MI] = (0, import_smithy_client.expectString)(output[_MI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  return contents;
}, "de_PublishResponse");
var de_ReplayLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ReplayLimitExceededException");
var de_ResourceNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ResourceNotFoundException");
var de_SetSMSAttributesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_SetSMSAttributesResponse");
var de_SMSSandboxPhoneNumber = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PN] != null) {
    contents[_PN] = (0, import_smithy_client.expectString)(output[_PN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_SMSSandboxPhoneNumber");
var de_SMSSandboxPhoneNumberList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_SMSSandboxPhoneNumber(entry, context);
  });
}, "de_SMSSandboxPhoneNumberList");
var de_StaleTagException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_StaleTagException");
var de_SubscribeResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SA] != null) {
    contents[_SA] = (0, import_smithy_client.expectString)(output[_SA]);
  }
  return contents;
}, "de_SubscribeResponse");
var de_Subscription = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SA] != null) {
    contents[_SA] = (0, import_smithy_client.expectString)(output[_SA]);
  }
  if (output[_O] != null) {
    contents[_O] = (0, import_smithy_client.expectString)(output[_O]);
  }
  if (output[_Pr] != null) {
    contents[_Pr] = (0, import_smithy_client.expectString)(output[_Pr]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  return contents;
}, "de_Subscription");
var de_SubscriptionAttributesMap = /* @__PURE__ */ __name((output, context) => {
  return output.reduce((acc, pair) => {
    if (pair["value"] === null) {
      return acc;
    }
    acc[pair["key"]] = (0, import_smithy_client.expectString)(pair["value"]);
    return acc;
  }, {});
}, "de_SubscriptionAttributesMap");
var de_SubscriptionLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SubscriptionLimitExceededException");
var de_SubscriptionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Subscription(entry, context);
  });
}, "de_SubscriptionsList");
var de_Tag = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_Va] != null) {
    contents[_Va] = (0, import_smithy_client.expectString)(output[_Va]);
  }
  return contents;
}, "de_Tag");
var de_TagLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TagLimitExceededException");
var de_TagList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Tag(entry, context);
  });
}, "de_TagList");
var de_TagPolicyException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TagPolicyException");
var de_TagResourceResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_TagResourceResponse");
var de_ThrottledException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ThrottledException");
var de_TooManyEntriesInBatchRequestException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TooManyEntriesInBatchRequestException");
var de_Topic = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  return contents;
}, "de_Topic");
var de_TopicAttributesMap = /* @__PURE__ */ __name((output, context) => {
  return output.reduce((acc, pair) => {
    if (pair["value"] === null) {
      return acc;
    }
    acc[pair["key"]] = (0, import_smithy_client.expectString)(pair["value"]);
    return acc;
  }, {});
}, "de_TopicAttributesMap");
var de_TopicLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TopicLimitExceededException");
var de_TopicsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Topic(entry, context);
  });
}, "de_TopicsList");
var de_UntagResourceResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_UntagResourceResponse");
var de_UserErrorException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_UserErrorException");
var de_ValidationException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_ValidationException");
var de_VerificationException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_VerificationException");
var de_VerifySMSSandboxPhoneNumberResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_VerifySMSSandboxPhoneNumberResult");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(SNSServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
var SHARED_HEADERS = {
  "content-type": "application/x-www-form-urlencoded"
};
var _ = "2010-03-31";
var _A = "Action";
var _AN = "ActionName";
var _ANt = "AttributeName";
var _AOU = "AuthenticateOnUnsubscribe";
var _AP = "AddPermission";
var _AV = "AttributeValue";
var _AWSAI = "AWSAccountId";
var _At = "Attributes";
var _BV = "BinaryValue";
var _C = "Code";
var _CA = "CreatedAt";
var _CIPNIOO = "CheckIfPhoneNumberIsOptedOut";
var _CPA = "CreatePlatformApplication";
var _CPE = "CreatePlatformEndpoint";
var _CS = "ConfirmSubscription";
var _CSMSSPN = "CreateSMSSandboxPhoneNumber";
var _CT = "CreateTopic";
var _CUD = "CustomUserData";
var _DE = "DeleteEndpoint";
var _DPA = "DeletePlatformApplication";
var _DPP = "DataProtectionPolicy";
var _DSMSSPN = "DeleteSMSSandboxPhoneNumber";
var _DT = "DeleteTopic";
var _DTa = "DataType";
var _E = "Endpoint";
var _EA = "EndpointArn";
var _En = "Endpoints";
var _F = "Failed";
var _GDPP = "GetDataProtectionPolicy";
var _GEA = "GetEndpointAttributes";
var _GPAA = "GetPlatformApplicationAttributes";
var _GSA = "GetSubscriptionAttributes";
var _GSMSA = "GetSMSAttributes";
var _GSMSSAS = "GetSMSSandboxAccountStatus";
var _GTA = "GetTopicAttributes";
var _I = "Id";
var _ICC = "Iso2CountryCode";
var _IIS = "IsInSandbox";
var _K = "Key";
var _L = "Label";
var _LC = "LanguageCode";
var _LEBPA = "ListEndpointsByPlatformApplication";
var _LON = "ListOriginationNumbers";
var _LPA = "ListPlatformApplications";
var _LPNOO = "ListPhoneNumbersOptedOut";
var _LS = "ListSubscriptions";
var _LSBT = "ListSubscriptionsByTopic";
var _LSMSSPN = "ListSMSSandboxPhoneNumbers";
var _LT = "ListTopics";
var _LTFR = "ListTagsForResource";
var _M = "Message";
var _MA = "MessageAttributes";
var _MDI = "MessageDeduplicationId";
var _MGI = "MessageGroupId";
var _MI = "MessageId";
var _MR = "MaxResults";
var _MS = "MessageStructure";
var _N = "Name";
var _NC = "NumberCapabilities";
var _NT = "NextToken";
var _O = "Owner";
var _OIPN = "OptInPhoneNumber";
var _OTP = "OneTimePassword";
var _P = "Publish";
var _PA = "PlatformApplications";
var _PAA = "PlatformApplicationArn";
var _PB = "PublishBatch";
var _PBRE = "PublishBatchRequestEntries";
var _PDPP = "PutDataProtectionPolicy";
var _PN = "PhoneNumber";
var _PNh = "PhoneNumbers";
var _Pl = "Platform";
var _Pr = "Protocol";
var _RA = "ResourceArn";
var _RP = "RemovePermission";
var _RSA = "ReturnSubscriptionArn";
var _RT = "RouteType";
var _S = "Subscribe";
var _SA = "SubscriptionArn";
var _SEA = "SetEndpointAttributes";
var _SF = "SenderFault";
var _SN = "SequenceNumber";
var _SPAA = "SetPlatformApplicationAttributes";
var _SSA = "SetSubscriptionAttributes";
var _SSMSA = "SetSMSAttributes";
var _STA = "SetTopicAttributes";
var _SV = "StringValue";
var _St = "Status";
var _Su = "Subject";
var _Sub = "Subscriptions";
var _Suc = "Successful";
var _T = "Token";
var _TA = "TopicArn";
var _TAa = "TargetArn";
var _TK = "TagKeys";
var _TR = "TagResource";
var _Ta = "Tags";
var _To = "Topics";
var _U = "Unsubscribe";
var _UR = "UntagResource";
var _V = "Version";
var _VSMSSPN = "VerifySMSSandboxPhoneNumber";
var _Va = "Value";
var _a = "attributes";
var _e = "entry";
var _iOO = "isOptedOut";
var _m = "message";
var _me = "member";
var _nT = "nextToken";
var _pN = "phoneNumber";
var _pNh = "phoneNumbers";
var buildFormUrlencodedString = /* @__PURE__ */ __name((formEntries) => Object.entries(formEntries).map(([key, value]) => (0, import_smithy_client.extendedEncodeURIComponent)(key) + "=" + (0, import_smithy_client.extendedEncodeURIComponent)(value)).join("&"), "buildFormUrlencodedString");
var loadQueryErrorCode = /* @__PURE__ */ __name((output, data) => {
  if (data.Error?.Code !== void 0) {
    return data.Error.Code;
  }
  if (output.statusCode == 404) {
    return "NotFound";
  }
}, "loadQueryErrorCode");

// src/commands/AddPermissionCommand.ts
var AddPermissionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "AddPermission", {}).n("SNSClient", "AddPermissionCommand").f(void 0, void 0).ser(se_AddPermissionCommand).de(de_AddPermissionCommand).build() {
  static {
    __name(this, "AddPermissionCommand");
  }
};

// src/commands/CheckIfPhoneNumberIsOptedOutCommand.ts



var CheckIfPhoneNumberIsOptedOutCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "CheckIfPhoneNumberIsOptedOut", {}).n("SNSClient", "CheckIfPhoneNumberIsOptedOutCommand").f(CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog, void 0).ser(se_CheckIfPhoneNumberIsOptedOutCommand).de(de_CheckIfPhoneNumberIsOptedOutCommand).build() {
  static {
    __name(this, "CheckIfPhoneNumberIsOptedOutCommand");
  }
};

// src/commands/ConfirmSubscriptionCommand.ts



var ConfirmSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ConfirmSubscription", {}).n("SNSClient", "ConfirmSubscriptionCommand").f(void 0, void 0).ser(se_ConfirmSubscriptionCommand).de(de_ConfirmSubscriptionCommand).build() {
  static {
    __name(this, "ConfirmSubscriptionCommand");
  }
};

// src/commands/CreatePlatformApplicationCommand.ts



var CreatePlatformApplicationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "CreatePlatformApplication", {}).n("SNSClient", "CreatePlatformApplicationCommand").f(void 0, void 0).ser(se_CreatePlatformApplicationCommand).de(de_CreatePlatformApplicationCommand).build() {
  static {
    __name(this, "CreatePlatformApplicationCommand");
  }
};

// src/commands/CreatePlatformEndpointCommand.ts



var CreatePlatformEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "CreatePlatformEndpoint", {}).n("SNSClient", "CreatePlatformEndpointCommand").f(void 0, void 0).ser(se_CreatePlatformEndpointCommand).de(de_CreatePlatformEndpointCommand).build() {
  static {
    __name(this, "CreatePlatformEndpointCommand");
  }
};

// src/commands/CreateSMSSandboxPhoneNumberCommand.ts



var CreateSMSSandboxPhoneNumberCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "CreateSMSSandboxPhoneNumber", {}).n("SNSClient", "CreateSMSSandboxPhoneNumberCommand").f(CreateSMSSandboxPhoneNumberInputFilterSensitiveLog, void 0).ser(se_CreateSMSSandboxPhoneNumberCommand).de(de_CreateSMSSandboxPhoneNumberCommand).build() {
  static {
    __name(this, "CreateSMSSandboxPhoneNumberCommand");
  }
};

// src/commands/CreateTopicCommand.ts



var CreateTopicCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "CreateTopic", {}).n("SNSClient", "CreateTopicCommand").f(void 0, void 0).ser(se_CreateTopicCommand).de(de_CreateTopicCommand).build() {
  static {
    __name(this, "CreateTopicCommand");
  }
};

// src/commands/DeleteEndpointCommand.ts



var DeleteEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "DeleteEndpoint", {}).n("SNSClient", "DeleteEndpointCommand").f(void 0, void 0).ser(se_DeleteEndpointCommand).de(de_DeleteEndpointCommand).build() {
  static {
    __name(this, "DeleteEndpointCommand");
  }
};

// src/commands/DeletePlatformApplicationCommand.ts



var DeletePlatformApplicationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "DeletePlatformApplication", {}).n("SNSClient", "DeletePlatformApplicationCommand").f(void 0, void 0).ser(se_DeletePlatformApplicationCommand).de(de_DeletePlatformApplicationCommand).build() {
  static {
    __name(this, "DeletePlatformApplicationCommand");
  }
};

// src/commands/DeleteSMSSandboxPhoneNumberCommand.ts



var DeleteSMSSandboxPhoneNumberCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "DeleteSMSSandboxPhoneNumber", {}).n("SNSClient", "DeleteSMSSandboxPhoneNumberCommand").f(DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog, void 0).ser(se_DeleteSMSSandboxPhoneNumberCommand).de(de_DeleteSMSSandboxPhoneNumberCommand).build() {
  static {
    __name(this, "DeleteSMSSandboxPhoneNumberCommand");
  }
};

// src/commands/DeleteTopicCommand.ts



var DeleteTopicCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "DeleteTopic", {}).n("SNSClient", "DeleteTopicCommand").f(void 0, void 0).ser(se_DeleteTopicCommand).de(de_DeleteTopicCommand).build() {
  static {
    __name(this, "DeleteTopicCommand");
  }
};

// src/commands/GetDataProtectionPolicyCommand.ts



var GetDataProtectionPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetDataProtectionPolicy", {}).n("SNSClient", "GetDataProtectionPolicyCommand").f(void 0, void 0).ser(se_GetDataProtectionPolicyCommand).de(de_GetDataProtectionPolicyCommand).build() {
  static {
    __name(this, "GetDataProtectionPolicyCommand");
  }
};

// src/commands/GetEndpointAttributesCommand.ts



var GetEndpointAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetEndpointAttributes", {}).n("SNSClient", "GetEndpointAttributesCommand").f(void 0, void 0).ser(se_GetEndpointAttributesCommand).de(de_GetEndpointAttributesCommand).build() {
  static {
    __name(this, "GetEndpointAttributesCommand");
  }
};

// src/commands/GetPlatformApplicationAttributesCommand.ts



var GetPlatformApplicationAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetPlatformApplicationAttributes", {}).n("SNSClient", "GetPlatformApplicationAttributesCommand").f(void 0, void 0).ser(se_GetPlatformApplicationAttributesCommand).de(de_GetPlatformApplicationAttributesCommand).build() {
  static {
    __name(this, "GetPlatformApplicationAttributesCommand");
  }
};

// src/commands/GetSMSAttributesCommand.ts



var GetSMSAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetSMSAttributes", {}).n("SNSClient", "GetSMSAttributesCommand").f(void 0, void 0).ser(se_GetSMSAttributesCommand).de(de_GetSMSAttributesCommand).build() {
  static {
    __name(this, "GetSMSAttributesCommand");
  }
};

// src/commands/GetSMSSandboxAccountStatusCommand.ts



var GetSMSSandboxAccountStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetSMSSandboxAccountStatus", {}).n("SNSClient", "GetSMSSandboxAccountStatusCommand").f(void 0, void 0).ser(se_GetSMSSandboxAccountStatusCommand).de(de_GetSMSSandboxAccountStatusCommand).build() {
  static {
    __name(this, "GetSMSSandboxAccountStatusCommand");
  }
};

// src/commands/GetSubscriptionAttributesCommand.ts



var GetSubscriptionAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetSubscriptionAttributes", {}).n("SNSClient", "GetSubscriptionAttributesCommand").f(void 0, void 0).ser(se_GetSubscriptionAttributesCommand).de(de_GetSubscriptionAttributesCommand).build() {
  static {
    __name(this, "GetSubscriptionAttributesCommand");
  }
};

// src/commands/GetTopicAttributesCommand.ts



var GetTopicAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "GetTopicAttributes", {}).n("SNSClient", "GetTopicAttributesCommand").f(void 0, void 0).ser(se_GetTopicAttributesCommand).de(de_GetTopicAttributesCommand).build() {
  static {
    __name(this, "GetTopicAttributesCommand");
  }
};

// src/commands/ListEndpointsByPlatformApplicationCommand.ts



var ListEndpointsByPlatformApplicationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListEndpointsByPlatformApplication", {}).n("SNSClient", "ListEndpointsByPlatformApplicationCommand").f(void 0, void 0).ser(se_ListEndpointsByPlatformApplicationCommand).de(de_ListEndpointsByPlatformApplicationCommand).build() {
  static {
    __name(this, "ListEndpointsByPlatformApplicationCommand");
  }
};

// src/commands/ListOriginationNumbersCommand.ts



var ListOriginationNumbersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListOriginationNumbers", {}).n("SNSClient", "ListOriginationNumbersCommand").f(void 0, ListOriginationNumbersResultFilterSensitiveLog).ser(se_ListOriginationNumbersCommand).de(de_ListOriginationNumbersCommand).build() {
  static {
    __name(this, "ListOriginationNumbersCommand");
  }
};

// src/commands/ListPhoneNumbersOptedOutCommand.ts



var ListPhoneNumbersOptedOutCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListPhoneNumbersOptedOut", {}).n("SNSClient", "ListPhoneNumbersOptedOutCommand").f(void 0, ListPhoneNumbersOptedOutResponseFilterSensitiveLog).ser(se_ListPhoneNumbersOptedOutCommand).de(de_ListPhoneNumbersOptedOutCommand).build() {
  static {
    __name(this, "ListPhoneNumbersOptedOutCommand");
  }
};

// src/commands/ListPlatformApplicationsCommand.ts



var ListPlatformApplicationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListPlatformApplications", {}).n("SNSClient", "ListPlatformApplicationsCommand").f(void 0, void 0).ser(se_ListPlatformApplicationsCommand).de(de_ListPlatformApplicationsCommand).build() {
  static {
    __name(this, "ListPlatformApplicationsCommand");
  }
};

// src/commands/ListSMSSandboxPhoneNumbersCommand.ts



var ListSMSSandboxPhoneNumbersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListSMSSandboxPhoneNumbers", {}).n("SNSClient", "ListSMSSandboxPhoneNumbersCommand").f(void 0, ListSMSSandboxPhoneNumbersResultFilterSensitiveLog).ser(se_ListSMSSandboxPhoneNumbersCommand).de(de_ListSMSSandboxPhoneNumbersCommand).build() {
  static {
    __name(this, "ListSMSSandboxPhoneNumbersCommand");
  }
};

// src/commands/ListSubscriptionsByTopicCommand.ts



var ListSubscriptionsByTopicCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListSubscriptionsByTopic", {}).n("SNSClient", "ListSubscriptionsByTopicCommand").f(void 0, void 0).ser(se_ListSubscriptionsByTopicCommand).de(de_ListSubscriptionsByTopicCommand).build() {
  static {
    __name(this, "ListSubscriptionsByTopicCommand");
  }
};

// src/commands/ListSubscriptionsCommand.ts



var ListSubscriptionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListSubscriptions", {}).n("SNSClient", "ListSubscriptionsCommand").f(void 0, void 0).ser(se_ListSubscriptionsCommand).de(de_ListSubscriptionsCommand).build() {
  static {
    __name(this, "ListSubscriptionsCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListTagsForResource", {}).n("SNSClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ListTopicsCommand.ts



var ListTopicsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "ListTopics", {}).n("SNSClient", "ListTopicsCommand").f(void 0, void 0).ser(se_ListTopicsCommand).de(de_ListTopicsCommand).build() {
  static {
    __name(this, "ListTopicsCommand");
  }
};

// src/commands/OptInPhoneNumberCommand.ts



var OptInPhoneNumberCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "OptInPhoneNumber", {}).n("SNSClient", "OptInPhoneNumberCommand").f(OptInPhoneNumberInputFilterSensitiveLog, void 0).ser(se_OptInPhoneNumberCommand).de(de_OptInPhoneNumberCommand).build() {
  static {
    __name(this, "OptInPhoneNumberCommand");
  }
};

// src/commands/PublishBatchCommand.ts



var PublishBatchCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "PublishBatch", {}).n("SNSClient", "PublishBatchCommand").f(void 0, void 0).ser(se_PublishBatchCommand).de(de_PublishBatchCommand).build() {
  static {
    __name(this, "PublishBatchCommand");
  }
};

// src/commands/PublishCommand.ts



var PublishCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "Publish", {}).n("SNSClient", "PublishCommand").f(PublishInputFilterSensitiveLog, void 0).ser(se_PublishCommand).de(de_PublishCommand).build() {
  static {
    __name(this, "PublishCommand");
  }
};

// src/commands/PutDataProtectionPolicyCommand.ts



var PutDataProtectionPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "PutDataProtectionPolicy", {}).n("SNSClient", "PutDataProtectionPolicyCommand").f(void 0, void 0).ser(se_PutDataProtectionPolicyCommand).de(de_PutDataProtectionPolicyCommand).build() {
  static {
    __name(this, "PutDataProtectionPolicyCommand");
  }
};

// src/commands/RemovePermissionCommand.ts



var RemovePermissionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "RemovePermission", {}).n("SNSClient", "RemovePermissionCommand").f(void 0, void 0).ser(se_RemovePermissionCommand).de(de_RemovePermissionCommand).build() {
  static {
    __name(this, "RemovePermissionCommand");
  }
};

// src/commands/SetEndpointAttributesCommand.ts



var SetEndpointAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "SetEndpointAttributes", {}).n("SNSClient", "SetEndpointAttributesCommand").f(void 0, void 0).ser(se_SetEndpointAttributesCommand).de(de_SetEndpointAttributesCommand).build() {
  static {
    __name(this, "SetEndpointAttributesCommand");
  }
};

// src/commands/SetPlatformApplicationAttributesCommand.ts



var SetPlatformApplicationAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "SetPlatformApplicationAttributes", {}).n("SNSClient", "SetPlatformApplicationAttributesCommand").f(void 0, void 0).ser(se_SetPlatformApplicationAttributesCommand).de(de_SetPlatformApplicationAttributesCommand).build() {
  static {
    __name(this, "SetPlatformApplicationAttributesCommand");
  }
};

// src/commands/SetSMSAttributesCommand.ts



var SetSMSAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "SetSMSAttributes", {}).n("SNSClient", "SetSMSAttributesCommand").f(void 0, void 0).ser(se_SetSMSAttributesCommand).de(de_SetSMSAttributesCommand).build() {
  static {
    __name(this, "SetSMSAttributesCommand");
  }
};

// src/commands/SetSubscriptionAttributesCommand.ts



var SetSubscriptionAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "SetSubscriptionAttributes", {}).n("SNSClient", "SetSubscriptionAttributesCommand").f(void 0, void 0).ser(se_SetSubscriptionAttributesCommand).de(de_SetSubscriptionAttributesCommand).build() {
  static {
    __name(this, "SetSubscriptionAttributesCommand");
  }
};

// src/commands/SetTopicAttributesCommand.ts



var SetTopicAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "SetTopicAttributes", {}).n("SNSClient", "SetTopicAttributesCommand").f(void 0, void 0).ser(se_SetTopicAttributesCommand).de(de_SetTopicAttributesCommand).build() {
  static {
    __name(this, "SetTopicAttributesCommand");
  }
};

// src/commands/SubscribeCommand.ts



var SubscribeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "Subscribe", {}).n("SNSClient", "SubscribeCommand").f(void 0, void 0).ser(se_SubscribeCommand).de(de_SubscribeCommand).build() {
  static {
    __name(this, "SubscribeCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "TagResource", {}).n("SNSClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/UnsubscribeCommand.ts



var UnsubscribeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "Unsubscribe", {}).n("SNSClient", "UnsubscribeCommand").f(void 0, void 0).ser(se_UnsubscribeCommand).de(de_UnsubscribeCommand).build() {
  static {
    __name(this, "UnsubscribeCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "UntagResource", {}).n("SNSClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/VerifySMSSandboxPhoneNumberCommand.ts



var VerifySMSSandboxPhoneNumberCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonSimpleNotificationService", "VerifySMSSandboxPhoneNumber", {}).n("SNSClient", "VerifySMSSandboxPhoneNumberCommand").f(VerifySMSSandboxPhoneNumberInputFilterSensitiveLog, void 0).ser(se_VerifySMSSandboxPhoneNumberCommand).de(de_VerifySMSSandboxPhoneNumberCommand).build() {
  static {
    __name(this, "VerifySMSSandboxPhoneNumberCommand");
  }
};

// src/SNS.ts
var commands = {
  AddPermissionCommand,
  CheckIfPhoneNumberIsOptedOutCommand,
  ConfirmSubscriptionCommand,
  CreatePlatformApplicationCommand,
  CreatePlatformEndpointCommand,
  CreateSMSSandboxPhoneNumberCommand,
  CreateTopicCommand,
  DeleteEndpointCommand,
  DeletePlatformApplicationCommand,
  DeleteSMSSandboxPhoneNumberCommand,
  DeleteTopicCommand,
  GetDataProtectionPolicyCommand,
  GetEndpointAttributesCommand,
  GetPlatformApplicationAttributesCommand,
  GetSMSAttributesCommand,
  GetSMSSandboxAccountStatusCommand,
  GetSubscriptionAttributesCommand,
  GetTopicAttributesCommand,
  ListEndpointsByPlatformApplicationCommand,
  ListOriginationNumbersCommand,
  ListPhoneNumbersOptedOutCommand,
  ListPlatformApplicationsCommand,
  ListSMSSandboxPhoneNumbersCommand,
  ListSubscriptionsCommand,
  ListSubscriptionsByTopicCommand,
  ListTagsForResourceCommand,
  ListTopicsCommand,
  OptInPhoneNumberCommand,
  PublishCommand,
  PublishBatchCommand,
  PutDataProtectionPolicyCommand,
  RemovePermissionCommand,
  SetEndpointAttributesCommand,
  SetPlatformApplicationAttributesCommand,
  SetSMSAttributesCommand,
  SetSubscriptionAttributesCommand,
  SetTopicAttributesCommand,
  SubscribeCommand,
  TagResourceCommand,
  UnsubscribeCommand,
  UntagResourceCommand,
  VerifySMSSandboxPhoneNumberCommand
};
var SNS = class extends SNSClient {
  static {
    __name(this, "SNS");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, SNS);

// src/pagination/ListEndpointsByPlatformApplicationPaginator.ts

var paginateListEndpointsByPlatformApplication = (0, import_core.createPaginator)(SNSClient, ListEndpointsByPlatformApplicationCommand, "NextToken", "NextToken", "");

// src/pagination/ListOriginationNumbersPaginator.ts

var paginateListOriginationNumbers = (0, import_core.createPaginator)(SNSClient, ListOriginationNumbersCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListPhoneNumbersOptedOutPaginator.ts

var paginateListPhoneNumbersOptedOut = (0, import_core.createPaginator)(SNSClient, ListPhoneNumbersOptedOutCommand, "nextToken", "nextToken", "");

// src/pagination/ListPlatformApplicationsPaginator.ts

var paginateListPlatformApplications = (0, import_core.createPaginator)(SNSClient, ListPlatformApplicationsCommand, "NextToken", "NextToken", "");

// src/pagination/ListSMSSandboxPhoneNumbersPaginator.ts

var paginateListSMSSandboxPhoneNumbers = (0, import_core.createPaginator)(SNSClient, ListSMSSandboxPhoneNumbersCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListSubscriptionsByTopicPaginator.ts

var paginateListSubscriptionsByTopic = (0, import_core.createPaginator)(SNSClient, ListSubscriptionsByTopicCommand, "NextToken", "NextToken", "");

// src/pagination/ListSubscriptionsPaginator.ts

var paginateListSubscriptions = (0, import_core.createPaginator)(SNSClient, ListSubscriptionsCommand, "NextToken", "NextToken", "");

// src/pagination/ListTopicsPaginator.ts

var paginateListTopics = (0, import_core.createPaginator)(SNSClient, ListTopicsCommand, "NextToken", "NextToken", "");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  SNSServiceException,
  __Client,
  SNSClient,
  SNS,
  $Command,
  AddPermissionCommand,
  CheckIfPhoneNumberIsOptedOutCommand,
  ConfirmSubscriptionCommand,
  CreatePlatformApplicationCommand,
  CreatePlatformEndpointCommand,
  CreateSMSSandboxPhoneNumberCommand,
  CreateTopicCommand,
  DeleteEndpointCommand,
  DeletePlatformApplicationCommand,
  DeleteSMSSandboxPhoneNumberCommand,
  DeleteTopicCommand,
  GetDataProtectionPolicyCommand,
  GetEndpointAttributesCommand,
  GetPlatformApplicationAttributesCommand,
  GetSMSAttributesCommand,
  GetSMSSandboxAccountStatusCommand,
  GetSubscriptionAttributesCommand,
  GetTopicAttributesCommand,
  ListEndpointsByPlatformApplicationCommand,
  ListOriginationNumbersCommand,
  ListPhoneNumbersOptedOutCommand,
  ListPlatformApplicationsCommand,
  ListSMSSandboxPhoneNumbersCommand,
  ListSubscriptionsByTopicCommand,
  ListSubscriptionsCommand,
  ListTagsForResourceCommand,
  ListTopicsCommand,
  OptInPhoneNumberCommand,
  PublishBatchCommand,
  PublishCommand,
  PutDataProtectionPolicyCommand,
  RemovePermissionCommand,
  SetEndpointAttributesCommand,
  SetPlatformApplicationAttributesCommand,
  SetSMSAttributesCommand,
  SetSubscriptionAttributesCommand,
  SetTopicAttributesCommand,
  SubscribeCommand,
  TagResourceCommand,
  UnsubscribeCommand,
  UntagResourceCommand,
  VerifySMSSandboxPhoneNumberCommand,
  paginateListEndpointsByPlatformApplication,
  paginateListOriginationNumbers,
  paginateListPhoneNumbersOptedOut,
  paginateListPlatformApplications,
  paginateListSMSSandboxPhoneNumbers,
  paginateListSubscriptionsByTopic,
  paginateListSubscriptions,
  paginateListTopics,
  AuthorizationErrorException,
  InternalErrorException,
  InvalidParameterException,
  NotFoundException,
  ThrottledException,
  FilterPolicyLimitExceededException,
  ReplayLimitExceededException,
  SubscriptionLimitExceededException,
  LanguageCodeString,
  OptedOutException,
  UserErrorException,
  ConcurrentAccessException,
  InvalidSecurityException,
  StaleTagException,
  TagLimitExceededException,
  TagPolicyException,
  TopicLimitExceededException,
  ResourceNotFoundException,
  InvalidStateException,
  NumberCapability,
  RouteType,
  ValidationException,
  SMSSandboxPhoneNumberVerificationStatus,
  EndpointDisabledException,
  InvalidParameterValueException,
  KMSAccessDeniedException,
  KMSDisabledException,
  KMSInvalidStateException,
  KMSNotFoundException,
  KMSOptInRequired,
  KMSThrottlingException,
  PlatformApplicationDisabledException,
  BatchEntryIdsNotDistinctException,
  BatchRequestTooLongException,
  EmptyBatchRequestException,
  InvalidBatchEntryIdException,
  TooManyEntriesInBatchRequestException,
  VerificationException,
  CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog,
  CreateSMSSandboxPhoneNumberInputFilterSensitiveLog,
  DeleteSMSSandboxPhoneNumberInputFilterSensitiveLog,
  PhoneNumberInformationFilterSensitiveLog,
  ListOriginationNumbersResultFilterSensitiveLog,
  ListPhoneNumbersOptedOutResponseFilterSensitiveLog,
  SMSSandboxPhoneNumberFilterSensitiveLog,
  ListSMSSandboxPhoneNumbersResultFilterSensitiveLog,
  OptInPhoneNumberInputFilterSensitiveLog,
  PublishInputFilterSensitiveLog,
  VerifySMSSandboxPhoneNumberInputFilterSensitiveLog
});

