import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetSubscriptionAttributesCommand, se_GetSubscriptionAttributesCommand } from "../protocols/Aws_query";
export { $Command };
export class GetSubscriptionAttributesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "GetSubscriptionAttributes", {})
    .n("SNSClient", "GetSubscriptionAttributesCommand")
    .f(void 0, void 0)
    .ser(se_GetSubscriptionAttributesCommand)
    .de(de_GetSubscriptionAttributesCommand)
    .build() {
}
