import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListSMSSandboxPhoneNumbersResultFilterSensitiveLog, } from "../models/models_0";
import { de_ListSMSSandboxPhoneNumbersCommand, se_ListSMSSandboxPhoneNumbersCommand } from "../protocols/Aws_query";
export { $Command };
export class ListSMSSandboxPhoneNumbersCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "ListSMSSandboxPhoneNumbers", {})
    .n("SNSClient", "ListSMSSandboxPhoneNumbersCommand")
    .f(void 0, ListSMSSandboxPhoneNumbersResultFilterSensitiveLog)
    .ser(se_ListSMSSandboxPhoneNumbersCommand)
    .de(de_ListSMSSandboxPhoneNumbersCommand)
    .build() {
}
