import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListSubscriptionsByTopicCommand, se_ListSubscriptionsByTopicCommand } from "../protocols/Aws_query";
export { $Command };
export class ListSubscriptionsByTopicCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "ListSubscriptionsByTopic", {})
    .n("SNSClient", "ListSubscriptionsByTopicCommand")
    .f(void 0, void 0)
    .ser(se_ListSubscriptionsByTopicCommand)
    .de(de_ListSubscriptionsByTopicCommand)
    .build() {
}
