import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { PublishInputFilterSensitiveLog } from "../models/models_0";
import { de_PublishCommand, se_PublishCommand } from "../protocols/Aws_query";
export { $Command };
export class PublishCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "Publish", {})
    .n("SNSClient", "PublishCommand")
    .f(PublishInputFilterSensitiveLog, void 0)
    .ser(se_PublishCommand)
    .de(de_PublishCommand)
    .build() {
}
