import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateMaintenanceWindowRequestFilterSensitiveLog, } from "../models/models_0";
import { de_CreateMaintenanceWindowCommand, se_CreateMaintenanceWindowCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class CreateMaintenanceWindowCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "CreateMaintenanceWindow", {})
    .n("SSMClient", "CreateMaintenanceWindowCommand")
    .f(CreateMaintenanceWindowRequestFilterSensitiveLog, void 0)
    .ser(se_CreateMaintenanceWindowCommand)
    .de(de_CreateMaintenanceWindowCommand)
    .build() {
}
