import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeInstancePatchStatesResultFilterSensitiveLog, } from "../models/models_0";
import { de_DescribeInstancePatchStatesCommand, se_DescribeInstancePatchStatesCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeInstancePatchStatesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeInstancePatchStates", {})
    .n("SSMClient", "DescribeInstancePatchStatesCommand")
    .f(void 0, DescribeInstancePatchStatesResultFilterSensitiveLog)
    .ser(se_DescribeInstancePatchStatesCommand)
    .de(de_DescribeInstancePatchStatesCommand)
    .build() {
}
