import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeInstancePropertiesResultFilterSensitiveLog, } from "../models/models_0";
import { de_DescribeInstancePropertiesCommand, se_DescribeInstancePropertiesCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeInstancePropertiesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeInstanceProperties", {})
    .n("SSMClient", "DescribeInstancePropertiesCommand")
    .f(void 0, DescribeInstancePropertiesResultFilterSensitiveLog)
    .ser(se_DescribeInstancePropertiesCommand)
    .de(de_DescribeInstancePropertiesCommand)
    .build() {
}
