import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeMaintenanceWindowTargetsResultFilterSensitiveLog, } from "../models/models_1";
import { de_DescribeMaintenanceWindowTargetsCommand, se_DescribeMaintenanceWindowTargetsCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeMaintenanceWindowTargetsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeMaintenanceWindowTargets", {})
    .n("SSMClient", "DescribeMaintenanceWindowTargetsCommand")
    .f(void 0, DescribeMaintenanceWindowTargetsResultFilterSensitiveLog)
    .ser(se_DescribeMaintenanceWindowTargetsCommand)
    .de(de_DescribeMaintenanceWindowTargetsCommand)
    .build() {
}
