import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribePatchGroupsCommand, se_DescribePatchGroupsCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribePatchGroupsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribePatchGroups", {})
    .n("SSMClient", "DescribePatchGroupsCommand")
    .f(void 0, void 0)
    .ser(se_DescribePatchGroupsCommand)
    .de(de_DescribePatchGroupsCommand)
    .build() {
}
