import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetMaintenanceWindowResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetMaintenanceWindowCommand, se_GetMaintenanceWindowCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetMaintenanceWindowCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetMaintenanceWindow", {})
    .n("SSMClient", "GetMaintenanceWindowCommand")
    .f(void 0, GetMaintenanceWindowResultFilterSensitiveLog)
    .ser(se_GetMaintenanceWindowCommand)
    .de(de_GetMaintenanceWindowCommand)
    .build() {
}
