import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetParametersResultFilterSensitiveLog } from "../models/models_1";
import { de_GetParametersCommand, se_GetParametersCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetParametersCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetParameters", {})
    .n("SSMClient", "GetParametersCommand")
    .f(void 0, GetParametersResultFilterSensitiveLog)
    .ser(se_GetParametersCommand)
    .de(de_GetParametersCommand)
    .build() {
}
