"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  copySnapshotPresignedUrlMiddleware: () => copySnapshotPresignedUrlMiddleware,
  copySnapshotPresignedUrlMiddlewareOptions: () => copySnapshotPresignedUrlMiddlewareOptions,
  getCopySnapshotPresignedUrlPlugin: () => getCopySnapshotPresignedUrlPlugin
});
module.exports = __toCommonJS(index_exports);
var import_util_format_url = require("@aws-sdk/util-format-url");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_protocol_http = require("@smithy/protocol-http");
var import_signature_v4 = require("@smithy/signature-v4");
var import_smithy_client = require("@smithy/smithy-client");
var version = "2016-11-15";
function copySnapshotPresignedUrlMiddleware(options) {
  return (next, context) => async (args) => {
    const { input } = args;
    if (!input.PresignedUrl) {
      const destinationRegion = await options.region();
      const endpoint = await (0, import_middleware_endpoint.getEndpointFromInstructions)(
        input,
        {
          /**
           * Replication of {@link CopySnapshotCommand} in EC2.
           * Not imported due to circular dependency.
           */
          getEndpointParameterInstructions() {
            return {
              UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
              Endpoint: { type: "builtInParams", name: "endpoint" },
              Region: { type: "builtInParams", name: "region" },
              UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
            };
          }
        },
        {
          ...options,
          region: input.SourceRegion
        }
      );
      const resolvedEndpoint = typeof options.endpoint === "function" ? await options.endpoint() : (0, import_middleware_endpoint.toEndpointV1)(endpoint);
      const requestToSign = new import_protocol_http.HttpRequest({
        ...resolvedEndpoint,
        protocol: "https",
        headers: {
          host: resolvedEndpoint.hostname
        },
        query: {
          // Values must be string instead of e.g. boolean
          // because we need to sign the serialized form.
          ...Object.entries(input).reduce((acc, [k, v]) => {
            acc[k] = String(v ?? "");
            return acc;
          }, {}),
          Action: "CopySnapshot",
          Version: version,
          DestinationRegion: destinationRegion
        }
      });
      const signer = new import_signature_v4.SignatureV4({
        credentials: options.credentials,
        region: input.SourceRegion,
        service: "ec2",
        sha256: options.sha256,
        uriEscapePath: options.signingEscapePath
      });
      const presignedRequest = await signer.presign(requestToSign, {
        expiresIn: 3600
      });
      args = {
        ...args,
        input: {
          ...args.input,
          DestinationRegion: destinationRegion,
          PresignedUrl: (0, import_util_format_url.formatUrl)(presignedRequest)
        }
      };
      if (import_protocol_http.HttpRequest.isInstance(args.request)) {
        const { request } = args;
        if (!(request.body ?? "").includes("DestinationRegion=")) {
          request.body += `&DestinationRegion=${destinationRegion}`;
        }
        if (!(request.body ?? "").includes("PresignedUrl=")) {
          request.body += `&PresignedUrl=${(0, import_smithy_client.extendedEncodeURIComponent)(args.input.PresignedUrl)}`;
        }
      }
    }
    return next(args);
  };
}
__name(copySnapshotPresignedUrlMiddleware, "copySnapshotPresignedUrlMiddleware");
var copySnapshotPresignedUrlMiddlewareOptions = {
  step: "serialize",
  tags: ["CROSS_REGION_PRESIGNED_URL"],
  name: "crossRegionPresignedUrlMiddleware",
  override: true,
  relation: "after",
  toMiddleware: "endpointV2Middleware"
};
var getCopySnapshotPresignedUrlPlugin = /* @__PURE__ */ __name((config) => ({
  applyToStack: /* @__PURE__ */ __name((clientStack) => {
    clientStack.add(copySnapshotPresignedUrlMiddleware(config), copySnapshotPresignedUrlMiddlewareOptions);
  }, "applyToStack")
}), "getCopySnapshotPresignedUrlPlugin");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  copySnapshotPresignedUrlMiddlewareOptions,
  getCopySnapshotPresignedUrlPlugin,
  copySnapshotPresignedUrlMiddleware
});

