# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/e2sub/endpoint/endpoint.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class EventType(betterproto.Enum):
    """Type of change"""

    NONE = 0
    ADDED = 1
    REMOVED = 3


@dataclass(eq=False, repr=False)
class TerminationEndpoint(betterproto.Message):
    """
    Termination is a record identifying the IP address and TCP port coordinates
    where the E2 termination service is available.
    """

    id: str = betterproto.string_field(1)
    revision: int = betterproto.uint64_field(2)
    ip: str = betterproto.string_field(3)
    port: int = betterproto.uint32_field(4)


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """Event is an end-point event"""

    type: "EventType" = betterproto.enum_field(1)
    endpoint: "TerminationEndpoint" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AddTerminationRequest(betterproto.Message):
    """
    AddTerminationRequest is a request for adding a new termination point
    """

    endpoint: "TerminationEndpoint" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AddTerminationResponse(betterproto.Message):
    """
    AddTerminationResponse is a response to adding a new termination point
    """

    pass


@dataclass(eq=False, repr=False)
class GetTerminationRequest(betterproto.Message):
    """
    GetTerminationRequest is a request for getting existing termination point
    """

    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetTerminationResponse(betterproto.Message):
    """
    GetTerminationResponse is a response with invormation about a requested
    termination point
    """

    endpoint: "TerminationEndpoint" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RemoveTerminationRequest(betterproto.Message):
    """RemoveTerminationRequest is a request for removing termination point"""

    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RemoveTerminationResponse(betterproto.Message):
    """
    RemoveTerminationResponse is a response to removing a termination point
    """

    pass


@dataclass(eq=False, repr=False)
class ListTerminationsRequest(betterproto.Message):
    """
    ListTerminationsRequest is a request to list all available E2 terminations
    """

    pass


@dataclass(eq=False, repr=False)
class ListTerminationsResponse(betterproto.Message):
    """
    ListTerminationsResponse is a response to list all available E2
    terminations
    """

    endpoints: List["TerminationEndpoint"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class WatchTerminationsRequest(betterproto.Message):
    """
    WatchTerminationsRequest is a request to receive a stream of all E2
    termination changes.
    """

    noreplay: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class WatchTerminationsResponse(betterproto.Message):
    """
    WatchTerminationsResponse is a response indicating a change in the
    available E2 termination end-points.
    """

    event: "Event" = betterproto.message_field(1)


class E2RegistryServiceStub(betterproto.ServiceStub):
    async def add_termination(
        self, *, endpoint: "TerminationEndpoint" = None
    ) -> "AddTerminationResponse":

        request = AddTerminationRequest()
        if endpoint is not None:
            request.endpoint = endpoint

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/AddTermination",
            request,
            AddTerminationResponse,
        )

    async def get_termination(self, *, id: str = "") -> "GetTerminationResponse":

        request = GetTerminationRequest()
        request.id = id

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/GetTermination",
            request,
            GetTerminationResponse,
        )

    async def remove_termination(self, *, id: str = "") -> "RemoveTerminationResponse":

        request = RemoveTerminationRequest()
        request.id = id

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/RemoveTermination",
            request,
            RemoveTerminationResponse,
        )

    async def list_terminations(self) -> "ListTerminationsResponse":

        request = ListTerminationsRequest()

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/ListTerminations",
            request,
            ListTerminationsResponse,
        )

    async def watch_terminations(
        self, *, noreplay: bool = False
    ) -> AsyncIterator["WatchTerminationsResponse"]:

        request = WatchTerminationsRequest()
        request.noreplay = noreplay

        async for response in self._unary_stream(
            "/onos.e2sub.endpoint.E2RegistryService/WatchTerminations",
            request,
            WatchTerminationsResponse,
        ):
            yield response


class E2RegistryServiceBase(ServiceBase):
    async def add_termination(
        self, endpoint: "TerminationEndpoint"
    ) -> "AddTerminationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_termination(self, id: str) -> "GetTerminationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_termination(self, id: str) -> "RemoveTerminationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_terminations(self) -> "ListTerminationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def watch_terminations(
        self, noreplay: bool
    ) -> AsyncIterator["WatchTerminationsResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_add_termination(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "endpoint": request.endpoint,
        }

        response = await self.add_termination(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_termination(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.get_termination(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_remove_termination(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "id": request.id,
        }

        response = await self.remove_termination(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_terminations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.list_terminations(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_watch_terminations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "noreplay": request.noreplay,
        }

        await self._call_rpc_handler_server_stream(
            self.watch_terminations,
            stream,
            request_kwargs,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/onos.e2sub.endpoint.E2RegistryService/AddTermination": grpclib.const.Handler(
                self.__rpc_add_termination,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddTerminationRequest,
                AddTerminationResponse,
            ),
            "/onos.e2sub.endpoint.E2RegistryService/GetTermination": grpclib.const.Handler(
                self.__rpc_get_termination,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetTerminationRequest,
                GetTerminationResponse,
            ),
            "/onos.e2sub.endpoint.E2RegistryService/RemoveTermination": grpclib.const.Handler(
                self.__rpc_remove_termination,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveTerminationRequest,
                RemoveTerminationResponse,
            ),
            "/onos.e2sub.endpoint.E2RegistryService/ListTerminations": grpclib.const.Handler(
                self.__rpc_list_terminations,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListTerminationsRequest,
                ListTerminationsResponse,
            ),
            "/onos.e2sub.endpoint.E2RegistryService/WatchTerminations": grpclib.const.Handler(
                self.__rpc_watch_terminations,
                grpclib.const.Cardinality.UNARY_STREAM,
                WatchTerminationsRequest,
                WatchTerminationsResponse,
            ),
        }
