/*
 * Decompiled with CFR 0.152.
 */
package datastructures.stdcollections;

import com.certora.collect.TreapSet;
import datastructures.ArrayHashSet;
import datastructures.LinkedArrayHashSet;
import datastructures.stdcollections.SetsKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ImmutableSet;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\u001aU\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0010\b\u0002\u0010\u0001*\n\u0012\u0006\b\u0000\u0012\u0002H\u00030\u0004*\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a:\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u0002H\u0002 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u0002H\u0002\u0018\u00010\u000b0\u000b\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a\u001b\u0010\r\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u001a\u001d\u0010\u000f\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u001a:\u0010\u0010\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u0002H\u0002 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u0002H\u0002\u0018\u00010\u000b0\u000b\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0012\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0012\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"mapTo", "C", "T", "R", "", "", "destination", "transform", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "parallelStream", "Ljava/util/stream/Stream;", "kotlin.jvm.PlatformType", "single", "(Ljava/lang/Iterable;)Ljava/lang/Object;", "singleOrNull", "stream", "toSet", "", "toUnorderedSet", "GeneralUtils"})
public final class IterablesKt {
    @NotNull
    public static final <T> Set<T> toSet(@NotNull Iterable<? extends T> $this$toSet) {
        Set set2;
        Intrinsics.checkNotNullParameter($this$toSet, "<this>");
        Iterable<T> iterable = $this$toSet;
        if (iterable instanceof ImmutableSet) {
            set2 = (Set)$this$toSet;
        } else if (iterable instanceof PersistentSet.Builder) {
            set2 = ((PersistentSet.Builder)$this$toSet).build();
        } else if (iterable instanceof Collection) {
            switch (((Collection)$this$toSet).size()) {
                case 0: {
                    set2 = kotlin.collections.SetsKt.emptySet();
                    break;
                }
                case 1: {
                    set2 = SetsKt.setOf($this$toSet instanceof List ? ((List)$this$toSet).get(0) : $this$toSet.iterator().next());
                    break;
                }
                default: {
                    set2 = (Set)CollectionsKt.toCollection($this$toSet, (Collection)new LinkedArrayHashSet(((Collection)$this$toSet).size(), 0.0f, 2, null));
                    break;
                }
            }
        } else {
            set2 = (Set)CollectionsKt.toCollection($this$toSet, (Collection)new LinkedArrayHashSet(0, 0.0f, 3, null));
        }
        return set2;
    }

    @NotNull
    public static final <T> Set<T> toUnorderedSet(@NotNull Iterable<? extends T> $this$toUnorderedSet) {
        Intrinsics.checkNotNullParameter($this$toUnorderedSet, "<this>");
        if ($this$toUnorderedSet instanceof Collection) {
            return switch (((Collection)$this$toUnorderedSet).size()) {
                case 0 -> SetsKt.emptyUnorderedSet();
                case 1 -> SetsKt.unorderedSetOf($this$toUnorderedSet instanceof List ? ((List)$this$toUnorderedSet).get(0) : $this$toUnorderedSet.iterator().next());
                default -> (Set)CollectionsKt.toCollection($this$toUnorderedSet, (Collection)new ArrayHashSet(((Collection)$this$toUnorderedSet).size(), 0.0f, 2, null));
            };
        }
        return (Set)CollectionsKt.toCollection($this$toUnorderedSet, (Collection)new ArrayHashSet(0, 0.0f, 3, null));
    }

    @NotNull
    public static final <T, R, C extends Collection<? super R>> C mapTo(@NotNull Iterable<? extends T> $this$mapTo, @NotNull C destination, @NotNull Function1<? super T, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter($this$mapTo, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(transform2, "transform");
        boolean $i$f$mapTo = false;
        for (T item : $this$mapTo) {
            destination.add(transform2.invoke(item));
        }
        return destination;
    }

    public static final <T> Stream<T> stream(@NotNull Iterable<? extends T> $this$stream) {
        Intrinsics.checkNotNullParameter($this$stream, "<this>");
        return StreamSupport.stream($this$stream.spliterator(), false);
    }

    public static final <T> Stream<T> parallelStream(@NotNull Iterable<? extends T> $this$parallelStream) {
        Intrinsics.checkNotNullParameter($this$parallelStream, "<this>");
        return StreamSupport.stream($this$parallelStream.spliterator(), true);
    }

    public static final <T> T single(@NotNull Iterable<? extends T> $this$single) {
        Intrinsics.checkNotNullParameter($this$single, "<this>");
        return $this$single instanceof TreapSet ? ((TreapSet)$this$single).single() : CollectionsKt.single($this$single);
    }

    @Nullable
    public static final <T> T singleOrNull(@NotNull Iterable<? extends T> $this$singleOrNull) {
        Intrinsics.checkNotNullParameter($this$singleOrNull, "<this>");
        return $this$singleOrNull instanceof TreapSet ? ((TreapSet)$this$singleOrNull).singleOrNull() : CollectionsKt.singleOrNull($this$singleOrNull);
    }
}

