/*
 * Decompiled with CFR 0.152.
 */
package dwarf;

import datastructures.stdcollections.ListsKt;
import dwarf.CompilationUnit;
import dwarf.DebugSymbolLoader;
import dwarf.DebugSymbols;
import dwarf.DebugSymbolsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.CVTAlertReporter;
import report.CVTAlertSeverity;
import report.CVTAlertType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ldwarf/DebugSymbolLoader;", "", "()V", "generate", "Ldwarf/DebugSymbols;", "file", "Ljava/io/File;", "demangleNames", "", "Shared"})
@SourceDebugExtension(value={"SMAP\nDebugSymbols.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugSymbols.kt\ndwarf/DebugSymbolLoader\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n80#2:354\n1#3:355\n*S KotlinDebug\n*F\n+ 1 DebugSymbols.kt\ndwarf/DebugSymbolLoader\n*L\n61#1:354\n*E\n"})
public final class DebugSymbolLoader {
    @NotNull
    public static final DebugSymbolLoader INSTANCE = new DebugSymbolLoader();

    private DebugSymbolLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final DebugSymbols generate(@NotNull File file, boolean demangleNames) {
        void stream$iv;
        void $this$decodeFromStream$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        List<String> cmd2 = ListsKt.plus((Collection)ListsKt.listOf("Gimli-DWARF-JSONDump", "-i", file.getAbsolutePath()), (Iterable)(demangleNames ? ListsKt.listOf("-d") : ListsKt.listOf()));
        DebugSymbolsKt.access$getDebugSymbolsLogger$p().info((Function0<? extends Object>)new Function0<Object>(cmd2){
            final /* synthetic */ List<String> $cmd;
            {
                this.$cmd = $cmd;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Running command to generate DWARF debug information " + CollectionsKt.joinToString$default(this.$cmd, " ", null, null, 0, null, null, 62, null);
            }
        });
        ProcessBuilder pb = new ProcessBuilder(cmd2);
        Process jsonDwarfDump = pb.start();
        Json json2 = JsonKt.Json$default(null, generate.debugSymbols.1.INSTANCE, 1, null);
        InputStream inputStream = jsonDwarfDump.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        Object object = inputStream;
        boolean $i$f$decodeFromStream = false;
        $this$decodeFromStream$iv.getSerializersModule();
        List debugSymbols2 = (List)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)new ArrayListSerializer<CompilationUnit>(CompilationUnit.Companion.serializer()), (InputStream)stream$iv);
        if (jsonDwarfDump.waitFor() != 0) {
            byte[] byArray;
            Closeable closeable = jsonDwarfDump.getErrorStream();
            Throwable throwable = null;
            try {
                InputStream it2 = (InputStream)closeable;
                boolean bl = false;
                byArray = it2.readAllBytes();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
            object = byArray;
            String errorText = new String((byte[])object, Charsets.UTF_8);
            CVTAlertReporter.Companion.reportAlert$default(CVTAlertReporter.Companion, CVTAlertType.DIAGNOSABILITY, CVTAlertSeverity.WARNING, null, "Failed to generate JSON dump of DWARF debug information - proceeding without debug information.", null, null, null, 96, null);
            DebugSymbolsKt.access$getDebugSymbolsLogger$p().warn((Function0<? extends Object>)new Function0<Object>(errorText){
                final /* synthetic */ String $errorText;
                {
                    this.$errorText = $errorText;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Failed to generate JSON dump of DWARF debug information - proceeding without debug information, reason " + this.$errorText;
                }
            });
            return null;
        }
        if (debugSymbols2.isEmpty()) {
            CVTAlertReporter.Companion.reportAlert$default(CVTAlertReporter.Companion, CVTAlertType.DIAGNOSABILITY, CVTAlertSeverity.WARNING, null, "No debug symbols are found in the file. The call trace will contain partial information only. Please ensure to have the build options `strip = false` and `debug = 2` set in your Cargo.toml.", null, null, null, 96, null);
            return null;
        }
        return new DebugSymbols(debugSymbols2);
    }
}

