/*
 * Decompiled with CFR 0.152.
 */
package log;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import log.ArtifactManagerFactory;
import log.StaticArtifactLocation;
import log.SubdirArtifactLocation;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Llog/ArtifactLocation;", "", "path", "Ljava/io/File;", "getPath", "()Ljava/io/File;", "getResolvedPath", "mainOutputDirPath", "", "isRelativeToMainOutputDir", "", "Llog/StaticArtifactLocation;", "Llog/SubdirArtifactLocation;", "Shared"})
public sealed interface ArtifactLocation
permits StaticArtifactLocation, SubdirArtifactLocation {
    @NotNull
    public File getPath();

    public boolean isRelativeToMainOutputDir();

    @NotNull
    public File getResolvedPath(@NotNull String var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static File getResolvedPath(@NotNull ArtifactLocation $this, @NotNull String mainOutputDirPath) {
            Intrinsics.checkNotNullParameter(mainOutputDirPath, "mainOutputDirPath");
            if (!ArtifactManagerFactory.INSTANCE.isEnabled()) {
                boolean bl = false;
                String string = "Cannot resolve the artifact location " + $this + " when artifacts are not enabled";
                throw new IllegalStateException(string.toString());
            }
            File resolvedPath = $this.isRelativeToMainOutputDir() ? FilesKt.resolve(new File(mainOutputDirPath), $this.getPath()) : ($this.getPath().isAbsolute() ? $this.getPath() : FilesKt.resolve(StaticArtifactLocation.CWD.INSTANCE.getPath(), $this.getPath()));
            String string = resolvedPath.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            ArtifactFileUtils.INSTANCE.createFolderIfNotExists(string);
            return resolvedPath;
        }
    }
}

