/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.CssTokens;
import org.owasp.html.Strings;

final class CssGrammar {
    CssGrammar() {
    }

    private static void errorRecoveryUntilSemiOrCloseBracket(CssTokens.TokenIterator it2) {
        int bracketDepth = 0;
        while (it2.hasNext()) {
            switch (it2.type()) {
                case SEMICOLON: {
                    it2.advance();
                    return;
                }
                case LEFT_CURLY: 
                case LEFT_PAREN: 
                case LEFT_SQUARE: {
                    ++bracketDepth;
                    break;
                }
                case RIGHT_CURLY: 
                case RIGHT_PAREN: 
                case RIGHT_SQUARE: {
                    if (--bracketDepth > 0) break;
                    if (bracketDepth != 0) {
                        it2.advance();
                    }
                    return;
                }
            }
            it2.advance();
        }
    }

    static void parsePropertyGroup(String css, PropertyHandler handler) {
        CssTokens tokens = CssTokens.lex(css);
        CssTokens.TokenIterator it2 = tokens.iterator();
        while (it2.hasTokenAfterSpace()) {
            if (it2.type() != CssTokens.TokenType.IDENT) {
                CssGrammar.errorRecoveryUntilSemiOrCloseBracket(it2);
                continue;
            }
            String name = it2.next();
            if (!it2.hasTokenAfterSpace() || !":".equals(it2.token())) {
                CssGrammar.errorRecoveryUntilSemiOrCloseBracket(it2);
                continue;
            }
            it2.advance();
            handler.startProperty(Strings.toLowerCase(name));
            CssGrammar.parsePropertyValue(it2, handler);
            handler.endProperty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePropertyValue(CssTokens.TokenIterator it2, PropertyHandler handler) {
        block11: while (it2.hasNext()) {
            CssTokens.TokenType type = it2.type();
            String token2 = it2.token();
            switch (type) {
                case SEMICOLON: {
                    it2.advance();
                    return;
                }
                case FUNCTION: {
                    CssTokens.TokenIterator actuals = it2.spliceToEnd();
                    handler.startFunction(token2);
                    CssGrammar.parsePropertyValue(actuals, handler);
                    handler.endFunction(token2);
                    continue block11;
                }
                case IDENT: {
                    handler.identifier(token2);
                    break;
                }
                case HASH_UNRESTRICTED: {
                    if (token2.length() != 4 && token2.length() != 7) break;
                    handler.hash(token2);
                    break;
                }
                case STRING: {
                    handler.quotedString(token2);
                    break;
                }
                case URL: {
                    handler.url(token2);
                    break;
                }
                case DIMENSION: 
                case NUMBER: 
                case PERCENTAGE: {
                    handler.quantity(token2);
                    break;
                }
                case AT: 
                case BAD_DIMENSION: 
                case COLUMN: 
                case DOT_IDENT: 
                case HASH_ID: 
                case MATCH: 
                case UNICODE_RANGE: 
                case WHITESPACE: {
                    break;
                }
                case LEFT_CURLY: 
                case LEFT_PAREN: 
                case LEFT_SQUARE: 
                case RIGHT_CURLY: 
                case RIGHT_PAREN: 
                case RIGHT_SQUARE: 
                case COMMA: 
                case COLON: 
                case DELIM: {
                    handler.punctuation(token2);
                }
            }
            it2.advance();
        }
    }

    static String cssContent(String token2) {
        int esc;
        char ch0;
        int n = token2.length();
        int pos = 0;
        StringBuilder sb = null;
        if (n >= 2 && ((ch0 = token2.charAt(0)) == '\"' || ch0 == '\'') && ch0 == token2.charAt(n - 1)) {
            pos = 1;
            sb = new StringBuilder(--n);
        }
        while ((esc = token2.indexOf(92, pos)) >= 0) {
            int end = esc + 2;
            if (esc > n) break;
            if (sb == null) {
                sb = new StringBuilder(n);
            }
            sb.append(token2, pos, esc);
            int codepoint = token2.charAt(end - 1);
            if (CssGrammar.isHex(codepoint)) {
                char ch;
                while (end < n && CssGrammar.isHex(token2.charAt(end))) {
                    ++end;
                }
                try {
                    codepoint = Integer.parseInt(token2.substring(esc + 1, end), 16);
                }
                catch (RuntimeException ex) {
                    CssGrammar.ignore(ex);
                    codepoint = 65533;
                }
                if (end >= n || (ch = token2.charAt(end)) == ' ' || ch == '\t') {
                    // empty if block
                }
            }
            sb.appendCodePoint(codepoint);
            pos = ++end;
        }
        if (sb == null) {
            return token2;
        }
        return sb.append(token2, pos, n).toString();
    }

    private static boolean isHex(int codepoint) {
        return 48 <= codepoint && codepoint <= 57 || 65 <= codepoint && codepoint <= 70 || 97 <= codepoint && codepoint <= 102;
    }

    private static void ignore(Object o) {
    }

    static interface PropertyHandler {
        public void startProperty(String var1);

        public void quantity(String var1);

        public void identifier(String var1);

        public void hash(String var1);

        public void quotedString(String var1);

        public void url(String var1);

        public void punctuation(String var1);

        public void startFunction(String var1);

        public void endFunction(String var1);

        public void endProperty();
    }
}

