/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.owasp.html.Joinable;
import org.owasp.html.JoinedElementPolicy;
import org.owasp.html.TCB;

@TCB
public interface ElementPolicy {
    public static final ElementPolicy IDENTITY_ELEMENT_POLICY = new ElementPolicy(){

        @Override
        public String apply(String elementName, List<String> attrs) {
            return elementName;
        }
    };
    public static final ElementPolicy REJECT_ALL_ELEMENT_POLICY = new ElementPolicy(){

        @Override
        @Nullable
        public String apply(String elementName, List<String> attrs) {
            return null;
        }
    };

    @Nullable
    public String apply(String var1, List<String> var2);

    public static interface JoinableElementPolicy
    extends ElementPolicy,
    Joinable<JoinableElementPolicy> {
    }

    public static final class Util {
        private Util() {
        }

        public static final ElementPolicy join(ElementPolicy ... policies) {
            PolicyJoiner joiner = new PolicyJoiner();
            for (ElementPolicy p2 : policies) {
                if (p2 == null) continue;
                joiner.unroll(p2);
            }
            return (ElementPolicy)joiner.join();
        }

        static final class PolicyJoiner
        extends Joinable.JoinHelper<ElementPolicy, JoinableElementPolicy> {
            PolicyJoiner() {
                super(ElementPolicy.class, JoinableElementPolicy.class, REJECT_ALL_ELEMENT_POLICY, IDENTITY_ELEMENT_POLICY);
            }

            @Override
            Optional<List<ElementPolicy>> split(ElementPolicy x) {
                if (x instanceof JoinedElementPolicy) {
                    return Optional.of(((JoinedElementPolicy)x).policies);
                }
                return Optional.empty();
            }

            @Override
            ElementPolicy rejoin(Set<? extends ElementPolicy> xs) {
                return new JoinedElementPolicy(xs);
            }
        }
    }
}

