/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.CancellableJob;
import parallel.CompleteJob;
import parallel.Parallel;
import parallel.ParallelPool;
import parallel.ParallelPoolKt;
import parallel.Scheduler;
import utils.ExtStdlibKt;
import utils.LazyKt;
import utils.TimeCheckException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \"2\u00020\u0001:\b\"#$%&'()B\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001f\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001cJ0\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u001d\u0010\u001d\u001a\u0019\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001b0\u001e\u00a2\u0006\u0002\b \u00a2\u0006\u0002\u0010!R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lparallel/ParallelPool;", "Ljava/io/Closeable;", "workerThreads", "", "poolFactory", "Lparallel/ParallelPool$PoolFactory;", "(ILparallel/ParallelPool$PoolFactory;)V", "(I)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "ioPool", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ForkJoinPool;Ljava/util/concurrent/ExecutorService;)V", "getIoPool$GeneralUtils", "()Ljava/util/concurrent/ExecutorService;", "scopeMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lparallel/ParallelPool$ResourceKey;", "Lparallel/ParallelPool$ScopeMapEntry;", "workerThreadPool", "getWorkerThreadPool$GeneralUtils", "()Ljava/util/concurrent/ForkJoinPool;", "close", "", "run", "T", "x", "Lparallel/Parallel;", "(Lparallel/Parallel;)Ljava/lang/Object;", "f", "Lkotlin/Function1;", "Lparallel/Scheduler;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ParallelPoolWorkerThread", "PoolFactory", "ResourceKey", "SchedulingTask", "ScopeMapEntry", "SimpleScheduler", "SpawnPolicy", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nParallelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1855#2,2:384\n*S KotlinDebug\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool\n*L\n205#1:384,2\n*E\n"})
public final class ParallelPool
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService ioPool;
    @NotNull
    private final ForkJoinPool workerThreadPool;
    @NotNull
    private final ConcurrentHashMap<ResourceKey<?, ?>, ScopeMapEntry<?>> scopeMap;
    @NotNull
    private static final Lazy<ParallelPool> globalPool$delegate = LazyKt.lazy(Companion.globalPool.2.INSTANCE);
    private static final int GLOBAL_TIMERS_THREAD_COUNT;
    private static final long SCOPED_ALLOC_CLOSE_DELAY;
    private static final ScheduledExecutorService globalTimers;

    private ParallelPool(ForkJoinPool forkJoinPool, ExecutorService ioPool) {
        this.ioPool = ioPool;
        this.workerThreadPool = forkJoinPool;
        this.scopeMap = new ConcurrentHashMap();
    }

    @NotNull
    public final ExecutorService getIoPool$GeneralUtils() {
        return this.ioPool;
    }

    private ParallelPool(int workerThreads, PoolFactory poolFactory) {
        ForkJoinPool forkJoinPool = new ForkJoinPool(workerThreads, poolFactory, null, false, 0, workerThreads + 256, workerThreads, arg_0 -> ParallelPool._init_$lambda$0(1.INSTANCE, arg_0), 60L, TimeUnit.SECONDS);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue(executorService, "newCachedThreadPool(...)");
        this(forkJoinPool, executorService);
        poolFactory.setParallelPool(this);
    }

    public ParallelPool(int workerThreads) {
        this(workerThreads, new PoolFactory());
    }

    public /* synthetic */ ParallelPool(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            Object object = System.getProperty("cvt.default.parallelism");
            n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? ((Integer)object).intValue() : Runtime.getRuntime().availableProcessors();
        }
        this(n);
    }

    @NotNull
    public final ForkJoinPool getWorkerThreadPool$GeneralUtils() {
        return this.workerThreadPool;
    }

    public final <T> T run(@NotNull Function1<? super Scheduler, ? extends Parallel<? extends T>> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        Parallel<? extends T> x = f.invoke(Scheduler.INSTANCE);
        return this.run(x);
    }

    public final <T> T run(@NotNull Parallel<? extends T> x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (x instanceof CompleteJob) {
            return x.getResult();
        }
        if (System.getProperty("cvt.simple.parallel") == null) {
            ForkJoinTask submit2 = this.workerThreadPool.submit(new SchedulingTask(this, x, false, null, false, 12, null));
            try {
                submit2.get();
            }
            catch (InterruptedException i) {
                Intrinsics.checkNotNull(submit2);
                ParallelPool.run$exceptional(this, x, submit2, i);
            }
            return x.getResult();
        }
        new SimpleScheduler().resolve(x);
        return x.getResult();
    }

    @Override
    public void close() {
        this.workerThreadPool.shutdownNow();
        this.workerThreadPool.awaitQuiescence(10L, TimeUnit.MILLISECONDS);
        this.ioPool.shutdownNow();
        Collection<ScopeMapEntry<?>> collection = this.scopeMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopeMapEntry it2 = (ScopeMapEntry)element$iv;
            boolean bl = false;
            it2.close();
        }
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final <T> void run$exceptional(ParallelPool this$0, Parallel<? extends T> $x, ForkJoinTask<?> submit2, Exception e) {
        ParallelPoolKt.access$getLogger$p().warn(e, (Function0<? extends Object>)new Function0<Object>($x){
            final /* synthetic */ Parallel<T> $x;
            {
                this.$x = $x;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Failed to run task " + this.$x;
            }
        });
        this$0.workerThreadPool.shutdown();
        this$0.ioPool.shutdownNow();
        submit2.get();
        this$0.close();
    }

    public /* synthetic */ ParallelPool(ForkJoinPool forkJoinPool, ExecutorService ioPool, DefaultConstructorMarker $constructor_marker) {
        this(forkJoinPool, ioPool);
    }

    static {
        Object object = System.getProperty("cvt.timer.threads");
        GLOBAL_TIMERS_THREAD_COUNT = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
        Object object2 = System.getProperty("cvt.scoped.alloc.close.delay");
        SCOPED_ALLOC_CLOSE_DELAY = object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null ? (Long)object2 : 10L;
        globalTimers = Executors.newScheduledThreadPool(GLOBAL_TIMERS_THREAD_COUNT);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0010\u001a\u0002H\u0011\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0016\b\b\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002H\u00120\u00152\u0014\b\b\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\u0015H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J]\u0010\u0010\u001a\u0002H\u0011\"\n\b\u0000\u0010\u0012\u0018\u0001*\u00020\u0013\"\u0004\b\u0001\u0010\u0011\"\u0004\b\u0002\u0010\u00192\u0006\u0010\u001a\u001a\u0002H\u00192\u0014\b\b\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00120\u00152\u0014\b\b\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\u0015H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ]\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u0011\"\u0004\b\u0002\u0010\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00190\u001d2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00120\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\u0015\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!J3\u0010\"\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020(J'\u0010)\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00120+2\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010,J)\u0010)\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120+2\b\b\u0002\u0010-\u001a\u00020$H\u0007\u00a2\u0006\u0004\b.\u0010,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Lparallel/ParallelPool$Companion;", "", "()V", "GLOBAL_TIMERS_THREAD_COUNT", "", "SCOPED_ALLOC_CLOSE_DELAY", "", "globalPool", "Lparallel/ParallelPool;", "getGlobalPool", "()Lparallel/ParallelPool;", "globalPool$delegate", "Lkotlin/Lazy;", "globalTimers", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "allocInScope", "R", "T", "Ljava/io/Closeable;", "mk", "Lkotlin/Function1;", "", "f", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "U", "args", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "k", "Lparallel/ParallelPool$ResourceKey;", "(Lparallel/ParallelPool$ResourceKey;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "fromExecutor", "executor", "Ljava/util/concurrent/Executor;", "inherit", "spawnPolicy", "Lparallel/ParallelPool$SpawnPolicy;", "poolF", "(Lparallel/ParallelPool$SpawnPolicy;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isPoolCancelled", "", "runInherit", "task", "Lparallel/Parallel;", "(Lparallel/Parallel;Lparallel/ParallelPool$SpawnPolicy;)Ljava/lang/Object;", "policy", "runInheritT", "GeneralUtils"})
    @SourceDebugExtension(value={"SMAP\nParallelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool$Companion\n+ 2 ExtStdlib.kt\nutils/ExtStdlibKt\n*L\n1#1,383:1\n242#1,8:384\n315#1:393\n54#2:392\n*S KotlinDebug\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool$Companion\n*L\n262#1:384,8\n316#1:393\n288#1:392\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isPoolCancelled() {
            if (Thread.interrupted()) return true;
            Thread thread2 = Thread.currentThread();
            if (!(thread2 instanceof ForkJoinWorkerThread)) return false;
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread2;
            Object object = forkJoinWorkerThread;
            if (forkJoinWorkerThread == null) return false;
            ForkJoinPool forkJoinPool = ((ForkJoinWorkerThread)object).getPool();
            object = forkJoinPool;
            if (forkJoinPool == null) return false;
            if (!((ForkJoinPool)object).isShutdown()) return false;
            return true;
        }

        @NotNull
        public final ParallelPool getGlobalPool() {
            Lazy lazy2 = globalPool$delegate;
            return (ParallelPool)lazy2.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T inherit(@NotNull SpawnPolicy spawnPolicy, @NotNull Function1<? super ParallelPool, ? extends T> poolF2) {
            T t;
            Intrinsics.checkNotNullParameter(spawnPolicy, "spawnPolicy");
            Intrinsics.checkNotNullParameter(poolF2, "poolF");
            boolean $i$f$inherit = false;
            Thread t3 = Thread.currentThread();
            if (t3 instanceof ParallelPoolWorkerThread) {
                t = poolF2.invoke(((ParallelPoolWorkerThread)t3).getParallelPool());
            } else {
                SpawnPolicy spawnPolicy2 = spawnPolicy;
                if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.GLOBAL.INSTANCE)) {
                    t = poolF2.invoke(this.getGlobalPool());
                } else {
                    if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.FAIL.INSTANCE)) {
                        throw new IllegalStateException("Expected that this call to runInherit occurred within a parallel computation; it is not");
                    }
                    if (spawnPolicy2 instanceof SpawnPolicy.New) {
                        Closeable closeable = ((SpawnPolicy.New)spawnPolicy).getF().invoke();
                        Throwable throwable = null;
                        try {
                            T t4 = poolF2.invoke((ParallelPool)closeable);
                            t = t4;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            InlineMarker.finallyStart(1);
                            CloseableKt.closeFinally(closeable, throwable);
                            InlineMarker.finallyEnd(1);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T runInherit(@NotNull Parallel<? extends T> task, @NotNull SpawnPolicy spawnPolicy) {
            Object r2;
            Intrinsics.checkNotNullParameter(task, "task");
            Intrinsics.checkNotNullParameter(spawnPolicy, "spawnPolicy");
            Function1 poolF2 = new Function1<ParallelPool, T>(task){
                final /* synthetic */ Parallel<T> $task;
                {
                    this.$task = $task;
                    super(1);
                }

                public final T invoke(@NotNull ParallelPool pool) {
                    Intrinsics.checkNotNullParameter(pool, "pool");
                    return pool.run(this.$task);
                }
            };
            Companion this_$iv = this;
            boolean $i$f$inherit = false;
            Thread t$iv = Thread.currentThread();
            if (t$iv instanceof ParallelPoolWorkerThread) {
                r2 = poolF2.invoke(((ParallelPoolWorkerThread)t$iv).getParallelPool());
            } else {
                SpawnPolicy spawnPolicy2 = spawnPolicy;
                if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.GLOBAL.INSTANCE)) {
                    r2 = poolF2.invoke(this_$iv.getGlobalPool());
                } else {
                    if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.FAIL.INSTANCE)) {
                        throw new IllegalStateException("Expected that this call to runInherit occurred within a parallel computation; it is not");
                    }
                    if (spawnPolicy2 instanceof SpawnPolicy.New) {
                        Closeable closeable = ((SpawnPolicy.New)spawnPolicy).getF().invoke();
                        Throwable throwable = null;
                        try {
                            Object r3 = poolF2.invoke(closeable);
                            r2 = r3;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return (T)r2;
        }

        @JvmName(name="runInheritT")
        public final <T> T runInheritT(@NotNull Parallel<? extends T> $this$runInherit, @NotNull SpawnPolicy policy) {
            Intrinsics.checkNotNullParameter($this$runInherit, "<this>");
            Intrinsics.checkNotNullParameter(policy, "policy");
            return this.runInherit($this$runInherit, policy);
        }

        public static /* synthetic */ Object runInheritT$default(Companion companion, Parallel parallel, SpawnPolicy spawnPolicy, int n, Object object) {
            if ((n & 1) != 0) {
                spawnPolicy = SpawnPolicy.New.Companion.invoke();
            }
            return companion.runInheritT(parallel, spawnPolicy);
        }

        @Nullable
        public final ParallelPool fromExecutor(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter(executor, "executor");
            ForkJoinPool forkJoinPool = executor instanceof ForkJoinPool ? (ForkJoinPool)executor : null;
            ForkJoinPool.ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = forkJoinPool != null ? forkJoinPool.getFactory() : null;
            PoolFactory poolFactory = forkJoinWorkerThreadFactory instanceof PoolFactory ? (PoolFactory)forkJoinWorkerThreadFactory : null;
            return poolFactory != null ? poolFactory.getParallelPool() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final <T extends Closeable, R, U> R allocInScope(@NotNull ResourceKey<T, U> k, @NotNull Function1<? super U, ? extends T> mk, @NotNull Function1<? super T, ? extends R> f) {
            void $this$uncheckedAs$iv;
            Intrinsics.checkNotNullParameter(k, "k");
            Intrinsics.checkNotNullParameter(mk, "mk");
            Intrinsics.checkNotNullParameter(f, "f");
            Thread t = Thread.currentThread();
            if (!(t instanceof ParallelPoolWorkerThread)) {
                Closeable closeable = (Closeable)mk.invoke(k.getArgs());
                Throwable throwable = null;
                try {
                    Closeable it2 = closeable;
                    boolean bl = false;
                    it2 = f.invoke(it2);
                }
                catch (Throwable it2) {
                    throwable = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return (R)it2;
            }
            ParallelPool pool = ((ParallelPoolWorkerThread)t).getParallelPool();
            ScopeMapEntry it2 = pool.scopeMap.computeIfAbsent(k, arg_0 -> Companion.allocInScope$lambda$1(new Function1<ResourceKey<?, ?>, ScopeMapEntry<?>>(mk, k){
                final /* synthetic */ Function1<U, T> $mk;
                final /* synthetic */ ResourceKey<T, U> $k;
                {
                    this.$mk = $mk;
                    this.$k = $k;
                    super(1);
                }

                @NotNull
                public final ScopeMapEntry<?> invoke(@NotNull ResourceKey<?, ?> it2) {
                    Intrinsics.checkNotNullParameter(it2, "it");
                    return new ScopeMapEntry<T>(new Function0<T>(this.$mk, this.$k){
                        final /* synthetic */ Function1<U, T> $mk;
                        final /* synthetic */ ResourceKey<T, U> $k;
                        {
                            this.$mk = $mk;
                            this.$k = $k;
                            super(0);
                        }

                        @NotNull
                        public final T invoke() {
                            return (T)((Closeable)this.$mk.invoke(this.$k.getArgs()));
                        }
                    });
                }
            }, arg_0));
            boolean $i$f$uncheckedAs = false;
            ScopeMapEntry entry2 = (ScopeMapEntry)$this$uncheckedAs$iv;
            return entry2.use(f);
        }

        public final /* synthetic */ <T extends Closeable, R, U> R allocInScope(U args2, Function1<? super U, ? extends T> mk, Function1<? super T, ? extends R> f) {
            Intrinsics.checkNotNullParameter(mk, "mk");
            Intrinsics.checkNotNullParameter(f, "f");
            boolean $i$f$allocInScope = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this.allocInScope((U)new ResourceKey<Closeable, U>(Closeable.class, args2), mk, f);
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T extends Closeable, R> R allocInScope(Function1 mk, Function1<? super T, ? extends R> f) {
            void this_$iv;
            Intrinsics.checkNotNullParameter(mk, "mk");
            Intrinsics.checkNotNullParameter(f, "f");
            boolean $i$f$allocInScope = false;
            Companion companion = this;
            Object args$iv = null;
            boolean $i$f$allocInScope2 = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this_$iv.allocInScope((Object)new ResourceKey<Closeable, Object>(Closeable.class, args$iv), (Function1)mk, f);
        }

        private static final ScopeMapEntry allocInScope$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (ScopeMapEntry)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lparallel/ParallelPool$ParallelPoolWorkerThread;", "Ljava/util/concurrent/ForkJoinWorkerThread;", "parallelPool", "Lparallel/ParallelPool;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "(Lparallel/ParallelPool;Ljava/util/concurrent/ForkJoinPool;)V", "getParallelPool", "()Lparallel/ParallelPool;", "GeneralUtils"})
    public static final class ParallelPoolWorkerThread
    extends ForkJoinWorkerThread {
        @NotNull
        private final ParallelPool parallelPool;

        public ParallelPoolWorkerThread(@NotNull ParallelPool parallelPool, @NotNull ForkJoinPool pool) {
            Intrinsics.checkNotNullParameter(parallelPool, "parallelPool");
            Intrinsics.checkNotNullParameter(pool, "pool");
            super(pool);
            this.parallelPool = parallelPool;
        }

        @NotNull
        public final ParallelPool getParallelPool() {
            return this.parallelPool;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lparallel/ParallelPool$PoolFactory;", "Ljava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;", "()V", "parallelPool", "Lparallel/ParallelPool;", "getParallelPool", "()Lparallel/ParallelPool;", "setParallelPool", "(Lparallel/ParallelPool;)V", "newThread", "Ljava/util/concurrent/ForkJoinWorkerThread;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "GeneralUtils"})
    private static final class PoolFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        public ParallelPool parallelPool;

        @NotNull
        public final ParallelPool getParallelPool() {
            ParallelPool parallelPool = this.parallelPool;
            if (parallelPool != null) {
                return parallelPool;
            }
            Intrinsics.throwUninitializedPropertyAccessException("parallelPool");
            return null;
        }

        public final void setParallelPool(@NotNull ParallelPool parallelPool) {
            Intrinsics.checkNotNullParameter(parallelPool, "<set-?>");
            this.parallelPool = parallelPool;
        }

        @Override
        @NotNull
        public ForkJoinWorkerThread newThread(@Nullable ForkJoinPool pool) {
            ParallelPool parallelPool = this.getParallelPool();
            ForkJoinPool forkJoinPool = pool;
            Intrinsics.checkNotNull(forkJoinPool);
            return new ParallelPoolWorkerThread(parallelPool, forkJoinPool);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000e\u0010\u000e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ4\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lparallel/ParallelPool$ResourceKey;", "T", "U", "", "klass", "Ljava/lang/Class;", "args", "(Ljava/lang/Class;Ljava/lang/Object;)V", "getArgs", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getKlass", "()Ljava/lang/Class;", "component1", "component2", "copy", "(Ljava/lang/Class;Ljava/lang/Object;)Lparallel/ParallelPool$ResourceKey;", "equals", "", "other", "hashCode", "", "toString", "", "GeneralUtils"})
    public static final class ResourceKey<T, U> {
        @NotNull
        private final Class<T> klass;
        private final U args;

        public ResourceKey(@NotNull Class<T> klass, U args2) {
            Intrinsics.checkNotNullParameter(klass, "klass");
            this.klass = klass;
            this.args = args2;
        }

        @NotNull
        public final Class<T> getKlass() {
            return this.klass;
        }

        public final U getArgs() {
            return this.args;
        }

        @NotNull
        public final Class<T> component1() {
            return this.klass;
        }

        public final U component2() {
            return this.args;
        }

        @NotNull
        public final ResourceKey<T, U> copy(@NotNull Class<T> klass, U args2) {
            Intrinsics.checkNotNullParameter(klass, "klass");
            return new ResourceKey<T, U>(klass, args2);
        }

        public static /* synthetic */ ResourceKey copy$default(ResourceKey resourceKey, Class clazz, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                clazz = resourceKey.klass;
            }
            if ((n & 2) != 0) {
                object = resourceKey.args;
            }
            return resourceKey.copy(clazz, object);
        }

        @NotNull
        public String toString() {
            return "ResourceKey(klass=" + this.klass + ", args=" + this.args + ")";
        }

        public int hashCode() {
            int result2 = this.klass.hashCode();
            result2 = result2 * 31 + (this.args == null ? 0 : this.args.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceKey)) {
                return false;
            }
            ResourceKey resourceKey = (ResourceKey)other;
            if (!Intrinsics.areEqual(this.klass, resourceKey.klass)) {
                return false;
            }
            return Intrinsics.areEqual(this.args, resourceKey.args);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0018\u00010\u0000R\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0002H\u0002J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0018\u00010\u0000R\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lparallel/ParallelPool$SchedulingTask;", "Ljava/util/concurrent/RecursiveTask;", "", "v", "Lparallel/Parallel;", "cancelFlag", "", "nextTask", "Lparallel/ParallelPool;", "inQueue", "(Lparallel/ParallelPool;Lparallel/Parallel;ZLparallel/ParallelPool$SchedulingTask;Z)V", "getNextTask", "()Lparallel/ParallelPool$SchedulingTask;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkCancellation", "compute", "computeWithoutFork", "GeneralUtils"})
    @SourceDebugExtension(value={"SMAP\nParallelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool$SchedulingTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1549#2:384\n1620#2,3:385\n1549#2:388\n1620#2,3:389\n*S KotlinDebug\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool$SchedulingTask\n*L\n138#1:384\n138#1:385,3\n148#1:388\n148#1:389,3\n*E\n"})
    private final class SchedulingTask
    extends RecursiveTask<Unit> {
        @NotNull
        private final Parallel<?> v;
        private final boolean cancelFlag;
        @Nullable
        private final SchedulingTask nextTask;
        private final boolean inQueue;
        @NotNull
        private final AtomicBoolean started;
        final /* synthetic */ ParallelPool this$0;

        public SchedulingTask(@NotNull ParallelPool this$0, Parallel<?> v, @Nullable boolean cancelFlag, SchedulingTask nextTask, boolean inQueue) {
            Intrinsics.checkNotNullParameter(v, "v");
            this.this$0 = this$0;
            this.v = v;
            this.cancelFlag = cancelFlag;
            this.nextTask = nextTask;
            this.inQueue = inQueue;
            this.started = new AtomicBoolean(false);
        }

        public /* synthetic */ SchedulingTask(ParallelPool parallelPool, Parallel parallel, boolean bl, SchedulingTask schedulingTask, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                schedulingTask = null;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            this(parallelPool, parallel, bl, schedulingTask, bl2);
        }

        @Nullable
        public final SchedulingTask getNextTask() {
            return this.nextTask;
        }

        private final void checkCancellation() {
            if (this.cancelFlag && ForkJoinTask.inForkJoinPool() && ForkJoinTask.getPool().isShutdown()) {
                throw new TimeCheckException();
            }
        }

        @Override
        public void compute() {
            this.checkCancellation();
            SchedulingTask schedulingTask = this.nextTask;
            if (schedulingTask != null) {
                schedulingTask.fork();
            }
            this.computeWithoutFork();
        }

        public final boolean computeWithoutFork() {
            Parallel it2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$map;
            Object object;
            this.checkCancellation();
            if (this.inQueue && this.started.getAndSet(true)) {
                return false;
            }
            if (!this.v.getRunnable()) {
                List<Parallel<?>> deps = this.v.getDeps();
                if (!(!((Collection)deps).isEmpty())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Iterable iterable = deps;
                object = this.this$0;
                $i$f$map = false;
                void var5_7 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Parallel parallel = (Parallel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new SchedulingTask((ParallelPool)object, it2, this.cancelFlag, null, false, 12, null));
                }
                RecursiveTask.invokeAll((List)destination$iv$iv);
            }
            this.checkCancellation();
            List<Parallel<?>> d2 = this.v.queueSchedule(this.this$0.getIoPool$GeneralUtils());
            if (!((Collection)d2).isEmpty()) {
                this.checkCancellation();
                try {
                    $this$map$iv = d2;
                    object = this.this$0;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (Parallel)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new SchedulingTask((ParallelPool)object, it2, this.cancelFlag || this.v instanceof CancellableJob, null, false, 12, null));
                    }
                    RecursiveTask.invokeAll((List)destination$iv$iv);
                }
                catch (Throwable t) {
                    if (this.v instanceof CancellableJob) {
                        ((CancellableJob)this.v).signalError(t);
                    }
                    throw t;
                }
            }
            if (!this.v.done()) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J%\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lparallel/ParallelPool$ScopeMapEntry;", "T", "Ljava/io/Closeable;", "", "mk", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "closer", "Ljava/util/concurrent/ScheduledFuture;", "getMk", "()Lkotlin/jvm/functions/Function0;", "refCount", "", "value", "Ljava/io/Closeable;", "close", "", "closeIfUnused", "use", "R", "f", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "GeneralUtils"})
    @SourceDebugExtension(value={"SMAP\nParallelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelPool.kt\nparallel/ParallelPool$ScopeMapEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
    private static final class ScopeMapEntry<T extends Closeable> {
        @NotNull
        private final Function0<T> mk;
        @Nullable
        private T value;
        private int refCount;
        @Nullable
        private ScheduledFuture<?> closer;

        public ScopeMapEntry(@NotNull Function0<? extends T> mk) {
            Intrinsics.checkNotNullParameter(mk, "mk");
            this.mk = mk;
        }

        @NotNull
        public final Function0<T> getMk() {
            return this.mk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <R> R use(@NotNull Function1<? super T, ? extends R> f) {
            Intrinsics.checkNotNullParameter(f, "f");
            ScopeMapEntry<Object> scopeMapEntry = this;
            synchronized (scopeMapEntry) {
                boolean bl = false;
                if (this.value == null) {
                    this.value = (Closeable)this.mk.invoke();
                }
                ScheduledFuture<?> scheduledFuture = this.closer;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                this.closer = null;
                int n = this.refCount;
                this.refCount = n + 1;
                int n2 = n;
            }
            try {
                T t = this.value;
                Intrinsics.checkNotNull(t);
                scopeMapEntry = f.invoke(t);
                return (R)scopeMapEntry;
            }
            finally {
                ScopeMapEntry scopeMapEntry2 = this;
                synchronized (scopeMapEntry2) {
                    boolean bl = false;
                    int n = this.refCount;
                    this.refCount = n + -1;
                    if (this.refCount == 0) {
                        this.closer = globalTimers.schedule(this::closeIfUnused, SCOPED_ALLOC_CLOSE_DELAY, TimeUnit.SECONDS);
                    }
                    Unit $i$a$-synchronized-ParallelPool$ScopeMapEntry$use$3 = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void closeIfUnused() {
            ScopeMapEntry scopeMapEntry = this;
            synchronized (scopeMapEntry) {
                boolean bl = false;
                if (this.refCount == 0) {
                    ScheduledFuture<?> scheduledFuture = this.closer;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(false);
                    }
                    this.closer = null;
                    T t = this.value;
                    if (t != null) {
                        t.close();
                    }
                    this.value = null;
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public final void close() {
            if (!(this.refCount == 0)) {
                boolean bl = false;
                String string = "Resource still in use: " + this.value;
                throw new IllegalStateException(string.toString());
            }
            this.closeIfUnused();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lparallel/ParallelPool$SimpleScheduler;", "", "(Lparallel/ParallelPool;)V", "resolve", "", "v", "Lparallel/Parallel;", "GeneralUtils"})
    private final class SimpleScheduler {
        public final void resolve(@NotNull Parallel<?> v) {
            Intrinsics.checkNotNullParameter(v, "v");
            Parallel[] parallelArray = new Parallel[]{v};
            List<Parallel> depQueue = CollectionsKt.mutableListOf(parallelArray);
            List execQueue = new ArrayList();
            block0: while (!((Collection)depQueue).isEmpty() || !((Collection)execQueue).isEmpty()) {
                while (!((Collection)depQueue).isEmpty()) {
                    Parallel j = ExtStdlibKt.removeLast(depQueue);
                    execQueue.add(j);
                    depQueue.addAll((Collection<Parallel>)j.getDeps());
                }
                while (!((Collection)execQueue).isEmpty()) {
                    Parallel exec = (Parallel)ExtStdlibKt.removeLast(execQueue);
                    if (!exec.getRunnable()) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    List<Parallel<?>> res2 = exec.queueSchedule(ParallelPool.this.getIoPool$GeneralUtils());
                    if (!(exec.done() || !((Collection)res2).isEmpty())) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    depQueue.addAll((Collection<Parallel>)res2);
                    if (!(!((Collection)depQueue).isEmpty())) continue;
                    continue block0;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lparallel/ParallelPool$SpawnPolicy;", "", "()V", "FAIL", "GLOBAL", "New", "Lparallel/ParallelPool$SpawnPolicy$FAIL;", "Lparallel/ParallelPool$SpawnPolicy$GLOBAL;", "Lparallel/ParallelPool$SpawnPolicy$New;", "GeneralUtils"})
    public static abstract sealed class SpawnPolicy {
        private SpawnPolicy() {
        }

        public /* synthetic */ SpawnPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lparallel/ParallelPool$SpawnPolicy$FAIL;", "Lparallel/ParallelPool$SpawnPolicy;", "()V", "GeneralUtils"})
        public static final class FAIL
        extends SpawnPolicy {
            @NotNull
            public static final FAIL INSTANCE = new FAIL();

            private FAIL() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lparallel/ParallelPool$SpawnPolicy$GLOBAL;", "Lparallel/ParallelPool$SpawnPolicy;", "()V", "GeneralUtils"})
        public static final class GLOBAL
        extends SpawnPolicy {
            @NotNull
            public static final GLOBAL INSTANCE = new GLOBAL();

            private GLOBAL() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lparallel/ParallelPool$SpawnPolicy$New;", "Lparallel/ParallelPool$SpawnPolicy;", "f", "Lkotlin/Function0;", "Lparallel/ParallelPool;", "(Lkotlin/jvm/functions/Function0;)V", "getF", "()Lkotlin/jvm/functions/Function0;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "GeneralUtils"})
        public static final class New
        extends SpawnPolicy {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Function0<ParallelPool> f;

            public New(@NotNull Function0<ParallelPool> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                super(null);
                this.f = f;
            }

            @NotNull
            public final Function0<ParallelPool> getF() {
                return this.f;
            }

            @NotNull
            public final Function0<ParallelPool> component1() {
                return this.f;
            }

            @NotNull
            public final New copy(@NotNull Function0<ParallelPool> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                return new New(f);
            }

            public static /* synthetic */ New copy$default(New new_, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    function0 = new_.f;
                }
                return new_.copy(function0);
            }

            @NotNull
            public String toString() {
                return "New(f=" + this.f + ")";
            }

            public int hashCode() {
                return this.f.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof New)) {
                    return false;
                }
                New new_ = (New)other;
                return Intrinsics.areEqual(this.f, new_.f);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lparallel/ParallelPool$SpawnPolicy$New$Companion;", "", "()V", "invoke", "Lparallel/ParallelPool$SpawnPolicy$New;", "GeneralUtils"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final New invoke() {
                    return new New(invoke.1.INSTANCE);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

