/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import config.Config;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.CastType;
import spec.cvlast.CVLBuiltInName;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpFolder;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.DisallowedTypeUsedInQuantifier;
import utils.CollectingResult;
import utils.ExtStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00050\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006JD\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016JD\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u000eH\u0016JD\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u0012H\u0002JD\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u0014H\u0016JD\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u0016H\u0016JD\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u0018H\u0016JD\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0004`\u00052\u0006\u0010\u000b\u001a\u00020\u001aH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lspec/cvlast/typechecker/QuantifierChecker;", "Lspec/cvlast/CVLExpFolder;", "Lutils/CollectingResult;", "", "Lspec/cvlast/typechecker/CVLError;", "Lutils/VoidResult;", "()V", "POSTFIX", "", "applyExp", "acc", "exp", "Lspec/cvlast/CVLExp$ApplyExp;", "arrayderef", "Lspec/cvlast/CVLExp$ArrayDerefExp;", "castExpression", "Lspec/cvlast/CVLExp$CastExpr;", "isStorageReference", "Lspec/cvlast/CVLExp;", "relop", "Lspec/cvlast/CVLExp$RelopExp;", "setmem", "Lspec/cvlast/CVLExp$SetMemExp;", "unary", "Lspec/cvlast/CVLExp$UnaryExp;", "variable", "Lspec/cvlast/CVLExp$VariableExp;", "Shared"})
public final class QuantifierChecker
extends CVLExpFolder<CollectingResult<? extends Unit, ? extends CVLError>> {
    @NotNull
    public static final QuantifierChecker INSTANCE = new QuantifierChecker();
    @NotNull
    private static final String POSTFIX = "are disallowed inside quantified formulas.";

    private QuantifierChecker() {
    }

    private final CollectingResult<Unit, CVLError> isStorageReference(CVLExp exp2) {
        return exp2.getCVLType() instanceof CVLType.PureCVLType.VMInternal.StorageReference ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp2, "Storage comparison references are disallowed inside quantified formulas.")) : (CollectingResult)CollectingResult.Companion.getOk();
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> castExpression(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.CastExpr exp2) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp2, "exp");
        return CollectingResult.Companion.bind(super.castExpression(acc, exp2), switch (WhenMappings.$EnumSwitchMapping$0[exp2.getCastType().ordinal()]) {
            case 1 -> CollectingResult.Companion.asError(new CVLError.Exp(exp2, "Require casts are disallowed inside quantified formulas."));
            case 2 -> CollectingResult.Companion.asError(new CVLError.Exp(exp2, "Assert casts are disallowed inside quantified formulas."));
            case 3, 4 -> CollectingResult.Companion.getOk();
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> arrayderef(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.ArrayDerefExp exp2) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp2, "exp");
        return CollectingResult.Companion.bind(super.arrayderef(acc, exp2), this.isStorageReference(exp2));
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> relop(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.RelopExp exp2) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp2, "exp");
        return CollectingResult.Companion.bind(super.relop(acc, exp2), (Function1)new Function1<Unit, CollectingResult<? extends Unit, ? extends CVLError>>(exp2){
            final /* synthetic */ CVLExp.RelopExp $exp;
            {
                this.$exp = $exp;
                super(1);
            }

            @NotNull
            public final CollectingResult<Unit, CVLError> invoke(@NotNull Unit it2) {
                Intrinsics.checkNotNullParameter(it2, "it");
                return this.$exp.getR().getCVLTypeOrNull() instanceof CVLType.PureCVLType.VMInternal.BlockchainState ? (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(this.$exp, "Storage comparisons are disallowed inside quantified formulas.")) : (CollectingResult)CollectingResult.Companion.getOk();
            }
        });
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> setmem(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.SetMemExp exp2) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp2, "exp");
        return CollectingResult.Companion.bind(super.setmem(acc, exp2), (CollectingResult)CollectingResult.Companion.asError(new CVLError.Exp(exp2, "Set membership checks are disallowed inside quantified formulas.")));
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> applyExp(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.ApplyExp exp2) {
        CollectingResult collectingResult;
        block6: {
            block9: {
                CVLExp.ApplyExp applyExp2;
                block8: {
                    block7: {
                        block5: {
                            Intrinsics.checkNotNullParameter(acc, "acc");
                            Intrinsics.checkNotNullParameter(exp2, "exp");
                            applyExp2 = exp2;
                            if (!(applyExp2 instanceof CVLExp.ApplyExp.CVLFunction)) break block5;
                            collectingResult = CollectingResult.Companion.asError(new DisallowedTypeUsedInQuantifier(exp2.getRangeOrEmpty(), exp2.toAppliedString(), DisallowedTypeUsedInQuantifier.DisallowedType.CVL_FUNCTION_CALL));
                            break block6;
                        }
                        if (!(applyExp2 instanceof CVLExp.ApplyExp.ContractFunction)) break block7;
                        collectingResult = !((Boolean)Config.INSTANCE.getAllowSolidityQuantifierCalls().get()).booleanValue() ? (CollectingResult)CollectingResult.Companion.asError(new DisallowedTypeUsedInQuantifier(exp2.getRangeOrEmpty(), exp2.toAppliedString(), DisallowedTypeUsedInQuantifier.DisallowedType.SOLIDITY_FUNCTION_CALL)) : (CollectingResult)CollectingResult.Companion.getOk();
                        break block6;
                    }
                    if (!(applyExp2 instanceof CVLExp.ApplyExp.Definition ? true : applyExp2 instanceof CVLExp.ApplyExp.Ghost)) break block8;
                    collectingResult = CollectingResult.Companion.getOk();
                    break block6;
                }
                if (!(applyExp2 instanceof CVLExp.ApplyExp.CVLBuiltIn)) break block9;
                switch (WhenMappings.$EnumSwitchMapping$1[((CVLExp.ApplyExp.CVLBuiltIn)exp2).getId().ordinal()]) {
                    case 1: {
                        collectingResult = CollectingResult.Companion.getOk();
                        break block6;
                    }
                    case 2: 
                    case 3: {
                        collectingResult = CollectingResult.Companion.asError(new DisallowedTypeUsedInQuantifier(exp2.getRangeOrEmpty(), exp2.toAppliedString(), DisallowedTypeUsedInQuantifier.DisallowedType.BUILT_IN_KECCAK256));
                        break block6;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        ExtStdlibKt.getImpossible!();
                        throw new KotlinNothingValueException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return CollectingResult.Companion.bind(super.applyExp(acc, exp2), collectingResult);
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> unary(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.UnaryExp exp2) {
        CollectingResult collectingResult;
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp2, "exp");
        CVLExp.UnaryExp unaryExp = exp2;
        if (unaryExp instanceof CVLExp.UnaryExp.BwNotExp) {
            collectingResult = CollectingResult.Companion.asError(new CVLError.Exp(exp2, "Bitwise not expressions are disallowed inside quantified formulas."));
        } else if (unaryExp instanceof CVLExp.UnaryExp.LNotExp) {
            collectingResult = CollectingResult.Companion.getOk();
        } else if (unaryExp instanceof CVLExp.UnaryExp.UnaryMinusExp) {
            collectingResult = CollectingResult.Companion.getOk();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectingResult.Companion.bind(super.unary(acc, exp2), collectingResult);
    }

    @Override
    @NotNull
    public CollectingResult<Unit, CVLError> variable(@NotNull CollectingResult<Unit, ? extends CVLError> acc, @NotNull CVLExp.VariableExp exp2) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        Intrinsics.checkNotNullParameter(exp2, "exp");
        return acc;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CastType.values().length];
            try {
                nArray[CastType.REQUIRE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CastType.ASSERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CastType.CONVERT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CastType.TO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CVLBuiltInName.values().length];
            try {
                nArray[CVLBuiltInName.ECRECOVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.SHA256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.KECCAK256.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_PRANK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_START_PRANK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_STOP_PRANK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_WARP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_ROLL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_MOCK_CALL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_CLEAR_MOCKED_CALLS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVLBuiltInName.FOUNDRY_EXPECT_EMIT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

