# CRC16计算封装
# 2025.02.10
# CC
def calculate_crc(data:bytes) -> bytes:
    """
    Modbus RTU CRC-16计算
    :param data: 输入字节数据
    :return: 2字节CRC校验码(小端序)
    """
    crc = 0xFFFF
    for byte in data:
        crc ^= byte
        for _ in range(8):
            lsb = crc & 0x0001
            crc >>= 1
            if lsb:
                crc ^= 0xA001
    return crc.to_bytes(2,'little')

def verify_crc(data:bytes) -> bool:
    """
    验证数据帧CRC校验
    """
    if len(data) < 2:
        return False
    received_crc = data[-2:]
    calculated_crc = calculate_crc(data[:-2])
    return received_crc == calculated_crc