"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return construct.node.stack.formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // if we have a string arn, we can extract the bucket name from it.
    if (props.bucketArn) {
        const resolved = construct.node.resolve(props.bucketArn);
        if (typeof (resolved) === 'string') {
            const components = construct.node.stack.parseArn(resolved);
            if (components.service !== 's3') {
                throw new Error('Invalid ARN. Expecting "s3" service:' + resolved);
            }
            if (components.resourceName) {
                throw new Error(`Bucket ARN must not contain a path`);
            }
            return components.resource;
        }
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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