"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const s3 = require("../lib");
// Define a stack with an S3 bucket and export it using `bucket.export()`.
// bucket.export returns an `IBucket` object which can later be used in
// `Bucket.import`.
class Producer extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const bucket = new s3.Bucket(this, 'MyBucket');
        this.myBucketRef = bucket.export();
    }
}
class ConsumerConstruct extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        props.bucket.addToResourcePolicy(new iam.PolicyStatement().addAction('*'));
    }
}
class Consumer extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id);
        const user = new iam.User(this, 'MyUser');
        const userBucket = s3.Bucket.fromBucketAttributes(this, 'ImportBucket', props.userBucketRef);
        new ConsumerConstruct(this, 'SomeConstruct', { bucket: userBucket });
        userBucket.grantReadWrite(user);
    }
}
// -------------------------------------------------------
// NOTE: To deploy this, just run `cdk -a "node file.js" deploy`. The stacks
// will be deployed IN-ORDER which means that the producer will be deployed
// first. In the future the toolkit will be able to understand the relationships
// between the stacks and will deploy them in order.
const app = new cdk.App();
const producer = new Producer(app, 'produce');
new Consumer(app, 'consume', {
    userBucketRef: producer.myBucketRef
});
app.run();
//# sourceMappingURL=data:application/json;base64,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